/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

public final class Flags {
    private Flags() {
    }

    public static boolean isAbstract(int n) {
        return (n & 0x400) != 0;
    }

    public static boolean isExport(int n) {
        return (n & 0x200) != 0;
    }

    public static boolean isInline(int n) {
        return (n & 0x20) != 0;
    }

    public static boolean isExplicit(int n) {
        return (n & 0x100) != 0;
    }

    public static boolean isPrivate(int n) {
        return (n & 2) != 0;
    }

    public static boolean isProtected(int n) {
        return (n & 4) != 0;
    }

    public static boolean isPublic(int n) {
        return (n & 1) != 0;
    }

    public static boolean isStatic(int n) {
        return (n & 8) != 0;
    }

    public static boolean isExtern(int n) {
        return (n & 0x10) != 0;
    }

    public static boolean isMutable(int n) {
        return (n & 0x800) != 0;
    }

    public static boolean isRegister(int n) {
        return (n & 0x80) != 0;
    }

    public static boolean isVirtual(int n) {
        return (n & 0x20000) != 0;
    }

    public static boolean isVolatile(int n) {
        return (n & 0x40) != 0;
    }

    public static String toString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (Flags.isPublic(n)) {
            stringBuffer.append("public ");
        }
        if (Flags.isProtected(n)) {
            stringBuffer.append("protected ");
        }
        if (Flags.isPrivate(n)) {
            stringBuffer.append("private ");
        }
        if (Flags.isStatic(n)) {
            stringBuffer.append("static ");
        }
        if (Flags.isAbstract(n)) {
            stringBuffer.append("abstract ");
        }
        if (Flags.isVirtual(n)) {
            stringBuffer.append("virtual ");
        }
        if (Flags.isInline(n)) {
            stringBuffer.append("inline ");
        }
        if (Flags.isExtern(n)) {
            stringBuffer.append("extern ");
        }
        if (Flags.isExport(n)) {
            stringBuffer.append("export ");
        }
        if (Flags.isVolatile(n)) {
            stringBuffer.append("volatile ");
        }
        if (Flags.isExplicit(n)) {
            stringBuffer.append("explicit ");
        }
        if ((n2 = stringBuffer.length()) == 0) {
            return "";
        }
        stringBuffer.setLength(n2 - 1);
        return stringBuffer.toString();
    }
}

