/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.search.AcceptMatchOperation;
import org.eclipse.cdt.internal.core.search.CSearchScope;
import org.eclipse.cdt.internal.core.search.CWorkspaceScope;
import org.eclipse.cdt.internal.core.search.PathCollector;
import org.eclipse.cdt.internal.core.search.PatternSearchJob;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.cdt.internal.core.search.matching.MatchLocator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SearchEngine
implements ICSearchConstants {
    public static boolean VERBOSE = false;
    private IWorkingCopy[] workingCopies = null;

    public SearchEngine() {
    }

    public SearchEngine(IWorkingCopy[] iWorkingCopyArray) {
        this.workingCopies = iWorkingCopyArray;
    }

    public static ICSearchScope createWorkspaceScope() {
        return new CWorkspaceScope();
    }

    public static ICSearchScope createCSearchScope(ICElement[] iCElementArray) {
        return SearchEngine.createCSearchScope(iCElementArray, true);
    }

    public static ICSearchScope createCSearchScope(ICElement[] iCElementArray, boolean bl) {
        CSearchScope cSearchScope = new CSearchScope();
        HashSet hashSet = new HashSet(2);
        int n = 0;
        int n2 = iCElementArray.length;
        while (n < n2) {
            ICElement iCElement = iCElementArray[n];
            if (iCElement != null) {
                try {
                    if (iCElement instanceof ICProject) {
                        cSearchScope.add((ICProject)iCElement, bl, hashSet);
                    } else {
                        cSearchScope.add(iCElement);
                    }
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        return cSearchScope;
    }

    public static ICSearchScope createCFileSearchScope(IFile iFile, ArrayList arrayList) {
        CSearchScope cSearchScope = new CSearchScope();
        if (iFile != null) {
            cSearchScope.addFile(iFile.getFullPath(), iFile.getProject());
            IPath iPath = CCorePlugin.getWorkspace().getRoot().getLocation();
            int n = CCorePlugin.getWorkspace().getRoot().getLocation().segmentCount();
            if (arrayList != null) {
                Iterator iterator = ((AbstractList)arrayList).iterator();
                while (iterator.hasNext()) {
                    Path path = new Path((String)iterator.next());
                    if (iPath.isPrefixOf((IPath)path)) {
                        IFile iFile2 = CCorePlugin.getWorkspace().getRoot().getFile((IPath)path);
                        IPath iPath2 = iFile2.getFullPath().removeFirstSegments(n);
                        iFile2 = CCorePlugin.getWorkspace().getRoot().getFile(iPath2);
                        cSearchScope.addFile(iFile2.getFullPath(), iFile2.getProject());
                        continue;
                    }
                    cSearchScope.addFile((IPath)path, null);
                }
            }
        }
        return cSearchScope;
    }

    public static ICSearchPattern createSearchPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, boolean bl) {
        int n = string.indexOf(42) != -1 || string.indexOf(63) != -1 ? 2 : 0;
        return CSearchPattern.createPattern(string, searchFor, limitTo, n, bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void search(IWorkspace iWorkspace, ICSearchPattern iCSearchPattern, ICSearchScope iCSearchScope, ICSearchResultCollector iCSearchResultCollector, boolean bl) throws InterruptedException {
        AcceptMatchOperation acceptMatchOperation;
        if (VERBOSE) {
            System.out.println("Searching for " + iCSearchPattern + " in " + iCSearchScope);
        }
        if (iCSearchPattern == null) {
            return;
        }
        iCSearchResultCollector.aboutToStart();
        ArrayList arrayList = new ArrayList();
        try {
            IProgressMonitor iProgressMonitor = iCSearchResultCollector.getProgressMonitor();
            if (iProgressMonitor != null) {
                iProgressMonitor.beginTask(Util.bind("engine.searching"), 100);
            }
            PathCollector pathCollector = new PathCollector();
            CModelManager cModelManager = CModelManager.getDefault();
            IndexManager indexManager = cModelManager.getIndexManager();
            SubProgressMonitor subProgressMonitor = iProgressMonitor == null ? null : new SubProgressMonitor(iProgressMonitor, 5);
            indexManager.performConcurrentJob(new PatternSearchJob((CSearchPattern)iCSearchPattern, iCSearchScope, pathCollector, indexManager), 3, (IProgressMonitor)subProgressMonitor, null);
            subProgressMonitor = iProgressMonitor == null ? null : new SubProgressMonitor(iProgressMonitor, 95);
            MatchLocator matchLocator = new MatchLocator(iCSearchPattern, iCSearchResultCollector, iCSearchScope, (IProgressMonitor)subProgressMonitor);
            matchLocator.setShouldExcludeLocalDeclarations(bl);
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            matchLocator.locateMatches(pathCollector.getPaths(), iWorkspace, this.workingCopies, arrayList);
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            AcceptMatchOperation acceptMatchOperation2 = new AcceptMatchOperation(iCSearchResultCollector, arrayList);
            try {
                CCorePlugin.getWorkspace().run((IWorkspaceRunnable)acceptMatchOperation2, null);
                throw throwable;
            }
            catch (CoreException coreException) {}
            throw throwable;
        }
        {
            Object var13_15 = null;
            acceptMatchOperation = new AcceptMatchOperation(iCSearchResultCollector, arrayList);
        }
        try {}
        catch (CoreException coreException) {
            return;
        }
        CCorePlugin.getWorkspace().run((IWorkspaceRunnable)acceptMatchOperation, null);
    }
}

