/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class Util {
    private static final char[] DOUBLE_QUOTES = "''".toCharArray();
    private static final char[] SINGLE_QUOTE = "'".toCharArray();
    private static final int DEFAULT_READING_SIZE = 8192;
    protected static ResourceBundle bundle;
    private static final String bundleName = "org.eclipse.cdt.internal.core.messages";
    public static HashSet existingExternalFiles;

    static {
        Util.relocalize();
        existingExternalFiles = new HashSet();
    }

    public static String bind(String string, String string2, String string3) {
        return Util.bind(string, new String[]{string2, string3});
    }

    public static String bind(String string, String string2) {
        return Util.bind(string, new String[]{string2});
    }

    public static String bind(String string, String[] stringArray) {
        StringBuffer stringBuffer;
        block9: {
            if (string == null) {
                return "No message available";
            }
            String string2 = null;
            try {
                string2 = bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return "Missing message: " + string + " in: " + bundleName;
            }
            char[] cArray = CharOperation.replace(string2.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            string2 = new String(cArray);
            if (stringArray == null) {
                return string2;
            }
            int n = string2.length();
            int n2 = -1;
            int n3 = n;
            stringBuffer = new StringBuffer(80);
            while ((n3 = string2.indexOf(123, n2)) > -1) {
                stringBuffer.append(string2.substring(n2 + 1, n3));
                n2 = string2.indexOf(125, n3);
                if (n2 > -1) {
                    int n4 = -1;
                    try {
                        n4 = Integer.parseInt(string2.substring(n3 + 1, n2));
                        stringBuffer.append(stringArray[n4]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append(string2.substring(n3 + 1, n2 + 1));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        stringBuffer.append("{missing " + Integer.toString(n4) + "}");
                    }
                    continue;
                }
                stringBuffer.append(string2.substring(n3, n));
                break block9;
            }
            stringBuffer.append(string2.substring(n2 + 1, n));
        }
        return stringBuffer.toString();
    }

    public static String bind(String string) {
        return Util.bind(string, null);
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw missingResourceException;
        }
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray = Util.getInputStreamAsByteArray(bufferedInputStream, (int)file.length());
                Object var2_3 = null;
                if (bufferedInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var2_4 = null;
                    if (bufferedInputStream == null) break block6;
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getFileCharContent(File file, String string) throws IOException {
        char[] cArray;
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                cArray = Util.getInputStreamAsCharArray(bufferedInputStream, (int)file.length(), string);
                Object var3_5 = null;
                if (bufferedInputStream == null) return cArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                char[] cArray2 = null;
                Object var3_6 = null;
                if (bufferedInputStream == null) return cArray2;
                try {
                    ((InputStream)bufferedInputStream).close();
                    return cArray2;
                }
                catch (IOException iOException) {}
                return cArray2;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            if (bufferedInputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)bufferedInputStream).close();
        return cArray;
    }

    public static byte[] getInputStreamAsByteArray(InputStream inputStream, int n) throws IOException {
        byte[] byArray;
        if (n == -1) {
            byArray = new byte[]{};
            int n2 = 0;
            int n3 = -1;
            do {
                int n4;
                if (n2 + (n4 = Math.max(inputStream.available(), 8192)) > byArray.length) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[n2 + n4];
                    System.arraycopy(byArray2, 0, byArray, 0, n2);
                }
                if ((n3 = inputStream.read(byArray, n2, n4)) <= 0) continue;
                n2 += n3;
            } while (n3 != -1);
            if (n2 < byArray.length) {
                byte[] byArray3 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray3, 0, byArray, 0, n2);
            }
        } else {
            byArray = new byte[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 != n) {
                n6 = inputStream.read(byArray, n5 += n6, n - n5);
            }
        }
        return byArray;
    }

    public static char[] getInputStreamAsCharArray(InputStream inputStream, int n, String string) throws IOException {
        char[] cArray;
        InputStreamReader inputStreamReader = null;
        InputStreamReader inputStreamReader2 = inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        if (n == -1) {
            cArray = CharOperation.NO_CHAR;
            int n2 = 0;
            int n3 = -1;
            do {
                int n4;
                if (n2 + (n4 = Math.max(inputStream.available(), 8192)) > cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n2 + n4];
                    System.arraycopy(cArray2, 0, cArray, 0, n2);
                }
                if ((n3 = inputStreamReader.read(cArray, n2, n4)) <= 0) continue;
                n2 += n3;
            } while (n3 != -1);
            if (n2 < cArray.length) {
                char[] cArray3 = cArray;
                cArray = new char[n2];
                System.arraycopy(cArray3, 0, cArray, 0, n2);
            }
        } else {
            cArray = new char[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 != n) {
                n6 = inputStreamReader.read(cArray, n5 += n6, n - n5);
            }
            if (n5 != n) {
                char[] cArray4 = cArray;
                cArray = new char[n5];
                System.arraycopy(cArray4, 0, cArray, 0, n5);
            }
        }
        return cArray;
    }

    public static Object getTarget(IContainer iContainer, IPath iPath, boolean bl) {
        Object object;
        if (iPath == null) {
            return null;
        }
        if (iPath.getDevice() == null && (object = iContainer.findMember(iPath)) != null) {
            if (!bl || object.exists()) {
                return object;
            }
            return null;
        }
        if (!iPath.isAbsolute()) {
            return null;
        }
        object = new File(iPath.toOSString());
        if (!bl) {
            return object;
        }
        if (existingExternalFiles.contains(object)) {
            return object;
        }
        if (((File)object).exists()) {
            existingExternalFiles.add(object);
            return object;
        }
        return null;
    }

    public static final boolean isExcluded(IResource iResource, char[][] cArray) {
        IPath iPath = iResource.getFullPath();
        if (iResource.getType() == 2) {
            iPath = iPath.append("*");
        }
        return Util.isExcluded(iPath, cArray);
    }

    public static final boolean isExcluded(IPath iPath, char[][] cArray) {
        if (cArray == null) {
            return false;
        }
        char[] cArray2 = iPath.toString().toCharArray();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            if (CharOperation.pathMatch(cArray[n], cArray2, true, '/')) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isCCFileName(String string) {
        String[] stringArray = CModelManager.sourceExtensions;
        String[] stringArray2 = CModelManager.headerExtensions;
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return true;
        }
        String string2 = "";
        if (n + 1 <= string.length()) {
            string2 = string.substring(n + 1);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals(string2)) {
                return true;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < stringArray2.length) {
            if (stringArray2[n2].equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

