/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.internal.core.index.impl.Block;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.Util;

public class FileListBlock
extends Block {
    protected int offset = 0;
    protected String prevPath = null;
    protected String[] paths = null;

    public FileListBlock(int n) {
        super(n);
    }

    public boolean addFile(IndexedFile indexedFile) {
        int n = this.offset;
        if (this.isEmpty()) {
            this.field.putInt4(n, indexedFile.getFileNumber());
            n += 4;
        }
        String string = indexedFile.getPath();
        int n2 = this.prevPath == null ? 0 : Util.prefixLength(this.prevPath, string);
        int n3 = 4 + (string.length() - n2) * 3;
        if (n + n3 > this.blockSize - 2) {
            return false;
        }
        this.field.putInt2(n, n2);
        n += 2;
        char[] cArray = new char[string.length() - n2];
        string.getChars(n2, string.length(), cArray, 0);
        n += this.field.putUTF(n, cArray);
        this.offset = n;
        this.prevPath = string;
        return true;
    }

    public void clear() {
        this.reset();
        super.clear();
    }

    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.field.putInt2(this.offset + 2, 0);
            this.offset = 0;
        }
    }

    public IndexedFile getFile(int n) throws IOException {
        IndexedFile indexedFile = null;
        try {
            String[] stringArray = this.getPaths();
            int n2 = n - this.field.getInt4(0);
            if (n2 >= stringArray.length) {
                return null;
            }
            indexedFile = new IndexedFile(stringArray[n2], n);
        }
        catch (Exception exception) {}
        return indexedFile;
    }

    protected String[] getPaths() throws IOException {
        if (this.paths == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 4;
            char[] cArray = null;
            while (true) {
                int n2 = this.field.getUInt2(n);
                int n3 = this.field.getUInt2(n += 2);
                char[] cArray2 = this.field.getUTF(n);
                n += 2 + n3;
                if (n2 != 0) {
                    char[] cArray3 = new char[n2 + cArray2.length];
                    System.arraycopy(cArray, 0, cArray3, 0, n2);
                    System.arraycopy(cArray2, 0, cArray3, n2, cArray2.length);
                    cArray2 = cArray3;
                }
                if (cArray2.length == 0) break;
                arrayList.add(new String(cArray2));
                cArray = cArray2;
            }
            this.paths = new String[arrayList.size()];
            arrayList.toArray(this.paths);
        }
        return this.paths;
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public void reset() {
        this.offset = 0;
        this.prevPath = null;
    }
}

