/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.Util;

public class IndexSummary {
    protected ArrayList firstFilesInBlocks = new ArrayList();
    protected ArrayList firstWordsInBlocks = new ArrayList();
    protected ArrayList firstIncludesInBlocks = new ArrayList();
    protected int numFiles;
    protected int numWords;
    protected int numIncludes;
    protected int firstWordBlockNum;
    protected boolean firstWordAdded = true;
    protected int firstIncludeBlockNum;
    protected boolean firstIncludeBlockAdded = true;

    public void addFirstFileInBlock(IndexedFile indexedFile, int n) {
        FirstFileInBlock firstFileInBlock = new FirstFileInBlock();
        firstFileInBlock.indexedFile = indexedFile;
        firstFileInBlock.blockNum = n;
        this.firstFilesInBlocks.add(firstFileInBlock);
    }

    public void addFirstWordInBlock(char[] cArray, int n) {
        if (this.firstWordAdded) {
            this.firstWordBlockNum = n;
            this.firstWordAdded = false;
        }
        FirstWordInBlock firstWordInBlock = new FirstWordInBlock();
        firstWordInBlock.word = cArray;
        firstWordInBlock.blockNum = n;
        this.firstWordsInBlocks.add(firstWordInBlock);
    }

    public void addFirstIncludeInBlock(char[] cArray, int n) {
        if (this.firstIncludeBlockAdded) {
            this.firstIncludeBlockNum = n;
            this.firstIncludeBlockAdded = false;
        }
        FirstIncludeInBlock firstIncludeInBlock = new FirstIncludeInBlock();
        firstIncludeInBlock.file = cArray;
        firstIncludeInBlock.blockNum = n;
        this.firstIncludesInBlocks.add(firstIncludeInBlock);
    }

    public int[] getAllBlockNums() {
        int n = this.firstWordsInBlocks.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = ((FirstWordInBlock)this.firstWordsInBlocks.get((int)n2)).blockNum;
            ++n2;
        }
        return nArray;
    }

    public int getBlockNum(int n) {
        return ((FirstWordInBlock)this.firstWordsInBlocks.get((int)n)).blockNum;
    }

    public int getBlockNumForFileNum(int n) {
        int n2 = 0;
        int n3 = this.firstFilesInBlocks.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            FirstFileInBlock firstFileInBlock = (FirstFileInBlock)this.firstFilesInBlocks.get(n4);
            int n5 = n - firstFileInBlock.indexedFile.getFileNumber();
            if (n5 == 0) {
                return firstFileInBlock.blockNum;
            }
            if (n5 < 0) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        if (n3 < 0) {
            return -1;
        }
        FirstFileInBlock firstFileInBlock = (FirstFileInBlock)this.firstFilesInBlocks.get(n3);
        return firstFileInBlock.blockNum;
    }

    public int getBlockNumForWord(char[] cArray) {
        int n = 0;
        int n2 = this.firstWordsInBlocks.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            FirstWordInBlock firstWordInBlock = (FirstWordInBlock)this.firstWordsInBlocks.get(n3);
            int n4 = Util.compare(cArray, firstWordInBlock.word);
            if (n4 == 0) {
                return firstWordInBlock.blockNum;
            }
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            n = n3 + 1;
        }
        if (n2 < 0) {
            return -1;
        }
        FirstWordInBlock firstWordInBlock = (FirstWordInBlock)this.firstWordsInBlocks.get(n2);
        return firstWordInBlock.blockNum;
    }

    public int[] getBlockNumsForPrefix(char[] cArray) {
        FirstWordInBlock firstWordInBlock;
        int n;
        int n2 = 0;
        int n3 = this.firstWordsInBlocks.size();
        int n4 = n3 - 1;
        int n5 = -1;
        while (n2 <= n4 && n5 < 0) {
            n = (n2 + n4) / 2;
            firstWordInBlock = (FirstWordInBlock)this.firstWordsInBlocks.get(n);
            int n6 = CharOperation.compareWith(firstWordInBlock.word, cArray);
            if (n6 == 0) {
                n5 = n;
                break;
            }
            if (n6 >= 0) {
                n4 = n - 1;
                continue;
            }
            n2 = n + 1;
        }
        if (n4 < 0) {
            return new int[0];
        }
        if (n5 < 0) {
            n5 = n4;
        }
        n = n5 - 1;
        while (n >= 0) {
            firstWordInBlock = (FirstWordInBlock)this.firstWordsInBlocks.get(n);
            if (!CharOperation.prefixEquals(cArray, firstWordInBlock.word)) break;
            --n;
        }
        if (n < 0) {
            n = 0;
        }
        int n7 = n5 + 1;
        while (n7 < n3) {
            FirstWordInBlock firstWordInBlock2 = (FirstWordInBlock)this.firstWordsInBlocks.get(n7);
            if (!CharOperation.prefixEquals(cArray, firstWordInBlock2.word)) break;
            ++n7;
        }
        int n8 = n7 - n;
        int[] nArray = new int[n8];
        int n9 = n;
        int n10 = 0;
        while (n10 < n8) {
            FirstWordInBlock firstWordInBlock3 = (FirstWordInBlock)this.firstWordsInBlocks.get(n9);
            nArray[n10] = firstWordInBlock3.blockNum;
            ++n10;
            ++n9;
        }
        return nArray;
    }

    public int[] getBlockNumsForIncludes() {
        int n = this.firstIncludesInBlocks.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = ((FirstIncludeInBlock)this.firstIncludesInBlocks.get((int)n2)).blockNum;
            ++n2;
        }
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    public int getFirstBlockLocationForPrefix(char[] var1_1) {
        block5: {
            var2_2 = 0;
            var3_3 = this.firstWordsInBlocks.size();
            var4_4 = var3_3 - 1;
            var5_5 = -1;
            while (var2_2 <= var4_4) {
                var6_6 = (var2_2 + var4_4) / 2;
                var7_8 = (FirstWordInBlock)this.firstWordsInBlocks.get(var6_6);
                var8_9 = CharOperation.compareWith(var7_8.word, var1_1);
                if (var8_9 == 0) {
                    var5_5 = var6_6;
                    break;
                }
                if (var8_9 >= 0) {
                    var4_4 = var6_6 - 1;
                    continue;
                }
                var5_5 = var6_6;
                var2_2 = var6_6 + 1;
            }
            if (var4_4 < 0) {
                return -1;
            }
            if (var5_5 >= 0) ** GOTO lbl26
            var5_5 = var4_4;
            break block5;
lbl-1000:
            // 1 sources

            {
                var6_7 = (FirstWordInBlock)this.firstWordsInBlocks.get(var5_5);
                if (!CharOperation.prefixEquals(var1_1, var6_7.word)) break;
                --var5_5;
lbl26:
                // 2 sources

                ** while (var5_5 > 0)
            }
        }
        return var5_5;
    }

    public int getFirstWordBlockNum() {
        return this.firstWordBlockNum;
    }

    public int getFirstIncludeBlockNum() {
        return this.firstIncludeBlockNum;
    }

    public int getNextBlockLocationForPrefix(char[] cArray, int n) {
        if (++n < this.firstWordsInBlocks.size()) {
            FirstWordInBlock firstWordInBlock = (FirstWordInBlock)this.firstWordsInBlocks.get(n);
            if (CharOperation.prefixEquals(cArray, firstWordInBlock.word)) {
                return n;
            }
        }
        return -1;
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    public int getNumWords() {
        return this.numWords;
    }

    public int getNumIncludes() {
        return this.numIncludes;
    }

    public void read(RandomAccessFile randomAccessFile) throws IOException {
        Object object;
        this.numFiles = randomAccessFile.readInt();
        this.numWords = randomAccessFile.readInt();
        this.numIncludes = randomAccessFile.readInt();
        this.firstWordBlockNum = randomAccessFile.readInt();
        this.firstIncludeBlockNum = randomAccessFile.readInt();
        int n = randomAccessFile.readInt();
        int n2 = 0;
        while (n2 < n) {
            FirstFileInBlock firstFileInBlock = new FirstFileInBlock();
            object = randomAccessFile.readUTF();
            int n3 = randomAccessFile.readInt();
            firstFileInBlock.indexedFile = new IndexedFile((String)object, n3);
            firstFileInBlock.blockNum = randomAccessFile.readInt();
            this.firstFilesInBlocks.add(firstFileInBlock);
            ++n2;
        }
        n2 = randomAccessFile.readInt();
        int n4 = 0;
        while (n4 < n2) {
            object = new FirstWordInBlock();
            ((FirstWordInBlock)object).word = randomAccessFile.readUTF().toCharArray();
            ((FirstWordInBlock)object).blockNum = randomAccessFile.readInt();
            this.firstWordsInBlocks.add(object);
            ++n4;
        }
        n4 = randomAccessFile.readInt();
        int n5 = 0;
        while (n5 < n4) {
            FirstIncludeInBlock firstIncludeInBlock = new FirstIncludeInBlock();
            firstIncludeInBlock.file = randomAccessFile.readUTF().toCharArray();
            firstIncludeInBlock.blockNum = randomAccessFile.readInt();
            this.firstIncludesInBlocks.add(firstIncludeInBlock);
            ++n5;
        }
    }

    public void setNumFiles(int n) {
        this.numFiles = n;
    }

    public void setNumWords(int n) {
        this.numWords = n;
    }

    public void setNumIncludes(int n) {
        this.numIncludes = n;
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        Object object;
        randomAccessFile.writeInt(this.numFiles);
        randomAccessFile.writeInt(this.numWords);
        randomAccessFile.writeInt(this.numIncludes);
        randomAccessFile.writeInt(this.firstWordBlockNum);
        randomAccessFile.writeInt(this.firstIncludeBlockNum);
        randomAccessFile.writeInt(this.firstFilesInBlocks.size());
        int n = 0;
        int n2 = this.firstFilesInBlocks.size();
        while (n < n2) {
            object = (FirstFileInBlock)this.firstFilesInBlocks.get(n);
            randomAccessFile.writeUTF(((FirstFileInBlock)object).indexedFile.getPath());
            randomAccessFile.writeInt(((FirstFileInBlock)object).indexedFile.getFileNumber());
            randomAccessFile.writeInt(((FirstFileInBlock)object).blockNum);
            ++n;
        }
        randomAccessFile.writeInt(this.firstWordsInBlocks.size());
        n = 0;
        n2 = this.firstWordsInBlocks.size();
        while (n < n2) {
            object = (FirstWordInBlock)this.firstWordsInBlocks.get(n);
            randomAccessFile.writeUTF(new String(((FirstWordInBlock)object).word));
            randomAccessFile.writeInt(((FirstWordInBlock)object).blockNum);
            ++n;
        }
        randomAccessFile.writeInt(this.firstIncludesInBlocks.size());
        n = 0;
        n2 = this.firstIncludesInBlocks.size();
        while (n < n2) {
            object = (FirstIncludeInBlock)this.firstIncludesInBlocks.get(n);
            randomAccessFile.writeUTF(new String(((FirstIncludeInBlock)object).file));
            randomAccessFile.writeInt(((FirstIncludeInBlock)object).blockNum);
            ++n;
        }
    }

    static class FirstFileInBlock {
        IndexedFile indexedFile;
        int blockNum;

        FirstFileInBlock() {
        }
    }

    static class FirstWordInBlock {
        char[] word;
        int blockNum;

        FirstWordInBlock() {
        }

        public String toString() {
            return "FirstWordInBlock: " + new String(this.word) + ", blockNum: " + this.blockNum;
        }
    }

    static class FirstIncludeInBlock {
        char[] file;
        int blockNum;

        FirstIncludeInBlock() {
        }

        public String toString() {
            return "FirstIncludeInBlock: " + new String(this.file) + ", blockNum: " + this.blockNum;
        }
    }
}

