/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CopyResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.DeleteResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.MoveResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.MultiOperation;
import org.eclipse.cdt.internal.core.model.RenameResourceElementsOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class CModel
extends CContainer
implements ICModel {
    public CModel() {
        this(ResourcesPlugin.getWorkspace().getRoot());
    }

    public CModel(IWorkspaceRoot iWorkspaceRoot) {
        super(null, (IResource)iWorkspaceRoot, 10);
    }

    public ICProject getCProject(String string) {
        IProject iProject = this.getWorkspace().getRoot().getProject(string);
        return CModelManager.getDefault().create(iProject);
    }

    public ICProject[] getCProjects() {
        ArrayList arrayList = this.getChildrenOfType(11);
        ICProject[] iCProjectArray = new ICProject[arrayList.size()];
        arrayList.toArray(iCProjectArray);
        return iCProjectArray;
    }

    public IWorkspace getWorkspace() {
        return this.getUnderlyingResource().getWorkspace();
    }

    public void copy(ICElement[] iCElementArray, ICElement[] iCElementArray2, ICElement[] iCElementArray3, String[] stringArray, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        if (iCElementArray == null || iCElementArray[0] == null || iCElementArray[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new CopyResourceElementsOperation(iCElementArray, iCElementArray2, bl), iCElementArray, iCElementArray3, stringArray, iProgressMonitor);
    }

    public void delete(ICElement[] iCElementArray, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        if (iCElementArray == null || iCElementArray[0] == null || iCElementArray[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new DeleteResourceElementsOperation(iCElementArray, bl), iProgressMonitor);
    }

    public void move(ICElement[] iCElementArray, ICElement[] iCElementArray2, ICElement[] iCElementArray3, String[] stringArray, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        if (iCElementArray == null || iCElementArray[0] == null || iCElementArray[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new MoveResourceElementsOperation(iCElementArray, iCElementArray2, bl), iCElementArray, iCElementArray3, stringArray, iProgressMonitor);
    }

    public void rename(ICElement[] iCElementArray, ICElement[] iCElementArray2, String[] stringArray, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        if (iCElementArray == null || iCElementArray[0] == null || iCElementArray[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new RenameResourceElementsOperation(iCElementArray, iCElementArray2, stringArray, bl), iProgressMonitor);
    }

    protected void runOperation(MultiOperation multiOperation, ICElement[] iCElementArray, ICElement[] iCElementArray2, String[] stringArray, IProgressMonitor iProgressMonitor) throws CModelException {
        multiOperation.setRenamings(stringArray);
        if (iCElementArray2 != null) {
            int n = 0;
            while (n < iCElementArray.length) {
                multiOperation.setInsertBefore(iCElementArray[n], iCElementArray2[n]);
                ++n;
            }
        }
        this.runOperation(multiOperation, iProgressMonitor);
    }

    protected CElementInfo createElementInfo() {
        return new CModelInfo(this);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }
}

