/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifierOwner;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.Enumeration;
import org.eclipse.cdt.internal.core.model.Enumerator;
import org.eclipse.cdt.internal.core.model.Field;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionTemplate;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.model.Include;
import org.eclipse.cdt.internal.core.model.Macro;
import org.eclipse.cdt.internal.core.model.Method;
import org.eclipse.cdt.internal.core.model.MethodDeclaration;
import org.eclipse.cdt.internal.core.model.MethodTemplate;
import org.eclipse.cdt.internal.core.model.Namespace;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.Structure;
import org.eclipse.cdt.internal.core.model.StructureTemplate;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.TypeDef;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.cdt.internal.core.model.VariableDeclaration;
import org.eclipse.cdt.internal.core.model.VariableTemplate;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.util.ASTUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class CModelBuilder {
    private TranslationUnit translationUnit;
    private Map newElements;
    private IQuickParseCallback quickParseCallback;
    private IASTCompilationUnit compilationUnit;
    private boolean hasNoErrors = false;

    public CModelBuilder(TranslationUnit translationUnit) {
        this.translationUnit = translationUnit;
        this.newElements = new HashMap();
    }

    private IASTCompilationUnit parse(ITranslationUnit iTranslationUnit, boolean bl, boolean bl2) throws ParserException {
        IProject iProject = null;
        boolean bl3 = true;
        String string = "";
        if (iTranslationUnit != null && iTranslationUnit.getCProject() != null) {
            iProject = iTranslationUnit.getCProject().getProject();
        }
        if (iProject != null) {
            bl3 = CoreModel.getDefault().hasCCNature(iProject);
        }
        try {
            string = iTranslationUnit.getBuffer().getContents();
        }
        catch (CModelException cModelException) {}
        ParserMode parserMode = bl ? ParserMode.QUICK_PARSE : ParserMode.STRUCTURAL_PARSE;
        this.quickParseCallback = bl ? ParserFactory.createQuickParseCallback() : ParserFactory.createStructuralParseCallback();
        ParserLanguage parserLanguage = bl3 ? ParserLanguage.CPP : ParserLanguage.C;
        IParser iParser = null;
        try {
            IScannerInfo iScannerInfo;
            ScannerInfo scannerInfo = new ScannerInfo();
            IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
            if (iScannerInfoProvider != null && (iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject)) != null) {
                scannerInfo = new ScannerInfo(iScannerInfo.getDefinedSymbols(), iScannerInfo.getIncludePaths());
            }
            iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((Reader)new StringReader(string), (String)(iTranslationUnit.getUnderlyingResource() != null ? iTranslationUnit.getUnderlyingResource().getLocation().toOSString() : ""), (IScannerInfo)scannerInfo, (ParserMode)parserMode, (ParserLanguage)parserLanguage, (ISourceElementRequestor)this.quickParseCallback, (IParserLogService)(bl ? new NullLogService() : ParserUtil.getScannerLogService())), (ISourceElementRequestor)this.quickParseCallback, (ParserMode)parserMode, (ParserLanguage)parserLanguage, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {
            throw new ParserException(CCorePlugin.getResourceString("CModelBuilder.Parser_Construction_Failure"));
        }
        this.hasNoErrors = iParser.parse();
        if (!this.hasNoErrors && bl2) {
            throw new ParserException(CCorePlugin.getResourceString("CModelBuilder.Parse_Failure"));
        }
        return this.quickParseCallback.getCompilationUnit();
    }

    public Map parse(boolean bl) throws Exception {
        try {
            this.compilationUnit = this.parse(this.translationUnit, bl, true);
        }
        catch (ParserException parserException) {
            Util.debugLog("Parse Exception in CModelBuilder", IDebugLogConstants.MODEL);
        }
        long l = System.currentTimeMillis();
        try {
            this.generateModelElements();
            this.translationUnit.getElementInfo().setIsStructureKnown(this.hasNoErrors);
        }
        catch (NullPointerException nullPointerException) {
            Util.debugLog("NullPointer exception in CModelBuilder", IDebugLogConstants.MODEL);
        }
        Util.debugLog("CModel build: " + (System.currentTimeMillis() - l) + "ms", IDebugLogConstants.MODEL);
        return this.newElements;
    }

    private void generateModelElements() {
        Iterator iterator = this.quickParseCallback.iterateOffsetableElements();
        while (iterator.hasNext()) {
            IASTOffsetableElement iASTOffsetableElement = (IASTOffsetableElement)iterator.next();
            if (iASTOffsetableElement instanceof IASTInclusion) {
                this.createInclusion(this.translationUnit, (IASTInclusion)iASTOffsetableElement);
                continue;
            }
            if (iASTOffsetableElement instanceof IASTMacro) {
                this.createMacro(this.translationUnit, (IASTMacro)iASTOffsetableElement);
                continue;
            }
            if (!(iASTOffsetableElement instanceof IASTDeclaration)) continue;
            try {
                this.generateModelElements((Parent)this.translationUnit, (IASTDeclaration)iASTOffsetableElement);
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
        }
    }

    private void generateModelElements(Parent parent, IASTDeclaration iASTDeclaration) throws ASTNotImplementedException {
        if (iASTDeclaration instanceof IASTNamespaceDefinition) {
            this.generateModelElements(parent, (IASTNamespaceDefinition)iASTDeclaration);
        }
        if (iASTDeclaration instanceof IASTAbstractTypeSpecifierDeclaration) {
            this.generateModelElements(parent, (IASTAbstractTypeSpecifierDeclaration)iASTDeclaration);
        }
        if (iASTDeclaration instanceof IASTTemplateDeclaration) {
            this.generateModelElements(parent, (IASTTemplateDeclaration)iASTDeclaration);
        }
        if (iASTDeclaration instanceof IASTTypedefDeclaration) {
            this.generateModelElements(parent, (IASTTypedefDeclaration)iASTDeclaration);
        }
        this.createSimpleElement(parent, iASTDeclaration, false);
    }

    private void generateModelElements(Parent parent, IASTNamespaceDefinition iASTNamespaceDefinition) throws ASTNotImplementedException {
        Namespace namespace = this.createNamespace(parent, iASTNamespaceDefinition);
        Iterator iterator = iASTNamespaceDefinition.getDeclarations();
        while (iterator.hasNext()) {
            IASTDeclaration iASTDeclaration = (IASTDeclaration)iterator.next();
            this.generateModelElements((Parent)namespace, iASTDeclaration);
        }
    }

    private void generateModelElements(Parent parent, IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration) throws ASTNotImplementedException {
        this.createAbstractElement(parent, (IASTTypeSpecifierOwner)iASTAbstractTypeSpecifierDeclaration, false);
    }

    private void generateModelElements(Parent parent, IASTTemplateDeclaration iASTTemplateDeclaration) throws ASTNotImplementedException {
        String[] stringArray;
        Object object;
        CElement cElement;
        IASTDeclaration iASTDeclaration = iASTTemplateDeclaration.getOwnedDeclaration();
        if (iASTDeclaration instanceof IASTAbstractTypeSpecifierDeclaration && (cElement = this.createAbstractElement(parent, (IASTTypeSpecifierOwner)(object = (IASTAbstractTypeSpecifierDeclaration)iASTDeclaration), true)) != null) {
            cElement.setPos(iASTTemplateDeclaration.getStartingOffset(), iASTTemplateDeclaration.getEndingOffset() - iASTTemplateDeclaration.getStartingOffset());
            cElement.setLines(iASTTemplateDeclaration.getStartingLine(), iASTTemplateDeclaration.getEndingLine());
            stringArray = ASTUtil.getTemplateParameters((IASTTemplateDeclaration)iASTTemplateDeclaration);
            ITemplate iTemplate = (ITemplate)((Object)cElement);
            iTemplate.setTemplateParameterTypes(stringArray);
        }
        object = null;
        object = (ITemplate)((Object)this.createSimpleElement(parent, iASTDeclaration, true));
        if (object != null) {
            cElement = (CElement)object;
            cElement.setPos(iASTTemplateDeclaration.getStartingOffset(), iASTTemplateDeclaration.getEndingOffset() - iASTTemplateDeclaration.getStartingOffset());
            cElement.setLines(iASTTemplateDeclaration.getStartingLine(), iASTTemplateDeclaration.getEndingLine());
            stringArray = ASTUtil.getTemplateParameters((IASTTemplateDeclaration)iASTTemplateDeclaration);
            object.setTemplateParameterTypes(stringArray);
        }
    }

    private void generateModelElements(Parent parent, IASTTypedefDeclaration iASTTypedefDeclaration) throws ASTNotImplementedException {
        this.createTypeDef(parent, iASTTypedefDeclaration);
        IASTAbstractDeclaration iASTAbstractDeclaration = iASTTypedefDeclaration.getAbstractDeclarator();
        this.createAbstractElement(parent, (IASTTypeSpecifierOwner)iASTAbstractDeclaration, false);
    }

    private CElement createAbstractElement(Parent parent, IASTTypeSpecifierOwner iASTTypeSpecifierOwner, boolean bl) throws ASTNotImplementedException {
        CElement cElement = null;
        if (iASTTypeSpecifierOwner != null) {
            IASTTypeSpecifier iASTTypeSpecifier = iASTTypeSpecifierOwner.getTypeSpecifier();
            if (iASTTypeSpecifier instanceof IASTEnumerationSpecifier) {
                IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)iASTTypeSpecifier;
                Enumeration enumeration = this.createEnumeration(parent, iASTEnumerationSpecifier);
                cElement = enumeration;
            } else if (iASTTypeSpecifier instanceof IASTClassSpecifier) {
                IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTypeSpecifier;
                Structure structure = this.createClass(parent, iASTClassSpecifier, bl);
                cElement = structure;
                Iterator iterator = iASTClassSpecifier.getDeclarations();
                while (iterator.hasNext()) {
                    IASTDeclaration iASTDeclaration = (IASTDeclaration)iterator.next();
                    this.generateModelElements((Parent)structure, iASTDeclaration);
                }
            } else {
                boolean cfr_ignored_0 = iASTTypeSpecifier instanceof IASTElaboratedTypeSpecifier;
            }
        }
        return cElement;
    }

    private CElement createSimpleElement(Parent parent, IASTDeclaration iASTDeclaration, boolean bl) throws ASTNotImplementedException {
        SourceManipulation sourceManipulation = null;
        if (iASTDeclaration instanceof IASTVariable) {
            sourceManipulation = this.createVariableSpecification(parent, (IASTVariable)iASTDeclaration, bl);
        } else if (iASTDeclaration instanceof IASTFunction) {
            sourceManipulation = this.createFunctionSpecification(parent, (IASTFunction)iASTDeclaration, bl);
        }
        return sourceManipulation;
    }

    private Include createInclusion(Parent parent, IASTInclusion iASTInclusion) {
        Include include = new Include((ICElement)parent, iASTInclusion.getName(), !iASTInclusion.isLocal());
        include.setFullPathName(iASTInclusion.getFullFileName());
        parent.addChild(include);
        include.setIdPos(iASTInclusion.getNameOffset(), iASTInclusion.getNameEndOffset() - iASTInclusion.getNameOffset());
        include.setPos(iASTInclusion.getStartingOffset(), iASTInclusion.getEndingOffset() - iASTInclusion.getStartingOffset());
        include.setLines(iASTInclusion.getStartingLine(), iASTInclusion.getEndingLine());
        this.newElements.put(include, include.getElementInfo());
        return include;
    }

    private Macro createMacro(Parent parent, IASTMacro iASTMacro) {
        Macro macro = new Macro(parent, iASTMacro.getName());
        parent.addChild(macro);
        macro.setIdPos(iASTMacro.getNameOffset(), iASTMacro.getNameEndOffset() - iASTMacro.getNameOffset());
        macro.setPos(iASTMacro.getStartingOffset(), iASTMacro.getEndingOffset() - iASTMacro.getStartingOffset());
        macro.setLines(iASTMacro.getStartingLine(), iASTMacro.getEndingLine());
        this.newElements.put(macro, macro.getElementInfo());
        return macro;
    }

    private Namespace createNamespace(Parent parent, IASTNamespaceDefinition iASTNamespaceDefinition) {
        String string = "namespace";
        String string2 = iASTNamespaceDefinition.getName() == null ? "" : iASTNamespaceDefinition.getName().toString();
        Namespace namespace = new Namespace(parent, string2);
        parent.addChild(namespace);
        namespace.setIdPos(iASTNamespaceDefinition.getNameOffset(), string2.length() == 0 ? string.length() : iASTNamespaceDefinition.getNameEndOffset() - iASTNamespaceDefinition.getNameOffset());
        namespace.setPos(iASTNamespaceDefinition.getStartingOffset(), iASTNamespaceDefinition.getEndingOffset() - iASTNamespaceDefinition.getStartingOffset());
        namespace.setLines(iASTNamespaceDefinition.getStartingLine(), iASTNamespaceDefinition.getEndingLine());
        namespace.setTypeName(string);
        this.newElements.put(namespace, namespace.getElementInfo());
        return namespace;
    }

    private Enumeration createEnumeration(Parent parent, IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        String string = "enum";
        String string2 = iASTEnumerationSpecifier.getName() == null ? "" : iASTEnumerationSpecifier.getName().toString();
        Enumeration enumeration = new Enumeration(parent, string2);
        parent.addChild(enumeration);
        Iterator iterator = iASTEnumerationSpecifier.getEnumerators();
        while (iterator.hasNext()) {
            IASTEnumerator iASTEnumerator = (IASTEnumerator)iterator.next();
            this.createEnumerator(enumeration, iASTEnumerator);
        }
        enumeration.setIdPos(iASTEnumerationSpecifier.getNameOffset(), string2.length() == 0 ? string.length() : iASTEnumerationSpecifier.getNameEndOffset() - iASTEnumerationSpecifier.getNameOffset());
        enumeration.setPos(iASTEnumerationSpecifier.getStartingOffset(), iASTEnumerationSpecifier.getEndingOffset() - iASTEnumerationSpecifier.getStartingOffset());
        enumeration.setLines(iASTEnumerationSpecifier.getStartingLine(), iASTEnumerationSpecifier.getEndingLine());
        enumeration.setTypeName(string);
        this.newElements.put(enumeration, enumeration.getElementInfo());
        return enumeration;
    }

    private Enumerator createEnumerator(Parent parent, IASTEnumerator iASTEnumerator) {
        Enumerator enumerator = new Enumerator(parent, iASTEnumerator.getName().toString());
        IASTExpression iASTExpression = iASTEnumerator.getInitialValue();
        if (iASTExpression != null) {
            if (iASTExpression.getLiteralString().length() > 0) {
                enumerator.setConstantExpression(iASTExpression.getLiteralString());
            } else {
                enumerator.setConstantExpression(iASTExpression.getIdExpression());
            }
        }
        parent.addChild(enumerator);
        enumerator.setIdPos(iASTEnumerator.getStartingOffset(), iASTEnumerator.getNameEndOffset() - iASTEnumerator.getNameOffset());
        enumerator.setPos(iASTEnumerator.getStartingOffset(), iASTEnumerator.getEndingOffset() - iASTEnumerator.getStartingOffset());
        enumerator.setLines(iASTEnumerator.getStartingLine(), iASTEnumerator.getEndingLine());
        this.newElements.put(enumerator, enumerator.getElementInfo());
        return enumerator;
    }

    private Structure createClass(Parent parent, IASTClassSpecifier iASTClassSpecifier, boolean bl) {
        Structure structure;
        Object object;
        String string = "";
        String string2 = "";
        int n = 64;
        ASTClassKind aSTClassKind = iASTClassSpecifier.getClassKind();
        if (aSTClassKind == ASTClassKind.CLASS) {
            n = !bl ? 64 : 73;
            string2 = "class";
            String string3 = string = iASTClassSpecifier.getName() == null ? "" : iASTClassSpecifier.getName().toString();
        }
        if (aSTClassKind == ASTClassKind.STRUCT) {
            n = !bl ? 65 : 82;
            string2 = "struct";
            String string4 = string = iASTClassSpecifier.getName() == null ? "" : iASTClassSpecifier.getName().toString();
        }
        if (aSTClassKind == ASTClassKind.UNION) {
            n = !bl ? 66 : 83;
            string2 = "union";
            String string5 = string = iASTClassSpecifier.getName() == null ? "" : iASTClassSpecifier.getName().toString();
        }
        if (!bl) {
            object = new Structure((ICElement)parent, n, string);
            structure = object;
        } else {
            object = new StructureTemplate((ICElement)parent, n, string);
            structure = object;
        }
        object = iASTClassSpecifier.getBaseClauses();
        while (object.hasNext()) {
            IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)object.next();
            structure.addSuperClass(iASTBaseSpecifier.getParentClassName(), iASTBaseSpecifier.getAccess());
        }
        parent.addChild(structure);
        structure.setIdPos(iASTClassSpecifier.getNameOffset(), string.length() == 0 ? string2.length() : iASTClassSpecifier.getNameEndOffset() - iASTClassSpecifier.getNameOffset());
        structure.setTypeName(string2);
        if (!bl) {
            structure.setPos(iASTClassSpecifier.getStartingOffset(), iASTClassSpecifier.getEndingOffset() - iASTClassSpecifier.getStartingOffset());
        }
        structure.setLines(iASTClassSpecifier.getStartingLine(), iASTClassSpecifier.getEndingLine());
        this.newElements.put(structure, structure.getElementInfo());
        return structure;
    }

    private TypeDef createTypeDef(Parent parent, IASTTypedefDeclaration iASTTypedefDeclaration) {
        String string = iASTTypedefDeclaration.getName();
        TypeDef typeDef = new TypeDef(parent, string);
        StringBuffer stringBuffer = new StringBuffer(ASTUtil.getType((IASTAbstractDeclaration)iASTTypedefDeclaration.getAbstractDeclarator()));
        typeDef.setTypeName(stringBuffer.toString());
        parent.addChild(typeDef);
        typeDef.setIdPos(iASTTypedefDeclaration.getNameOffset(), iASTTypedefDeclaration.getNameEndOffset() - iASTTypedefDeclaration.getNameOffset());
        typeDef.setPos(iASTTypedefDeclaration.getStartingOffset(), iASTTypedefDeclaration.getEndingOffset() - iASTTypedefDeclaration.getStartingOffset());
        typeDef.setLines(iASTTypedefDeclaration.getStartingLine(), iASTTypedefDeclaration.getEndingLine());
        this.newElements.put(typeDef, typeDef.getElementInfo());
        return typeDef;
    }

    private VariableDeclaration createVariableSpecification(Parent parent, IASTVariable iASTVariable, boolean bl) throws ASTNotImplementedException {
        String string = iASTVariable.getName();
        if (string == null || string.length() <= 0) {
            return null;
        }
        IASTAbstractDeclaration iASTAbstractDeclaration = iASTVariable.getAbstractDeclaration();
        this.createAbstractElement(parent, (IASTTypeSpecifierOwner)iASTAbstractDeclaration, bl);
        VariableDeclaration variableDeclaration = null;
        if (iASTVariable instanceof IASTField) {
            IASTField iASTField = (IASTField)iASTVariable;
            Field field = new Field(parent, string);
            field.setMutable(iASTField.isMutable());
            field.setVisibility(iASTField.getVisiblity());
            variableDeclaration = field;
        } else if (bl) {
            VariableTemplate variableTemplate = new VariableTemplate(parent, string);
            variableDeclaration = variableTemplate;
        } else if (iASTVariable.isExtern()) {
            VariableDeclaration variableDeclaration2;
            variableDeclaration = variableDeclaration2 = new VariableDeclaration(parent, string);
        } else {
            Variable variable = new Variable(parent, string);
            variableDeclaration = variable;
        }
        variableDeclaration.setTypeName(ASTUtil.getType((IASTAbstractDeclaration)iASTVariable.getAbstractDeclaration()));
        variableDeclaration.setConst(iASTVariable.getAbstractDeclaration().isConst());
        variableDeclaration.setVolatile(iASTVariable.getAbstractDeclaration().isVolatile());
        variableDeclaration.setStatic(iASTVariable.isStatic());
        parent.addChild(variableDeclaration);
        variableDeclaration.setIdPos(iASTVariable.getNameOffset(), iASTVariable.getNameEndOffset() - iASTVariable.getNameOffset());
        if (!bl) {
            variableDeclaration.setPos(iASTVariable.getStartingOffset(), iASTVariable.getEndingOffset() - iASTVariable.getStartingOffset());
        }
        variableDeclaration.setLines(iASTVariable.getStartingLine(), iASTVariable.getEndingLine());
        this.newElements.put(variableDeclaration, variableDeclaration.getElementInfo());
        return variableDeclaration;
    }

    private FunctionDeclaration createFunctionSpecification(Parent parent, IASTFunction iASTFunction, boolean bl) {
        String string = iASTFunction.getName();
        if (string == null || string.length() <= 0) {
            return null;
        }
        String[] stringArray = ASTUtil.getFunctionParameterTypes((IASTFunction)iASTFunction);
        FunctionDeclaration functionDeclaration = null;
        if (iASTFunction instanceof IASTMethod) {
            IASTMethod iASTMethod = (IASTMethod)iASTFunction;
            MethodDeclaration methodDeclaration = null;
            if (iASTMethod.hasFunctionBody()) {
                if (!bl) {
                    Method method = new Method(parent, string);
                    methodDeclaration = method;
                } else {
                    MethodTemplate methodTemplate = new MethodTemplate(parent, string);
                    methodDeclaration = methodTemplate;
                }
            } else if (!bl) {
                MethodDeclaration methodDeclaration2;
                methodDeclaration = methodDeclaration2 = new MethodDeclaration(parent, string);
            } else {
                MethodTemplate methodTemplate = new MethodTemplate(parent, string);
                methodDeclaration = methodTemplate;
            }
            methodDeclaration.setParameterTypes(stringArray);
            methodDeclaration.setReturnType(ASTUtil.getType((IASTAbstractDeclaration)iASTFunction.getReturnType()));
            methodDeclaration.setStatic(iASTFunction.isStatic());
            methodDeclaration.setVisibility(iASTMethod.getVisiblity());
            methodDeclaration.setVolatile(iASTMethod.isVolatile());
            methodDeclaration.setConst(iASTMethod.isConst());
            methodDeclaration.setVirtual(iASTMethod.isVirtual());
            methodDeclaration.setPureVirtual(iASTMethod.isPureVirtual());
            methodDeclaration.setInline(iASTMethod.isInline());
            methodDeclaration.setFriend(iASTMethod.isFriend());
            methodDeclaration.setConstructor(iASTMethod.isConstructor());
            methodDeclaration.setDestructor(iASTMethod.isDestructor());
            functionDeclaration = methodDeclaration;
        } else {
            FunctionDeclaration functionDeclaration2 = null;
            if (iASTFunction.hasFunctionBody()) {
                if (!bl) {
                    Function function = new Function(parent, string);
                    functionDeclaration2 = function;
                } else {
                    FunctionTemplate functionTemplate = new FunctionTemplate(parent, string);
                    functionDeclaration2 = functionTemplate;
                }
            } else if (!bl) {
                FunctionDeclaration functionDeclaration3;
                functionDeclaration2 = functionDeclaration3 = new FunctionDeclaration(parent, string);
            } else {
                FunctionTemplate functionTemplate = new FunctionTemplate(parent, string);
                functionDeclaration2 = functionTemplate;
            }
            functionDeclaration2.setParameterTypes(stringArray);
            functionDeclaration2.setReturnType(ASTUtil.getType((IASTAbstractDeclaration)iASTFunction.getReturnType()));
            functionDeclaration2.setStatic(iASTFunction.isStatic());
            functionDeclaration = functionDeclaration2;
        }
        parent.addChild(functionDeclaration);
        functionDeclaration.setIdPos(iASTFunction.getNameOffset(), iASTFunction.getNameEndOffset() - iASTFunction.getNameOffset());
        if (!bl) {
            functionDeclaration.setPos(iASTFunction.getStartingOffset(), iASTFunction.getEndingOffset() - iASTFunction.getStartingOffset());
        }
        functionDeclaration.setLines(iASTFunction.getStartingLine(), iASTFunction.getEndingLine());
        this.newElements.put(functionDeclaration, functionDeclaration.getElementInfo());
        return functionDeclaration;
    }
}

