/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CSearchScope
implements ICSearchScope {
    private ArrayList elements;
    private IPath[] paths;
    private boolean[] pathWithSubFolders;
    private int pathsCount;
    private IPath[] enclosingProjects;
    static /* synthetic */ Class class$0;

    public CSearchScope() {
        this.initialize();
    }

    protected void initialize() {
        this.paths = new IPath[1];
        this.pathWithSubFolders = new boolean[1];
        this.pathsCount = 0;
        this.enclosingProjects = new IPath[0];
    }

    private void addEnclosingProject(IPath iPath) {
        int n = this.enclosingProjects.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.enclosingProjects[n2].equals((Object)iPath)) {
                return;
            }
            ++n2;
        }
        this.enclosingProjects = new IPath[n + 1];
        System.arraycopy(this.enclosingProjects, 0, this.enclosingProjects, 0, n);
        this.enclosingProjects[n] = iPath;
    }

    public void add(ICProject iCProject, boolean bl, HashSet hashSet) {
        IProject iProject = iCProject.getProject();
        if (!iProject.isAccessible() || !hashSet.add(iProject)) {
            return;
        }
        this.addEnclosingProject(iProject.getFullPath());
        ICElement[] iCElementArray = iCProject.getChildren();
        int n = 0;
        while (n < iCElementArray.length) {
            this.add(iCElementArray[n]);
            ++n;
        }
        if (bl) {
            IProject[] iProjectArray = null;
            try {
                iProjectArray = iProject.getReferencedProjects();
            }
            catch (CoreException coreException) {}
            int n2 = 0;
            while (n2 < iProjectArray.length) {
                ICProject iCProject2;
                IProject iProject2 = iProjectArray[n2];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.core.model.ICElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iCProject2 = (ICProject)iProject2.getAdapter((Class)clazz)) != null) {
                    this.add(iCProject2, true, hashSet);
                }
                ++n2;
            }
        }
    }

    public void add(IProject iProject, boolean bl, HashSet hashSet) {
        if (!iProject.isAccessible() || !hashSet.add(iProject)) {
            return;
        }
        IProjectDescription iProjectDescription = null;
        try {
            iProjectDescription = iProject.getDescription();
        }
        catch (CoreException coreException) {}
        if (iProjectDescription == null) {
            return;
        }
        String[] stringArray = iProjectDescription.getNatureIds();
        boolean bl2 = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("org.eclipse.cdt.core.cnature")) {
                bl2 = true;
                break;
            }
            ++n;
        }
        if (!bl2) {
            return;
        }
        this.addEnclosingProject(iProject.getFullPath());
        if (bl) {
            IProject[] iProjectArray = null;
            try {
                iProjectArray = iProject.getReferencedProjects();
            }
            catch (CoreException coreException) {}
            int n2 = 0;
            while (n2 < iProjectArray.length) {
                ICProject iCProject;
                IProject iProject2 = iProjectArray[n2];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.core.model.ICElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iCProject = (ICProject)iProject2.getAdapter((Class)clazz)) != null) {
                    this.add(iCProject, true, hashSet);
                }
                ++n2;
            }
        }
    }

    private void add(IPath iPath, boolean bl) {
        if (this.paths.length == this.pathsCount) {
            this.paths = new IPath[this.pathsCount * 2];
            System.arraycopy(this.paths, 0, this.paths, 0, this.pathsCount);
            this.pathWithSubFolders = new boolean[this.pathsCount * 2];
            System.arraycopy(this.pathWithSubFolders, 0, this.pathWithSubFolders, 0, this.pathsCount);
        }
        this.paths[this.pathsCount] = iPath;
        this.pathWithSubFolders[this.pathsCount++] = bl;
    }

    public boolean encloses(String string) {
        Path path = new Path(string);
        return this.encloses((IPath)path);
    }

    private boolean encloses(IPath iPath) {
        int n = 0;
        while (n < this.pathsCount) {
            IPath iPath2;
            if (this.pathWithSubFolders[n] ? this.paths[n].isPrefixOf(iPath) : (iPath2 = this.paths[n]).isPrefixOf(iPath) && (iPath2.segmentCount() == iPath.segmentCount() - 1 || iPath2.segmentCount() == iPath.segmentCount())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean encloses(ICElement iCElement) {
        if (this.elements != null) {
            int n = 0;
            int n2 = this.elements.size();
            while (n < n2) {
                ICElement iCElement2 = (ICElement)this.elements.get(n);
                ICElement iCElement3 = iCElement;
                while (iCElement3 != null) {
                    if (iCElement3.equals(iCElement2)) {
                        return true;
                    }
                    iCElement3 = iCElement3.getParent();
                }
                ++n;
            }
            return false;
        }
        return this.encloses(this.fullPath(iCElement));
    }

    public IPath[] enclosingProjects() {
        return this.enclosingProjects;
    }

    private IPath fullPath(ICElement iCElement) {
        return iCElement.getPath();
    }

    public void add(ICElement iCElement) {
        switch (iCElement.getElementType()) {
            case 11: {
                break;
            }
            default: {
                if (iCElement instanceof IMember) {
                    if (this.elements == null) {
                        this.elements = new ArrayList();
                    }
                    this.elements.add(iCElement);
                }
                this.add(this.fullPath(iCElement), true);
                ICElement iCElement2 = iCElement.getParent();
                while (iCElement2 != null && !(iCElement2 instanceof ICProject)) {
                    iCElement2 = iCElement2.getParent();
                }
                if (!(iCElement2 instanceof ICProject)) break;
                this.addEnclosingProject(iCElement2.getCProject().getProject().getFullPath());
            }
        }
    }

    public void addFile(IPath iPath, IProject iProject) {
        this.add(iPath, true);
        if (iProject != null) {
            this.addEnclosingProject(iProject.getFullPath());
        }
    }
}

