/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

class AddFolderToIndex
extends IndexRequest {
    IPath folderPath;
    IProject project;
    char[][] exclusionPattern;

    public AddFolderToIndex(IPath iPath, IProject iProject, char[][] cArray, IndexManager indexManager) {
        super(iProject.getFullPath(), indexManager);
        this.folderPath = iPath;
        this.project = iProject;
        this.exclusionPattern = cArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IResource iResource = this.project.getParent().findMember(this.folderPath);
        if (iResource == null) return true;
        if (iResource.getType() == 1) {
            return true;
        }
        IIndex iIndex = this.manager.getIndex(this.indexPath, true, true);
        if (iIndex == null) {
            return true;
        }
        ReadWriteMonitor readWriteMonitor = this.manager.getMonitorFor(iIndex);
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            try {
                readWriteMonitor.enterRead();
                final IPath iPath = this.indexPath;
                final IndexManager indexManager = this.manager;
                final char[][] cArray = this.exclusionPattern;
                iResource.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                        switch (iResourceProxy.getType()) {
                            case 1: {
                                if (Util.isCCFileName(iResourceProxy.getName())) {
                                    IResource iResource = iResourceProxy.requestResource();
                                    if (cArray == null || !Util.isExcluded(iResource, cArray)) {
                                        indexManager.addSource((IFile)iResource, iPath);
                                    }
                                }
                                return false;
                            }
                            case 2: {
                                if (cArray == null || !Util.isExcluded(iResourceProxy.requestResource(), cArray)) break;
                                return false;
                            }
                        }
                        return true;
                    }
                }, 0);
            }
            catch (CoreException coreException) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to add " + this.folderPath + " to index because of the following exception:");
                    coreException.printStackTrace();
                }
                Object var8_9 = null;
                readWriteMonitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            readWriteMonitor.exitRead();
            throw throwable;
        }
        {
            Object var8_11 = null;
            readWriteMonitor.exitRead();
            return true;
        }
    }

    public String toString() {
        return "adding " + this.folderPath + " to index " + this.indexPath;
    }
}

