/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.stabs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.utils.debug.DebugArrayType;
import org.eclipse.cdt.utils.debug.DebugBaseType;
import org.eclipse.cdt.utils.debug.DebugCrossRefType;
import org.eclipse.cdt.utils.debug.DebugEnumField;
import org.eclipse.cdt.utils.debug.DebugEnumType;
import org.eclipse.cdt.utils.debug.DebugField;
import org.eclipse.cdt.utils.debug.DebugFunctionType;
import org.eclipse.cdt.utils.debug.DebugParameterKind;
import org.eclipse.cdt.utils.debug.DebugPointerType;
import org.eclipse.cdt.utils.debug.DebugReferenceType;
import org.eclipse.cdt.utils.debug.DebugStructType;
import org.eclipse.cdt.utils.debug.DebugType;
import org.eclipse.cdt.utils.debug.DebugUnknownType;
import org.eclipse.cdt.utils.debug.DebugVariableKind;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.stabs.StringField;
import org.eclipse.cdt.utils.debug.stabs.TypeInformation;
import org.eclipse.cdt.utils.debug.stabs.TypeNumber;
import org.eclipse.cdt.utils.debug.tools.DebugSym;
import org.eclipse.cdt.utils.debug.tools.DebugSymsRequestor;
import org.eclipse.cdt.utils.elf.Elf;

public class Stabs {
    static final String LLLOW = "01000000000000000000000";
    static final String LLHIGH = "0777777777777777777777";
    static final String ULLHIGH = "01777777777777777777777";
    byte[] stabData;
    byte[] stabstrData;
    boolean isLe;
    boolean inCompilationUnit;
    boolean inFunction;
    boolean inInclude;
    int bracket;
    String currentFile;
    Map mapTypes = new HashMap();
    DebugType voidType = new DebugBaseType("void", 0, false);

    public Stabs(String string) throws IOException {
        Elf elf = new Elf(string);
        this.init(elf);
        elf.dispose();
    }

    public Stabs(Elf elf) throws IOException {
        this.init(elf);
    }

    public Stabs(byte[] byArray, byte[] byArray2, boolean bl) {
        this.init(byArray, byArray2, bl);
    }

    void init(Elf elf) throws IOException {
        boolean bl;
        byte[] byArray = null;
        byte[] byArray2 = null;
        Elf.Section[] sectionArray = elf.getSections();
        int n = 0;
        while (n < sectionArray.length) {
            String string = sectionArray[n].toString();
            if (string.equals(".stab")) {
                byArray = sectionArray[n].loadSectionData();
            } else if (string.equals(".stabstr")) {
                byArray2 = sectionArray[n].loadSectionData();
            }
            ++n;
        }
        Elf.ELFhdr eLFhdr = elf.getELFhdr();
        boolean bl2 = bl = eLFhdr.e_ident[5] == 1;
        if (byArray != null && byArray2 != null) {
            this.init(byArray, byArray2, bl);
        }
    }

    void init(byte[] byArray, byte[] byArray2, boolean bl) {
        this.stabData = byArray;
        this.stabstrData = byArray2;
        this.isLe = bl;
    }

    String makeString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        while (l < (long)this.stabstrData.length) {
            byte by = this.stabstrData[(int)l];
            if (by == 0) break;
            stringBuffer.append((char)by);
            ++l;
        }
        return stringBuffer.toString();
    }

    int read_4_bytes(byte[] byArray, int n) {
        if (this.isLe) {
            return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        }
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    short read_2_bytes(byte[] byArray, int n) {
        if (this.isLe) {
            return (short)((byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF);
        }
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public void parse(IDebugEntryRequestor iDebugEntryRequestor) {
        new ArrayList();
        long l = this.stabData.length / 12;
        String string = null;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        short s = 0;
        long l3 = 0L;
        int n3 = 0;
        int n4 = 0;
        this.bracket = 0;
        while ((long)n4 < l) {
            l2 = this.read_4_bytes(this.stabData, n3);
            n = 0xFF & this.stabData[n3 + 4];
            n2 = 0xFF & this.stabData[n3 + 5];
            s = this.read_2_bytes(this.stabData, n3 + 6);
            l3 = this.read_4_bytes(this.stabData, n3 + 8);
            String string2 = l2 > 0L ? this.makeString(l2) : new String();
            if (string2.endsWith("\\") || string2.endsWith("?")) {
                string2 = string2.substring(0, string2.length() - 1);
                string = string == null ? string2 : String.valueOf(string) + string2;
            } else {
                if (string != null) {
                    string2 = String.valueOf(string) + string2;
                    string = null;
                }
                this.parseStabEntry(iDebugEntryRequestor, string2, n, n2, s, l3);
            }
            ++n4;
            n3 += 12;
        }
        if (this.inFunction) {
            iDebugEntryRequestor.exitFunction(-1L);
            this.inFunction = false;
        }
        if (this.inInclude) {
            iDebugEntryRequestor.exitInclude();
            this.inInclude = false;
        }
        if (this.inCompilationUnit) {
            iDebugEntryRequestor.exitCompilationUnit(l3);
            this.inCompilationUnit = false;
            this.currentFile = null;
        }
    }

    void parseStabEntry(IDebugEntryRequestor iDebugEntryRequestor, String string, int n, int n2, short s, long l) {
        switch (n) {
            case 32: 
            case 128: 
            case 160: {
                this.parseStabString(iDebugEntryRequestor, string, l);
                break;
            }
            case 68: {
                iDebugEntryRequestor.acceptStatement(s, l);
                break;
            }
            case 36: {
                if (this.inFunction) {
                    iDebugEntryRequestor.exitFunction(l);
                    this.inFunction = false;
                }
                if (string.length() == 0) {
                    string = " anon ";
                }
                this.inFunction = true;
                this.parseStabString(iDebugEntryRequestor, string, l);
                break;
            }
            case 192: {
                if (this.inFunction) {
                    iDebugEntryRequestor.enterCodeBlock(l);
                }
                ++this.bracket;
                break;
            }
            case 224: {
                iDebugEntryRequestor.exitCodeBlock(l);
                --this.bracket;
                break;
            }
            case 130: {
                iDebugEntryRequestor.enterInclude(string);
                this.inInclude = true;
                break;
            }
            case 162: {
                iDebugEntryRequestor.exitInclude();
                this.inInclude = false;
                break;
            }
            case 132: {
                if (this.inInclude) {
                    iDebugEntryRequestor.exitInclude();
                    this.inInclude = false;
                }
                iDebugEntryRequestor.enterInclude(string);
                this.inInclude = true;
                break;
            }
            case 84: {
                this.parseStabString(iDebugEntryRequestor, string, l);
                break;
            }
            case 100: {
                if (this.inFunction) {
                    iDebugEntryRequestor.exitFunction(-1L);
                    this.inFunction = false;
                }
                if (this.inInclude) {
                    iDebugEntryRequestor.exitInclude();
                    this.inInclude = false;
                }
                if (this.inCompilationUnit) {
                    iDebugEntryRequestor.exitCompilationUnit(l);
                    this.inCompilationUnit = false;
                    this.currentFile = null;
                }
                if (string == null || string.length() <= 0) break;
                if (string.endsWith("/")) {
                    this.currentFile = string;
                    break;
                }
                this.currentFile = this.currentFile != null ? String.valueOf(this.currentFile) + string : string;
                iDebugEntryRequestor.enterCompilationUnit(this.currentFile, l);
                this.inCompilationUnit = true;
                this.currentFile = null;
            }
        }
    }

    void parseStabString(IDebugEntryRequestor iDebugEntryRequestor, String string, long l) {
        StringField stringField = new StringField(string);
        switch (stringField.getSymbolDescriptor()) {
            case ':': {
                break;
            }
            case 'a': {
                String string2 = stringField.getTypeInformation();
                String string3 = stringField.getName();
                DebugParameterKind debugParameterKind = DebugParameterKind.REGISTER_REFERENCE;
                DebugType debugType = this.parseStabType("", string2);
                iDebugEntryRequestor.acceptParameter(string3, debugType, debugParameterKind, l);
                break;
            }
            case 'b': {
                break;
            }
            case 'c': {
                String string4 = stringField.getName();
                String string5 = stringField.getTypeInformation();
                this.parseStabConstant(iDebugEntryRequestor, string4, string5, l);
                break;
            }
            case 'C': {
                String string6 = stringField.getName();
                String string7 = stringField.getTypeInformation();
                DebugType debugType = this.parseStabType("", string7);
                iDebugEntryRequestor.acceptCaughtException(string6, debugType, l);
                break;
            }
            case 'F': 
            case 'f': {
                String string8 = stringField.getName();
                String string9 = stringField.getTypeInformation();
                DebugType debugType = this.parseStabType("", string9);
                boolean bl = stringField.getSymbolDescriptor() == 'F';
                iDebugEntryRequestor.enterFunction(string8, debugType, bl, l);
                break;
            }
            case 'G': {
                String string10 = stringField.getName();
                String string11 = stringField.getTypeInformation();
                DebugVariableKind debugVariableKind = DebugVariableKind.GLOBAL;
                DebugType debugType = this.parseStabType("", string11);
                iDebugEntryRequestor.acceptVariable(string10, debugType, debugVariableKind, l);
                break;
            }
            case 'i': {
                break;
            }
            case 'I': {
                break;
            }
            case 'J': {
                break;
            }
            case 'L': {
                break;
            }
            case 'm': {
                break;
            }
            case 'p': {
                String string12 = stringField.getName();
                String string13 = stringField.getTypeInformation();
                DebugParameterKind debugParameterKind = DebugParameterKind.STACK;
                DebugType debugType = this.parseStabType("", string13);
                iDebugEntryRequestor.acceptParameter(string12, debugType, debugParameterKind, l);
                break;
            }
            case 'D': 
            case 'P': 
            case 'R': {
                String string14 = stringField.getName();
                String string15 = stringField.getTypeInformation();
                DebugParameterKind debugParameterKind = DebugParameterKind.REGISTER;
                DebugType debugType = this.parseStabType("", string15);
                iDebugEntryRequestor.acceptParameter(string14, debugType, debugParameterKind, l);
                break;
            }
            case 'Q': {
                break;
            }
            case 'd': 
            case 'r': {
                String string16 = stringField.getName();
                String string17 = stringField.getTypeInformation();
                DebugVariableKind debugVariableKind = DebugVariableKind.REGISTER;
                DebugType debugType = this.parseStabType("", string17);
                iDebugEntryRequestor.acceptVariable(string16, debugType, debugVariableKind, l);
                break;
            }
            case 'S': {
                String string18 = stringField.getName();
                String string19 = stringField.getTypeInformation();
                DebugVariableKind debugVariableKind = DebugVariableKind.STATIC;
                DebugType debugType = this.parseStabType("", string19);
                iDebugEntryRequestor.acceptVariable(string18, debugType, debugVariableKind, l);
                break;
            }
            case 't': {
                String string20 = stringField.getName();
                String string21 = stringField.getTypeInformation();
                DebugType debugType = this.parseStabType(string20, string21);
                iDebugEntryRequestor.acceptTypeDef(string20, debugType);
                break;
            }
            case 'T': {
                String string22 = stringField.getTypeInformation();
                if (string22.length() > 0 && string22.charAt(0) == 't') {
                    string22.substring(1);
                    this.parseStabString(iDebugEntryRequestor, string, l);
                    break;
                }
                String string23 = stringField.getName();
                this.parseStabType(string23, string22);
                break;
            }
            case 'v': {
                String string24 = stringField.getName();
                String string25 = stringField.getTypeInformation();
                DebugParameterKind debugParameterKind = DebugParameterKind.REFERENCE;
                DebugType debugType = this.parseStabType("", string25);
                iDebugEntryRequestor.acceptParameter(string24, debugType, debugParameterKind, l);
                break;
            }
            case 'V': {
                String string26 = stringField.getName();
                String string27 = stringField.getTypeInformation();
                DebugVariableKind debugVariableKind = DebugVariableKind.LOCAL_STATIC;
                DebugType debugType = this.parseStabType("", string27);
                iDebugEntryRequestor.acceptVariable(string26, debugType, debugVariableKind, l);
                break;
            }
            case 'x': {
                break;
            }
            default: {
                String string28 = stringField.getName();
                String string29 = stringField.getTypeInformation();
                DebugVariableKind debugVariableKind = DebugVariableKind.LOCAL;
                DebugType debugType = this.parseStabType("", string29);
                iDebugEntryRequestor.acceptVariable(string28, debugType, debugVariableKind, l);
            }
        }
    }

    DebugType parseStabType(String string, String string2) {
        try {
            StringReader stringReader = new StringReader(string2);
            return this.parseStabType(string, stringReader);
        }
        catch (IOException iOException) {
            return new DebugUnknownType(string);
        }
    }

    DebugType parseStabType(String string, Reader reader) throws IOException {
        return this.parseStabType(string, null, reader);
    }

    DebugType parseStabType(String string, TypeInformation typeInformation, Reader reader) throws IOException {
        TypeInformation typeInformation2 = new TypeInformation(reader);
        DebugType debugType = null;
        switch (typeInformation2.getTypeDescriptor()) {
            case '#': {
                break;
            }
            case '&': {
                DebugType debugType2 = this.parseStabType("", reader);
                debugType = new DebugReferenceType(debugType2);
                break;
            }
            case '@': {
                break;
            }
            case '*': {
                DebugType debugType3 = this.parseStabType("", reader);
                debugType = new DebugPointerType(debugType3);
                break;
            }
            case 'R': 
            case 'b': 
            case 'c': 
            case 'g': 
            case 'w': {
                char c = typeInformation2.getTypeDescriptor();
                debugType = this.parseStabBuiltinType(string, c, reader);
                break;
            }
            case 'A': 
            case 'a': {
                debugType = this.parseStabArrayType(string, reader);
                break;
            }
            case 'B': {
                break;
            }
            case 'C': {
                break;
            }
            case 'd': {
                break;
            }
            case 'D': {
                break;
            }
            case 'e': {
                debugType = this.parseStabEnumType(string, reader);
                break;
            }
            case 'E': {
                break;
            }
            case 'f': {
                DebugType debugType4 = this.parseStabType("", reader);
                debugType = new DebugFunctionType(debugType4);
                break;
            }
            case 'F': {
                break;
            }
            case 'G': {
                break;
            }
            case 'i': {
                break;
            }
            case 'k': {
                break;
            }
            case 'K': {
                break;
            }
            case 'M': {
                break;
            }
            case 'n': {
                break;
            }
            case 'N': {
                break;
            }
            case 'o': {
                break;
            }
            case 'p': {
                break;
            }
            case 'P': {
                break;
            }
            case 'r': {
                debugType = this.parseStabRangeType(string, typeInformation2.getTypeNumber(), reader);
                break;
            }
            case 's': {
                debugType = this.parseStabStructType(string, typeInformation2.getTypeNumber(), false, reader);
                break;
            }
            case 'u': {
                debugType = this.parseStabStructType(string, typeInformation2.getTypeNumber(), true, reader);
                break;
            }
            case 'S': {
                break;
            }
            case 'v': {
                break;
            }
            case 'x': {
                debugType = this.parseStabCrossRefType(string, reader);
                break;
            }
            case 'Y': {
                break;
            }
            case 'z': {
                break;
            }
            default: {
                debugType = typeInformation2.isTypeDefinition() ? this.parseStabType(string, typeInformation2, reader) : (typeInformation != null && typeInformation.getTypeNumber().equals(typeInformation2.getTypeNumber()) ? this.voidType : this.getDebugType(typeInformation2.getTypeNumber()));
            }
        }
        if (debugType != null && typeInformation2.isTypeDefinition()) {
            this.mapTypes.put(typeInformation2.getTypeNumber(), debugType);
        }
        if (debugType == null) {
            debugType = new DebugUnknownType(string);
        }
        return debugType;
    }

    DebugType parseStabCrossRefType(String string, Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = reader.read();
        if (n == 115) {
            stringBuffer.append("struct ");
        } else if (n == 117) {
            stringBuffer.append("union ");
        } else if (n == 101) {
            stringBuffer.append("enum ");
        } else {
            stringBuffer.append((char)n);
        }
        while ((n = reader.read()) != -1) {
            if (n == 58) break;
            stringBuffer.append((char)n);
        }
        return new DebugCrossRefType(null, string, stringBuffer.toString());
    }

    private DebugType parseStabBuiltinType(String string, char c, Reader reader) throws IOException {
        DebugBaseType debugBaseType = null;
        switch (c) {
            case 'b': {
                String string2;
                int n;
                int n2 = reader.read();
                reader.mark(1);
                int n3 = reader.read();
                if (n3 != 99) {
                    reader.reset();
                }
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = reader.read()) != -1) {
                    if (n == 59) break;
                    stringBuffer.append((char)n);
                }
                try {
                    string2 = stringBuffer.toString();
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
                stringBuffer.setLength(0);
                while ((n = reader.read()) != -1) {
                    if (n == 59) break;
                    stringBuffer.append((char)n);
                }
                try {
                    string2 = stringBuffer.toString();
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
                stringBuffer.setLength(0);
                int n4 = 0;
                while ((n = reader.read()) != -1) {
                    if (n == 59) break;
                    stringBuffer.append((char)n);
                }
                try {
                    String string3 = stringBuffer.toString();
                    n4 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {}
                debugBaseType = new DebugBaseType(string, n4 / 8, n2 == 117);
                break;
            }
            case 'w': {
                debugBaseType = new DebugBaseType(string, 8, false);
                break;
            }
            case 'R': {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = reader.read()) != -1) {
                    if (n == 59) break;
                    stringBuffer.append((char)n);
                }
                try {
                    String string4 = stringBuffer.toString();
                    Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {}
                stringBuffer.setLength(0);
                int n5 = 0;
                while ((n = reader.read()) != -1) {
                    if (n == 59) break;
                    stringBuffer.append((char)n);
                }
                try {
                    String string5 = stringBuffer.toString();
                    n5 = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {}
                debugBaseType = new DebugBaseType(string, n5, false);
                break;
            }
            case 'c': 
            case 'g': {
                this.parseStabType(string, reader);
                int n = reader.read();
                StringBuffer stringBuffer = new StringBuffer();
                int n6 = 0;
                while ((n = reader.read()) != -1) {
                    stringBuffer.append((char)n);
                }
                try {
                    String string6 = stringBuffer.toString();
                    n6 = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {}
                debugBaseType = new DebugBaseType(string, n6 / 8, false);
            }
        }
        return debugBaseType;
    }

    DebugType parseStabArrayType(String string, Reader reader) throws IOException {
        int n = reader.read();
        if (n == 114) {
            Object object;
            this.parseStabType("", reader);
            n = reader.read();
            if (n != 59) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = reader.read()) != -1) {
                if (n == 59) break;
                stringBuffer.append((char)n);
            }
            if (n != 59) {
                return null;
            }
            int n2 = 0;
            try {
                String string2 = stringBuffer.toString();
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
            stringBuffer.setLength(0);
            while ((n = reader.read()) != -1) {
                if (n == 59) break;
                stringBuffer.append((char)n);
            }
            if (n != 59) {
                return null;
            }
            int n3 = 0;
            try {
                object = stringBuffer.toString();
                n3 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
            if (n != 59) {
                return null;
            }
            object = this.parseStabType("", reader);
            return new DebugArrayType((DebugType)object, n3 - n2 + 1);
        }
        return new DebugArrayType(new DebugUnknownType(string), 0);
    }

    DebugType parseStabEnumType(String string, Reader reader) throws IOException {
        Object object;
        int n;
        ArrayList<DebugEnumField> arrayList = new ArrayList<DebugEnumField>();
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != -1) {
            if (n == 58) {
                string2 = stringBuffer.toString();
                stringBuffer.setLength(0);
                continue;
            }
            if (n == 44) {
                if (string2 != null && string2.length() > 0) {
                    object = stringBuffer.toString();
                    int n2 = 0;
                    try {
                        n2 = Integer.decode((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    arrayList.add(new DebugEnumField(string2, n2));
                }
                string2 = null;
                stringBuffer.setLength(0);
                continue;
            }
            if (n == 59) break;
            stringBuffer.append((char)n);
        }
        object = new DebugEnumField[arrayList.size()];
        arrayList.toArray((T[])object);
        return new DebugEnumType(string, (DebugEnumField[])object);
    }

    DebugType parseStabStructType(String string, TypeNumber typeNumber, boolean bl, Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != -1) {
            if (!Character.isDigit((char)n)) {
                reader.reset();
                break;
            }
            reader.mark(1);
            stringBuffer.append((char)n);
        }
        String string2 = stringBuffer.toString();
        int n2 = 0;
        try {
            n2 = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        DebugStructType debugStructType = new DebugStructType(string, n2, bl);
        this.mapTypes.put(typeNumber, debugStructType);
        this.parseStabStructField(debugStructType, reader);
        return debugStructType;
    }

    void parseStabStructField(DebugStructType debugStructType, Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != -1) {
            if (n == 58) break;
            stringBuffer.append((char)n);
        }
        if (n != 58) {
            return;
        }
        String string = stringBuffer.toString();
        DebugType debugType = this.parseStabType("", reader);
        n = reader.read();
        if (n != 44) {
            return;
        }
        stringBuffer.setLength(0);
        while ((n = reader.read()) != -1 && n != 44) {
            stringBuffer.append((char)n);
        }
        if (n != 44) {
            return;
        }
        int n2 = 0;
        try {
            n2 = Integer.decode(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {}
        stringBuffer.setLength(0);
        while ((n = reader.read()) != -1 && n != 59) {
            stringBuffer.append((char)n);
        }
        if (n != 59) {
            return;
        }
        int n3 = 0;
        try {
            n3 = Integer.decode(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {}
        debugStructType.addField(new DebugField(string, debugType, n2, n3));
        this.parseStabStructField(debugStructType, reader);
    }

    DebugType parseStabRangeType(String string, TypeNumber typeNumber, Reader reader) throws IOException {
        DebugBaseType debugBaseType = null;
        TypeNumber typeNumber2 = new TypeNumber(reader);
        int n = reader.read();
        if (n != 59) {
            return new DebugUnknownType(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != -1) {
            if (n == 59) break;
            stringBuffer.append((char)n);
        }
        if (n != 59) {
            return new DebugUnknownType(string);
        }
        boolean bl = false;
        String string2 = stringBuffer.toString();
        long l = 0L;
        try {
            l = Long.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        stringBuffer.setLength(0);
        while ((n = reader.read()) != -1) {
            if (n == 59) break;
            stringBuffer.append((char)n);
        }
        if (n != 59) {
            return new DebugUnknownType(string);
        }
        boolean bl2 = false;
        long l2 = 0L;
        String string3 = stringBuffer.toString();
        try {
            l2 = Long.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = true;
        }
        if (typeNumber2 == null) {
            typeNumber2 = new TypeNumber(0, 0);
        }
        boolean bl3 = typeNumber2.equals(typeNumber);
        if (bl || bl2) {
            if (string2.equals(LLLOW) && string3.equals(LLHIGH)) {
                debugBaseType = new DebugBaseType(string, 8, false);
            }
            if (!bl && l == 0L && string3.equals(ULLHIGH)) {
                debugBaseType = new DebugBaseType(string, 8, true);
            }
        } else if (l == 0L && l2 == -1L) {
            debugBaseType = string.equals("long long int") ? new DebugBaseType(string, 8, true) : (string.equals("long long unsigned int") ? new DebugBaseType(string, 8, true) : new DebugBaseType(string, 4, true));
        } else if (l2 == 0L && l > 0L) {
            debugBaseType = new DebugBaseType(string, (int)l, true);
        } else if (l == -128L && l2 == 127L) {
            debugBaseType = new DebugBaseType(string, 1, false);
        } else if (bl3 && l == 0L && l2 == 127L) {
            debugBaseType = new DebugBaseType(string, 1, false);
        } else if (bl3 && l == 0L && l2 == 255L) {
            debugBaseType = new DebugBaseType(string, 1, true);
        } else if (l == -32768L && l2 == 32767L) {
            debugBaseType = new DebugBaseType(string, 2, false);
        } else if (bl3 && l == 0L && l2 == 65535L) {
            debugBaseType = new DebugBaseType(string, 2, true);
        } else if (l == Integer.MIN_VALUE && l2 == Integer.MAX_VALUE) {
            debugBaseType = new DebugBaseType(string, 4, false);
        }
        return debugBaseType;
    }

    void parseStabConstant(IDebugEntryRequestor iDebugEntryRequestor, String string, String string2, long l) {
        try {
            this.parseStabConstant(iDebugEntryRequestor, string, new StringReader(string2), l);
        }
        catch (IOException iOException) {}
    }

    void parseStabConstant(IDebugEntryRequestor iDebugEntryRequestor, String string, Reader reader, long l) throws IOException {
        block20: {
            int n = reader.read();
            if (n != 61) break block20;
            n = reader.read();
            switch (n) {
                case 98: {
                    break;
                }
                case 99: {
                    break;
                }
                case 101: {
                    int n2 = 0;
                    DebugType debugType = this.parseStabType("", reader);
                    n = reader.read();
                    if (n == 44) {
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((n = reader.read()) != -1) {
                            stringBuffer.append((char)n);
                        }
                        try {
                            String string2 = stringBuffer.toString();
                            n2 = Integer.decode(string2);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    iDebugEntryRequestor.acceptTypeConst(string, debugType, n2);
                    break;
                }
                case 105: {
                    int n3 = 0;
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n = reader.read()) != -1) {
                        stringBuffer.append((char)n);
                    }
                    try {
                        String string3 = stringBuffer.toString();
                        n3 = Integer.decode(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    iDebugEntryRequestor.acceptIntegerConst(string, n3);
                    break;
                }
                case 114: {
                    double d = 0.0;
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n = reader.read()) != -1) {
                        stringBuffer.append((char)n);
                    }
                    try {
                        String string4 = stringBuffer.toString();
                        d = string4.equals("-INF") ? Double.NEGATIVE_INFINITY : (string4.equals("INF") ? Double.POSITIVE_INFINITY : (string4.equals("QNAN") ? Double.NaN : (string4.equals("SNAN") ? Double.NaN : Double.parseDouble(string4))));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    iDebugEntryRequestor.acceptFloatConst(string, d);
                    break;
                }
                case 115: {
                    break;
                }
            }
        }
    }

    DebugType getDebugType(TypeNumber typeNumber) {
        return (DebugType)this.mapTypes.get(typeNumber);
    }

    public static void main(String[] stringArray) {
        try {
            DebugSymsRequestor debugSymsRequestor = new DebugSymsRequestor();
            Stabs stabs = new Stabs(stringArray[0]);
            stabs.parse(debugSymsRequestor);
            DebugSym[] debugSymArray = debugSymsRequestor.getEntries();
            int n = 0;
            while (n < debugSymArray.length) {
                DebugSym debugSym = debugSymArray[n];
                System.out.println(debugSym);
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

