/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.SymbolSortCompare;

public class ElfHelper {
    private Elf elf;
    private Elf.ELFhdr hdr;
    private Elf.Attribute attrib;
    private Elf.Symbol[] dynsyms;
    private Elf.Symbol[] symbols;
    private Elf.Section[] sections;
    private Elf.Dynamic[] dynamics;

    public void dispose() {
        if (this.elf != null) {
            this.elf.dispose();
            this.elf = null;
        }
    }

    private void loadSymbols() throws IOException {
        if (this.symbols == null) {
            this.elf.loadSymbols();
            this.symbols = this.elf.getSymtabSymbols();
            this.dynsyms = this.elf.getDynamicSymbols();
            if (this.symbols.length <= 0) {
                this.symbols = this.dynsyms;
            }
            if (this.dynsyms.length <= 0) {
                this.dynsyms = this.symbols;
            }
        }
    }

    private void loadSections() throws IOException {
        if (this.sections == null) {
            this.sections = this.elf.getSections();
        }
    }

    private void loadDynamics() throws IOException {
        if (this.dynamics == null) {
            this.dynamics = new Elf.Dynamic[0];
            Elf.Section section = this.elf.getSectionByName(".dynamic");
            if (section != null) {
                this.dynamics = this.elf.getDynamicSections(section);
            }
        }
    }

    private void commonSetup() throws IOException {
        this.hdr = this.elf.getELFhdr();
        this.attrib = this.elf.getAttributes();
    }

    public ElfHelper(Elf elf) throws IOException {
        this.elf = elf;
        this.commonSetup();
    }

    public ElfHelper(String string) throws IOException {
        this.elf = new Elf(string);
        this.commonSetup();
    }

    public ElfHelper(String string, boolean bl) throws IOException {
        this.elf = new Elf(string, bl);
        this.commonSetup();
    }

    public Elf getElf() {
        return this.elf;
    }

    public Elf.Symbol[] getExternalFunctions() throws IOException {
        Vector<Elf.Symbol> vector = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        int n = 0;
        while (n < this.dynsyms.length) {
            if (this.dynsyms[n].st_bind() == 1 && this.dynsyms[n].st_type() == 2) {
                short s = this.dynsyms[n].st_shndx;
                if (s < -225 && s > -256) {
                    String string = this.dynsyms[n].toString();
                    if (string != null && string.trim().length() > 0) {
                        vector.add(this.dynsyms[n]);
                    }
                } else if (s >= 0 && this.sections[s].sh_type == 0L) {
                    vector.add(this.dynsyms[n]);
                }
            }
            ++n;
        }
        Elf.Symbol[] symbolArray = vector.toArray(new Elf.Symbol[0]);
        Arrays.sort(symbolArray, new SymbolSortCompare());
        return symbolArray;
    }

    public Elf.Symbol[] getExternalObjects() throws IOException {
        Vector<Elf.Symbol> vector = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        int n = 0;
        while (n < this.dynsyms.length) {
            if (this.dynsyms[n].st_bind() == 1 && this.dynsyms[n].st_type() == 1) {
                short s = this.dynsyms[n].st_shndx;
                if (s < -225 && s > -256) {
                    String string = this.dynsyms[n].toString();
                    if (string != null && string.trim().length() > 0) {
                        vector.add(this.dynsyms[n]);
                    }
                } else if (s >= 0 && this.sections[s].sh_type == 0L) {
                    vector.add(this.dynsyms[n]);
                }
            }
            ++n;
        }
        Elf.Symbol[] symbolArray = vector.toArray(new Elf.Symbol[0]);
        Arrays.sort(symbolArray, new SymbolSortCompare());
        return symbolArray;
    }

    public Elf.Symbol[] getUndefined() throws IOException {
        Vector<Elf.Symbol> vector = new Vector<Elf.Symbol>();
        this.loadSymbols();
        int n = 0;
        while (n < this.dynsyms.length) {
            if (this.dynsyms[n].st_shndx == 0) {
                vector.add(this.dynsyms[n]);
            }
            ++n;
        }
        Elf.Symbol[] symbolArray = vector.toArray(new Elf.Symbol[0]);
        Arrays.sort(symbolArray, new SymbolSortCompare());
        return symbolArray;
    }

    public Elf.Symbol[] getLocalFunctions() throws IOException {
        Vector<Elf.Symbol> vector = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        int n = 0;
        while (n < this.symbols.length) {
            if (this.symbols[n].st_bind() == 1 && this.symbols[n].st_type() == 2) {
                short s = this.symbols[n].st_shndx;
                if (s < -225 && s > -256) {
                    String string = this.symbols[n].toString();
                    if (string != null && string.trim().length() > 0) {
                        vector.add(this.symbols[n]);
                    }
                } else if (s >= 0 && this.sections[s].sh_type != 0L) {
                    vector.add(this.symbols[n]);
                }
            }
            ++n;
        }
        Elf.Symbol[] symbolArray = vector.toArray(new Elf.Symbol[0]);
        Arrays.sort(symbolArray, new SymbolSortCompare());
        return symbolArray;
    }

    public Elf.Symbol[] getLocalObjects() throws IOException {
        Vector<Elf.Symbol> vector = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        int n = 0;
        while (n < this.symbols.length) {
            if (this.symbols[n].st_bind() == 1 && this.symbols[n].st_type() == 1) {
                short s = this.symbols[n].st_shndx;
                if (s < -225 && s > -256) {
                    String string = this.symbols[n].toString();
                    if (string != null && string.trim().length() > 0) {
                        vector.add(this.symbols[n]);
                    }
                } else if (s >= 0 && this.sections[s].sh_type != 0L) {
                    vector.add(this.symbols[n]);
                }
            }
            ++n;
        }
        Elf.Symbol[] symbolArray = vector.toArray(new Elf.Symbol[0]);
        Arrays.sort(symbolArray, new SymbolSortCompare());
        return symbolArray;
    }

    public Elf.Symbol[] getCommonObjects() throws IOException {
        Vector<Elf.Symbol> vector = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        int n = 0;
        while (n < this.symbols.length) {
            short s;
            if (this.symbols[n].st_bind() == 1 && this.symbols[n].st_type() == 1 && (s = this.symbols[n].st_shndx) == -14) {
                vector.add(this.symbols[n]);
            }
            ++n;
        }
        Elf.Symbol[] symbolArray = vector.toArray(new Elf.Symbol[0]);
        Arrays.sort(symbolArray, new SymbolSortCompare());
        return symbolArray;
    }

    public Elf.Dynamic[] getNeeded() throws IOException {
        Vector<Elf.Dynamic> vector = new Vector<Elf.Dynamic>();
        this.loadDynamics();
        int n = 0;
        while (n < this.dynamics.length) {
            if (this.dynamics[n].d_tag == 1L) {
                vector.add(this.dynamics[n]);
            }
            ++n;
        }
        return vector.toArray(new Elf.Dynamic[0]);
    }

    public String getSoname() throws IOException {
        String string = "";
        this.loadDynamics();
        int n = 0;
        while (n < this.dynamics.length) {
            if (this.dynamics[n].d_tag == 14L) {
                string = this.dynamics[n].toString();
            }
            ++n;
        }
        return string;
    }

    private String getSubUsage(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) == '%' && string.charAt(n3 + 1) == '-') {
                if (n == 0) {
                    int n4 = string.indexOf(10, n3 + 2);
                    String string3 = string.substring(n3 + 2, n4);
                    if (string3.compareTo(string2) == 0) {
                        n = n4;
                    }
                } else if (n2 == 0) {
                    n2 = n3 - 1;
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            n2 = string.length();
        }
        if (n == 0) {
            return string;
        }
        return string.substring(n, n2);
    }

    public String getQnxUsage() throws IOException {
        this.loadSections();
        int n = 0;
        while (n < this.sections.length) {
            if (this.sections[n].toString().compareTo("QNX_usage") == 0) {
                File file = new File(this.elf.getFilename());
                String string = new String(this.sections[n].loadSectionData());
                String string2 = this.getSubUsage(string, file.getName());
                StringBuffer stringBuffer = new StringBuffer(string2);
                int n2 = 0;
                while (n2 < stringBuffer.length()) {
                    if (stringBuffer.charAt(n2) == '%' && stringBuffer.charAt(n2 + 1) == 'C') {
                        stringBuffer.replace(n2, n2 + 2, file.getName());
                    }
                    ++n2;
                }
                return stringBuffer.toString();
            }
            ++n;
        }
        return new String("");
    }

    public Sizes getSizes() throws IOException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        this.loadSections();
        int n = 0;
        while (n < this.sections.length) {
            if (this.sections[n].sh_type != 8L) {
                if (this.sections[n].sh_flags == 3L) {
                    l2 += this.sections[n].sh_size;
                } else if ((this.sections[n].sh_flags & 2L) != 0L) {
                    l += this.sections[n].sh_size;
                }
            } else if (this.sections[n].sh_flags == 3L) {
                l3 += this.sections[n].sh_size;
            }
            ++n;
        }
        return new Sizes(l, l2, l3);
    }

    public class Sizes {
        public long text;
        public long data;
        public long bss;
        public long total;

        public Sizes(long l, long l2, long l3) {
            this.text = l;
            this.data = l2;
            this.bss = l3;
            this.total = this.text + this.data + this.bss;
        }
    }
}

