/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.StandardCElementLabelProvider;
import org.eclipse.cdt.internal.ui.cview.CLibFilter;
import org.eclipse.cdt.internal.ui.cview.CPatternFilter;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.internal.ui.cview.CViewDropAdapter;
import org.eclipse.cdt.internal.ui.cview.CViewElementComparer;
import org.eclipse.cdt.internal.ui.cview.CViewFrameSource;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.cview.MainActionGroup;
import org.eclipse.cdt.internal.ui.cview.SelectionConverter;
import org.eclipse.cdt.internal.ui.drag.DelegatingDragAdapter;
import org.eclipse.cdt.internal.ui.drag.FileTransferDragAdapter;
import org.eclipse.cdt.internal.ui.drag.LocalSelectionTransferDragAdapter;
import org.eclipse.cdt.internal.ui.drag.ResourceTransferDragAdapter;
import org.eclipse.cdt.internal.ui.drag.TransferDragSourceListener;
import org.eclipse.cdt.internal.ui.preferences.CPluginPreferencePage;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CElementSorter;
import org.eclipse.cdt.ui.CLocalSelectionTransfer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class CView
extends ViewPart
implements ISetSelectionTarget,
IPropertyChangeListener,
IShowInTarget {
    ProblemTreeViewer viewer;
    IMemento memento;
    CViewActionGroup actionGroup;
    FrameList frameList;
    CViewFrameSource frameSource;
    CLibFilter clibFilter = new CLibFilter();
    CPatternFilter patternFilter = new CPatternFilter();
    ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    private boolean dragDetected;
    private Listener dragDetectListener;
    static final String TAG_SELECTION = "selection";
    static final String TAG_EXPANDED = "expanded";
    static final String TAG_ELEMENT = "element";
    static final String TAG_PATH = "path";
    static final String TAG_VERTICAL_POSITION = "verticalPosition";
    static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static final String TAG_FILTERS = "filters";
    static final String TAG_FILTER = "filter";
    static final String TAG_SHOWLIBRARIES = "showLibraries";
    static final String TAG_WORKINGSET = "workingSet";
    static final String TAG_SORTER = "sorter";
    final String WORKING_GROUP_MARKER = "workingSetGroup";
    final String WORKING_GROUP_MARKER_END = "end-workingSetGroup";
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof IEditorPart) {
                CView.this.editorActivated((IEditorPart)iWorkbenchPart);
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };
    private IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            IWorkingSet iWorkingSet = CView.this.workingSetFilter.getWorkingSet();
            if (string == null) {
                return;
            }
            if ("workingSetRemove".equals(string) && object2 == iWorkingSet) {
                CView.this.setWorkingSet(null);
            } else if ("workingSetNameChange".equals(string) && object == iWorkingSet) {
                CView.this.updateTitle();
            } else if ("workingSetContentChange".equals(string) && object == iWorkingSet) {
                CView.this.getViewer().refresh();
            }
        }
    };
    private ITreeViewerListener expansionListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            Control control;
            Object object = treeExpansionEvent.getElement();
            if (object instanceof IParent && (control = CView.this.viewer.getControl()) != null && !control.isDisposed()) {
                control.getDisplay().asyncExec(new Runnable(this, object){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ Object val$element;
                    {
                        this.this$1 = var1_1;
                        this.val$element = object;
                    }

                    public void run() {
                        Control control = 3.access$0(this.this$1).viewer.getControl();
                        if (control != null && !control.isDisposed()) {
                            3.access$0(this.this$1).viewer.expandToLevel(this.val$element, 1);
                        }
                    }
                });
            }
        }

        static /* synthetic */ CView access$0(3 var0) {
            return var0.CView.this;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void selectReveal(ISelection iSelection) {
        IStructuredSelection iStructuredSelection = SelectionConverter.convertSelectionToCElements(iSelection);
        if (!iStructuredSelection.isEmpty()) {
            this.getViewer().setSelection((ISelection)iStructuredSelection, true);
        }
    }

    protected void handleOpen(OpenEvent openEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)openEvent.getSelection();
        this.getActionGroup().runDefaultAction(iStructuredSelection);
    }

    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (this.viewer.isExpandable(object)) {
            if (object instanceof ITranslationUnit || object instanceof IBinary || object instanceof IArchive) {
                return;
            }
            this.viewer.setExpandedState(object, !this.viewer.getExpandedState(object));
        }
    }

    void handleKeyPressed(KeyEvent keyEvent) {
        if (this.getActionGroup() != null) {
            this.getActionGroup().handleKeyPressed(keyEvent);
        }
    }

    protected void handleKeyReleased(KeyEvent keyEvent) {
        if (this.getActionGroup() != null) {
            this.getActionGroup().handleKeyReleased(keyEvent);
        }
    }

    void handleSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        final IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        this.updateStatusLine(iStructuredSelection);
        this.updateActionBars(iStructuredSelection);
        this.dragDetected = false;
        if (this.isLinkingEnabled()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!CView.this.dragDetected) {
                        CView.this.linkToEditor(iStructuredSelection);
                    }
                }
            });
        }
    }

    protected CViewActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected void setActionGroup(CViewActionGroup cViewActionGroup) {
        this.actionGroup = cViewActionGroup;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this.viewer;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return this.getShowInSource();
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.ui.part.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz4) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.memento = iMemento;
    }

    void initFrameList() {
        this.frameSource = new CViewFrameSource(this);
        this.frameList = new FrameList((IFrameSource)this.frameSource);
        this.frameSource.connectTo(this.frameList);
    }

    void initCElementSorter() {
        this.viewer.setSorter(new CElementSorter());
    }

    void initFilters(TreeViewer treeViewer) {
        treeViewer.addFilter((ViewerFilter)this.patternFilter);
        treeViewer.addFilter((ViewerFilter)this.workingSetFilter);
    }

    void initDragAndDrop() {
        int n = 3;
        Transfer[] transferArray = new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), CLocalSelectionTransfer.getInstance(), PluginTransfer.getInstance()};
        TransferDragSourceListener[] transferDragSourceListenerArray = new TransferDragSourceListener[]{new ResourceTransferDragAdapter((ISelectionProvider)this.viewer), new LocalSelectionTransferDragAdapter((ISelectionProvider)this.viewer), new FileTransferDragAdapter((ISelectionProvider)this.viewer)};
        this.viewer.addDragSupport(n, transferArray, new DelegatingDragAdapter((ISelectionProvider)this.viewer, transferDragSourceListenerArray));
        Transfer[] transferArray2 = new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), LocalSelectionTransfer.getInstance(), PluginTransfer.getInstance()};
        this.viewer.addDropSupport(n, transferArray2, (DropTargetListener)new CViewDropAdapter((StructuredViewer)this.viewer));
        this.dragDetectListener = new Listener(){

            public void handleEvent(Event event) {
                CView.this.dragDetected = true;
            }
        };
        this.viewer.getControl().addListener(29, this.dragDetectListener);
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault(TAG_SHOWLIBRARIES, true);
    }

    void initFilterFromPreferences() {
        CUIPlugin cUIPlugin = CUIPlugin.getDefault();
        boolean bl = cUIPlugin.getPreferenceStore().getBoolean(TAG_SHOWLIBRARIES);
        this.getLibraryFilter().setShowLibraries(bl);
    }

    void initContentProvider(TreeViewer treeViewer) {
        CElementContentProvider cElementContentProvider = this.createContentProvider();
        treeViewer.setContentProvider((IContentProvider)cElementContentProvider);
    }

    void initLabelProvider(TreeViewer treeViewer) {
        StandardCElementLabelProvider standardCElementLabelProvider = this.createLabelProvider();
        ILabelDecorator iLabelDecorator = CUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)standardCElementLabelProvider, iLabelDecorator));
    }

    protected void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                CView.this.fillContextMenu(iMenuManager);
            }
        });
        TreeViewer treeViewer = this.getViewer();
        Menu menu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)treeViewer);
    }

    void initWorkingSetFilter() {
        IWorkingSetManager iWorkingSetManager;
        IWorkingSet iWorkingSet;
        if (this.memento == null) {
            return;
        }
        String string = this.memento.getString(TAG_WORKINGSET);
        if (string != null && !string.equals("") && (iWorkingSet = (iWorkingSetManager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager()).getWorkingSet(string)) != null) {
            this.workingSetFilter.setWorkingSet(iWorkingSet);
        }
    }

    protected void initListeners(TreeViewer treeViewer) {
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                CView.this.handleDoubleClick(doubleClickEvent);
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                CView.this.handleSelectionChanged(selectionChangedEvent);
            }
        });
        treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                CView.this.handleOpen(openEvent);
            }
        });
        treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                CView.this.handleKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                CView.this.handleKeyReleased(keyEvent);
            }
        });
    }

    public void createPartControl(Composite composite) {
        this.viewer = this.createViewer(composite);
        this.viewer.setUseHashlookup(true);
        this.viewer.setComparer(new CViewElementComparer());
        this.initContentProvider(this.viewer);
        this.initLabelProvider(this.viewer);
        CUIPlugin.getDefault().getProblemMarkerManager().addListener(this.viewer);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.memento != null) {
            this.restoreFilters();
        } else {
            this.initFilterFromPreferences();
        }
        this.initFilters(this.viewer);
        this.initWorkingSetFilter();
        this.initListeners(this.viewer);
        this.initCElementSorter();
        this.initFrameList();
        this.initDragAndDrop();
        this.updateTitle();
        this.viewer.setInput(CoreModel.getDefault().getCModel());
        this.initContextMenu();
        this.makeActions();
        this.getActionGroup().fillActionBars(this.getViewSite().getActionBars());
        this.updateActionBars((IStructuredSelection)this.viewer.getSelection());
        IWorkingSetManager iWorkingSetManager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager();
        iWorkingSetManager.addPropertyChangeListener(this.workingSetListener);
        this.viewer.addTreeListener(this.expansionListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addPartListener(this.partListener);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
    }

    protected ProblemTreeViewer createViewer(Composite composite) {
        return new ProblemTreeViewer(composite, 770);
    }

    protected CElementContentProvider createContentProvider() {
        boolean bl = CPluginPreferencePage.showCompilationUnitChildren();
        return new CElementContentProvider(bl, true);
    }

    protected StandardCElementLabelProvider createLabelProvider() {
        return new StandardCElementLabelProvider();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.viewer != null) {
            this.viewer.removeTreeListener(this.expansionListener);
            CUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.viewer);
        }
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        IWorkingSetManager iWorkingSetManager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager();
        iWorkingSetManager.removePropertyChangeListener(this.workingSetListener);
        Control control = this.viewer.getControl();
        if (this.dragDetectListener != null && control != null && !control.isDisposed()) {
            control.removeListener(29, this.dragDetectListener);
        }
        super.dispose();
    }

    void editorActivated(IEditorPart iEditorPart) {
        IFileEditorInput iFileEditorInput;
        IFile iFile;
        CoreModel coreModel;
        ICElement iCElement;
        if (!CPluginPreferencePage.isLinkToEditor()) {
            return;
        }
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput && (iCElement = (coreModel = CoreModel.getDefault()).create(iFile = (iFileEditorInput = (IFileEditorInput)iEditorInput).getFile())) != null) {
            StructuredSelection structuredSelection = new StructuredSelection((Object)iCElement);
            if (!this.viewer.getSelection().equals(structuredSelection)) {
                this.viewer.setSelection((ISelection)structuredSelection);
            }
        }
    }

    CLibFilter getLibraryFilter() {
        return this.clibFilter;
    }

    CPatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSetFilter.getWorkingSet();
    }

    public CElementSorter getSorter() {
        return (CElementSorter)this.getViewer().getSorter();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public FrameList getFrameList() {
        return this.frameList;
    }

    void makeActions() {
        this.setActionGroup(new MainActionGroup(this));
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getViewer().getSelection();
        CViewActionGroup cViewActionGroup = this.getActionGroup();
        if (cViewActionGroup != null) {
            cViewActionGroup.setContext(new ActionContext((ISelection)iStructuredSelection));
            cViewActionGroup.fillContextMenu(iMenuManager);
            cViewActionGroup.setContext(null);
        }
    }

    String getToolTipText(Object object) {
        if (object instanceof IResource) {
            IPath iPath = ((IResource)object).getFullPath();
            if (iPath.isRoot()) {
                return "CVIEW";
            }
            return iPath.makeRelative().toString();
        }
        return ((ILabelProvider)this.viewer.getLabelProvider()).getText(object);
    }

    String getStatusLineMessage(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IResource) {
                return ((IResource)object).getFullPath().makeRelative().toString();
            }
            if (object instanceof ICElement) {
                IResource iResource;
                ICElement iCElement = (ICElement)object;
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iCElement.getAdapter((Class)clazz)) != null) {
                    return iResource.getFullPath().toString();
                }
                if (iCElement.getElementType() == 30) {
                    if (iCElement instanceof IBinaryContainer) {
                        ICProject iCProject = iCElement.getCProject();
                        if (iCProject != null) {
                            return iCProject.getPath() + CViewMessages.getString("CView.binaries");
                        }
                    } else if (iCElement instanceof IArchiveContainer) {
                        ICProject iCProject = iCElement.getCProject();
                        if (iCProject != null) {
                            return iCProject.getPath() + CViewMessages.getString("CView.archives");
                        }
                    } else if (iCElement instanceof IBinaryModule) {
                        IBinary iBinary = ((IBinaryModule)iCElement).getBinary();
                        return iBinary.getPath() + ":" + iCElement.getElementName();
                    }
                } else if (iCElement.getElementType() > 60) {
                    return String.valueOf(iCElement.getPath().toString()) + " - [" + iCElement.getElementName() + "]";
                }
                return iCElement.getElementName();
            }
            return "ItemSelected";
        }
        if (iStructuredSelection.size() > 1) {
            return "StatusLine";
        }
        return "";
    }

    protected void updateActionBars(IStructuredSelection iStructuredSelection) {
        CViewActionGroup cViewActionGroup = this.getActionGroup();
        if (cViewActionGroup != null) {
            cViewActionGroup.setContext(new ActionContext((ISelection)iStructuredSelection));
            cViewActionGroup.updateActionBars();
        }
    }

    void updateTitle() {
        Object object = this.getViewer().getInput();
        String string = this.getConfigurationElement().getAttribute("name");
        if (object == null || object instanceof ICModel) {
            this.setTitle(string);
            this.setTitleToolTip("");
        } else {
            ILabelProvider iLabelProvider = (ILabelProvider)this.getViewer().getLabelProvider();
            String string2 = iLabelProvider.getText(object);
            this.setTitle(string2);
            this.setTitleToolTip(this.getToolTipText(object));
        }
    }

    void updateStatusLine(IStructuredSelection iStructuredSelection) {
        String string = this.getStatusLineMessage(iStructuredSelection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        TreeViewer treeViewer = this.getViewer();
        Object[] objectArray = treeViewer.getExpandedElements();
        ISelection iSelection = treeViewer.getSelection();
        this.workingSetFilter.setWorkingSet(iWorkingSet);
        this.updateTitle();
        treeViewer.refresh();
        treeViewer.setExpandedElements(objectArray);
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            treeViewer.reveal(iStructuredSelection.getFirstElement());
        }
    }

    public void setLabelDecorator(ILabelDecorator iLabelDecorator) {
        StandardCElementLabelProvider standardCElementLabelProvider = this.createLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)standardCElementLabelProvider, iLabelDecorator));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        CViewActionGroup cViewActionGroup;
        if (this.viewer == null) {
            return;
        }
        boolean bl = false;
        String string = propertyChangeEvent.getProperty();
        if (string.equals("org.eclipse.cdt.ui.editor.CUChildren")) {
            boolean bl2 = CPluginPreferencePage.showCompilationUnitChildren();
            ((CElementContentProvider)this.viewer.getContentProvider()).setProvideMembers(bl2);
            bl = true;
        } else if (string.equals("org.eclipse.cdt.ui.editor.linkToEditor") && (cViewActionGroup = this.getActionGroup()) instanceof MainActionGroup) {
            boolean bl3 = this.isLinkingEnabled();
            ((MainActionGroup)cViewActionGroup).toggleLinkingAction.setChecked(bl3);
        }
        if (bl) {
            this.viewer.refresh();
        }
    }

    public boolean isLinkingEnabled() {
        return CPluginPreferencePage.isLinkToEditor();
    }

    public void setLinkingEnabled(boolean bl) {
        CPluginPreferencePage.setLinkingEnabled(bl);
    }

    void linkToEditor(IStructuredSelection iStructuredSelection) {
        IEditorPart iEditorPart;
        ITranslationUnit iTranslationUnit;
        Object object;
        if (!this.isActivePart()) {
            return;
        }
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof ISourceReference && (iTranslationUnit = ((ISourceReference)object).getTranslationUnit()) != null && (iEditorPart = EditorUtility.isOpenInEditor(object)) != null) {
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            if (object instanceof ICElement) {
                EditorUtility.revealInEditor(iEditorPart, (ICElement)object);
            }
        }
    }

    private boolean isActivePart() {
        return this == this.getSite().getPage().getActivePart();
    }

    public Object getViewPartInput() {
        if (this.viewer != null) {
            return this.viewer.getInput();
        }
        return null;
    }

    public void collapseAll() {
        this.viewer.getControl().setRedraw(false);
        this.viewer.collapseToLevel(this.getViewPartInput(), -1);
        this.viewer.getControl().setRedraw(true);
    }

    void restoreFilters() {
        Object object;
        IMemento iMemento = this.memento.getChild(TAG_FILTERS);
        if (iMemento != null) {
            object = iMemento.getChildren(TAG_FILTER);
            String[] stringArray = new String[((IMemento[])object).length];
            int n = 0;
            while (n < ((IMemento[])object).length) {
                stringArray[n] = object[n].getString(TAG_ELEMENT);
                ++n;
            }
            this.getPatternFilter().setPatterns(stringArray);
        } else {
            this.getPatternFilter().setPatterns(new String[0]);
        }
        object = this.memento.getString(TAG_SHOWLIBRARIES);
        if (object != null) {
            this.getLibraryFilter().setShowLibraries(((String)object).equals("true"));
        } else {
            this.initFilterFromPreferences();
        }
    }

    void restoreState(IMemento iMemento) {
        Path path;
        ICElement iCElement;
        String string;
        int n;
        ScrollBar scrollBar;
        Tree tree;
        CoreModel coreModel = CoreModel.getDefault();
        IMemento iMemento2 = iMemento.getChild(TAG_EXPANDED);
        if (iMemento2 != null) {
            tree = new ArrayList();
            scrollBar = iMemento2.getChildren(TAG_ELEMENT);
            n = 0;
            while (n < ((ScrollBar)scrollBar).length) {
                string = scrollBar[n].getString(TAG_PATH);
                if (string != null && (iCElement = coreModel.create((IPath)(path = new Path(string)))) != null) {
                    tree.add(iCElement);
                }
                ++n;
            }
            this.viewer.setExpandedElements(tree.toArray());
        }
        if ((iMemento2 = iMemento.getChild(TAG_SELECTION)) != null) {
            tree = new ArrayList();
            scrollBar = iMemento2.getChildren(TAG_ELEMENT);
            n = 0;
            while (n < ((ScrollBar)scrollBar).length) {
                string = scrollBar[n].getString(TAG_PATH);
                if (string != null && (iCElement = coreModel.create((IPath)(path = new Path(string)))) != null) {
                    tree.add(iCElement);
                }
                ++n;
            }
            this.viewer.setSelection((ISelection)new StructuredSelection((List)tree));
        }
        if ((scrollBar = (tree = this.viewer.getTree()).getVerticalBar()) != null) {
            try {
                String string2 = iMemento.getString(TAG_VERTICAL_POSITION);
                int n2 = new Integer(string2);
                scrollBar.setSelection(n2);
                n2 = new Integer(string2);
                scrollBar.setSelection(n2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((scrollBar = tree.getHorizontalBar()) != null) {
            try {
                String string3 = iMemento.getString(TAG_HORIZONTAL_POSITION);
                int n3 = new Integer(string3);
                scrollBar.setSelection(n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void saveState(IMemento iMemento) {
        Object object;
        ScrollBar scrollBar;
        IMemento iMemento2;
        IResource iResource;
        String[] stringArray;
        Object[] objectArray;
        if (this.viewer == null) {
            if (this.memento != null) {
                iMemento.putMemento(this.memento);
            }
            return;
        }
        Tree tree = this.viewer.getTree();
        Object[] objectArray2 = this.viewer.getExpandedElements();
        if (objectArray2.length > 0) {
            objectArray = iMemento.createChild(TAG_EXPANDED);
            int n = 0;
            while (n < objectArray2.length) {
                Object object2 = objectArray2[n];
                if (!(!(object2 instanceof IParent) || object2 instanceof IArchiveContainer || object2 instanceof IBinaryContainer || object2 instanceof IBinary || object2 instanceof IArchive)) {
                    stringArray = objectArray.createChild(TAG_ELEMENT);
                    iResource = (ICElement)object2;
                    iMemento2 = iResource.getResource();
                    if (iMemento2 != null) {
                        stringArray.putString(TAG_PATH, iMemento2.getLocation().toOSString());
                    }
                }
                ++n;
            }
        }
        if ((objectArray = ((IStructuredSelection)this.viewer.getSelection()).toArray()).length > 0) {
            IMemento iMemento3 = iMemento.createChild(TAG_SELECTION);
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof ICElement && (iResource = (stringArray = (String[])objectArray[n]).getResource()) != null) {
                    iMemento2 = iMemento3.createChild(TAG_ELEMENT);
                    iMemento2.putString(TAG_PATH, iResource.getLocation().toString());
                }
                ++n;
            }
        }
        int n = (scrollBar = tree.getVerticalBar()) != null ? scrollBar.getSelection() : 0;
        iMemento.putString(TAG_VERTICAL_POSITION, String.valueOf(n));
        scrollBar = tree.getHorizontalBar();
        n = scrollBar != null ? scrollBar.getSelection() : 0;
        iMemento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(n));
        stringArray = this.getPatternFilter().getPatterns();
        if (stringArray.length > 0) {
            iResource = iMemento.createChild(TAG_FILTERS);
            int n2 = 0;
            while (n2 < stringArray.length) {
                object = iResource.createChild(TAG_FILTER);
                object.putString(TAG_ELEMENT, stringArray[n2]);
                ++n2;
            }
        }
        boolean bl = this.getLibraryFilter().getShowLibraries();
        String string = "true";
        if (!bl) {
            string = "false";
        }
        iMemento.putString(TAG_SHOWLIBRARIES, string);
        if (this.workingSetFilter.getWorkingSet() != null && (object = this.workingSetFilter.getWorkingSet().getName()) != null) {
            iMemento.putString(TAG_WORKINGSET, (String)object);
        }
    }

    public boolean show(ShowInContext showInContext) {
        ISelection iSelection;
        IEditorInput iEditorInput = (IEditorInput)showInContext.getInput();
        if (iEditorInput != null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iSelection = (IResource)iEditorInput.getAdapter((Class)clazz)) != null) {
                this.selectReveal((ISelection)new StructuredSelection((Object)iSelection));
                return true;
            }
        }
        if ((iSelection = showInContext.getSelection()) != null) {
            this.selectReveal(iSelection);
            return true;
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(CView.this.getViewer().getInput(), CView.this.getViewer().getSelection());
            }
        };
    }
}

