/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.CMarkerAnnotationModel;
import org.eclipse.cdt.internal.ui.editor.DocumentAdapter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IEditorInputDelegate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class CDocumentProvider
extends FileDocumentProvider {
    private IBufferFactory fBufferFactory = new BufferFactory();
    private boolean fIsAboutToSave = false;
    static /* synthetic */ Class class$0;

    protected IDocument createDocument(Object object) throws CoreException {
        CDocument cDocument = null;
        IStorage iStorage = null;
        if (object instanceof IEditorInputDelegate) {
            if (((IEditorInputDelegate)object).getDelegate() != null) {
                return this.createDocument(((IEditorInputDelegate)object).getDelegate());
            }
            iStorage = ((IEditorInputDelegate)object).getStorage();
        }
        if (object instanceof IStorageEditorInput) {
            iStorage = ((IStorageEditorInput)object).getStorage();
        }
        if (iStorage != null) {
            cDocument = new CDocument();
            this.setDocumentContent((IDocument)cDocument, iStorage.getContents(), this.getDefaultEncoding());
        }
        this.initializeDocument((IDocument)cDocument);
        return cDocument;
    }

    protected IAnnotationModel createAnnotationModel(Object object) throws CoreException {
        if (object instanceof IEditorInputDelegate && ((IEditorInputDelegate)object).getDelegate() != null) {
            return this.createAnnotationModel(((IEditorInputDelegate)object).getDelegate());
        }
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return new CMarkerAnnotationModel((IResource)iFileEditorInput.getFile());
        }
        if (object instanceof IStorageEditorInput) {
            IResource iResource;
            IStorageEditorInput iStorageEditorInput = (IStorageEditorInput)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iStorageEditorInput.getAdapter((Class)clazz)) != null && iResource.exists()) {
                return new CMarkerAnnotationModel(iResource);
            }
        }
        return super.createAnnotationModel(object);
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (!(object instanceof IFileEditorInput)) {
            return super.createElementInfo(object);
        }
        IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
        ITranslationUnit iTranslationUnit = this.createTranslationUnit(iFileEditorInput.getFile());
        if (iTranslationUnit != null) {
            try {
                try {
                    this.refreshFile(iFileEditorInput.getFile());
                }
                catch (CoreException coreException) {
                    this.handleCoreException(coreException, CEditorMessages.getString("TranslationUnitDocumentProvider.error.createElementInfo"));
                }
                IAnnotationModel iAnnotationModel = this.createAnnotationModel(iFileEditorInput);
                IBufferFactory iBufferFactory = this.getBufferFactory();
                IWorkingCopy iWorkingCopy = iTranslationUnit.getSharedWorkingCopy(this.getProgressMonitor(), iBufferFactory);
                DocumentAdapter documentAdapter = null;
                try {
                    documentAdapter = (DocumentAdapter)iWorkingCopy.getBuffer();
                }
                catch (ClassCastException classCastException) {
                    Status status = new Status(4, "org.eclipse.cdt.ui", 2, "Shared working copy has wrong buffer", (Throwable)classCastException);
                    throw new CoreException((IStatus)status);
                }
                FileDocumentProvider.FileSynchronizer fileSynchronizer = new FileDocumentProvider.FileSynchronizer((FileDocumentProvider)this, iFileEditorInput);
                fileSynchronizer.install();
                TranslationUnitFileInfo translationUnitFileInfo = new TranslationUnitFileInfo(documentAdapter.getDocument(), iAnnotationModel, fileSynchronizer, iWorkingCopy);
                translationUnitFileInfo.setModificationStamp(this.computeModificationStamp((IResource)iFileEditorInput.getFile()));
                ((AbstractDocumentProvider.ElementInfo)translationUnitFileInfo).fStatus = documentAdapter.getStatus();
                ((StorageDocumentProvider.StorageInfo)translationUnitFileInfo).fEncoding = this.getPersistedEncoding(iFileEditorInput);
                return translationUnitFileInfo;
            }
            catch (CModelException cModelException) {
                throw new CoreException(cModelException.getStatus());
            }
        }
        return super.createElementInfo(object);
    }

    protected ITranslationUnit createTranslationUnit(IFile iFile) {
        ICElement iCElement = CoreModel.getDefault().create(iFile);
        if (iCElement instanceof ITranslationUnit) {
            return (ITranslationUnit)iCElement;
        }
        return null;
    }

    protected void disposeElementInfo(Object object, AbstractDocumentProvider.ElementInfo elementInfo) {
        if (elementInfo instanceof TranslationUnitFileInfo) {
            TranslationUnitFileInfo translationUnitFileInfo = (TranslationUnitFileInfo)elementInfo;
            translationUnitFileInfo.fCopy.destroy();
        }
        super.disposeElementInfo(object, elementInfo);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(object);
        if (!(elementInfo instanceof TranslationUnitFileInfo)) {
            super.doSaveDocument(iProgressMonitor, object, iDocument, bl);
            return;
        }
        TranslationUnitFileInfo translationUnitFileInfo = (TranslationUnitFileInfo)elementInfo;
        translationUnitFileInfo.fCopy.reconcile();
        ITranslationUnit iTranslationUnit = translationUnitFileInfo.fCopy.getOriginalElement();
        IResource iResource = iTranslationUnit.getResource();
        if (iResource == null) {
            super.doSaveDocument(iProgressMonitor, object, iDocument, bl);
            return;
        }
        if (iResource != null && !bl) {
            this.checkSynchronizationState(translationUnitFileInfo.fModificationStamp, iResource);
        }
        this.fireElementStateChanging(object);
        try {
            try {
                this.fIsAboutToSave = true;
                translationUnitFileInfo.fCopy.commit(bl, iProgressMonitor);
            }
            catch (CoreException coreException) {
                this.fireElementStateChangeFailed(object);
                throw coreException;
            }
            catch (RuntimeException runtimeException) {
                this.fireElementStateChangeFailed(object);
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.fIsAboutToSave = false;
            throw throwable;
        }
        {
            Object var10_14 = null;
            this.fIsAboutToSave = false;
        }
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = (AbstractMarkerAnnotationModel)((AbstractDocumentProvider.ElementInfo)translationUnitFileInfo).fModel;
        abstractMarkerAnnotationModel.updateMarkers(((AbstractDocumentProvider.ElementInfo)translationUnitFileInfo).fDocument);
        if (iResource == null) return;
        translationUnitFileInfo.setModificationStamp(this.computeModificationStamp(iResource));
    }

    public IBufferFactory getBufferFactory() {
        return this.fBufferFactory;
    }

    public IResource getUnderlyingResource(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return iFileEditorInput.getFile();
        }
        return null;
    }

    public IWorkingCopy getWorkingCopy(IEditorInput iEditorInput) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(iEditorInput);
        if (elementInfo instanceof TranslationUnitFileInfo) {
            TranslationUnitFileInfo translationUnitFileInfo = (TranslationUnitFileInfo)elementInfo;
            return translationUnitFileInfo.fCopy;
        }
        return null;
    }

    protected void initializeDocument(IDocument iDocument) {
        if (iDocument != null) {
            IDocumentPartitioner iDocumentPartitioner = CUIPlugin.getDefault().getTextTools().createDocumentPartitioner();
            iDocumentPartitioner.connect(iDocument);
            iDocument.setDocumentPartitioner(iDocumentPartitioner);
        }
    }

    public void saveDocumentContent(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            try {
                String string = this.getEncoding(object);
                if (string == null) {
                    string = ResourcesPlugin.getEncoding();
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(iDocument.get().getBytes(string));
                IFile iFile = iFileEditorInput.getFile();
                iFile.setContents((InputStream)byteArrayInputStream, bl, true, iProgressMonitor);
            }
            catch (IOException iOException) {
                Status status = new Status(4, "org.eclipse.cdt.ui", 0, iOException.getMessage(), (Throwable)iOException);
                throw new CoreException((IStatus)status);
            }
        }
    }

    public void shutdown() {
    }

    public boolean isConnected(IEditorInput iEditorInput) {
        return this.getElementInfo(iEditorInput) != null;
    }

    public IStatus getStatus(Object object) {
        if (object instanceof IEditorInputDelegate) {
            if (((IEditorInputDelegate)object).getDelegate() != null) {
                return super.getStatus((Object)((IEditorInputDelegate)object).getDelegate());
            }
            return new Status(1, CUIPlugin.getPluginId(), 0, "", null);
        }
        return super.getStatus(object);
    }

    protected class CDocument
    extends AbstractDocument {
        public CDocument() {
            this.setTextStore((ITextStore)new GapTextStore(50, 300));
            this.setLineTracker((ILineTracker)new DefaultLineTracker());
            this.completeInitialization();
        }

        public CDocument(String string) {
            this.setTextStore((ITextStore)new GapTextStore(50, 300));
            this.setLineTracker((ILineTracker)new DefaultLineTracker());
            this.getStore().set(string);
            this.getTracker().set(string);
            this.completeInitialization();
        }
    }

    protected class TranslationUnitFileInfo
    extends FileDocumentProvider.FileInfo {
        IWorkingCopy fCopy;

        TranslationUnitFileInfo(IDocument iDocument, IAnnotationModel iAnnotationModel, FileDocumentProvider.FileSynchronizer fileSynchronizer, IWorkingCopy iWorkingCopy) {
            super((FileDocumentProvider)CDocumentProvider.this, iDocument, iAnnotationModel, fileSynchronizer);
            this.fCopy = iWorkingCopy;
        }

        void setModificationStamp(long l) {
            this.fModificationStamp = l;
        }
    }

    protected class BufferFactory
    implements IBufferFactory {
        protected BufferFactory() {
        }

        private IDocument internalGetDocument(IFileEditorInput iFileEditorInput) throws CoreException {
            IDocument iDocument = CDocumentProvider.this.getDocument(iFileEditorInput);
            if (iDocument != null) {
                return iDocument;
            }
            return CDocumentProvider.this.createDocument(iFileEditorInput);
        }

        public IBuffer createBuffer(IOpenable iOpenable) {
            IWorkingCopy iWorkingCopy;
            ITranslationUnit iTranslationUnit;
            IResource iResource;
            if (iOpenable instanceof IWorkingCopy && (iResource = (iTranslationUnit = (iWorkingCopy = (IWorkingCopy)iOpenable).getOriginalElement()).getResource()) instanceof IFile) {
                FileEditorInput fileEditorInput = new FileEditorInput((IFile)iResource);
                IDocument iDocument = null;
                IStatus iStatus = null;
                try {
                    iDocument = this.internalGetDocument((IFileEditorInput)fileEditorInput);
                }
                catch (CoreException coreException) {
                    iStatus = coreException.getStatus();
                    iDocument = new Document();
                    CDocumentProvider.this.initializeDocument(iDocument);
                }
                DocumentAdapter documentAdapter = new DocumentAdapter((IOpenable)iWorkingCopy, iDocument, (ILineTracker)new DefaultLineTracker(), CDocumentProvider.this, fileEditorInput);
                documentAdapter.setStatus(iStatus);
                return documentAdapter;
            }
            return DocumentAdapter.NULL;
        }
    }
}

