/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.IBufferChangedListener;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;

public class DocumentAdapter
implements IBuffer,
IDocumentListener {
    public static final IBuffer NULL = new NullBuffer();
    private IOpenable fOwner;
    IDocument fDocument;
    private DocumentSetCommand fSetCmd = new DocumentSetCommand();
    private DocumentReplaceCommand fReplaceCmd = new DocumentReplaceCommand();
    private Object fProviderKey;
    private CDocumentProvider fProvider;
    private String fLineDelimiter;
    private ILineTracker fLineTracker;
    private List fBufferListeners = new ArrayList(3);
    private IStatus fStatus;

    public void addBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        Assert.isNotNull((Object)iBufferChangedListener);
        if (!this.fBufferListeners.contains(iBufferChangedListener)) {
            this.fBufferListeners.add(iBufferChangedListener);
        }
    }

    public DocumentAdapter(IOpenable iOpenable, IDocument iDocument, ILineTracker iLineTracker, CDocumentProvider cDocumentProvider, Object object) {
        Assert.isNotNull((Object)iDocument);
        Assert.isNotNull((Object)iLineTracker);
        this.fOwner = iOpenable;
        this.fDocument = iDocument;
        this.fLineTracker = iLineTracker;
        this.fProvider = cDocumentProvider;
        this.fProviderKey = object;
        this.fDocument.addPrenotifiedDocumentListener((IDocumentListener)this);
    }

    public void setStatus(IStatus iStatus) {
        this.fStatus = iStatus;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    protected String getLineDelimiter() {
        if (this.fLineDelimiter == null) {
            try {
                this.fLineDelimiter = this.fDocument.getLineDelimiter(0);
            }
            catch (BadLocationException badLocationException) {}
            if (this.fLineDelimiter == null) {
                String string = System.getProperty("line.separator");
                String[] stringArray = this.fDocument.getLegalLineDelimiters();
                Assert.isTrue((stringArray.length > 0 ? 1 : 0) != 0);
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(string)) {
                        this.fLineDelimiter = string;
                        break;
                    }
                    ++n;
                }
                if (this.fLineDelimiter == null) {
                    this.fLineDelimiter = stringArray[0];
                }
            }
        }
        return this.fLineDelimiter;
    }

    public String normalize(String string) {
        this.fLineTracker.set(string);
        int n = this.fLineTracker.getNumberOfLines();
        if (n <= 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        try {
            IRegion iRegion = this.fLineTracker.getLineInformation(0);
            int n2 = 1;
            while (n2 < n) {
                int n3 = iRegion.getOffset() + iRegion.getLength();
                int n4 = this.fLineTracker.getLineInformation(n2).getOffset();
                this.fLineTracker.replace(n3, n4 - n3, this.getLineDelimiter());
                stringBuffer.replace(n3, n4, this.getLineDelimiter());
                iRegion = this.fLineTracker.getLineInformation(n2);
                ++n2;
            }
            String string2 = this.fLineTracker.getLineDelimiter(n - 1);
            if (string2 != null && string2.length() > 0) {
                stringBuffer.replace(iRegion.getOffset() + iRegion.getLength(), stringBuffer.length(), this.getLineDelimiter());
            }
            return stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            return string;
        }
    }

    public void append(char[] cArray) {
        this.append(new String(cArray));
    }

    public void append(String string) {
        this.fReplaceCmd.replace(this.fDocument.getLength(), 0, this.normalize(string));
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        IDocument iDocument = this.fDocument;
        this.fDocument = null;
        iDocument.removePrenotifiedDocumentListener((IDocumentListener)this);
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, 0, 0, null));
        this.fBufferListeners.clear();
    }

    public char getChar(int n) {
        try {
            return this.fDocument.getChar(n);
        }
        catch (BadLocationException badLocationException) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public char[] getCharacters() {
        String string = this.getContents();
        return string == null ? null : string.toCharArray();
    }

    public String getContents() {
        return this.fDocument.get();
    }

    public int getLength() {
        return this.fDocument.getLength();
    }

    public IOpenable getOwner() {
        return this.fOwner;
    }

    public String getText(int n, int n2) {
        try {
            return this.fDocument.get(n, n2);
        }
        catch (BadLocationException badLocationException) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public IResource getUnderlyingResource() {
        return this.fProvider != null ? this.fProvider.getUnderlyingResource(this.fProviderKey) : null;
    }

    public boolean hasUnsavedChanges() {
        return this.fProvider != null ? this.fProvider.canSaveDocument(this.fProviderKey) : false;
    }

    public boolean isClosed() {
        return this.fDocument == null;
    }

    public boolean isReadOnly() {
        IResource iResource = this.getUnderlyingResource();
        return iResource == null ? true : iResource.isReadOnly();
    }

    public void removeBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        Assert.isNotNull((Object)iBufferChangedListener);
        this.fBufferListeners.remove(iBufferChangedListener);
    }

    public void replace(int n, int n2, char[] cArray) {
        this.replace(n, n2, new String(cArray));
    }

    public void replace(int n, int n2, String string) {
        this.fReplaceCmd.replace(n, n2, this.normalize(string));
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl) throws CModelException {
        if (this.fProvider != null) {
            try {
                this.fProvider.saveDocumentContent(iProgressMonitor, this.fProviderKey, this.fDocument, bl);
            }
            catch (CoreException coreException) {
                throw new CModelException(coreException);
            }
        }
    }

    public void setContents(char[] cArray) {
        this.setContents(new String(cArray));
    }

    public void setContents(String string) {
        int n = this.fDocument.getLength();
        if (string == null) {
            if (n != 0) {
                this.fSetCmd.set("");
            }
        } else {
            String string2 = this.normalize(string);
            int n2 = string2.length();
            if (n != n2 || !string2.equals(this.fDocument.get())) {
                this.fSetCmd.set(string2);
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public void documentChanged(DocumentEvent documentEvent) {
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, documentEvent.getOffset(), documentEvent.getLength(), documentEvent.getText()));
    }

    private void fireBufferChanged(BufferChangedEvent bufferChangedEvent) {
        if (this.fBufferListeners != null && this.fBufferListeners.size() > 0) {
            Iterator iterator = ((AbstractList)new ArrayList(this.fBufferListeners)).iterator();
            while (iterator.hasNext()) {
                ((IBufferChangedListener)iterator.next()).bufferChanged(bufferChangedEvent);
            }
        }
    }

    private static class NullBuffer
    implements IBuffer {
        NullBuffer() {
        }

        public void addBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        }

        public void append(char[] cArray) {
        }

        public void append(String string) {
        }

        public void close() {
        }

        public char getChar(int n) {
            return '\u0000';
        }

        public char[] getCharacters() {
            return null;
        }

        public String getContents() {
            return null;
        }

        public int getLength() {
            return 0;
        }

        public IOpenable getOwner() {
            return null;
        }

        public String getText(int n, int n2) {
            return null;
        }

        public IResource getUnderlyingResource() {
            return null;
        }

        public boolean hasUnsavedChanges() {
            return false;
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public void removeBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        }

        public void replace(int n, int n2, char[] cArray) {
        }

        public void replace(int n, int n2, String string) {
        }

        public void save(IProgressMonitor iProgressMonitor, boolean bl) throws CModelException {
        }

        public void setContents(char[] cArray) {
        }

        public void setContents(String string) {
        }
    }

    protected class DocumentSetCommand
    implements Runnable {
        private String fContents;

        protected DocumentSetCommand() {
        }

        public void run() {
            DocumentAdapter.this.fDocument.set(this.fContents);
        }

        public void set(String string) {
            this.fContents = string;
            Display.getDefault().syncExec((Runnable)this);
        }
    }

    protected class DocumentReplaceCommand
    implements Runnable {
        private int fOffset;
        private int fLength;
        private String fText;

        protected DocumentReplaceCommand() {
        }

        public void run() {
            try {
                DocumentAdapter.this.fDocument.replace(this.fOffset, this.fLength, this.fText);
            }
            catch (BadLocationException badLocationException) {}
        }

        public void replace(int n, int n2, String string) {
            this.fOffset = n;
            this.fLength = n2;
            this.fText = string;
            Display.getDefault().syncExec((Runnable)this);
        }
    }
}

