/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchResultCollector;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;

public class CSearchOperation
implements IRunnableWithProgress,
ICSearchConstants {
    private CSearchResultCollector _collector;
    private IWorkspace _workspace;
    private ICSearchScope _scope;
    private String _stringPattern;
    private String _scopeDescription;
    private boolean _caseSensitive;
    private ICSearchConstants.LimitTo _limitTo;
    private List _searchFor;

    public CSearchOperation(IWorkspace iWorkspace, String string, boolean bl, List list, ICSearchConstants.LimitTo limitTo, ICSearchScope iCSearchScope, String string2, CSearchResultCollector cSearchResultCollector) {
        this(iWorkspace, limitTo, iCSearchScope, string2, cSearchResultCollector);
        this._stringPattern = string;
        this._caseSensitive = bl;
        this._searchFor = list;
    }

    public CSearchOperation(IWorkspace iWorkspace, ICSearchConstants.LimitTo limitTo, ICSearchScope iCSearchScope, String string, CSearchResultCollector cSearchResultCollector) {
        this._workspace = iWorkspace;
        this._limitTo = limitTo;
        this._scope = iCSearchScope;
        this._scopeDescription = string;
        this._collector = cSearchResultCollector;
        this._collector.setOperation(this);
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        this._collector.setProgressMonitor(iProgressMonitor);
        SearchEngine searchEngine = new SearchEngine(CUIPlugin.getSharedWorkingCopies());
        OrPattern orPattern = null;
        if (this._searchFor.size() > 1) {
            OrPattern orPattern2 = new OrPattern();
            Iterator iterator = this._searchFor.iterator();
            while (iterator.hasNext()) {
                ICSearchConstants.SearchFor searchFor = (ICSearchConstants.SearchFor)iterator.next();
                orPattern2.addPattern(SearchEngine.createSearchPattern((String)this._stringPattern, (ICSearchConstants.SearchFor)searchFor, (ICSearchConstants.LimitTo)this._limitTo, (boolean)this._caseSensitive));
            }
            orPattern = orPattern2;
        } else {
            Iterator iterator = this._searchFor.iterator();
            orPattern = SearchEngine.createSearchPattern((String)this._stringPattern, (ICSearchConstants.SearchFor)((ICSearchConstants.SearchFor)iterator.next()), (ICSearchConstants.LimitTo)this._limitTo, (boolean)this._caseSensitive);
        }
        try {
            searchEngine.search(this._workspace, (ICSearchPattern)orPattern, this._scope, (ICSearchResultCollector)this._collector, false);
        }
        catch (InterruptedException interruptedException) {}
    }

    public String getSingularLabel() {
        String string = null;
        string = this._stringPattern;
        Object[] objectArray = new String[]{string, this._scopeDescription};
        if (this._limitTo == ICSearchConstants.DECLARATIONS) {
            return CSearchMessages.getFormattedString("CSearchOperation.singularDeclarationsPostfix", objectArray);
        }
        if (this._limitTo == ICSearchConstants.REFERENCES) {
            return CSearchMessages.getFormattedString("CSearchOperation.singularReferencesPostfix", objectArray);
        }
        return CSearchMessages.getFormattedString("CSearchOperation.singularOccurrencesPostfix", objectArray);
    }

    public String getPluralLabelPattern() {
        String string = null;
        string = this._stringPattern;
        Object[] objectArray = new String[]{string, "{0}", this._scopeDescription};
        if (this._limitTo == ICSearchConstants.DECLARATIONS) {
            return CSearchMessages.getFormattedString("CSearchOperation.pluralDeclarationsPostfix", objectArray);
        }
        if (this._limitTo == ICSearchConstants.REFERENCES) {
            return CSearchMessages.getFormattedString("CSearchOperation.pluralReferencesPostfix", objectArray);
        }
        return CSearchMessages.getFormattedString("CSearchOperation.pluralOccurrencesPostfix", objectArray);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this._limitTo == ICSearchConstants.DECLARATIONS) {
            return CPluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return CPluginImages.DESC_OBJS_SEARCH_REF;
    }
}

