/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.ui.CElementImageProvider;
import org.eclipse.cdt.internal.ui.ErrorTickAdornmentProvider;
import org.eclipse.cdt.internal.ui.IAdornmentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CElementLabelProvider
extends LabelProvider {
    public static final int SHOW_RETURN_TYPE = 1;
    public static final int SHOW_PARAMETERS = 2;
    public static final int SHOW_EXCEPTION = 4;
    public static final int SHOW_SMALL_ICONS = 256;
    public static final int SHOW_OVERLAY_ICONS = 16;
    public static final int SHOW_QUALIFIED = 1024;
    public static final int SHOW_POST_QUALIFIED = 2048;
    public static final int SHOW_BASICS = 0;
    public static final int SHOW_DEFAULT = new Integer(18);
    private ImageRegistry fImageRegistry = CUIPlugin.getDefault().getImageRegistry();
    private WorkbenchLabelProvider fWorkbenchLabelProvider = new WorkbenchLabelProvider();
    private CElementImageProvider fImageLabelProvider = new CElementImageProvider();
    private IAdornmentProvider[] fAdornmentProviders;
    private int fFlags;
    private int fImageFlags;
    private int fTextFlags;

    public CElementLabelProvider() {
        this(SHOW_DEFAULT);
    }

    public CElementLabelProvider(int n) {
        this(n, null);
    }

    public CElementLabelProvider(int n, IAdornmentProvider[] iAdornmentProviderArray) {
        this.fAdornmentProviders = iAdornmentProviderArray;
        this.fFlags = n;
    }

    public String getText(Object object) {
        if (object instanceof ICElement) {
            IVariableDeclaration iVariableDeclaration;
            ICElement iCElement = (ICElement)object;
            StringBuffer stringBuffer = new StringBuffer();
            switch (iCElement.getElementType()) {
                case 69: 
                case 74: 
                case 75: {
                    iVariableDeclaration = (IVariableDeclaration)iCElement;
                    stringBuffer.append(iVariableDeclaration.getElementName());
                    if (iVariableDeclaration.getTypeName() == null || iVariableDeclaration.getTypeName().length() <= 0) break;
                    stringBuffer.append(" : ");
                    stringBuffer.append(iVariableDeclaration.getTypeName());
                    break;
                }
                case 67: 
                case 68: 
                case 70: 
                case 71: {
                    IFunctionDeclaration iFunctionDeclaration = (IFunctionDeclaration)iCElement;
                    stringBuffer.append(iFunctionDeclaration.getSignature());
                    if (iFunctionDeclaration.getReturnType() == null || iFunctionDeclaration.getReturnType().length() <= 0) break;
                    stringBuffer.append(" : ");
                    stringBuffer.append(iFunctionDeclaration.getReturnType());
                    break;
                }
                case 63: 
                case 65: 
                case 66: {
                    if (iCElement.getElementName() != null && iCElement.getElementName().length() > 0) {
                        stringBuffer.append(iCElement.getElementName());
                        break;
                    }
                    if (!(iCElement instanceof IVariableDeclaration)) break;
                    IVariableDeclaration iVariableDeclaration2 = (IVariableDeclaration)iCElement;
                    stringBuffer.append(iVariableDeclaration2.getTypeName());
                    break;
                }
                case 78: {
                    ITypeDef iTypeDef = (ITypeDef)iCElement;
                    stringBuffer.append(iTypeDef.getElementName());
                    if (iTypeDef.getTypeName() == null || iTypeDef.getTypeName().length() <= 0) break;
                    stringBuffer.append(" : ");
                    stringBuffer.append(iTypeDef.getTypeName());
                    break;
                }
                case 61: {
                    if (iCElement.getElementName() != null && iCElement.getElementName().length() > 0) {
                        stringBuffer.append(iCElement.getElementName());
                        break;
                    }
                    if (!(iCElement instanceof INamespace)) break;
                    INamespace iNamespace = (INamespace)iCElement;
                    stringBuffer.append(iNamespace.getTypeName());
                    break;
                }
                case 73: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: {
                    ITemplate iTemplate = (ITemplate)iCElement;
                    String string = iTemplate.getTemplateSignature();
                    stringBuffer.append(string);
                    break;
                }
                default: {
                    stringBuffer.append(iCElement.getElementName());
                }
            }
            if (iCElement instanceof IBinary) {
                iVariableDeclaration = (IBinary)iCElement;
                stringBuffer.append(" - [" + iVariableDeclaration.getCPU() + (iVariableDeclaration.isLittleEndian() ? "le" : "be") + "]");
            }
            return stringBuffer.toString();
        }
        return this.fWorkbenchLabelProvider.getText(object);
    }

    public Image getImage(Object object) {
        int n = this.getImageFlags();
        if (this.fAdornmentProviders != null) {
            int n2 = 0;
            while (n2 < this.fAdornmentProviders.length) {
                n |= this.fAdornmentProviders[n2].computeAdornmentFlags(object);
                ++n2;
            }
        }
        return this.fImageLabelProvider.getImageLabel(object, n);
    }

    public void dispose() {
        if (this.fAdornmentProviders != null) {
            int n = 0;
            while (n < this.fAdornmentProviders.length) {
                this.fAdornmentProviders[n].dispose();
                ++n;
            }
        }
        if (this.fWorkbenchLabelProvider != null) {
            this.fWorkbenchLabelProvider.dispose();
            this.fWorkbenchLabelProvider = null;
        }
        this.fImageRegistry = null;
        if (this.fImageLabelProvider != null) {
            this.fImageLabelProvider.dispose();
        }
    }

    private boolean getFlag(int n) {
        return (this.fFlags & n) != 0;
    }

    public void turnOn(int n) {
        this.fFlags |= n;
    }

    public void turnOff(int n) {
        this.fFlags &= ~n;
    }

    public int getImageFlags() {
        this.fImageFlags = 0;
        if (this.getFlag(16)) {
            this.fImageFlags |= 1;
        }
        if (this.getFlag(256)) {
            this.fImageFlags |= 2;
        }
        return this.fImageFlags;
    }

    public int getTextFlags() {
        this.fTextFlags = 0;
        if (this.getFlag(1)) {
            this.fTextFlags |= 8;
        }
        if (this.getFlag(2)) {
            this.fTextFlags |= 1;
        }
        if (this.getFlag(4)) {
            this.fTextFlags |= 4;
        }
        return this.fTextFlags;
    }

    public static IAdornmentProvider[] getAdornmentProviders(boolean bl, IAdornmentProvider iAdornmentProvider) {
        if (bl) {
            if (iAdornmentProvider == null) {
                return new IAdornmentProvider[]{new ErrorTickAdornmentProvider()};
            }
            return new IAdornmentProvider[]{new ErrorTickAdornmentProvider(), iAdornmentProvider};
        }
        if (iAdornmentProvider != null) {
            return new IAdornmentProvider[]{iAdornmentProvider};
        }
        return null;
    }
}

