/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.cdt.core.parser.Enum;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.IASTMember;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.DerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.SpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ParserSymbolTable {
    public static final String EMPTY_NAME = "";
    public static final String THIS = "this";
    private IContainerSymbol _compilationUnit;
    private ParserLanguage _language;
    private ParserMode _mode;
    private LinkedList undoList = new LinkedList();
    private HashSet markSet = new HashSet();

    public ParserSymbolTable(ParserLanguage parserLanguage, ParserMode parserMode) {
        this._compilationUnit = this.newContainerSymbol(EMPTY_NAME, TypeInfo.t_namespace);
        this._language = parserLanguage;
        this._mode = parserMode;
    }

    public IContainerSymbol getCompilationUnit() {
        return this._compilationUnit;
    }

    public IContainerSymbol newContainerSymbol(String string) {
        return new ContainerSymbol(this, string);
    }

    public IContainerSymbol newContainerSymbol(String string, TypeInfo.eType eType2) {
        return new ContainerSymbol(this, string, eType2);
    }

    public ISymbol newSymbol(String string) {
        return new BasicSymbol(this, string);
    }

    public ISymbol newSymbol(String string, TypeInfo.eType eType2) {
        return new BasicSymbol(this, string, eType2);
    }

    public IDerivableContainerSymbol newDerivableContainerSymbol(String string) {
        return new DerivableContainerSymbol(this, string);
    }

    public IDerivableContainerSymbol newDerivableContainerSymbol(String string, TypeInfo.eType eType2) {
        return new DerivableContainerSymbol(this, string, eType2);
    }

    public IParameterizedSymbol newParameterizedSymbol(String string) {
        return new ParameterizedSymbol(this, string);
    }

    public IParameterizedSymbol newParameterizedSymbol(String string, TypeInfo.eType eType2) {
        return new ParameterizedSymbol(this, string, eType2);
    }

    public ITemplateSymbol newTemplateSymbol(String string) {
        return new TemplateSymbol(this, string);
    }

    public ISpecializedSymbol newSpecializedSymbol(String string) {
        return new SpecializedSymbol(this, string);
    }

    protected static void lookup(LookupData lookupData, IContainerSymbol iContainerSymbol) throws ParserSymbolTableException {
        Cloneable cloneable;
        if (iContainerSymbol.isType(TypeInfo.t_namespace) && (cloneable = iContainerSymbol.getTypeSymbol()) != null && cloneable.isType(TypeInfo.t_namespace)) {
            iContainerSymbol = (IContainerSymbol)cloneable;
        }
        cloneable = new LinkedList();
        Map map = null;
        if (!lookupData.usingDirectivesOnly) {
            map = ParserSymbolTable.lookupInContained(lookupData, iContainerSymbol);
            if (lookupData.foundItems == null || lookupData.foundItems.isEmpty()) {
                lookupData.foundItems = map;
            } else {
                ParserSymbolTable.mergeResults(lookupData, lookupData.foundItems, map);
            }
        }
        if (iContainerSymbol.getSymbolTable().getLanguage() == ParserLanguage.CPP && !lookupData.ignoreUsingDirectives) {
            lookupData.visited.clear();
            ParserSymbolTable.lookupInNominated(lookupData, iContainerSymbol, (LinkedList)cloneable);
            if (!lookupData.qualified || lookupData.foundItems == null || lookupData.foundItems.isEmpty()) {
                ParserSymbolTable.processDirectives(iContainerSymbol, lookupData, (List)((Object)cloneable));
                if (iContainerSymbol.hasUsingDirectives()) {
                    ParserSymbolTable.processDirectives(iContainerSymbol, lookupData, iContainerSymbol.getUsingDirectives());
                }
                while (lookupData.usingDirectives != null && lookupData.usingDirectives.get(iContainerSymbol) != null) {
                    ((LinkedList)cloneable).clear();
                    ParserSymbolTable.lookupInNominated(lookupData, iContainerSymbol, (LinkedList)cloneable);
                    if (lookupData.qualified && lookupData.foundItems != null) continue;
                    ParserSymbolTable.processDirectives(iContainerSymbol, lookupData, (List)((Object)cloneable));
                }
            }
        }
        if (!(lookupData.mode != LookupMode.NORMAL || lookupData.foundItems.isEmpty() && lookupData.stopAt != iContainerSymbol)) {
            return;
        }
        if (!lookupData.usingDirectivesOnly && iContainerSymbol instanceof IDerivableContainerSymbol) {
            lookupData.visited.clear();
            map = ParserSymbolTable.lookupInParents(lookupData, iContainerSymbol);
            if (lookupData.foundItems == null || lookupData.foundItems.isEmpty()) {
                lookupData.foundItems = map;
            } else {
                ParserSymbolTable.mergeInheritedResults(lookupData.foundItems, map);
            }
        }
        if ((lookupData.foundItems == null || lookupData.foundItems.isEmpty() || lookupData.mode == LookupMode.PREFIX) && iContainerSymbol.getContainingSymbol() != null) {
            if (lookupData.qualified) {
                if (lookupData.usingDirectives != null && !lookupData.usingDirectives.isEmpty()) {
                    lookupData.usingDirectivesOnly = true;
                    ParserSymbolTable.lookup(lookupData, iContainerSymbol.getContainingSymbol());
                }
            } else {
                ParserSymbolTable.lookup(lookupData, iContainerSymbol.getContainingSymbol());
            }
        }
    }

    private static void lookupInNominated(LookupData lookupData, IContainerSymbol iContainerSymbol, LinkedList linkedList) throws ParserSymbolTableException {
        if (lookupData.usingDirectives == null) {
            return;
        }
        LinkedList linkedList2 = null;
        Iterator iterator = null;
        IContainerSymbol iContainerSymbol2 = null;
        boolean bl = false;
        int n = 0;
        linkedList2 = (LinkedList)lookupData.usingDirectives.remove(iContainerSymbol);
        if (linkedList2 == null) {
            return;
        }
        iterator = linkedList2.iterator();
        int n2 = n = linkedList2.size();
        while (n2 > 0) {
            iContainerSymbol2 = (IContainerSymbol)iterator.next();
            if (!lookupData.visited.contains(iContainerSymbol2)) {
                lookupData.visited.add(iContainerSymbol2);
                Map map = ParserSymbolTable.lookupInContained(lookupData, iContainerSymbol2);
                bl = !map.isEmpty();
                ParserSymbolTable.mergeResults(lookupData, lookupData.foundItems, map);
                if (!(lookupData.qualified && bl && lookupData.mode != LookupMode.PREFIX || !iContainerSymbol2.hasUsingDirectives())) {
                    linkedList.addAll(iContainerSymbol2.getUsingDirectives());
                }
            }
            --n2;
        }
    }

    private static void mergeResults(LookupData lookupData, Map map, Map map2) throws ParserSymbolTableException {
        if (map == null || map2 == null || map2.isEmpty()) {
            return;
        }
        Iterator iterator = map2.keySet().iterator();
        Object k = null;
        while (iterator.hasNext()) {
            k = iterator.next();
            if (map.containsKey(k)) {
                LinkedList linkedList = new LinkedList();
                Object v = map.get(k);
                if (v instanceof List) {
                    linkedList.addAll((List)v);
                } else {
                    linkedList.add(v);
                }
                v = map2.get(k);
                if (v instanceof List) {
                    linkedList.addAll((List)v);
                } else {
                    linkedList.add(v);
                }
                map.put(k, ParserSymbolTable.collectSymbol(lookupData, linkedList));
                continue;
            }
            map.put(k, map2.get(k));
        }
    }

    protected static Map lookupInContained(LookupData lookupData, IContainerSymbol iContainerSymbol) throws ParserSymbolTableException {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Object object = null;
        if (lookupData.associated != null) {
            lookupData.associated.remove(iContainerSymbol);
        }
        Map map = iContainerSymbol.getContainedSymbols();
        Iterator iterator = null;
        if (lookupData.mode == LookupMode.PREFIX) {
            if (map instanceof SortedMap) {
                iterator = ((SortedMap)map).tailMap(lookupData.name.toLowerCase()).keySet().iterator();
            } else {
                throw new ParserSymbolTableError(-1);
            }
        }
        String string = iterator != null && iterator.hasNext() ? (String)iterator.next() : lookupData.name;
        while (string != null) {
            if (!ParserSymbolTable.nameMatches(lookupData, string)) break;
            object = map != null ? (Object)map.get(string) : null;
            if ((object = ParserSymbolTable.collectSymbol(lookupData, object)) != null) {
                linkedHashMap.put(string, object);
            }
            string = iterator != null && iterator.hasNext() ? (String)iterator.next() : null;
        }
        if (!linkedHashMap.isEmpty() && lookupData.mode == LookupMode.NORMAL) {
            return linkedHashMap;
        }
        if (iContainerSymbol instanceof IParameterizedSymbol) {
            ParserSymbolTable.lookupInParameters(lookupData, iContainerSymbol, linkedHashMap);
        }
        if (iContainerSymbol.isTemplateMember() && lookupData.templateMember == null) {
            IContainerSymbol iContainerSymbol2;
            IContainerSymbol iContainerSymbol3 = iContainerSymbol.getContainingSymbol();
            IContainerSymbol iContainerSymbol4 = iContainerSymbol2 = iContainerSymbol3 != null ? iContainerSymbol3.getContainingSymbol() : null;
            if (iContainerSymbol3 instanceof IDerivableContainerSymbol && iContainerSymbol2 instanceof ITemplateSymbol || iContainerSymbol instanceof IParameterizedSymbol && iContainerSymbol3 instanceof ITemplateSymbol) {
                lookupData.templateMember = iContainerSymbol;
            }
        }
        return linkedHashMap;
    }

    private static void lookupInParameters(LookupData lookupData, IContainerSymbol iContainerSymbol, Map map) throws ParserSymbolTableException {
        Object object;
        if (iContainerSymbol instanceof ITemplateSymbol && ((ITemplateSymbol)iContainerSymbol).getDefinitionParameterMap() != null) {
            object = (ITemplateSymbol)iContainerSymbol;
            if (lookupData.templateMember != null && object.getDefinitionParameterMap().containsKey(lookupData.templateMember)) {
                Map map2 = (Map)object.getDefinitionParameterMap().get(lookupData.templateMember);
                Iterator iterator = map2.keySet().iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    ISymbol iSymbol = (ISymbol)iterator.next();
                    if (!ParserSymbolTable.nameMatches(lookupData, iSymbol.getName()) || (object2 = ParserSymbolTable.collectSymbol(lookupData, iSymbol)) == null) continue;
                    map.put(iSymbol.getName(), object2);
                }
                return;
            }
        }
        if ((object = ((IParameterizedSymbol)iContainerSymbol).getParameterMap()) != null) {
            Iterator iterator = null;
            if (lookupData.mode == LookupMode.PREFIX) {
                if (object instanceof SortedMap) {
                    iterator = ((SortedMap)object).tailMap(lookupData.name.toLowerCase()).keySet().iterator();
                } else {
                    throw new ParserSymbolTableError(-1);
                }
            }
            String string = iterator != null && iterator.hasNext() ? (String)iterator.next() : lookupData.name;
            while (string != null) {
                if (!ParserSymbolTable.nameMatches(lookupData, string)) break;
                Object object3 = object.get(string);
                if ((object3 = ParserSymbolTable.collectSymbol(lookupData, object3)) != null) {
                    map.put(string, object3);
                }
                string = iterator != null && iterator.hasNext() ? (String)iterator.next() : null;
            }
        }
    }

    private static boolean nameMatches(LookupData lookupData, String string) {
        if (lookupData.mode == LookupMode.PREFIX) {
            return string.regionMatches(true, 0, lookupData.name, 0, lookupData.name.length());
        }
        return string.equals(lookupData.name);
    }

    private static boolean checkType(LookupData lookupData, ISymbol iSymbol) {
        if (lookupData.filter == null) {
            return true;
        }
        return lookupData.filter.shouldAccept(iSymbol);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object collectSymbol(LookupData lookupData, Object object) throws ParserSymbolTableException {
        Iterator iterator;
        if (object == null) {
            return null;
        }
        ISymbol iSymbol = null;
        Iterator iterator2 = object instanceof List ? ((List)object).iterator() : null;
        ISymbol iSymbol2 = iterator2 != null ? (ISymbol)iterator2.next() : (ISymbol)object;
        HashSet<ISymbol> hashSet = new HashSet<ISymbol>();
        HashSet<ISymbol> hashSet2 = new HashSet<ISymbol>();
        ISymbol iSymbol3 = null;
        ISymbol iSymbol4 = null;
        while (iSymbol2 != null) {
            if (iSymbol2 instanceof ITemplateSymbol) {
                IContainerSymbol iContainerSymbol = ((ITemplateSymbol)iSymbol2).getTemplatedSymbol();
                ISymbol iSymbol5 = iSymbol2 = iContainerSymbol != null ? iContainerSymbol : iSymbol2;
            }
            if (!iSymbol2.getIsInvisible() && ParserSymbolTable.checkType(lookupData, iSymbol2)) {
                iSymbol = iSymbol2;
                if (iSymbol.isType(TypeInfo.t_function)) {
                    if (iSymbol.isForwardDeclaration() && iSymbol.getTypeSymbol() != null) {
                        iSymbol = iSymbol.getTypeSymbol();
                    }
                    if (iSymbol.getContainingSymbol().isType(TypeInfo.t_template)) {
                        hashSet2.add(iSymbol);
                    } else {
                        hashSet.add(iSymbol);
                    }
                } else if (iSymbol.isType(TypeInfo.t_class, TypeInfo.t_enumeration)) {
                    if (iSymbol4 == null) {
                        iSymbol4 = (IContainerSymbol)iSymbol;
                    } else if (iSymbol4.getTypeInfo().isForwardDeclaration() && iSymbol4.getTypeSymbol() == iSymbol) {
                        iSymbol4 = (IContainerSymbol)iSymbol;
                    } else if (!iSymbol.getTypeInfo().isForwardDeclaration() || iSymbol.getTypeSymbol() != iSymbol4) {
                        if (lookupData.mode != LookupMode.PREFIX) throw new ParserSymbolTableException(0);
                        if (lookupData.ambiguities == null) {
                            lookupData.ambiguities = new HashSet();
                        }
                        lookupData.ambiguities.add(iSymbol.getName());
                    }
                } else if (iSymbol3 == null) {
                    iSymbol3 = iSymbol;
                } else {
                    if (lookupData.mode != LookupMode.PREFIX) throw new ParserSymbolTableException(0);
                    if (lookupData.ambiguities == null) {
                        lookupData.ambiguities = new HashSet();
                    }
                    lookupData.ambiguities.add(iSymbol.getName());
                }
            }
            iSymbol2 = iterator2 != null ? (iterator2.hasNext() ? (ISymbol)iterator2.next() : null) : null;
        }
        int n = hashSet.size();
        int n2 = hashSet2.size();
        boolean bl = false;
        if (iSymbol4 != null) {
            int n3;
            if (iSymbol3 != null && iSymbol4.getContainingSymbol() != iSymbol3.getContainingSymbol()) {
                bl = true;
            }
            iterator = null;
            IParameterizedSymbol iParameterizedSymbol = null;
            if (!hashSet2.isEmpty()) {
                iterator = hashSet2.iterator();
                n3 = n2;
                while (n3 > 0) {
                    iParameterizedSymbol = (IParameterizedSymbol)iterator.next();
                    if (iSymbol4.getContainingSymbol() != iParameterizedSymbol.getContainingSymbol()) {
                        bl = true;
                        break;
                    }
                    --n3;
                }
            }
            if (!hashSet.isEmpty()) {
                iterator = hashSet.iterator();
                n3 = n;
                while (n3 > 0) {
                    iParameterizedSymbol = (IParameterizedSymbol)iterator.next();
                    if (iSymbol4.getContainingSymbol() != iParameterizedSymbol.getContainingSymbol()) {
                        bl = true;
                        break;
                    }
                    --n3;
                }
            }
        }
        if (n2 > 0) {
            if (lookupData.parameters != null) {
                iterator = TemplateEngine.selectTemplateFunctions(hashSet2, lookupData.parameters);
                hashSet.addAll((Collection<ISymbol>)((Object)iterator));
                n = hashSet.size();
            } else {
                hashSet.addAll(hashSet2);
                n += n2;
            }
        }
        if (iSymbol3 != null && !bl) {
            if (n <= 0) return iSymbol3;
            bl = true;
        } else if (n > 0) {
            return new LinkedList(hashSet);
        }
        if (!bl) return iSymbol4;
        if (lookupData.mode != LookupMode.PREFIX) throw new ParserSymbolTableException(0);
        if (lookupData.ambiguities == null) {
            lookupData.ambiguities = new HashSet();
        }
        lookupData.ambiguities.add(iSymbol.getName());
        return iSymbol4;
    }

    private static Map lookupInParents(LookupData lookupData, ISymbol iSymbol) throws ParserSymbolTableException {
        int n;
        IDerivableContainerSymbol iDerivableContainerSymbol = null;
        if (!(iSymbol instanceof IDerivableContainerSymbol)) {
            throw new ParserSymbolTableError(-1);
        }
        iDerivableContainerSymbol = (IDerivableContainerSymbol)iSymbol;
        List list = iDerivableContainerSymbol.getParents();
        Map map = null;
        Map map2 = null;
        Map map3 = null;
        Iterator iterator = null;
        IDerivableContainerSymbol.IParentSymbol iParentSymbol = null;
        if (list == null) {
            return null;
        }
        if (lookupData.inheritanceChain == null) {
            lookupData.inheritanceChain = new HashSet();
        }
        lookupData.inheritanceChain.add(iDerivableContainerSymbol);
        iterator = list.iterator();
        int n2 = n = list.size();
        while (n2 > 0) {
            iParentSymbol = (IDerivableContainerSymbol.IParentSymbol)iterator.next();
            ISymbol iSymbol2 = iParentSymbol.getParent();
            if (!iParentSymbol.isVirtual() || !lookupData.visited.contains(iSymbol2)) {
                if (iParentSymbol.isVirtual()) {
                    lookupData.visited.add(iSymbol2);
                }
                if (!lookupData.inheritanceChain.contains(iSymbol2)) {
                    if (!(iSymbol2 instanceof IDerivableContainerSymbol)) {
                        throw new ParserSymbolTableException(1);
                    }
                    map = ParserSymbolTable.lookupInContained(lookupData, (IDerivableContainerSymbol)iSymbol2);
                    if (map.isEmpty() || lookupData.mode == LookupMode.PREFIX) {
                        map3 = ParserSymbolTable.lookupInParents(lookupData, iSymbol2);
                        ParserSymbolTable.mergeInheritedResults(map, map3);
                    }
                } else {
                    throw new ParserSymbolTableException(2);
                }
            }
            if (map != null && !map.isEmpty()) {
                if (map2 == null || map2.isEmpty()) {
                    map2 = map;
                } else if (map != null && !map.isEmpty()) {
                    Iterator iterator2 = map.keySet().iterator();
                    Object k = null;
                    while (iterator2.hasNext()) {
                        k = iterator2.next();
                        if (map2.containsKey(k)) {
                            Object v = map2.get(k);
                            Iterator iterator3 = v instanceof List ? ((List)v).iterator() : null;
                            ISymbol iSymbol3 = (ISymbol)(iterator3 != null && iterator3.hasNext() ? iterator3.next() : v);
                            while (iSymbol3 != null) {
                                if (!ParserSymbolTable.checkAmbiguity(iSymbol3, map.get(k))) {
                                    if (lookupData.mode == LookupMode.PREFIX) {
                                        if (lookupData.ambiguities == null) {
                                            lookupData.ambiguities = new HashSet();
                                        }
                                        lookupData.ambiguities.add(iSymbol3.getName());
                                    } else {
                                        throw new ParserSymbolTableException(0);
                                    }
                                }
                                iSymbol3 = iterator3 != null && iterator3.hasNext() ? (ISymbol)iterator3.next() : null;
                            }
                            continue;
                        }
                        map2.put(k, map.get(k));
                    }
                }
            } else {
                map = null;
            }
            --n2;
        }
        lookupData.inheritanceChain.remove(iDerivableContainerSymbol);
        return map2;
    }

    private static boolean checkAmbiguity(Object object, Object object2) {
        if (object == object2) {
            Iterator iterator = object instanceof List ? ((List)object).iterator() : null;
            ISymbol iSymbol = iterator != null ? (ISymbol)iterator.next() : (ISymbol)object;
            while (iSymbol != null) {
                TypeInfo typeInfo = ((ISymbol)object).getTypeInfo();
                if (!typeInfo.checkBit(128) && !typeInfo.isType(TypeInfo.t_enumerator)) {
                    return false;
                }
                iSymbol = iterator != null && iterator.hasNext() ? (ISymbol)iterator.next() : null;
            }
            return true;
        }
        return false;
    }

    private static void mergeInheritedResults(Map map, Map map2) {
        if (map == null || map2 == null || map2.isEmpty()) {
            return;
        }
        Iterator iterator = map2.keySet().iterator();
        Object k = null;
        while (iterator.hasNext()) {
            k = iterator.next();
            if (map.containsKey(k)) continue;
            map.put(k, map2.get(k));
        }
    }

    protected static boolean isValidOverload(ISymbol iSymbol, ISymbol iSymbol2) {
        ITemplateSymbol iTemplateSymbol;
        TypeInfo.eType eType2 = iSymbol.getType();
        TypeInfo.eType eType3 = iSymbol2.getType();
        if (eType2 == TypeInfo.t_template) {
            iTemplateSymbol = (ITemplateSymbol)iSymbol;
            if ((iSymbol = (ISymbol)iTemplateSymbol.getContainedSymbols().get(iTemplateSymbol.getName())) == null) {
                return true;
            }
            eType2 = iSymbol.getType();
        }
        if (eType3 == TypeInfo.t_template) {
            iTemplateSymbol = (ITemplateSymbol)iSymbol2;
            if ((iSymbol2 = (ISymbol)iTemplateSymbol.getContainedSymbols().get(iTemplateSymbol.getName())) == null) {
                return true;
            }
            eType3 = iSymbol2.getType();
        }
        if (iSymbol.getTypeInfo().isForwardDeclaration()) {
            if (iSymbol.getTypeSymbol() == iSymbol2) {
                return true;
            }
            if (iSymbol.getIsInvisible() && iSymbol.isType(iSymbol2.getType())) {
                iSymbol.getTypeInfo().setTypeSymbol(iSymbol2);
                return true;
            }
        }
        if (eType2.compareTo(TypeInfo.t_class) >= 0 && eType2.compareTo(TypeInfo.t_enumeration) <= 0 && (eType3 == TypeInfo.t_type || eType3.compareTo(TypeInfo.t_function) >= 0)) {
            return true;
        }
        if (iSymbol instanceof IParameterizedSymbol && iSymbol2 instanceof IParameterizedSymbol) {
            return ParserSymbolTable.isValidFunctionOverload((IParameterizedSymbol)iSymbol, (IParameterizedSymbol)iSymbol2);
        }
        return false;
    }

    protected static boolean isValidOverload(List list, ISymbol iSymbol) {
        if (list.size() == 1) {
            return ParserSymbolTable.isValidOverload((ISymbol)list.iterator().next(), iSymbol);
        }
        if (list.size() > 1) {
            Iterator iterator;
            if (iSymbol.isType(TypeInfo.t_template)) {
                iterator = (ITemplateSymbol)iSymbol;
                iSymbol = (ISymbol)iterator.getContainedSymbols().get(iterator.getName());
            }
            if (iSymbol.getType() != TypeInfo.t_function && iSymbol.getType() != TypeInfo.t_constructor) {
                return false;
            }
            iterator = list.iterator();
            ISymbol iSymbol2 = (ISymbol)iterator.next();
            if (iSymbol2.isType(TypeInfo.t_template)) {
                IParameterizedSymbol iParameterizedSymbol = (IParameterizedSymbol)iSymbol2;
                iSymbol2 = (ISymbol)iParameterizedSymbol.getContainedSymbols().get(iParameterizedSymbol.getName());
            }
            boolean bl = ParserSymbolTable.isValidOverload(iSymbol2, iSymbol);
            while (bl && iterator.hasNext()) {
                iSymbol2 = (ISymbol)iterator.next();
                if (iSymbol2.isType(TypeInfo.t_template)) {
                    IParameterizedSymbol iParameterizedSymbol = (IParameterizedSymbol)iSymbol2;
                    iSymbol2 = (ISymbol)iParameterizedSymbol.getContainedSymbols().get(iParameterizedSymbol.getName());
                }
                boolean bl2 = bl = iSymbol2 instanceof IParameterizedSymbol && ParserSymbolTable.isValidFunctionOverload((IParameterizedSymbol)iSymbol2, (IParameterizedSymbol)iSymbol);
            }
            return bl;
        }
        return true;
    }

    private static boolean isValidFunctionOverload(IParameterizedSymbol iParameterizedSymbol, IParameterizedSymbol iParameterizedSymbol2) {
        if (!iParameterizedSymbol.isType(TypeInfo.t_function) && !iParameterizedSymbol.isType(TypeInfo.t_constructor) || !iParameterizedSymbol2.isType(TypeInfo.t_function) && !iParameterizedSymbol2.isType(TypeInfo.t_constructor)) {
            return false;
        }
        if (iParameterizedSymbol.getTypeInfo().isForwardDeclaration() && iParameterizedSymbol.getTypeSymbol() == iParameterizedSymbol2) {
            return true;
        }
        if (iParameterizedSymbol.hasSameParameters(iParameterizedSymbol2)) {
            if (iParameterizedSymbol.getTypeInfo().checkBit(128) || iParameterizedSymbol2.getTypeInfo().checkBit(128)) {
                return false;
            }
            return iParameterizedSymbol.compareCVQualifiersTo(iParameterizedSymbol2) != 0;
        }
        return true;
    }

    protected static ISymbol resolveAmbiguities(LookupData lookupData) throws ParserSymbolTableException {
        if (lookupData.foundItems == null || lookupData.foundItems.isEmpty() || lookupData.mode == LookupMode.PREFIX) {
            return null;
        }
        Object v = lookupData.foundItems.get(lookupData.name);
        LinkedList<ISymbol> linkedList = new LinkedList<ISymbol>();
        if (v instanceof List) {
            linkedList.addAll((List)v);
        } else {
            ISymbol iSymbol = (ISymbol)v;
            if (iSymbol.isType(TypeInfo.t_function)) {
                linkedList.add(iSymbol);
            } else {
                if (iSymbol.isTemplateMember() && !iSymbol.isTemplateInstance() && !iSymbol.isType(TypeInfo.t_templateParameter) && iSymbol.getContainingSymbol().isType(TypeInfo.t_template)) {
                    return iSymbol.getContainingSymbol();
                }
                return iSymbol;
            }
        }
        if (lookupData.parameters == null) {
            if (linkedList.size() == 1) {
                return (ISymbol)linkedList.getFirst();
            }
            throw new ParserSymbolTableException(7);
        }
        return ParserSymbolTable.resolveFunction(lookupData, linkedList);
    }

    protected static IParameterizedSymbol resolveFunction(LookupData lookupData, List list) throws ParserSymbolTableException {
        IParameterizedSymbol iParameterizedSymbol;
        Object object;
        if (list == null) {
            return null;
        }
        ParserSymbolTable.reduceToViable(lookupData, list);
        int n = lookupData.parameters == null ? 0 : lookupData.parameters.size();
        int n2 = list.size();
        if (n == 0) {
            if (n2 == 0) {
                return null;
            }
            if (n2 == 1) {
                return (IParameterizedSymbol)list.iterator().next();
            }
            if (n2 == 2) {
                object = list.iterator();
                while (object.hasNext()) {
                    iParameterizedSymbol = (IParameterizedSymbol)object.next();
                    if (!iParameterizedSymbol.getTypeInfo().isForwardDeclaration() || iParameterizedSymbol.getTypeSymbol() == null || !list.contains(iParameterizedSymbol.getTypeSymbol())) continue;
                    return (IParameterizedSymbol)iParameterizedSymbol.getTypeSymbol();
                }
            }
            if (lookupData.parameters == null) {
                throw new ParserSymbolTableException(0);
            }
        }
        object = null;
        iParameterizedSymbol = null;
        Cost[] costArray = null;
        Cost[] costArray2 = null;
        Iterator iterator = list.iterator();
        Iterator iterator2 = null;
        Iterator iterator3 = null;
        Cost cost = null;
        Cost cost2 = null;
        TypeInfo typeInfo = null;
        TypeInfo typeInfo2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        LinkedList<TypeInfo> linkedList = null;
        if (n == 0) {
            linkedList = new LinkedList<TypeInfo>();
            linkedList.add(new TypeInfo(TypeInfo.t_void, 0, null));
            n = 1;
        } else {
            linkedList = lookupData.parameters;
        }
        int n3 = n2;
        while (n3 > 0) {
            block39: {
                block37: {
                    block38: {
                        iParameterizedSymbol = (IParameterizedSymbol)iterator.next();
                        if (object == null) break block37;
                        if (!object.isForwardDeclaration() || object.getTypeSymbol() != iParameterizedSymbol) break block38;
                        object = iParameterizedSymbol;
                        break block39;
                    }
                    if (iParameterizedSymbol.isForwardDeclaration() && iParameterizedSymbol.getTypeSymbol() == object) break block39;
                }
                iterator2 = linkedList.iterator();
                LinkedList<ISymbol> linkedList2 = null;
                if (iParameterizedSymbol.getParameterList().isEmpty() && !iParameterizedSymbol.hasVariableArgs()) {
                    linkedList2 = new LinkedList<ISymbol>();
                    linkedList2.add(iParameterizedSymbol.getSymbolTable().newSymbol(EMPTY_NAME, TypeInfo.t_void));
                } else {
                    linkedList2 = iParameterizedSymbol.getParameterList();
                }
                iterator3 = linkedList2.iterator();
                if (costArray2 == null) {
                    costArray2 = new Cost[n];
                }
                int n4 = 0;
                boolean bl6 = false;
                int n5 = 0;
                while (n5 < n) {
                    typeInfo = (TypeInfo)iterator2.next();
                    if (iterator3.hasNext()) {
                        typeInfo2 = ((ISymbol)iterator3.next()).getTypeInfo();
                    } else {
                        bl6 = true;
                    }
                    if (bl6) {
                        cost = new Cost(typeInfo, null);
                        cost.rank = 5;
                    } else if (typeInfo2.getHasDefault() && typeInfo.isType(TypeInfo.t_void) && !typeInfo.hasPtrOperators()) {
                        cost = new Cost(typeInfo, typeInfo2);
                        cost.rank = 0;
                    } else if (typeInfo.equals(typeInfo2)) {
                        cost = new Cost(typeInfo, typeInfo2);
                        cost.rank = 0;
                    } else {
                        cost = ParserSymbolTable.checkStandardConversionSequence(typeInfo, typeInfo2);
                        if (cost.rank == -1 && !lookupData.forUserDefinedConversion && (cost2 = ParserSymbolTable.checkUserDefinedConversionSequence(typeInfo, typeInfo2)) != null) {
                            cost = cost2;
                        }
                    }
                    costArray2[n5] = cost;
                    ++n5;
                }
                bl = false;
                bl2 = false;
                n5 = 0;
                while (n5 < n) {
                    if (costArray2[n5].rank < 0) {
                        bl = true;
                        bl2 = false;
                        break;
                    }
                    boolean bl7 = bl4 = costArray2[n5].userDefined == 1;
                    if (costArray != null) {
                        n4 = costArray2[n5].compare(costArray[n5]);
                        bl |= n4 < 0;
                        bl2 |= n4 > 0;
                    } else {
                        bl2 = true;
                    }
                    ++n5;
                }
                bl3 |= bl && bl2 || !bl && !bl2;
                if (!bl) {
                    if (!bl2 && object.isTemplateInstance() && iParameterizedSymbol.isTemplateInstance()) {
                        ITemplateSymbol iTemplateSymbol;
                        ITemplateSymbol iTemplateSymbol2 = (ITemplateSymbol)object.getInstantiatedSymbol().getContainingSymbol();
                        int n6 = TemplateEngine.orderTemplateFunctions(iTemplateSymbol2, iTemplateSymbol = (ITemplateSymbol)iParameterizedSymbol.getInstantiatedSymbol().getContainingSymbol());
                        if (n6 < 0) {
                            bl2 = true;
                        } else if (n6 > 0) {
                            bl3 = false;
                        }
                    }
                    if (bl2) {
                        bl3 = false;
                        costArray = costArray2;
                        bl5 = bl4;
                        costArray2 = null;
                        object = iParameterizedSymbol;
                    }
                }
            }
            --n3;
        }
        if (bl3 || bl5) {
            throw new ParserSymbolTableException(0);
        }
        return object;
    }

    private static boolean functionHasParameters(IParameterizedSymbol iParameterizedSymbol, List list) {
        if (list == null) {
            return iParameterizedSymbol.getParameterList().isEmpty();
        }
        IParameterizedSymbol iParameterizedSymbol2 = iParameterizedSymbol.getSymbolTable().newParameterizedSymbol(EMPTY_NAME, TypeInfo.t_function);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ISymbol iSymbol = iParameterizedSymbol.getSymbolTable().newSymbol(EMPTY_NAME);
            iSymbol.setTypeInfo((TypeInfo)iterator.next());
            iParameterizedSymbol2.addParameter(iSymbol);
        }
        return iParameterizedSymbol.hasSameParameters(iParameterizedSymbol2);
    }

    private static void reduceToViable(LookupData lookupData, List list) {
        int n = lookupData.parameters == null ? 0 : lookupData.parameters.size();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            ListIterator listIterator;
            int n2;
            IParameterizedSymbol iParameterizedSymbol = (IParameterizedSymbol)iterator.next();
            int n3 = n2 = iParameterizedSymbol.getParameterList() == null ? 0 : iParameterizedSymbol.getParameterList().size();
            if (n2 == n) {
                if (!lookupData.exactFunctionsOnly || ParserSymbolTable.functionHasParameters(iParameterizedSymbol, lookupData.parameters)) continue;
                iterator.remove();
                continue;
            }
            if (n != 0 || n2 != 1 ? n == 1 && n2 == 0 && ((TypeInfo)((Object)(listIterator = (TypeInfo)lookupData.parameters.iterator().next()))).isType(TypeInfo.t_void) : (listIterator = (ISymbol)iParameterizedSymbol.getParameterList().iterator().next()).isType(TypeInfo.t_void)) continue;
            if (n2 < n) {
                if (iParameterizedSymbol.hasVariableArgs()) continue;
                iterator.remove();
                continue;
            }
            listIterator = iParameterizedSymbol.getParameterList().listIterator(n2);
            int n4 = n2;
            while (n4 > n - n2 + 1) {
                TypeInfo typeInfo = ((ISymbol)listIterator.previous()).getTypeInfo();
                if (!typeInfo.getHasDefault()) {
                    iterator.remove();
                    continue block0;
                }
                --n4;
            }
        }
    }

    private static void processDirectives(IContainerSymbol iContainerSymbol, LookupData lookupData, List list) {
        IContainerSymbol iContainerSymbol2 = null;
        IContainerSymbol iContainerSymbol3 = null;
        int n = list.size();
        Iterator iterator = list.iterator();
        int n2 = n;
        while (n2 > 0) {
            iContainerSymbol3 = ((IUsingDirectiveSymbol)iterator.next()).getNamespace();
            if (!lookupData.visited.contains(iContainerSymbol3)) {
                LinkedList<IContainerSymbol> linkedList;
                iContainerSymbol2 = ParserSymbolTable.getClosestEnclosingDeclaration(iContainerSymbol, iContainerSymbol3);
                LinkedList<IContainerSymbol> linkedList2 = linkedList = lookupData.usingDirectives == null ? null : (LinkedList<IContainerSymbol>)lookupData.usingDirectives.get(iContainerSymbol2);
                if (linkedList == null) {
                    linkedList = new LinkedList<IContainerSymbol>();
                    linkedList.add(iContainerSymbol3);
                    if (lookupData.usingDirectives == null) {
                        lookupData.usingDirectives = new HashMap();
                    }
                    lookupData.usingDirectives.put(iContainerSymbol2, linkedList);
                } else {
                    linkedList.add(iContainerSymbol3);
                }
            }
            --n2;
        }
    }

    private static IContainerSymbol getClosestEnclosingDeclaration(ISymbol iSymbol, ISymbol iSymbol2) {
        if (iSymbol == iSymbol2) {
            return iSymbol instanceof IContainerSymbol ? (IContainerSymbol)iSymbol : iSymbol.getContainingSymbol();
        }
        if (iSymbol.getDepth() == iSymbol2.getDepth()) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(iSymbol.getContainingSymbol(), iSymbol2.getContainingSymbol());
        }
        if (iSymbol.getDepth() > iSymbol2.getDepth()) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(iSymbol.getContainingSymbol(), iSymbol2);
        }
        return ParserSymbolTable.getClosestEnclosingDeclaration(iSymbol, iSymbol2.getContainingSymbol());
    }

    protected static int hasBaseClass(ISymbol iSymbol, ISymbol iSymbol2) throws ParserSymbolTableException {
        return ParserSymbolTable.hasBaseClass(iSymbol, iSymbol2, false);
    }

    private static int hasBaseClass(ISymbol iSymbol, ISymbol iSymbol2, boolean bl) throws ParserSymbolTableException {
        if (iSymbol == iSymbol2) {
            return 0;
        }
        IDerivableContainerSymbol iDerivableContainerSymbol = null;
        if (!(iSymbol instanceof IDerivableContainerSymbol)) {
            return -1;
        }
        iDerivableContainerSymbol = (IDerivableContainerSymbol)iSymbol;
        if (iDerivableContainerSymbol.hasParents()) {
            int n;
            ISymbol iSymbol3 = null;
            IDerivableContainerSymbol iDerivableContainerSymbol2 = null;
            Iterator iterator = iDerivableContainerSymbol.getParents().iterator();
            int n2 = n = iDerivableContainerSymbol.getParents().size();
            while (n2 > 0) {
                boolean bl2;
                IDerivableContainerSymbol.IParentSymbol iParentSymbol = (IDerivableContainerSymbol.IParentSymbol)iterator.next();
                iSymbol3 = iParentSymbol.getParent();
                boolean bl3 = bl2 = iParentSymbol.getAccess() == ASTAccessVisibility.PUBLIC;
                if (iSymbol3 instanceof IDerivableContainerSymbol) {
                    iDerivableContainerSymbol2 = (IDerivableContainerSymbol)iSymbol3;
                    if (iDerivableContainerSymbol2 == iSymbol2) {
                        if (bl && !bl2) {
                            throw new ParserSymbolTableException(6);
                        }
                        return 1;
                    }
                    int n3 = ParserSymbolTable.hasBaseClass(iDerivableContainerSymbol2, iSymbol2, bl);
                    if (n3 > 0) {
                        return n3 + 1;
                    }
                }
                --n2;
            }
        }
        return -1;
    }

    protected static void getAssociatedScopes(ISymbol iSymbol, HashSet hashSet) {
        if (iSymbol == null) {
            return;
        }
        if (iSymbol instanceof IDerivableContainerSymbol) {
            hashSet.add(iSymbol);
            hashSet.add(iSymbol.getContainingSymbol());
            ParserSymbolTable.getBaseClassesAndContainingNamespaces((IDerivableContainerSymbol)iSymbol, hashSet);
        } else if (iSymbol.getType() == TypeInfo.t_union || iSymbol.getType() == TypeInfo.t_enumeration) {
            hashSet.add(iSymbol.getContainingSymbol());
        }
    }

    private static void getBaseClassesAndContainingNamespaces(IDerivableContainerSymbol iDerivableContainerSymbol, HashSet hashSet) {
        if (iDerivableContainerSymbol.getParents() != null) {
            int n;
            if (hashSet == null) {
                return;
            }
            Iterator iterator = iDerivableContainerSymbol.getParents().iterator();
            int n2 = n = iDerivableContainerSymbol.getParents().size();
            while (n2 > 0) {
                IDerivableContainerSymbol.IParentSymbol iParentSymbol = (IDerivableContainerSymbol.IParentSymbol)iterator.next();
                ISymbol iSymbol = iParentSymbol.getParent();
                if (iSymbol instanceof IDerivableContainerSymbol) {
                    hashSet.add(iSymbol);
                    if (iSymbol.getContainingSymbol().getType() == TypeInfo.t_namespace) {
                        hashSet.add(iSymbol.getContainingSymbol());
                    }
                    ParserSymbolTable.getBaseClassesAndContainingNamespaces((IDerivableContainerSymbol)iSymbol, hashSet);
                }
                --n2;
            }
        }
    }

    protected static boolean okToAddUsingDeclaration(ISymbol iSymbol, IContainerSymbol iContainerSymbol) {
        boolean bl = false;
        if (iSymbol.isTemplateMember() && iSymbol.getContainingSymbol().isType(TypeInfo.t_template)) {
            bl = false;
        } else if (iContainerSymbol.isType(TypeInfo.t_class, TypeInfo.t_struct)) {
            IContainerSymbol iContainerSymbol2 = iSymbol.getContainingSymbol();
            try {
                if (iSymbol.getContainingSymbol().getType() == iContainerSymbol.getType()) {
                    bl = ParserSymbolTable.hasBaseClass(iContainerSymbol, iContainerSymbol2) > 0;
                } else if (iSymbol.getContainingSymbol().getType() == TypeInfo.t_union) {
                    bl = (iContainerSymbol2 = iContainerSymbol2.getContainingSymbol()) instanceof IDerivableContainerSymbol ? ParserSymbolTable.hasBaseClass(iContainerSymbol, iContainerSymbol2) > 0 : false;
                } else if (iSymbol.getType() == TypeInfo.t_enumerator) {
                    bl = (iContainerSymbol2 = iContainerSymbol2.getContainingSymbol()) instanceof IDerivableContainerSymbol ? ParserSymbolTable.hasBaseClass(iContainerSymbol, iContainerSymbol2) > 0 : false;
                }
            }
            catch (ParserSymbolTableException parserSymbolTableException) {}
        } else {
            bl = true;
        }
        return bl;
    }

    private static Cost lvalue_to_rvalue(TypeInfo typeInfo, TypeInfo typeInfo2) {
        int n;
        Iterator iterator;
        int n2;
        TypeInfo.PtrOp ptrOp;
        Iterator iterator2;
        List list;
        Object object;
        if (typeInfo.isType(TypeInfo.t_type)) {
            typeInfo = ParserSymbolTable.getFlatTypeInfo(typeInfo);
        }
        if (typeInfo2.isType(TypeInfo.t_type) && (object = typeInfo2.getTypeSymbol()) != null && object.isForwardDeclaration() && object.getTypeSymbol() != null) {
            typeInfo2 = new TypeInfo(typeInfo2);
            typeInfo2.setType(TypeInfo.t_type);
            typeInfo2.setTypeSymbol(object.getTypeSymbol());
        }
        object = new Cost(typeInfo, typeInfo2);
        if (((Cost)object).source == null || ((Cost)object).target == null) {
            return object;
        }
        TypeInfo.PtrOp ptrOp2 = null;
        if (((Cost)object).source.hasPtrOperators()) {
            list = ((Cost)object).source.getPtrOperators();
            iterator2 = list.iterator();
            ptrOp = (TypeInfo.PtrOp)iterator2.next();
            if (ptrOp.getType() == TypeInfo.PtrOp.t_reference) {
                iterator2.remove();
            }
            n2 = list.size();
            iterator = list.iterator();
            n = n2;
            while (n > 0) {
                ptrOp2 = (TypeInfo.PtrOp)iterator.next();
                if (ptrOp2.getType() == TypeInfo.PtrOp.t_array) {
                    ptrOp2.setType(TypeInfo.PtrOp.t_pointer);
                }
                --n;
            }
        }
        if (((Cost)object).target.hasPtrOperators()) {
            list = ((Cost)object).target.getPtrOperators();
            iterator2 = list.listIterator();
            ptrOp = (TypeInfo.PtrOp)iterator2.next();
            if (ptrOp.getType() == TypeInfo.PtrOp.t_reference) {
                iterator2.remove();
                ((Cost)object).targetHadReference = true;
            }
            n2 = list.size();
            iterator = list.iterator();
            n = n2;
            while (n > 0) {
                ptrOp2 = (TypeInfo.PtrOp)iterator.next();
                if (ptrOp2.getType() == TypeInfo.PtrOp.t_array) {
                    ptrOp2.setType(TypeInfo.PtrOp.t_pointer);
                }
                --n;
            }
        }
        return object;
    }

    private static void qualificationConversion(Cost cost) {
        int n = cost.source.getPtrOperators().size();
        int n2 = cost.target.getPtrOperators().size();
        TypeInfo.PtrOp ptrOp = null;
        TypeInfo.PtrOp ptrOp2 = null;
        boolean bl = true;
        Iterator iterator = cost.source.getPtrOperators().iterator();
        Iterator iterator2 = cost.target.getPtrOperators().iterator();
        if (n != n2) {
            bl = false;
        } else if (n > 0) {
            ptrOp = (TypeInfo.PtrOp)iterator.next();
            ptrOp2 = (TypeInfo.PtrOp)iterator2.next();
            boolean bl2 = true;
            int n3 = 1;
            while (n3 < n) {
                ptrOp = (TypeInfo.PtrOp)iterator.next();
                ptrOp2 = (TypeInfo.PtrOp)iterator2.next();
                if (ptrOp.getType() != ptrOp2.getType()) {
                    bl = false;
                    break;
                }
                if (ptrOp.isConst() && !ptrOp2.isConst() || ptrOp.isVolatile() && !ptrOp2.isVolatile()) {
                    bl = false;
                    break;
                }
                if (ptrOp.compareCVTo(ptrOp2) != 0 && !bl2) {
                    bl = false;
                    break;
                }
                bl2 &= ptrOp2.isConst();
                ++n3;
            }
        }
        if (cost.source.checkBit(32768) && !cost.target.checkBit(32768) || cost.source.checkBit(65536) && !cost.target.checkBit(65536)) {
            bl = false;
        }
        if (bl) {
            cost.qualification = 1;
            cost.rank = 0;
        } else {
            cost.qualification = 0;
        }
    }

    private static void promotion(Cost cost) {
        TypeInfo typeInfo = cost.source;
        TypeInfo typeInfo2 = cost.target;
        int n = 26083328;
        if ((typeInfo.isType(TypeInfo.t__Bool, TypeInfo.t_float) || typeInfo.isType(TypeInfo.t_enumeration)) && (typeInfo2.isType(TypeInfo.t_int) || typeInfo2.isType(TypeInfo.t_double))) {
            if (typeInfo.getType() == typeInfo2.getType() && (typeInfo.getTypeInfo() & n) == (typeInfo2.getTypeInfo() & n)) {
                return;
            }
            cost.promotion = typeInfo.isType(TypeInfo.t_float) ? (typeInfo2.isType(TypeInfo.t_double) ? 1 : 0) : (typeInfo2.isType(TypeInfo.t_int) && typeInfo2.canHold(typeInfo) ? 1 : 0);
        } else {
            cost.promotion = 0;
        }
        cost.rank = cost.promotion > 0 ? 1 : -1;
    }

    private static void conversion(Cost cost) {
        TypeInfo typeInfo = cost.source;
        TypeInfo typeInfo2 = cost.target;
        int n = -1;
        cost.conversion = 0;
        cost.detail = 0;
        if (!typeInfo.hasSamePtrs(typeInfo2)) {
            return;
        }
        if (typeInfo.hasPtrOperators() && typeInfo.getPtrOperators().size() == 1) {
            ISymbol iSymbol;
            TypeInfo.PtrOp ptrOp = (TypeInfo.PtrOp)typeInfo.getPtrOperators().iterator().next();
            ISymbol iSymbol2 = typeInfo.isType(TypeInfo.t_type) ? typeInfo.getTypeSymbol() : null;
            ISymbol iSymbol3 = iSymbol = typeInfo2.isType(TypeInfo.t_type) ? typeInfo2.getTypeSymbol() : null;
            if (ptrOp.getType() == TypeInfo.PtrOp.t_pointer) {
                if (iSymbol2 == null || iSymbol == null && !typeInfo2.isType(TypeInfo.t_void)) {
                    return;
                }
                if (typeInfo2.isType(TypeInfo.t_void)) {
                    cost.rank = 2;
                    cost.conversion = 1;
                    cost.detail = 2;
                    return;
                }
                cost.detail = 1;
                if (iSymbol2 instanceof IDerivableContainerSymbol && iSymbol.isType(iSymbol2.getType())) {
                    try {
                        n = ParserSymbolTable.hasBaseClass(iSymbol2, iSymbol);
                    }
                    catch (ParserSymbolTableException parserSymbolTableException) {}
                    cost.rank = n > -1 ? 2 : -1;
                    cost.conversion = n > -1 ? n : 0;
                    cost.detail = 1;
                    return;
                }
            } else if (ptrOp.getType() == TypeInfo.PtrOp.t_memberPointer) {
                TypeInfo.PtrOp ptrOp2;
                if (iSymbol2 == null || iSymbol == null) {
                    return;
                }
                TypeInfo.PtrOp ptrOp3 = ptrOp2 = typeInfo2.hasPtrOperators() ? (TypeInfo.PtrOp)typeInfo2.getPtrOperators().iterator().next() : null;
                if (iSymbol.isType(iSymbol2.getType()) && ptrOp2 != null && ptrOp2.getType() == TypeInfo.PtrOp.t_memberPointer) {
                    try {
                        n = ParserSymbolTable.hasBaseClass(ptrOp.getMemberOf(), ptrOp2.getMemberOf());
                    }
                    catch (ParserSymbolTableException parserSymbolTableException) {}
                    cost.rank = n > -1 ? 2 : -1;
                    cost.detail = 1;
                    cost.conversion = n > -1 ? n : 0;
                    return;
                }
            }
        } else if (!typeInfo.hasPtrOperators() && (typeInfo.isType(TypeInfo.t__Bool, TypeInfo.t_int) || typeInfo.isType(TypeInfo.t_float, TypeInfo.t_double) || typeInfo.isType(TypeInfo.t_enumeration)) && (typeInfo2.isType(TypeInfo.t__Bool, TypeInfo.t_int) || typeInfo2.isType(TypeInfo.t_float, TypeInfo.t_double))) {
            cost.rank = 2;
            cost.conversion = 1;
        }
    }

    private static void derivedToBaseConversion(Cost cost) throws ParserSymbolTableException {
        ISymbol iSymbol;
        TypeInfo typeInfo = cost.source;
        TypeInfo typeInfo2 = cost.target;
        ISymbol iSymbol2 = typeInfo.isType(TypeInfo.t_type) ? typeInfo.getTypeSymbol() : null;
        ISymbol iSymbol3 = iSymbol = typeInfo2.isType(TypeInfo.t_type) ? typeInfo2.getTypeSymbol() : null;
        if (!typeInfo.hasSamePtrs(typeInfo2) || iSymbol2 == null || iSymbol == null || !cost.targetHadReference) {
            return;
        }
        int n = ParserSymbolTable.hasBaseClass(iSymbol2, iSymbol, true);
        if (n > -1) {
            cost.rank = 3;
            cost.conversion = n;
        }
    }

    protected static Cost checkStandardConversionSequence(TypeInfo typeInfo, TypeInfo typeInfo2) throws ParserSymbolTableException {
        Cost cost = ParserSymbolTable.lvalue_to_rvalue(typeInfo, typeInfo2);
        if (cost.source == null || cost.target == null) {
            return cost;
        }
        if (cost.source.equals(cost.target)) {
            cost.rank = 0;
            return cost;
        }
        ParserSymbolTable.qualificationConversion(cost);
        if (cost.qualification == 0) {
            return cost;
        }
        if (cost.source.isType(TypeInfo.t_type) && cost.target.isType(TypeInfo.t_type)) {
            if (cost.target.hasSamePtrs(cost.source)) {
                ISymbol iSymbol = cost.source.getTypeSymbol();
                ISymbol iSymbol2 = cost.target.getTypeSymbol();
                if (iSymbol != null && iSymbol2 != null && iSymbol.equals(iSymbol2)) {
                    return cost;
                }
            }
        } else if (cost.source.getType() == cost.target.getType() && (cost.source.getTypeInfo() & 0xFFFF7FFF & 0xFFFEFFFF) == (cost.target.getTypeInfo() & 0xFFFF7FFF & 0xFFFEFFFF)) {
            return cost;
        }
        ParserSymbolTable.promotion(cost);
        if (cost.promotion > 0 || cost.rank > -1) {
            return cost;
        }
        ParserSymbolTable.conversion(cost);
        if (cost.rank > -1) {
            return cost;
        }
        ParserSymbolTable.derivedToBaseConversion(cost);
        return cost;
    }

    private static Cost checkUserDefinedConversionSequence(TypeInfo typeInfo, TypeInfo typeInfo2) throws ParserSymbolTableException {
        LinkedList linkedList;
        Object object;
        Object object2;
        Cost cost = null;
        Cost cost2 = null;
        Cost cost3 = null;
        ISymbol iSymbol = null;
        ISymbol iSymbol2 = null;
        ISymbol iSymbol3 = null;
        Object object3 = null;
        if (typeInfo2.getType() == TypeInfo.t_type && (iSymbol = typeInfo2.getTypeSymbol()).isType(TypeInfo.t_class, TypeInfo.t_union)) {
            object2 = new LookupData(EMPTY_NAME, TypeInfo.t_constructor);
            ((LookupData)object2).parameters = new LinkedList();
            ((LookupData)object2).parameters.add(typeInfo);
            ((LookupData)object2).forUserDefinedConversion = true;
            object = (IDerivableContainerSymbol)iSymbol;
            if (!object.getConstructors().isEmpty()) {
                linkedList = new LinkedList(object.getConstructors());
                iSymbol3 = ParserSymbolTable.resolveFunction((LookupData)object2, linkedList);
            }
            if (iSymbol3 != null && iSymbol3.getTypeInfo().checkBit(4096)) {
                iSymbol3 = null;
            }
        }
        if (typeInfo.getType() == TypeInfo.t_type) {
            ISymbol iSymbol4 = iSymbol2 = (typeInfo = ParserSymbolTable.getFlatTypeInfo(typeInfo)) != null ? typeInfo.getTypeSymbol() : null;
            if (iSymbol2 != null && iSymbol2 instanceof IContainerSymbol && !((String)(object2 = typeInfo2.toString())).equals(EMPTY_NAME)) {
                object = new LookupData("operator " + (String)object2, TypeInfo.t_function);
                ((LookupData)object).parameters = linkedList = new LinkedList();
                ((LookupData)object).forUserDefinedConversion = true;
                ((LookupData)object).foundItems = ParserSymbolTable.lookupInContained((LookupData)object, (IContainerSymbol)iSymbol2);
                object3 = (IParameterizedSymbol)ParserSymbolTable.resolveAmbiguities((LookupData)object);
            }
        }
        if (iSymbol3 != null) {
            cost2 = ParserSymbolTable.checkStandardConversionSequence(new TypeInfo(TypeInfo.t_type, 0, iSymbol3.getContainingSymbol()), typeInfo2);
        }
        if (object3 != null) {
            cost3 = ParserSymbolTable.checkStandardConversionSequence(new TypeInfo(typeInfo2.getType(), 0, typeInfo2.getTypeSymbol()), typeInfo2);
        }
        if (cost2 != null && cost2.rank != -1 && cost3 != null && cost3.rank != -1) {
            cost = cost2;
            cost.userDefined = 1;
            cost.rank = 4;
        } else if (cost2 != null && cost2.rank != -1) {
            cost = cost2;
            cost.userDefined = iSymbol3.hashCode();
            cost.rank = 4;
        } else if (cost3 != null && cost3.rank != -1) {
            cost = cost3;
            cost.userDefined = object3.hashCode();
            cost.rank = 4;
        }
        return cost;
    }

    public static TypeInfo getConditionalOperand(TypeInfo typeInfo, TypeInfo typeInfo2) throws ParserSymbolTableException {
        boolean bl;
        Cost cost = ParserSymbolTable.checkStandardConversionSequence(typeInfo, ParserSymbolTable.getFlatTypeInfo(typeInfo2));
        if (cost.rank == -1) {
            cost = ParserSymbolTable.checkUserDefinedConversionSequence(typeInfo, ParserSymbolTable.getFlatTypeInfo(typeInfo2));
        }
        Cost cost2 = ParserSymbolTable.checkStandardConversionSequence(typeInfo2, ParserSymbolTable.getFlatTypeInfo(typeInfo));
        if (cost2.rank == -1) {
            cost2 = ParserSymbolTable.checkUserDefinedConversionSequence(typeInfo2, ParserSymbolTable.getFlatTypeInfo(typeInfo));
        }
        boolean bl2 = cost != null && cost.rank != -1;
        boolean bl3 = bl = cost2 != null && cost2.rank != -1;
        if (!bl2 && !bl) {
            return null;
        }
        if (bl2 && bl) {
            throw new ParserSymbolTableException(0);
        }
        if (bl2) {
            if (cost.userDefined == 1) {
                throw new ParserSymbolTableException(0);
            }
            return typeInfo2;
        }
        if (cost2.userDefined == 1) {
            throw new ParserSymbolTableException(0);
        }
        return typeInfo;
    }

    protected static TypeInfo getFlatTypeInfo(TypeInfo typeInfo) {
        TypeInfo typeInfo2 = typeInfo;
        TypeInfo typeInfo3 = null;
        if (typeInfo.getType() == TypeInfo.t_type && typeInfo.getTypeSymbol() != null) {
            typeInfo2 = new TypeInfo();
            typeInfo2.setTypeInfo(typeInfo.getTypeInfo());
            ISymbol iSymbol = typeInfo.getTypeSymbol();
            typeInfo3 = iSymbol.getTypeInfo();
            while (typeInfo3.getTypeSymbol() != null && (typeInfo3.getType() == TypeInfo.t_type || typeInfo3.isForwardDeclaration())) {
                iSymbol = typeInfo3.getTypeSymbol();
                typeInfo2.addPtrOperator(typeInfo3.getPtrOperators());
                typeInfo2.setTypeInfo((typeInfo2.getTypeInfo() | typeInfo3.getTypeInfo()) & 0xFFFFDFFF & 0xFFEFFFFF);
                typeInfo3 = iSymbol.getTypeInfo();
            }
            if (typeInfo3.isType(TypeInfo.t_class, TypeInfo.t_enumeration) || typeInfo3.isType(TypeInfo.t_function)) {
                typeInfo2.setType(TypeInfo.t_type);
                typeInfo2.setTypeSymbol(iSymbol);
            } else {
                typeInfo2.setTypeInfo((typeInfo2.getTypeInfo() | typeInfo3.getTypeInfo()) & 0xFFFFDFFF & 0xFFEFFFFF);
                typeInfo2.setType(typeInfo3.getType());
                typeInfo2.setTypeSymbol(null);
                typeInfo2.addPtrOperator(typeInfo3.getPtrOperators());
            }
            typeInfo2.applyOperatorExpressions(typeInfo.getOperatorExpressions());
            if (typeInfo.hasPtrOperators()) {
                TypeInfo.PtrOp ptrOp = (TypeInfo.PtrOp)typeInfo.getPtrOperators().iterator().next();
                TypeInfo.PtrOp ptrOp2 = new TypeInfo.PtrOp(ptrOp.getType(), ptrOp.isConst(), ptrOp.isVolatile());
                typeInfo2.addPtrOperator(ptrOp2);
            }
        } else {
            typeInfo2 = new TypeInfo(typeInfo);
        }
        return typeInfo2;
    }

    public void setLanguage(ParserLanguage parserLanguage) {
        this._language = parserLanguage;
    }

    public ParserLanguage getLanguage() {
        return this._language;
    }

    public ParserMode getParserMode() {
        return this._mode;
    }

    protected void pushCommand(Command command) {
        this.undoList.addFirst(command);
    }

    public Mark setMark() {
        Mark mark = new Mark();
        this.undoList.addFirst(mark);
        this.markSet.add(mark);
        return mark;
    }

    public boolean rollBack(Mark mark) {
        if (this.markSet.contains(mark)) {
            this.markSet.remove(mark);
            Command command = (Command)this.undoList.removeFirst();
            while (command != mark) {
                command.undoIt();
                command = (Command)this.undoList.removeFirst();
            }
            return true;
        }
        return false;
    }

    public boolean commit(Mark mark) {
        if (this.markSet.contains(mark)) {
            this.markSet.remove(mark);
            Command command = (Command)this.undoList.removeLast();
            while (command != mark) {
                command = (Command)this.undoList.removeLast();
            }
            return true;
        }
        return false;
    }

    public static ASTAccessVisibility getVisibility(ISymbol iSymbol, IContainerSymbol iContainerSymbol) {
        IContainerSymbol iContainerSymbol2 = iSymbol.getContainingSymbol();
        if (iContainerSymbol == null || iContainerSymbol2.equals(iContainerSymbol)) {
            ASTSymbol aSTSymbol;
            ISymbolASTExtension iSymbolASTExtension = iSymbol.getASTExtension();
            ASTSymbol aSTSymbol2 = aSTSymbol = iSymbolASTExtension != null ? iSymbolASTExtension.getPrimaryDeclaration() : null;
            if (aSTSymbol != null && aSTSymbol instanceof IASTMember) {
                return ((IASTMember)((Object)aSTSymbol)).getVisiblity();
            }
            throw new ParserSymbolTableError(-1);
        }
        if (!(iContainerSymbol instanceof IDerivableContainerSymbol)) {
            throw new ParserSymbolTableError(-1);
        }
        List list = ((IDerivableContainerSymbol)iContainerSymbol).getParents();
        Iterator iterator = list.iterator();
        IDerivableContainerSymbol.IParentSymbol iParentSymbol = null;
        ASTAccessVisibility aSTAccessVisibility = null;
        ASTAccessVisibility aSTAccessVisibility2 = null;
        while (iterator.hasNext()) {
            iParentSymbol = (IDerivableContainerSymbol.IParentSymbol)iterator.next();
            if (iContainerSymbol2 != iParentSymbol.getParent()) continue;
            aSTAccessVisibility2 = iParentSymbol.getAccess();
            return aSTAccessVisibility2.isGreaterThan(aSTAccessVisibility = ((IASTMember)((Object)iSymbol.getASTExtension().getPrimaryDeclaration())).getVisiblity()) ? aSTAccessVisibility2 : aSTAccessVisibility;
        }
        iterator = list.iterator();
        boolean bl = iSymbol.isType(TypeInfo.t_enumerator) || iSymbol.getTypeInfo().checkBit(128);
        ASTAccessVisibility aSTAccessVisibility3 = null;
        while (iterator.hasNext()) {
            iParentSymbol = (IDerivableContainerSymbol.IParentSymbol)iterator.next();
            aSTAccessVisibility2 = iParentSymbol.getAccess();
            aSTAccessVisibility = ParserSymbolTable.getVisibility(iSymbol, (IContainerSymbol)iParentSymbol.getParent());
            if (aSTAccessVisibility == null) continue;
            ASTAccessVisibility aSTAccessVisibility4 = aSTAccessVisibility = aSTAccessVisibility2.isGreaterThan(aSTAccessVisibility) ? aSTAccessVisibility2 : aSTAccessVisibility;
            if (bl) {
                if (aSTAccessVisibility3 != null) {
                    aSTAccessVisibility3 = aSTAccessVisibility3.isGreaterThan(aSTAccessVisibility) ? aSTAccessVisibility : aSTAccessVisibility3;
                    continue;
                }
                aSTAccessVisibility3 = aSTAccessVisibility;
                continue;
            }
            return aSTAccessVisibility;
        }
        return aSTAccessVisibility3;
    }

    protected static abstract class Command {
        protected Command() {
        }

        public abstract void undoIt();
    }

    public static class Mark
    extends Command {
        public void undoIt() {
        }
    }

    public static class LookupMode
    extends Enum {
        public static final LookupMode PREFIX = new LookupMode(1);
        public static final LookupMode NORMAL = new LookupMode(2);

        private LookupMode(int n) {
            super(n);
        }
    }

    protected static class LookupData {
        public Set ambiguities;
        public String name;
        public Map usingDirectives;
        public Set visited = new HashSet();
        public HashSet inheritanceChain;
        public List parameters;
        public HashSet associated;
        public ISymbol stopAt;
        public TypeFilter filter = null;
        public ISymbol templateMember;
        public boolean qualified = false;
        public boolean ignoreUsingDirectives = false;
        public boolean usingDirectivesOnly = false;
        public boolean forUserDefinedConversion = false;
        public boolean exactFunctionsOnly = false;
        public Map foundItems = null;
        public LookupMode mode = LookupMode.NORMAL;

        public LookupData(String string, TypeInfo.eType eType2) {
            this.name = string;
            this.filter = new TypeFilter(eType2);
        }

        public LookupData(String string, TypeFilter typeFilter) {
            this.name = string;
            this.filter = typeFilter != null ? typeFilter : new TypeFilter(TypeInfo.t_any);
        }
    }

    protected static class Cost {
        public TypeInfo source;
        public TypeInfo target;
        public boolean targetHadReference = false;
        public int lvalue;
        public int promotion;
        public int conversion;
        public int qualification;
        public int userDefined;
        public int rank = -1;
        public int detail;
        public static final int AMBIGUOUS_USERDEFINED_CONVERSION = 1;
        public static final int NO_MATCH_RANK = -1;
        public static final int IDENTITY_RANK = 0;
        public static final int LVALUE_OR_QUALIFICATION_RANK = 0;
        public static final int PROMOTION_RANK = 1;
        public static final int CONVERSION_RANK = 2;
        public static final int DERIVED_TO_BASE_CONVERSION = 3;
        public static final int USERDEFINED_CONVERSION_RANK = 4;
        public static final int ELLIPSIS_CONVERSION = 5;

        public Cost(TypeInfo typeInfo, TypeInfo typeInfo2) {
            this.source = typeInfo != null ? new TypeInfo(typeInfo) : new TypeInfo();
            this.target = typeInfo2 != null ? new TypeInfo(typeInfo2) : new TypeInfo();
        }

        public int compare(Cost cost) {
            int n = 0;
            if (this.rank != cost.rank) {
                return cost.rank - this.rank;
            }
            if (this.userDefined != 0 || cost.userDefined != 0) {
                if (this.userDefined == 0 || cost.userDefined == 0) {
                    return cost.userDefined - this.userDefined;
                }
                if (this.userDefined == 1 || cost.userDefined == 1 || this.userDefined != cost.userDefined) {
                    return 0;
                }
            }
            if (this.promotion > 0 || cost.promotion > 0) {
                n = cost.promotion - this.promotion;
            }
            if (this.conversion > 0 || cost.conversion > 0) {
                n = this.detail == cost.detail ? cost.conversion - this.conversion : cost.detail - this.detail;
            }
            if (n == 0) {
                if (cost.qualification != this.qualification) {
                    return cost.qualification - this.qualification;
                }
                if (cost.qualification == this.qualification && this.qualification == 0) {
                    return 0;
                }
                int n2 = cost.target.hasPtrOperators() ? cost.target.getPtrOperators().size() : 0;
                int n3 = this.target.hasPtrOperators() ? this.target.getPtrOperators().size() : 0;
                ListIterator listIterator = cost.target.getPtrOperators().listIterator(n2);
                ListIterator listIterator2 = this.target.getPtrOperators().listIterator(n3);
                TypeInfo.PtrOp ptrOp = null;
                TypeInfo.PtrOp ptrOp2 = null;
                int n4 = 0;
                int n5 = n2 < n3 ? n2 : n3;
                while (n5 > 0) {
                    ptrOp = (TypeInfo.PtrOp)listIterator.previous();
                    ptrOp2 = (TypeInfo.PtrOp)listIterator2.previous();
                    if (n4 == 0) {
                        n4 = ptrOp.compareCVTo(ptrOp2);
                    } else if (n4 > 0 && ptrOp.compareCVTo(ptrOp2) < 0 || n4 < 0 && ptrOp.compareCVTo(ptrOp2) > 0) {
                        n = -1;
                        break;
                    }
                    --n5;
                }
                n = n == -1 ? 0 : (n2 == n3 ? n4 : n2 - n3);
            }
            return n;
        }
    }
}

