/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.pst.DeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class TemplateSymbol
extends ParameterizedSymbol
implements ITemplateSymbol {
    private LinkedList _specializations;
    private HashMap _explicitSpecializations;
    private HashMap _defnParameterMap;
    private HashMap _instantiations;

    protected TemplateSymbol(ParserSymbolTable parserSymbolTable, String string) {
        super(parserSymbolTable, string, TypeInfo.t_template);
    }

    protected TemplateSymbol(ParserSymbolTable parserSymbolTable, String string, ISymbolASTExtension iSymbolASTExtension) {
        super(parserSymbolTable, string, iSymbolASTExtension);
    }

    public Object clone() {
        TemplateSymbol templateSymbol = (TemplateSymbol)super.clone();
        templateSymbol._defnParameterMap = this._defnParameterMap != null ? (HashMap)this._defnParameterMap.clone() : null;
        templateSymbol._instantiations = this._instantiations != null ? (HashMap)this._instantiations.clone() : null;
        return templateSymbol;
    }

    public IContainerSymbol getTemplatedSymbol() {
        Iterator iterator = this.getContentsIterator();
        if (iterator.hasNext()) {
            IContainerSymbol iContainerSymbol = (IContainerSymbol)iterator.next();
            return iContainerSymbol;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISymbol instantiate(List list) throws ParserSymbolTableException {
        Object object;
        List list2;
        ITemplateSymbol iTemplateSymbol;
        if (this.getType() != TypeInfo.t_template) {
            if (this.getType() != TypeInfo.t_templateParameter) return null;
            if (this.getTypeInfo().getTemplateParameterType() != TypeInfo.t_template) {
                return null;
            }
        }
        if ((iTemplateSymbol = TemplateEngine.matchTemplatePartialSpecialization(this, list)) != null && iTemplateSymbol instanceof ISpecializedSymbol) {
            return iTemplateSymbol.instantiate(list);
        }
        if (iTemplateSymbol == null) {
            iTemplateSymbol = this;
        }
        if ((list2 = iTemplateSymbol.getParameterList()) == null) return null;
        int n = list2.size();
        int n2 = n;
        if (n2 == 0) {
            return null;
        }
        HashMap<ISymbol, TypeInfo> hashMap = new HashMap<ISymbol, TypeInfo>();
        Iterator iterator = list2.iterator();
        Iterator iterator2 = list.iterator();
        ISymbol iSymbol = null;
        TypeInfo typeInfo = null;
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        ISymbol iSymbol2 = iTemplateSymbol.getTemplatedSymbol();
        while (iSymbol2 != null && iSymbol2.isTemplateInstance()) {
            iSymbol2 = iSymbol2.getInstantiatedSymbol();
        }
        int n3 = 0;
        while (n3 < n2) {
            iSymbol = (ISymbol)iterator.next();
            iSymbol = TemplateEngine.translateParameterForDefinition(iSymbol2, iSymbol, this.getDefinitionParameterMap());
            if (iterator2.hasNext()) {
                typeInfo = (TypeInfo)iterator2.next();
                if (typeInfo.isType(TypeInfo.t_type) && typeInfo.getTypeSymbol().isType(TypeInfo.t_templateParameter)) {
                    return this.deferredInstance(list);
                }
            } else {
                object = iSymbol.getTypeInfo().getDefault();
                if (object == null) throw new ParserSymbolTableException(8);
                if (!(object instanceof TypeInfo)) throw new ParserSymbolTableException(8);
                typeInfo = (TypeInfo)object;
                if (typeInfo.isType(TypeInfo.t_type) && typeInfo.getTypeSymbol().isType(TypeInfo.t_templateParameter)) {
                    if (!hashMap.containsKey(typeInfo.getTypeSymbol())) throw new ParserSymbolTableException(8);
                    typeInfo = (TypeInfo)hashMap.get(typeInfo.getTypeSymbol());
                }
            }
            if (!TemplateEngine.matchTemplateParameterAndArgument(iSymbol, typeInfo)) throw new ParserSymbolTableException(8);
            hashMap.put(iSymbol, typeInfo);
            linkedList.add(typeInfo);
            ++n3;
        }
        IContainerSymbol iContainerSymbol = this.findInstantiation(linkedList);
        if (iContainerSymbol != null) {
            return iContainerSymbol;
        }
        if (iTemplateSymbol.isType(TypeInfo.t_templateParameter)) {
            return this.deferredInstance(list);
        }
        object = iTemplateSymbol.getTemplatedSymbol();
        ISymbol iSymbol3 = TemplateEngine.checkForTemplateExplicitSpecialization(iTemplateSymbol, (ISymbol)object, linkedList);
        object = (IContainerSymbol)(iSymbol3 != null ? iSymbol3 : object);
        iContainerSymbol = (IContainerSymbol)object.instantiate(iTemplateSymbol, hashMap);
        this.addInstantiation(iContainerSymbol, linkedList);
        return iContainerSymbol;
    }

    public void addParameter(ISymbol iSymbol) {
        throw new ParserSymbolTableError(0);
    }

    public void addTemplateParameter(ISymbol iSymbol) throws ParserSymbolTableException {
        if (this.isType(TypeInfo.t_template)) {
            if (!this.isAllowableTemplateParameter(iSymbol)) {
                throw new ParserSymbolTableException(9);
            }
            this.modifyTemplateParameter(iSymbol);
        }
        super.addParameter(iSymbol);
    }

    private boolean isAllowableTemplateParameter(ISymbol iSymbol) {
        if (!iSymbol.isType(TypeInfo.t_templateParameter)) {
            return false;
        }
        if (iSymbol.getName().equals(this.getName())) {
            return false;
        }
        if (iSymbol.getTypeInfo().getTemplateParameterType() != TypeInfo.t_typeName && iSymbol.getTypeInfo().getTemplateParameterType() != TypeInfo.t_template) {
            if (iSymbol.isType(TypeInfo.t_bool, TypeInfo.t_int) || iSymbol.isType(TypeInfo.t_enumerator)) {
                return true;
            }
            if (iSymbol.isType(TypeInfo.t_float) || iSymbol.isType(TypeInfo.t_double) || iSymbol.isType(TypeInfo.t_class) || iSymbol.isType(TypeInfo.t_void)) {
                return false;
            }
        }
        return true;
    }

    private void modifyTemplateParameter(ISymbol iSymbol) {
        List list = iSymbol.getPtrOperators();
        if (list.size() > 0) {
            TypeInfo.PtrOp ptrOp = (TypeInfo.PtrOp)list.get(0);
            if (ptrOp.getType() == TypeInfo.PtrOp.t_array) {
                ptrOp.setType(TypeInfo.PtrOp.t_pointer);
            }
        } else if (iSymbol.isType(TypeInfo.t_type) && iSymbol.getTypeSymbol().isType(TypeInfo.t_function)) {
            iSymbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        }
    }

    public boolean hasSpecializations() {
        return this._specializations != null && !this._specializations.isEmpty();
    }

    public void addExplicitSpecialization(ISymbol iSymbol, List list) throws ParserSymbolTableException {
        List list2 = TemplateEngine.verifyExplicitArguments(this, list, iSymbol);
        Map map = this.getExplicitSpecializations();
        Map<ISymbol, ISymbol> map2 = null;
        if (map.containsKey(list2)) {
            map2 = (Map)map.get(list2);
        } else {
            map2 = new HashMap();
            map.put(new LinkedList(list2), map2);
        }
        ISymbol iSymbol2 = null;
        try {
            if (iSymbol.isType(TypeInfo.t_function) || iSymbol.isType(TypeInfo.t_constructor)) {
                LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
                Iterator iterator = ((IParameterizedSymbol)iSymbol).getParameterList().iterator();
                while (iterator.hasNext()) {
                    linkedList.add(((ISymbol)iterator.next()).getTypeInfo());
                }
                iSymbol2 = this.getTemplatedSymbol().lookupMethodForDefinition(iSymbol.getName(), linkedList);
            } else {
                iSymbol2 = this.getTemplatedSymbol().lookupMemberForDefinition(iSymbol.getName());
            }
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        if (iSymbol2 == null && this.getTemplatedSymbol().getName().equals(iSymbol.getName())) {
            iSymbol2 = this.getTemplatedSymbol();
        }
        if (iSymbol2 != null) {
            iSymbol.setIsTemplateMember(true);
            iSymbol.setContainingSymbol(iSymbol2.getContainingSymbol());
            map2.put(iSymbol2, iSymbol);
        }
    }

    public void addSpecialization(ISpecializedSymbol iSpecializedSymbol) {
        List list = this.getSpecializations();
        list.add(iSpecializedSymbol);
        iSpecializedSymbol.setContainingSymbol(this.getContainingSymbol());
        iSpecializedSymbol.setPrimaryTemplate(this);
    }

    public List getSpecializations() {
        if (this._specializations == null) {
            this._specializations = new LinkedList();
        }
        return this._specializations;
    }

    public void addInstantiation(IContainerSymbol iContainerSymbol, List list) {
        LinkedList linkedList = new LinkedList(list);
        if (this._instantiations == null) {
            this._instantiations = new HashMap();
        }
        this._instantiations.put(linkedList, iContainerSymbol);
    }

    public IContainerSymbol findInstantiation(List list) {
        if (this._instantiations == null) {
            return null;
        }
        Iterator iterator = this._instantiations.keySet().iterator();
        List list2 = null;
        while (iterator.hasNext()) {
            list2 = (List)iterator.next();
            if (!list2.equals(list)) continue;
            return (IContainerSymbol)this._instantiations.get(list2);
        }
        return null;
    }

    public List findArgumentsFor(IContainerSymbol iContainerSymbol) {
        if (iContainerSymbol == null || !iContainerSymbol.isTemplateInstance()) {
            return null;
        }
        ITemplateSymbol iTemplateSymbol = (ITemplateSymbol)iContainerSymbol.getInstantiatedSymbol().getContainingSymbol();
        if (iTemplateSymbol != this) {
            return null;
        }
        Iterator iterator = this._instantiations.keySet().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            if (this._instantiations.get(list) != iContainerSymbol) continue;
            return list;
        }
        return null;
    }

    public Map getDefinitionParameterMap() {
        if (this._defnParameterMap == null) {
            this._defnParameterMap = new HashMap();
        }
        return this._defnParameterMap;
    }

    public IDeferredTemplateInstance deferredInstance(List list) {
        return new DeferredTemplateInstance(this.getSymbolTable(), this, list);
    }

    public Map getExplicitSpecializations() {
        if (this._explicitSpecializations == null) {
            this._explicitSpecializations = new HashMap();
        }
        return this._explicitSpecializations;
    }
}

