/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.parser.Enum;
import org.eclipse.cdt.core.parser.ParserLanguage;

public class KeywordSets {
    private static final Set EMPTY = new HashSet();
    private static final Set NAMESPACE_ONLY = new HashSet();
    private static final Set MACRO_ONLY;
    private static final Set DECL_SPECIFIER_SEQUENCE_C;
    private static final Set DECL_SPECIFIER_SEQUENCE_CPP;
    private static final Hashtable DECL_SPECIFIER_SEQUENCE;
    private static final Set DECLARATION_CPP;
    private static final Set DECLARATION_C;
    private static final Hashtable DECLARATION;
    private static final Set STATEMENT_C;
    private static final Set STATEMENT_CPP;
    private static final Hashtable STATEMENT;
    private static final Set BASE_SPECIFIER_CPP;
    private static final Set POST_USING_CPP;
    private static final Set FUNCTION_MODIFIER_C;
    private static final Set FUNCTION_MODIFIER_CPP;
    private static final Hashtable FUNCTION_MODIFIER;
    private static final Set PP_DIRECTIVES;

    static {
        NAMESPACE_ONLY.add("namespace");
        MACRO_ONLY = new HashSet();
        MACRO_ONLY.add("defined()");
        DECL_SPECIFIER_SEQUENCE_C = new TreeSet();
        DECL_SPECIFIER_SEQUENCE_C.add("inline");
        DECL_SPECIFIER_SEQUENCE_C.add("auto");
        DECL_SPECIFIER_SEQUENCE_C.add("register");
        DECL_SPECIFIER_SEQUENCE_C.add("static");
        DECL_SPECIFIER_SEQUENCE_C.add("extern");
        DECL_SPECIFIER_SEQUENCE_C.add("mutable");
        DECL_SPECIFIER_SEQUENCE_C.add("typedef");
        DECL_SPECIFIER_SEQUENCE_C.add("const");
        DECL_SPECIFIER_SEQUENCE_C.add("volatile");
        DECL_SPECIFIER_SEQUENCE_C.add("signed");
        DECL_SPECIFIER_SEQUENCE_C.add("unsigned");
        DECL_SPECIFIER_SEQUENCE_C.add("short");
        DECL_SPECIFIER_SEQUENCE_C.add("long");
        DECL_SPECIFIER_SEQUENCE_C.add("_Complex");
        DECL_SPECIFIER_SEQUENCE_C.add("_Imaginary");
        DECL_SPECIFIER_SEQUENCE_C.add("char");
        DECL_SPECIFIER_SEQUENCE_C.add("wchar_t");
        DECL_SPECIFIER_SEQUENCE_C.add("_Bool");
        DECL_SPECIFIER_SEQUENCE_C.add("int");
        DECL_SPECIFIER_SEQUENCE_C.add("float");
        DECL_SPECIFIER_SEQUENCE_C.add("double");
        DECL_SPECIFIER_SEQUENCE_C.add("void");
        DECL_SPECIFIER_SEQUENCE_C.add("struct");
        DECL_SPECIFIER_SEQUENCE_C.add("union");
        DECL_SPECIFIER_SEQUENCE_C.add("enum");
        DECL_SPECIFIER_SEQUENCE_CPP = new TreeSet();
        DECL_SPECIFIER_SEQUENCE_CPP.addAll(DECL_SPECIFIER_SEQUENCE_C);
        DECL_SPECIFIER_SEQUENCE_CPP.remove("_Complex");
        DECL_SPECIFIER_SEQUENCE_CPP.remove("_Imaginary");
        DECL_SPECIFIER_SEQUENCE_CPP.remove("_Bool");
        DECL_SPECIFIER_SEQUENCE_CPP.add("virtual");
        DECL_SPECIFIER_SEQUENCE_CPP.add("mutable");
        DECL_SPECIFIER_SEQUENCE_CPP.add("explicit");
        DECL_SPECIFIER_SEQUENCE_CPP.add("friend");
        DECL_SPECIFIER_SEQUENCE_CPP.add("bool");
        DECL_SPECIFIER_SEQUENCE_CPP.add("typename");
        DECL_SPECIFIER_SEQUENCE_CPP.add("class");
        DECL_SPECIFIER_SEQUENCE = new Hashtable();
        DECL_SPECIFIER_SEQUENCE.put(ParserLanguage.CPP, DECL_SPECIFIER_SEQUENCE_CPP);
        DECL_SPECIFIER_SEQUENCE.put(ParserLanguage.C, DECL_SPECIFIER_SEQUENCE_C);
        DECLARATION_CPP = new TreeSet();
        DECLARATION_CPP.addAll(DECL_SPECIFIER_SEQUENCE_CPP);
        DECLARATION_CPP.add("asm");
        DECLARATION_C = new TreeSet();
        DECLARATION_C.addAll(DECL_SPECIFIER_SEQUENCE_C);
        DECLARATION_C.add("asm");
        DECLARATION = new Hashtable();
        DECLARATION.put(ParserLanguage.CPP, DECLARATION_CPP);
        DECLARATION.put(ParserLanguage.C, DECLARATION_C);
        STATEMENT_C = new TreeSet();
        STATEMENT_C.addAll(DECLARATION_C);
        STATEMENT_C.add("for");
        STATEMENT_CPP = new TreeSet(STATEMENT_C);
        STATEMENT_CPP.add("try");
        STATEMENT = new Hashtable();
        STATEMENT.put(ParserLanguage.CPP, STATEMENT_CPP);
        STATEMENT.put(ParserLanguage.C, STATEMENT_C);
        BASE_SPECIFIER_CPP = new TreeSet();
        BASE_SPECIFIER_CPP.add("public");
        BASE_SPECIFIER_CPP.add("protected");
        BASE_SPECIFIER_CPP.add("private");
        BASE_SPECIFIER_CPP.add("virtual");
        POST_USING_CPP = new TreeSet();
        POST_USING_CPP.add("namespace");
        POST_USING_CPP.add("typename");
        FUNCTION_MODIFIER_C = new TreeSet();
        FUNCTION_MODIFIER_CPP = new TreeSet(FUNCTION_MODIFIER_C);
        FUNCTION_MODIFIER_CPP.add("const");
        FUNCTION_MODIFIER_CPP.add("throw");
        FUNCTION_MODIFIER_CPP.add("try");
        FUNCTION_MODIFIER_CPP.add("volatile");
        FUNCTION_MODIFIER = new Hashtable();
        FUNCTION_MODIFIER.put(ParserLanguage.CPP, FUNCTION_MODIFIER_CPP);
        FUNCTION_MODIFIER.put(ParserLanguage.C, FUNCTION_MODIFIER_C);
        PP_DIRECTIVES = new TreeSet();
        PP_DIRECTIVES.add("#");
        PP_DIRECTIVES.add("#define");
        PP_DIRECTIVES.add("#undef");
        PP_DIRECTIVES.add("#if");
        PP_DIRECTIVES.add("#ifdef");
        PP_DIRECTIVES.add("#ifndef");
        PP_DIRECTIVES.add("#else");
        PP_DIRECTIVES.add("#endif");
        PP_DIRECTIVES.add("#include");
        PP_DIRECTIVES.add("#line");
        PP_DIRECTIVES.add("#error");
        PP_DIRECTIVES.add("#pragma");
        PP_DIRECTIVES.add("#elif");
    }

    public static Set getKeywords(Key key, ParserLanguage parserLanguage) {
        if (key == Key.EMPTY) {
            return EMPTY;
        }
        if (key == Key.DECL_SPECIFIER_SEQUENCE) {
            return (Set)DECL_SPECIFIER_SEQUENCE.get(parserLanguage);
        }
        if (key == Key.DECLARATION) {
            return (Set)DECLARATION.get(parserLanguage);
        }
        if (key == Key.STATEMENT) {
            return (Set)STATEMENT.get(parserLanguage);
        }
        if (key == Key.BASE_SPECIFIER) {
            return BASE_SPECIFIER_CPP;
        }
        if (key == Key.POST_USING) {
            return POST_USING_CPP;
        }
        if (key == Key.FUNCTION_MODIFIER) {
            return (Set)FUNCTION_MODIFIER.get(parserLanguage);
        }
        if (key == Key.NAMESPACE_ONLY) {
            return NAMESPACE_ONLY;
        }
        if (key == Key.MACRO) {
            return MACRO_ONLY;
        }
        if (key == Key.PP_DIRECTIVE) {
            return PP_DIRECTIVES;
        }
        return null;
    }

    public static class Key
    extends Enum {
        public static final Key EMPTY = new Key(0);
        public static final Key DECL_SPECIFIER_SEQUENCE = new Key(1);
        public static final Key DECLARATION = new Key(2);
        public static final Key STATEMENT = new Key(3);
        public static final Key BASE_SPECIFIER = new Key(4);
        public static final Key POST_USING = new Key(5);
        public static final Key FUNCTION_MODIFIER = new Key(6);
        public static final Key NAMESPACE_ONLY = new Key(6);
        public static final Key MACRO = new Key(7);
        public static final Key PP_DIRECTIVE = new Key(8);

        protected Key(int n) {
            super(n);
        }
    }
}

