/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;

public class Token
implements IToken {
    public int type;
    protected String image;
    public String filename;
    protected int offset;
    protected int macroOffset = -1;
    protected int macroLength = -1;
    private IToken next;
    private int lineNumber;

    public Token(int n, String string, IScannerContext iScannerContext, int n2) {
        this.type = n;
        this.image = string;
        this.filename = iScannerContext.getFilename();
        this.offset = iScannerContext.getOffset() - this.image.length() - iScannerContext.undoStackSize();
        this.lineNumber = n2;
        this.macroOffset = iScannerContext.getMacroOffset();
        this.macroLength = iScannerContext.getMacroLength();
        if (this.type == 131 || this.type == 130 || this.type == 132) {
            --this.offset;
        }
    }

    public Token(int n, String string) {
        this.type = n;
        this.image = string;
    }

    public String toString() {
        return "Token type=" + this.type + "  image =" + this.image + " offset=" + this.offset;
    }

    public int getType() {
        return this.type;
    }

    public String getImage() {
        return this.image;
    }

    public int getOffset() {
        return this.macroOffset < 0 ? this.offset : this.macroOffset;
    }

    public int getLength() {
        return this.macroLength < 0 ? this.image.length() : this.macroLength;
    }

    public int getEndOffset() {
        return this.getOffset() + this.getLength();
    }

    public int getDelta(IToken iToken) {
        return iToken.getOffset() + iToken.getLength() - this.getOffset();
    }

    public IToken getNext() {
        return this.next;
    }

    public void setNext(IToken iToken) {
        this.next = iToken;
    }

    public boolean looksLikeExpression() {
        switch (this.getType()) {
            case 2: 
            case 8: 
            case 16: 
            case 21: 
            case 23: 
            case 30: 
            case 34: 
            case 36: 
            case 50: 
            case 81: 
            case 114: 
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                return true;
            }
        }
        return false;
    }

    public boolean isPointer() {
        return this.getType() == 30 || this.getType() == 23;
    }

    public boolean isOperator() {
        switch (this.getType()) {
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 72: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    public void setImage(String string) {
        this.image = string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IToken)) {
            return false;
        }
        if (!((IToken)object).getImage().equals(this.image)) {
            return false;
        }
        return ((IToken)object).getType() == this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isKeywordOrOperator() {
        if (this.type == 132) {
            return false;
        }
        if (this.type == 129) {
            return false;
        }
        if (this.type == 1) {
            return false;
        }
        if (this.type == 2) {
            return false;
        }
        if (this.type == 130) {
            return false;
        }
        if (this.type == 131) {
            return false;
        }
        return this.type != 133;
    }
}

