/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchFilter;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class CApplicationLaunchShortcut
implements ILaunchShortcut,
ILaunchFilter {
    static /* synthetic */ Class class$0;

    public void launch(IEditorPart iEditorPart, String string) {
        this.searchAndLaunch(new Object[]{iEditorPart.getEditorInput()}, string);
    }

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string);
        }
    }

    public void launch(IBinary iBinary, String string) {
        try {
            ILaunchConfiguration iLaunchConfiguration = this.findLaunchConfiguration(iBinary, string);
            if (iLaunchConfiguration != null) {
                DebugUITools.saveAndBuildBeforeLaunch();
                iLaunchConfiguration.launch(string, null);
            }
        }
        catch (CoreException coreException) {
            LaunchUIPlugin.errorDialog("Launch failed", coreException.getStatus());
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IBinary iBinary, String string) {
        String string2;
        Object object;
        ICDebugConfiguration[] iCDebugConfigurationArray;
        ILaunchConfiguration iLaunchConfiguration = null;
        ILaunchConfigurationType iLaunchConfigurationType = this.getCLaunchConfigType();
        ArrayList<ICDebugConfiguration[]> arrayList = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            arrayList = new ArrayList<ICDebugConfiguration[]>(iLaunchConfigurationArray.length);
            int n = 0;
            while (n < iLaunchConfigurationArray.length) {
                iCDebugConfigurationArray = iLaunchConfigurationArray[n];
                object = AbstractCLaunchDelegate.getProgramName((ILaunchConfiguration)iCDebugConfigurationArray);
                string2 = AbstractCLaunchDelegate.getProjectName((ILaunchConfiguration)iCDebugConfigurationArray);
                String string3 = iBinary.getResource().getProjectRelativePath().toString();
                if (object != null && ((String)object).equals(string3) && string2 != null && string2.equals(iBinary.getCProject().getProject().getName())) {
                    arrayList.add(iCDebugConfigurationArray);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.log((Throwable)coreException);
        }
        int n = arrayList.size();
        if (n < 1) {
            ICDebugConfiguration iCDebugConfiguration = null;
            iCDebugConfigurationArray = CDebugCorePlugin.getDefault().getDebugConfigurations();
            object = new ArrayList(iCDebugConfigurationArray.length);
            string2 = BootLoader.getOS();
            int n2 = 0;
            while (n2 < iCDebugConfigurationArray.length) {
                String string4 = iCDebugConfigurationArray[n2].getPlatform();
                if (string4 == null || string4.equals("native") || string4.equals(string2)) {
                    object.add(iCDebugConfigurationArray[n2]);
                }
                ++n2;
            }
            iCDebugConfigurationArray = object.toArray(new ICDebugConfiguration[0]);
            if (iCDebugConfigurationArray.length == 1) {
                iCDebugConfiguration = iCDebugConfigurationArray[0];
            } else if (iCDebugConfigurationArray.length > 1) {
                iCDebugConfiguration = this.chooseDebugConfig(iCDebugConfigurationArray, string);
            }
            if (iCDebugConfiguration != null) {
                iLaunchConfiguration = this.createConfiguration(iBinary, iCDebugConfiguration);
            }
        } else {
            iLaunchConfiguration = n == 1 ? (ILaunchConfiguration)arrayList.get(0) : this.chooseConfiguration(arrayList, string);
        }
        return iLaunchConfiguration;
    }

    private ILaunchConfiguration createConfiguration(IBinary iBinary, ICDebugConfiguration iCDebugConfiguration) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            String string = iBinary.getResource().getProjectRelativePath().toString();
            ILaunchConfigurationType iLaunchConfigurationType = this.getCLaunchConfigType();
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iBinary.getElementName()));
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", string);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", iBinary.getCProject().getElementName());
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", iCDebugConfiguration.getID());
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.log((Throwable)coreException);
        }
        return iLaunchConfiguration;
    }

    protected ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.cdt.launch.localCLaunch");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return CDebugUIPlugin.getActiveWorkbenchShell();
    }

    private ICDebugConfiguration chooseDebugConfig(ICDebugConfiguration[] iCDebugConfigurationArray, String string) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object object) {
                if (object == null) {
                    return "";
                }
                if (object instanceof ICDebugConfiguration) {
                    return ((ICDebugConfiguration)object).getName();
                }
                return object.toString();
            }
        };
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        elementListSelectionDialog.setElements((Object[])iCDebugConfigurationArray);
        elementListSelectionDialog.setTitle(this.getDebugConfigDialogTitleString(iCDebugConfigurationArray, string));
        elementListSelectionDialog.setMessage(this.getDebugConfigDialogMessageString(iCDebugConfigurationArray, string));
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        labelProvider.dispose();
        if (n == 0) {
            return (ICDebugConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected String getDebugConfigDialogTitleString(ICDebugConfiguration[] iCDebugConfigurationArray, String string) {
        return "Launch Debug Configuration Selection";
    }

    protected String getDebugConfigDialogMessageString(ICDebugConfiguration[] iCDebugConfigurationArray, String string) {
        if (string.equals("debug")) {
            return "Choose a debug configuration to debug";
        }
        return "Choose a configuration to run";
    }

    protected ILaunchConfiguration chooseConfiguration(List list, String string) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle(this.getLaunchSelectionDialogTitleString(list, string));
        elementListSelectionDialog.setMessage(this.getLaunchSelectionDialogMessageString(list, string));
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected String getLaunchSelectionDialogTitleString(List list, String string) {
        return "Launch Configuration Selection";
    }

    protected String getLaunchSelectionDialogMessageString(List list, String string) {
        if (string.equals("debug")) {
            return "Choose a launch configuration to debug";
        }
        return "Choose a launch configuration to run";
    }

    protected IBinary chooseBinary(List list, String string) {
        CElementLabelProvider cElementLabelProvider = new CElementLabelProvider(){

            public String getText(Object object) {
                if (object instanceof IBinary) {
                    IBinary iBinary = (IBinary)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(iBinary.getPath().lastSegment());
                    return stringBuffer.toString();
                }
                return super.getText(object);
            }
        };
        CElementLabelProvider cElementLabelProvider2 = new CElementLabelProvider(){

            public String getText(Object object) {
                if (object instanceof IBinary) {
                    IBinary iBinary = (IBinary)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(String.valueOf(iBinary.getCPU()) + (iBinary.isLittleEndian() ? "le" : "be"));
                    stringBuffer.append(" - ");
                    stringBuffer.append(iBinary.getPath().toString());
                    return stringBuffer.toString();
                }
                return super.getText(object);
            }
        };
        TwoPaneElementSelector twoPaneElementSelector = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)cElementLabelProvider, (ILabelProvider)cElementLabelProvider2);
        twoPaneElementSelector.setElements(list.toArray());
        twoPaneElementSelector.setTitle(this.getBinarySelectionDialogTitleString(list, string));
        twoPaneElementSelector.setMessage(this.getBinarySelectionDialogMessageString(list, string));
        twoPaneElementSelector.setUpperListLabel("Binaries:");
        twoPaneElementSelector.setLowerListLabel("Qualifier:");
        twoPaneElementSelector.setMultipleSelection(false);
        if (twoPaneElementSelector.open() == 0) {
            return (IBinary)twoPaneElementSelector.getFirstResult();
        }
        return null;
    }

    protected String getBinarySelectionDialogTitleString(List list, String string) {
        return "C Local Application";
    }

    protected String getBinarySelectionDialogMessageString(List list, String string) {
        if (string.equals("debug")) {
            return "Choose a local application to debug";
        }
        return "Choose a local application to run";
    }

    private void searchAndLaunch(final Object[] objectArray, String string) {
        if (objectArray != null && objectArray.length > 0) {
            IBinary iBinary = null;
            if (objectArray.length == 1 && objectArray[0] instanceof IBinary) {
                iBinary = (IBinary)objectArray[0];
            } else {
                final ArrayList arrayList = new ArrayList();
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
                IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                        int n = objectArray.length;
                        iProgressMonitor.beginTask("Looking for executables", n);
                        try {
                            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                            int n2 = 0;
                            while (n2 < n) {
                                if (objectArray[n2] instanceof IAdaptable) {
                                    ICProject iCProject;
                                    IResource iResource;
                                    IAdaptable iAdaptable = (IAdaptable)objectArray[n2];
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && (iCProject = CoreModel.getDefault().create(iResource.getProject())) != null) {
                                        IBinary[] iBinaryArray = iCProject.getBinaryContainer().getBinaries();
                                        int n3 = 0;
                                        while (n3 < iBinaryArray.length) {
                                            if (iBinaryArray[n3].isExecutable()) {
                                                arrayList.add(iBinaryArray[n3]);
                                            }
                                            ++n3;
                                        }
                                    }
                                }
                                if (iProgressMonitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                subProgressMonitor.done();
                                ++n2;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            iProgressMonitor.done();
                            throw throwable;
                        }
                        {
                            Object var9_11 = null;
                        }
                        iProgressMonitor.done();
                    }
                };
                try {
                    progressMonitorDialog.run(true, true, iRunnableWithProgress);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Application Launcher", (String)invocationTargetException.getMessage());
                    return;
                }
                int n = arrayList.size();
                if (n == 0) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Application Launcher", (String)"Launch failed no binaries");
                } else {
                    iBinary = n > 1 ? this.chooseBinary(arrayList, string) : (IBinary)arrayList.get(0);
                }
            }
            if (iBinary != null) {
                this.launch(iBinary, string);
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Application Launcher", (String)"Launch failed no project selected");
        }
    }

    public boolean testAttribute(IResource iResource, String string, String string2) {
        if ("ContextualLaunchActionFilter".equals(string)) {
            return this.isExecutable(iResource);
        }
        return false;
    }

    private boolean isExecutable(IResource iResource) {
        ICElement iCElement = null;
        if (iResource instanceof IFile) {
            iCElement = CoreModel.getDefault().create(iResource);
        }
        return iCElement != null && iCElement instanceof IBinary;
    }
}

