/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ProcessClosure {
    protected static int fCounter = 0;
    protected Process fProcess;
    protected OutputStream fOutput;
    protected OutputStream fError;
    protected ReaderThread fOutputReader;
    protected ReaderThread fErrorReader;

    public ProcessClosure(Process process, OutputStream outputStream, OutputStream outputStream2) {
        this.fProcess = process;
        this.fOutput = outputStream;
        this.fError = outputStream2;
    }

    public void runNonBlocking() {
        ThreadGroup threadGroup = new ThreadGroup("CBuilder" + fCounter++);
        InputStream inputStream = this.fProcess.getInputStream();
        InputStream inputStream2 = this.fProcess.getErrorStream();
        this.fOutputReader = new ReaderThread(threadGroup, "OutputReader", inputStream, this.fOutput);
        this.fErrorReader = new ReaderThread(threadGroup, "ErrorReader", inputStream2, this.fError);
        this.fOutputReader.start();
        this.fErrorReader.start();
    }

    public void runBlocking() {
        this.runNonBlocking();
        boolean bl = false;
        while (!bl) {
            try {
                this.fProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            try {
                this.fProcess.exitValue();
                bl = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
        if (!this.fOutputReader.finished()) {
            this.fOutputReader.waitFor();
        }
        if (!this.fErrorReader.finished()) {
            this.fErrorReader.waitFor();
        }
        this.fProcess = null;
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    public boolean isAlive() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() || this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
            this.fOutputReader = null;
            this.fErrorReader = null;
        }
        return false;
    }

    public void terminate() {
        if (this.fProcess != null) {
            this.fProcess.destroy();
            this.fProcess = null;
        }
    }

    protected static class ReaderThread
    extends Thread {
        private InputStream fInputStream;
        private OutputStream fOutputStream;
        private boolean fFinished = false;
        private String lineSeparator;

        public ReaderThread(ThreadGroup threadGroup, String string, InputStream inputStream, OutputStream outputStream) {
            super(threadGroup, string);
            this.fOutputStream = outputStream;
            this.fInputStream = inputStream;
            this.setDaemon(true);
            this.lineSeparator = System.getProperty("line.separator");
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.fInputStream));
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.fOutputStream));
                    while ((string = bufferedReader.readLine()) != null) {
                        string = String.valueOf(string) + this.lineSeparator;
                        char[] cArray = string.toCharArray();
                        bufferedWriter.write(cArray, 0, cArray.length);
                        bufferedWriter.flush();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    this.fInputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    this.fOutputStream.close();
                }
                catch (IOException iOException) {}
                this.complete();
                throw throwable;
            }
            {
                Object var5_7 = null;
            }
            try {}
            catch (IOException iOException) {}
            this.fInputStream.close();
            try {}
            catch (IOException iOException) {}
            this.fOutputStream.close();
            this.complete();
        }

        public synchronized boolean finished() {
            return this.fFinished;
        }

        public synchronized void waitFor() {
            while (!this.fFinished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void complete() {
            this.fFinished = true;
            this.notify();
        }
    }
}

