/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.FunctionInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.Util;

public class FunctionDeclaration
extends SourceManipulation
implements IFunctionDeclaration {
    protected static final String[] fgEmptyList = new String[0];
    protected String[] fParameterTypes = fgEmptyList;
    protected String returnType;

    public FunctionDeclaration(ICElement iCElement, String string) {
        super(iCElement, string, 70);
    }

    public FunctionDeclaration(ICElement iCElement, String string, int n) {
        super(iCElement, string, n);
    }

    public String getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        return "";
    }

    public void setReturnType(String string) {
        this.returnType = string;
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public void setParameterTypes(String[] stringArray) {
        this.fParameterTypes = stringArray;
    }

    public String getSignature() {
        StringBuffer stringBuffer = new StringBuffer(this.getElementName());
        stringBuffer.append(this.getParameterClause());
        if (this.isConst()) {
            stringBuffer.append(" const");
        }
        if (this.isVolatile()) {
            stringBuffer.append(" volatile");
        }
        return stringBuffer.toString();
    }

    public String getParameterClause() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getNumberOfParameters() > 0) {
            stringBuffer.append("(");
            String[] stringArray = this.getParameterTypes();
            int n = 0;
            stringBuffer.append(stringArray[n++]);
            while (n < stringArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(stringArray[n++]);
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append("()");
        }
        return stringBuffer.toString();
    }

    public String getParameterInitializer(int n) {
        return "";
    }

    public String[] getExceptions() {
        return new String[0];
    }

    protected CElementInfo createElementInfo() {
        return new FunctionInfo(this);
    }

    protected FunctionInfo getFunctionInfo() {
        return (FunctionInfo)this.getElementInfo();
    }

    public boolean equals(Object object) {
        return super.equals(object) && Util.equalArraysOrNull(this.fParameterTypes, ((FunctionDeclaration)object).fParameterTypes) && this.getReturnType().equals(((FunctionDeclaration)object).getReturnType());
    }

    public boolean isConst() {
        return this.getFunctionInfo().isConst();
    }

    public void setConst(boolean bl) {
        this.getFunctionInfo().setConst(bl);
    }

    public boolean isStatic() {
        return this.getFunctionInfo().isStatic();
    }

    public boolean isVolatile() {
        return this.getFunctionInfo().isVolatile();
    }

    public void setStatic(boolean bl) {
        this.getFunctionInfo().setStatic(bl);
    }

    public void setVolatile(boolean bl) {
        this.getFunctionInfo().setVolatile(bl);
    }
}

