/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.Index;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.search.CWorkspaceScope;
import org.eclipse.cdt.internal.core.search.IndexSelector;
import org.eclipse.cdt.internal.core.search.SimpleLookupTable;
import org.eclipse.cdt.internal.core.search.indexing.AddCompilationUnitToIndex;
import org.eclipse.cdt.internal.core.search.indexing.AddFolderToIndex;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.IndexAllProject;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.indexing.RemoveFolderFromIndex;
import org.eclipse.cdt.internal.core.search.indexing.RemoveFromIndex;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.cdt.internal.core.sourcedependency.UpdateDependency;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class IndexManager
extends JobManager
implements IIndexConstants {
    public static int MAX_FILES_IN_MEMORY = 0;
    public IWorkspace workspace;
    public SimpleLookupTable indexNames = new SimpleLookupTable();
    private Map indexes = new HashMap(5);
    private Map monitors = new HashMap(5);
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath cCorePluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = new File(this.getCCorePluginWorkingLocation().append("savedIndexNames.txt").toOSString());
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);
    public static boolean VERBOSE = false;

    public synchronized void aboutToUpdateIndex(IPath iPath, Integer n) {
        Integer n2;
        String string = this.computeIndexName(iPath);
        Object object = this.getIndexStates().get(string);
        Integer n3 = n2 = object == null ? UNKNOWN_STATE : (Integer)object;
        if (n2.equals(REBUILDING_STATE)) {
            return;
        }
        int n4 = n.compareTo(n2);
        if (n4 > 0) {
            this.updateIndexState(string, n);
        } else if (n4 < 0 && this.indexes.get(iPath) == null) {
            this.rebuildIndex(string, iPath);
        }
    }

    public void addSource(IFile iFile, IPath iPath) {
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        AddCompilationUnitToIndex addCompilationUnitToIndex = new AddCompilationUnitToIndex(iFile, iPath, this);
        if (this.awaitingJobsCount() < MAX_FILES_IN_MEMORY && !addCompilationUnitToIndex.initializeContents()) {
            return;
        }
        this.request(addCompilationUnitToIndex);
    }

    public void updateDependencies(IResource iResource) {
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        UpdateDependency updateDependency = new UpdateDependency(iResource);
        this.request(updateDependency);
    }

    String computeIndexName(IPath iPath) {
        String string = (String)this.indexNames.get(iPath);
        if (string == null) {
            String string2 = iPath.toOSString();
            checksumCalculator.reset();
            checksumCalculator.update(string2.getBytes());
            String string3 = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            if (VERBOSE) {
                JobManager.verbose("-> index name for " + string2 + " is " + string3);
            }
            string = this.getCCorePluginWorkingLocation().append(string3).toOSString();
            this.indexNames.put(iPath, string);
        }
        return string;
    }

    public synchronized IIndex getIndex(IPath iPath, boolean bl, boolean bl2) {
        IIndex iIndex = (IIndex)this.indexes.get(iPath);
        if (iIndex == null) {
            Integer n;
            String string = this.computeIndexName(iPath);
            Object object = this.getIndexStates().get(string);
            Integer n2 = n = object == null ? UNKNOWN_STATE : (Integer)object;
            if (n == UNKNOWN_STATE) {
                this.rebuildIndex(string, iPath);
                return null;
            }
            if (bl) {
                File file = new File(string);
                if (file.exists()) {
                    try {
                        iIndex = new Index(string, "Index for " + iPath.toOSString(), true);
                        this.indexes.put(iPath, iIndex);
                        this.monitors.put(iIndex, new ReadWriteMonitor());
                        return iIndex;
                    }
                    catch (IOException iOException) {
                        if (n != REBUILDING_STATE) {
                            if (VERBOSE) {
                                JobManager.verbose("-> cannot reuse existing index: " + string + " path: " + iPath.toOSString());
                            }
                            this.rebuildIndex(string, iPath);
                            return null;
                        }
                        iIndex = null;
                    }
                }
                if (n == SAVED_STATE) {
                    this.rebuildIndex(string, iPath);
                    return null;
                }
            }
            if (bl2) {
                try {
                    if (VERBOSE) {
                        JobManager.verbose("-> create empty index: " + string + " path: " + iPath.toOSString());
                    }
                    iIndex = new Index(string, "Index for " + iPath.toOSString(), false);
                    this.indexes.put(iPath, iIndex);
                    this.monitors.put(iIndex, new ReadWriteMonitor());
                    return iIndex;
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        JobManager.verbose("-> unable to create empty index: " + string + " path: " + iPath.toOSString());
                    }
                    return null;
                }
            }
        }
        return iIndex;
    }

    private SimpleLookupTable getIndexStates() {
        if (this.indexStates != null) {
            return this.indexStates;
        }
        this.indexStates = new SimpleLookupTable();
        char[] cArray = this.readIndexState();
        if (cArray.length > 0) {
            char[][] cArray2 = CharOperation.splitOn('\n', cArray);
            int n = 0;
            int n2 = cArray2.length;
            while (n < n2) {
                char[] cArray3 = cArray2[n];
                if (cArray3.length > 0) {
                    this.indexStates.put(new String(cArray3), SAVED_STATE);
                }
                ++n;
            }
        }
        return this.indexStates;
    }

    private IPath getCCorePluginWorkingLocation() {
        if (this.cCorePluginLocation != null) {
            return this.cCorePluginLocation;
        }
        this.cCorePluginLocation = CCorePlugin.getDefault().getStateLocation();
        return this.cCorePluginLocation;
    }

    public ReadWriteMonitor getMonitorFor(IIndex iIndex) {
        return (ReadWriteMonitor)this.monitors.get(iIndex);
    }

    public void indexAll(IProject iProject) {
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        IndexAllProject indexAllProject = new IndexAllProject(iProject, this);
        int n = this.jobEnd;
        while (n > this.jobStart) {
            if (((Object)indexAllProject).equals(this.awaitingJobs[n])) {
                return;
            }
            --n;
        }
        this.request(indexAllProject);
    }

    public void indexSourceFolder(CProject cProject, IPath iPath, char[][] cArray) {
        IProject iProject = cProject.getProject();
        if (this.jobEnd > this.jobStart) {
            IndexAllProject indexAllProject = new IndexAllProject(iProject, this);
            int n = this.jobEnd;
            while (n > this.jobStart) {
                if (((Object)indexAllProject).equals(this.awaitingJobs[n])) {
                    return;
                }
                --n;
            }
        }
        this.request(new AddFolderToIndex(iPath, iProject, cArray, this));
    }

    public void jobWasCancelled(IPath iPath) {
        Object v = this.indexes.get(iPath);
        if (v instanceof IIndex) {
            this.monitors.remove(v);
            this.indexes.remove(iPath);
        }
        this.updateIndexState(this.computeIndexName(iPath), UNKNOWN_STATE);
    }

    protected synchronized void moveToNextJob() {
        this.needToSave = true;
        super.moveToNextJob();
    }

    protected void notifyIdle(long l) {
        if (l > 1000L && this.needToSave) {
            this.saveIndexes();
        }
    }

    public IIndex peekAtIndex(IPath iPath) {
        return (IIndex)this.indexes.get(iPath);
    }

    public String processName() {
        return Util.bind("process.name");
    }

    private void rebuildIndex(String string, IPath iPath) {
        Object object = Util.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), iPath, true);
        if (object == null) {
            return;
        }
        if (VERBOSE) {
            JobManager.verbose("-> request to rebuild index: " + string + " path: " + iPath.toOSString());
        }
        this.updateIndexState(string, REBUILDING_STATE);
        IndexAllProject indexAllProject = null;
        if (object instanceof IProject) {
            IProject iProject = (IProject)object;
            indexAllProject = new IndexAllProject(iProject, this);
        }
        if (indexAllProject != null) {
            this.request(indexAllProject);
        }
    }

    public synchronized IIndex recreateIndex(IPath iPath) {
        try {
            IIndex iIndex = (IIndex)this.indexes.get(iPath);
            ReadWriteMonitor readWriteMonitor = (ReadWriteMonitor)this.monitors.remove(iIndex);
            String string = this.computeIndexName(iPath);
            if (VERBOSE) {
                JobManager.verbose("-> recreating index: " + string + " for path: " + iPath.toOSString());
            }
            iIndex = new Index(string, "Index for " + iPath.toOSString(), false);
            this.indexes.put(iPath, iIndex);
            this.monitors.put(iIndex, readWriteMonitor);
            return iIndex;
        }
        catch (IOException iOException) {
            if (VERBOSE) {
                JobManager.verbose("-> failed to recreate index for path: " + iPath.toOSString());
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public void remove(String string, IPath iPath) {
        this.request(new RemoveFromIndex(string, iPath, this));
    }

    public synchronized void removeIndex(IPath iPath) {
        Object v;
        String string;
        File file;
        if (VERBOSE) {
            JobManager.verbose("removing index " + iPath);
        }
        if ((file = new File(string = this.computeIndexName(iPath))).exists()) {
            file.delete();
        }
        if ((v = this.indexes.get(iPath)) instanceof IIndex) {
            this.monitors.remove(v);
        }
        this.indexes.remove(iPath);
        this.updateIndexState(string, null);
    }

    public synchronized void removeIndexFamily(IPath iPath) {
        ArrayList<IPath> arrayList = null;
        Iterator iterator = this.indexes.keySet().iterator();
        while (iterator.hasNext()) {
            IPath iPath2 = (IPath)iterator.next();
            if (!iPath.isPrefixOf(iPath2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<IPath>();
            }
            arrayList.add(iPath2);
        }
        if (arrayList != null) {
            int n = 0;
            int n2 = arrayList.size();
            while (n < n2) {
                this.removeIndex((IPath)arrayList.get(n));
                ++n;
            }
        }
    }

    public void removeSourceFolderFromIndex(CProject cProject, IPath iPath, char[][] cArray) {
        IProject iProject = cProject.getProject();
        if (this.jobEnd > this.jobStart) {
            IndexAllProject indexAllProject = new IndexAllProject(iProject, this);
            int n = this.jobEnd;
            while (n > this.jobStart) {
                if (((Object)indexAllProject).equals(this.awaitingJobs[n])) {
                    return;
                }
                --n;
            }
        }
        this.request(new RemoveFolderFromIndex(iPath, cArray, iProject, this));
    }

    public void reset() {
        super.reset();
        if (this.indexes != null) {
            this.indexes = new HashMap(5);
            this.monitors = new HashMap(5);
            this.indexStates = null;
        }
        this.indexNames = new SimpleLookupTable();
        this.cCorePluginLocation = null;
    }

    public void saveIndex(IIndex iIndex) throws IOException {
        Object object;
        if (iIndex.hasChanged()) {
            if (VERBOSE) {
                JobManager.verbose("-> saving index " + iIndex.getIndexFile());
            }
            iIndex.save();
        }
        String string = iIndex.getIndexFile().getPath();
        if (this.jobEnd > this.jobStart && (object = this.indexNames.keyForValue(string)) != null) {
            int n = this.jobEnd;
            while (n > this.jobStart) {
                IJob iJob = this.awaitingJobs[n];
                if (iJob instanceof IndexRequest && ((IndexRequest)iJob).indexPath.equals(object)) {
                    return;
                }
                --n;
            }
        }
        this.updateIndexState(string, SAVED_STATE);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveIndexes() {
        Object object;
        ArrayList arrayList = new ArrayList();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Iterator iterator = this.indexes.values().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof IIndex)) continue;
                arrayList.add(object);
            }
        }
        int n = 0;
        int n2 = arrayList.size();
        while (true) {
            if (n >= n2) {
                this.needToSave = false;
                return;
            }
            object = (IIndex)arrayList.get(n);
            ReadWriteMonitor readWriteMonitor = this.getMonitorFor((IIndex)object);
            if (readWriteMonitor != null) {
                Object var7_9;
                try {
                    readWriteMonitor.enterWrite();
                    try {
                        this.saveIndex((IIndex)object);
                    }
                    catch (IOException iOException) {
                        if (VERBOSE) {
                            JobManager.verbose("-> got the following exception while saving:");
                            iOException.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    var7_9 = null;
                    readWriteMonitor.exitWrite();
                    throw throwable;
                }
                {
                    var7_9 = null;
                    readWriteMonitor.exitWrite();
                }
            }
            ++n;
        }
    }

    public void shutdown() {
        File[] fileArray;
        File file;
        if (VERBOSE) {
            JobManager.verbose("Shutdown");
        }
        IndexSelector indexSelector = new IndexSelector(new CWorkspaceScope(), null, false, this);
        IIndex[] iIndexArray = indexSelector.getIndexes();
        SimpleLookupTable simpleLookupTable = new SimpleLookupTable();
        int n = 0;
        int n2 = iIndexArray.length;
        while (n < n2) {
            String string = iIndexArray[n].getIndexFile().getAbsolutePath();
            simpleLookupTable.put(string, string);
            ++n;
        }
        if (this.indexStates != null) {
            Object[] objectArray = this.indexStates.keyTable;
            n2 = 0;
            int n3 = objectArray.length;
            while (n2 < n3) {
                String string = (String)objectArray[n2];
                if (string != null && !simpleLookupTable.containsKey(string)) {
                    this.updateIndexState(string, null);
                }
                ++n2;
            }
        }
        if ((file = new File(this.getCCorePluginWorkingLocation().toOSString())).isDirectory() && (fileArray = file.listFiles()) != null) {
            int n4 = 0;
            int n5 = fileArray.length;
            while (n4 < n5) {
                String string = fileArray[n4].getAbsolutePath();
                if (!simpleLookupTable.containsKey(string) && string.toLowerCase().endsWith(".index")) {
                    if (VERBOSE) {
                        JobManager.verbose("Deleting index file " + fileArray[n4]);
                    }
                    fileArray[n4].delete();
                }
                ++n4;
            }
        }
        super.shutdown();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(super.toString());
        stringBuffer.append("In-memory indexes:\n");
        int n = 0;
        Iterator iterator = this.indexes.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(++n).append(" - ").append(iterator.next().toString()).append('\n');
        }
        return stringBuffer.toString();
    }

    private char[] readIndexState() {
        try {
            return Util.getFileCharContent(this.savedIndexNamesFile, null);
        }
        catch (IOException iOException) {
            if (VERBOSE) {
                JobManager.verbose("Failed to read saved index file names");
            }
            return new char[0];
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateIndexState(String string, Integer n) {
        Object object;
        block22: {
            this.getIndexStates();
            if (n != null) {
                if (n.equals(this.indexStates.get(string))) {
                    return;
                }
                this.indexStates.put(string, n);
            } else {
                if (!this.indexStates.containsKey(string)) {
                    return;
                }
                this.indexStates.removeKey(string);
            }
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(this.savedIndexNamesFile));
                    object = this.indexStates.keyTable;
                    Object[] objectArray = this.indexStates.valueTable;
                    int n2 = 0;
                    int n3 = objectArray.length;
                    while (n2 < n3) {
                        if (objectArray[n2] == SAVED_STATE) {
                            bufferedWriter.write((String)object[n2]);
                            bufferedWriter.write(10);
                        }
                        ++n2;
                    }
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        JobManager.verbose("Failed to write saved index file names");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (bufferedWriter == null) throw throwable;
                try {
                    bufferedWriter.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (bufferedWriter == null) break block22;
            }
            try {}
            catch (IOException iOException) {}
            bufferedWriter.close();
        }
        if (!VERBOSE) return;
        object = "?";
        if (n == SAVED_STATE) {
            object = "SAVED";
        } else if (n == UPDATING_STATE) {
            object = "UPDATING";
        } else if (n == UNKNOWN_STATE) {
            object = "UNKNOWN";
        } else if (n == REBUILDING_STATE) {
            object = "REBUILDING";
        }
        JobManager.verbose("-> index state updated to: " + (String)object + " for: " + string);
    }
}

