/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.Reader;
import java.util.LinkedList;
import org.eclipse.cdt.core.parser.DefaultProblemHandler;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.SourceIndexer;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    SourceIndexer indexer;
    IDocument document;
    char[] packageName;
    char[][] enclosingTypeNames = new char[5][];
    int depth = 0;
    int methodDepth = 0;
    private IASTInclusion currentInclude = null;
    private LinkedList includeStack = new LinkedList();

    public SourceIndexerRequestor(SourceIndexer sourceIndexer, IDocument iDocument) {
        this.indexer = sourceIndexer;
        this.document = iDocument;
    }

    public boolean acceptProblem(IProblem iProblem) {
        return DefaultProblemHandler.ruleOnProblem((IProblem)iProblem, (ParserMode)ParserMode.COMPLETE_PARSE);
    }

    public void acceptMacro(IASTMacro iASTMacro) {
        this.indexer.addMacro(iASTMacro);
    }

    public void acceptVariable(IASTVariable iASTVariable) {
        this.indexer.addVariable(iASTVariable);
    }

    public void acceptFunctionDeclaration(IASTFunction iASTFunction) {
        this.indexer.addFunctionDeclaration(iASTFunction);
    }

    public void acceptUsingDirective(IASTUsingDirective iASTUsingDirective) {
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration iASTUsingDeclaration) {
    }

    public void acceptASMDefinition(IASTASMDefinition iASTASMDefinition) {
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration iASTTypedefDeclaration) {
        this.indexer.addTypedefDeclaration(iASTTypedefDeclaration);
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        this.indexer.addEnumerationSpecifier(iASTEnumerationSpecifier);
    }

    public void enterFunctionBody(IASTFunction iASTFunction) {
        this.indexer.addFunctionDeclaration(iASTFunction);
    }

    public void exitFunctionBody(IASTFunction iASTFunction) {
    }

    public void enterCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
    }

    public void enterInclusion(IASTInclusion iASTInclusion) {
        IASTInclusion iASTInclusion2 = this.peekInclude();
        this.indexer.addInclude(iASTInclusion, iASTInclusion2);
        this.pushInclude(iASTInclusion);
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.indexer.addNamespaceDefinition(iASTNamespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        this.indexer.addClassSpecifier(iASTClassSpecifier);
    }

    public void enterLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
    }

    public void acceptMethodDeclaration(IASTMethod iASTMethod) {
        this.indexer.addMethodDeclaration(iASTMethod);
    }

    public void enterMethodBody(IASTMethod iASTMethod) {
        this.indexer.addMethodDeclaration(iASTMethod);
    }

    public void exitMethodBody(IASTMethod iASTMethod) {
    }

    public void acceptField(IASTField iASTField) {
        this.indexer.addFieldDeclaration(iASTField);
    }

    public void acceptClassReference(IASTClassReference iASTClassReference) {
        if (iASTClassReference.getReferencedElement() instanceof IASTClassSpecifier) {
            this.indexer.addClassReference((IASTTypeSpecifier)((IASTClassSpecifier)iASTClassReference.getReferencedElement()));
        } else if (iASTClassReference.getReferencedElement() instanceof IASTElaboratedTypeSpecifier) {
            this.indexer.addClassReference((IASTTypeSpecifier)iASTClassReference.getReferencedElement());
        }
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
    }

    public void exitLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
    }

    public void exitClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
    }

    public void exitInclusion(IASTInclusion iASTInclusion) {
        this.popInclude();
    }

    public void exitCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration) {
    }

    public void acceptTypedefReference(IASTTypedefReference iASTTypedefReference) {
        if (iASTTypedefReference.getReferencedElement() instanceof IASTTypedefDeclaration) {
            this.indexer.addTypedefReference((IASTTypedefDeclaration)iASTTypedefReference.getReferencedElement());
        }
    }

    public void acceptNamespaceReference(IASTNamespaceReference iASTNamespaceReference) {
        if (iASTNamespaceReference.getReferencedElement() instanceof IASTNamespaceDefinition) {
            this.indexer.addNamespaceReference((IASTNamespaceDefinition)iASTNamespaceReference.getReferencedElement());
        }
    }

    public void acceptEnumerationReference(IASTEnumerationReference iASTEnumerationReference) {
        if (iASTEnumerationReference.getReferencedElement() instanceof IASTEnumerationSpecifier) {
            this.indexer.addEnumerationReference((IASTEnumerationSpecifier)iASTEnumerationReference.getReferencedElement());
        }
    }

    public void acceptVariableReference(IASTVariableReference iASTVariableReference) {
        if (iASTVariableReference.getReferencedElement() instanceof IASTVariable) {
            this.indexer.addVariableReference((IASTVariable)iASTVariableReference.getReferencedElement());
        }
    }

    public void acceptFunctionReference(IASTFunctionReference iASTFunctionReference) {
        if (iASTFunctionReference.getReferencedElement() instanceof IASTFunction) {
            this.indexer.addFunctionReference((IASTFunction)iASTFunctionReference.getReferencedElement());
        }
    }

    public void acceptFieldReference(IASTFieldReference iASTFieldReference) {
        if (iASTFieldReference.getReferencedElement() instanceof IASTField) {
            this.indexer.addFieldReference((IASTField)iASTFieldReference.getReferencedElement());
        }
    }

    public void acceptMethodReference(IASTMethodReference iASTMethodReference) {
        if (iASTMethodReference.getReferencedElement() instanceof IASTMethod) {
            this.indexer.addMethodReference((IASTMethod)iASTMethodReference.getReferencedElement());
        }
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
        this.indexer.addElaboratedForwardDeclaration(iASTElaboratedTypeSpecifier);
    }

    public void enterCodeBlock(IASTCodeScope iASTCodeScope) {
    }

    public void exitCodeBlock(IASTCodeScope iASTCodeScope) {
    }

    public void acceptEnumeratorReference(IASTEnumeratorReference iASTEnumeratorReference) {
        if (iASTEnumeratorReference.getReferencedElement() instanceof IASTEnumerator) {
            this.indexer.addEnumeratorReference((IASTEnumerator)iASTEnumeratorReference.getReferencedElement());
        }
    }

    public void acceptParameterReference(IASTParameterReference iASTParameterReference) {
        if (iASTParameterReference.getReferencedElement() instanceof IASTParameterDeclaration) {
            this.indexer.addParameterReference((IASTParameterDeclaration)iASTParameterReference.getReferencedElement());
        }
    }

    private void pushInclude(IASTInclusion iASTInclusion) {
        this.includeStack.addFirst(this.currentInclude);
        this.currentInclude = iASTInclusion;
    }

    private IASTInclusion popInclude() {
        IASTInclusion iASTInclusion = this.currentInclude;
        this.currentInclude = this.includeStack.size() > 0 ? (IASTInclusion)this.includeStack.removeFirst() : null;
        return iASTInclusion;
    }

    private IASTInclusion peekInclude() {
        return this.currentInclude;
    }

    public Reader createReader(String string) {
        return ParserUtil.createReader(string);
    }
}

