/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class ClassDeclarationPattern
extends CSearchPattern {
    private char[] simpleName;
    private char[][] qualifications;
    private ASTClassKind classKind;
    private ICSearchConstants.SearchFor searchFor;
    protected char[] decodedSimpleName;
    private char[][] decodedContainingTypes;
    protected char decodedType;

    public ClassDeclarationPattern(char[] cArray, char[][] cArray2, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        super(n, bl, limitTo);
        char[] cArray3 = this.simpleName = bl ? cArray : CharOperation.toLowerCase(cArray);
        if (bl || cArray2 == null) {
            this.qualifications = cArray2;
        } else {
            int n2 = cArray2.length;
            this.qualifications = new char[n2][];
            int n3 = 0;
            while (n3 < n2) {
                this.qualifications[n3] = CharOperation.toLowerCase(cArray2[n3]);
                ++n3;
            }
        }
        this.searchFor = searchFor;
        this.classKind = searchFor == ICSearchConstants.CLASS ? ASTClassKind.CLASS : (searchFor == ICSearchConstants.STRUCT ? ASTClassKind.STRUCT : (searchFor == ICSearchConstants.ENUM ? ASTClassKind.ENUM : (searchFor == ICSearchConstants.UNION ? ASTClassKind.UNION : null)));
    }

    public int matchLevel(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, ICSearchConstants.LimitTo limitTo) {
        IASTClassSpecifier iASTClassSpecifier;
        if (this.searchFor == ICSearchConstants.TYPEDEF ? !(iSourceElementCallbackDelegate instanceof IASTTypedefDeclaration) : (this.searchFor == ICSearchConstants.ENUM ? !(iSourceElementCallbackDelegate instanceof IASTEnumerationSpecifier) : !(iSourceElementCallbackDelegate instanceof IASTClassSpecifier) && !(iSourceElementCallbackDelegate instanceof IASTElaboratedTypeSpecifier))) {
            return 0;
        }
        if (!this.canAccept(limitTo)) {
            return 0;
        }
        String string = null;
        if (iSourceElementCallbackDelegate instanceof IASTElaboratedTypeSpecifier) {
            string = ((IASTElaboratedTypeSpecifier)iSourceElementCallbackDelegate).getName();
        } else if (iSourceElementCallbackDelegate instanceof IASTOffsetableNamedElement) {
            string = ((IASTOffsetableNamedElement)iSourceElementCallbackDelegate).getName();
        } else {
            return 0;
        }
        if (this.simpleName != null && !this.matchesName(this.simpleName, string.toCharArray())) {
            return 0;
        }
        if (iSourceElementCallbackDelegate instanceof IASTQualifiedNameElement) {
            iASTClassSpecifier = ((IASTQualifiedNameElement)iSourceElementCallbackDelegate).getFullyQualifiedName();
            char[][] cArray = new char[((String[])iASTClassSpecifier).length - 1][];
            int n = 0;
            while (n < ((IASTClassSpecifier)iASTClassSpecifier).length - 1) {
                cArray[n] = iASTClassSpecifier[n].toCharArray();
                ++n;
            }
            if (!this.matchQualifications(this.qualifications, cArray)) {
                return 0;
            }
        }
        if (this.classKind != null) {
            if (iSourceElementCallbackDelegate instanceof IASTClassSpecifier) {
                iASTClassSpecifier = (IASTClassSpecifier)iSourceElementCallbackDelegate;
                return this.classKind == iASTClassSpecifier.getClassKind() ? 2 : 0;
            }
            if (iSourceElementCallbackDelegate instanceof IASTEnumerationSpecifier) {
                return this.classKind == ASTClassKind.ENUM ? 2 : 0;
            }
            if (iSourceElementCallbackDelegate instanceof IASTElaboratedTypeSpecifier) {
                iASTClassSpecifier = (IASTElaboratedTypeSpecifier)iSourceElementCallbackDelegate;
                return this.classKind == iASTClassSpecifier.getClassKind() ? 2 : 0;
            }
        }
        return 2;
    }

    public char[] getName() {
        return this.simpleName;
    }

    public char[][] getContainingTypes() {
        return this.qualifications;
    }

    public ASTClassKind getKind() {
        return this.classKind;
    }

    public void feedIndexRequestor(IIndexSearchRequestor iIndexSearchRequestor, int n, int[] nArray, IndexInput indexInput, ICSearchScope iCSearchScope) throws IOException {
        boolean bl = this.decodedType == 'C';
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            String string;
            IndexedFile indexedFile = indexInput.getIndexedFile(nArray[n2]);
            if (indexedFile != null && iCSearchScope.encloses(string = indexedFile.getPath())) {
                if (bl) {
                    iIndexSearchRequestor.acceptClassDeclaration(string, this.decodedSimpleName, this.decodedContainingTypes);
                } else {
                    iIndexSearchRequestor.acceptClassDeclaration(string, this.decodedSimpleName, this.decodedContainingTypes);
                }
            }
            ++n2;
        }
    }

    protected void resetIndexInfo() {
        this.decodedType = '\u0000';
        this.decodedSimpleName = null;
        this.decodedContainingTypes = null;
    }

    protected void decodeIndexEntry(IEntryResult iEntryResult) {
        char[] cArray = iEntryResult.getWord();
        int n = cArray.length;
        int n2 = CharOperation.indexOf('/', cArray, 0);
        this.decodedType = cArray[n2 + 1];
        int n3 = CharOperation.indexOf('/', cArray, (n2 += 2) + 1);
        this.decodedSimpleName = CharOperation.subarray(cArray, n2 + 1, n3);
        if (n3 != -1 && n3 + 1 < n) {
            char[][] cArray2 = CharOperation.splitOn('/', CharOperation.subarray(cArray, n3 + 1, n));
            this.decodedContainingTypes = new char[cArray2.length][];
            int n4 = 0;
            while (n4 < cArray2.length) {
                this.decodedContainingTypes[n4] = cArray2[cArray2.length - n4 - 1];
                ++n4;
            }
        }
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestTypePrefix(this.searchFor, this.getLimitTo(), this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        if (this.classKind == null) {
            if (this.searchFor == ICSearchConstants.TYPEDEF && this.decodedType != 'T') {
                return false;
            }
            if (this.decodedType == 'V') {
                return false;
            }
        } else if (this.classKind == ASTClassKind.CLASS ? this.decodedType != 'C' : (this.classKind == ASTClassKind.STRUCT ? this.decodedType != 'S' : (this.classKind == ASTClassKind.UNION ? this.decodedType != 'U' : this.classKind == ASTClassKind.ENUM && this.decodedType != 'E'))) {
            return false;
        }
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedContainingTypes);
    }
}

