/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.SharedLibrary;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetAutoSolib;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetSolibSearchPath;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetStopOnSolibEvents;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShow;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowSolibSearchPath;
import org.eclipse.cdt.debug.mi.core.command.MIInfoSharedLibrary;
import org.eclipse.cdt.debug.mi.core.command.MISharedLibrary;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowInfo;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowSolibSearchPathInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoSharedLibraryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIShared;

public class SharedLibraryManager
extends SessionObject
implements ICDISharedLibraryManager {
    List sharedList = new ArrayList(1);
    boolean autoupdate = true;
    boolean isDeferred;

    public SharedLibraryManager(Session session) {
        super(session);
    }

    MIShared[] getMIShareds() throws CDIException {
        MIShared[] mISharedArray = new MIShared[]{};
        Session session = (Session)this.getSession();
        CommandFactory commandFactory = session.getMISession().getCommandFactory();
        MIInfoSharedLibrary mIInfoSharedLibrary = commandFactory.createMIInfoSharedLibrary();
        try {
            session.getMISession().postCommand(mIInfoSharedLibrary);
            MIInfoSharedLibraryInfo mIInfoSharedLibraryInfo = mIInfoSharedLibrary.getMIInfoSharedLibraryInfo();
            if (mIInfoSharedLibraryInfo == null) {
                throw new CDIException("No answer");
            }
            mISharedArray = mIInfoSharedLibraryInfo.getMIShared();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        return mISharedArray;
    }

    public void update() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        List list = this.updateState();
        MIEvent[] mIEventArray = list.toArray(new MIEvent[0]);
        mISession.fireEvents(mIEventArray);
    }

    public List updateState() throws CDIException {
        Session session = (Session)this.getSession();
        ICDIConfiguration iCDIConfiguration = session.getConfiguration();
        if (!iCDIConfiguration.supportsSharedLibrary()) {
            return Collections.EMPTY_LIST;
        }
        MIShared[] mISharedArray = this.getMIShareds();
        ArrayList<MIEvent> arrayList = new ArrayList<MIEvent>(mISharedArray.length);
        int n = 0;
        while (n < mISharedArray.length) {
            ICDISharedLibrary iCDISharedLibrary = this.getSharedLibrary(mISharedArray[n].getName());
            if (iCDISharedLibrary != null) {
                if (this.hasSharedLibChanged(iCDISharedLibrary, mISharedArray[n])) {
                    ((SharedLibrary)iCDISharedLibrary).setMIShared(mISharedArray[n]);
                    arrayList.add(new MISharedLibChangedEvent(mISharedArray[n].getName()));
                }
            } else {
                this.sharedList.add(new SharedLibrary(this, mISharedArray[n]));
                arrayList.add(new MISharedLibCreatedEvent(mISharedArray[n].getName()));
            }
            ++n;
        }
        ICDISharedLibrary[] iCDISharedLibraryArray = this.sharedList.toArray(new ICDISharedLibrary[0]);
        int n2 = 0;
        while (n2 < iCDISharedLibraryArray.length) {
            boolean bl = false;
            int n3 = 0;
            while (n3 < mISharedArray.length) {
                if (mISharedArray[n3].getName().equals(iCDISharedLibraryArray[n2].getFileName())) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                arrayList.add(new MISharedLibUnloadedEvent(iCDISharedLibraryArray[n2].getFileName()));
            }
            ++n2;
        }
        return arrayList;
    }

    public boolean hasSharedLibChanged(ICDISharedLibrary iCDISharedLibrary, MIShared mIShared) {
        return !mIShared.getName().equals(iCDISharedLibrary.getFileName()) || mIShared.getFrom() != iCDISharedLibrary.getStartAddress() || mIShared.getTo() != iCDISharedLibrary.getEndAddress() || mIShared.isRead() != iCDISharedLibrary.areSymbolsLoaded();
    }

    public void deleteSharedLibrary(ICDISharedLibrary iCDISharedLibrary) {
        this.sharedList.remove(iCDISharedLibrary);
    }

    public ICDISharedLibrary getSharedLibrary(String string) {
        ICDISharedLibrary[] iCDISharedLibraryArray = this.sharedList.toArray(new ICDISharedLibrary[0]);
        int n = 0;
        while (n < iCDISharedLibraryArray.length) {
            if (string.equals(iCDISharedLibraryArray[n].getFileName())) {
                return iCDISharedLibraryArray[n];
            }
            ++n;
        }
        return null;
    }

    public void setDeferredBreakpoint(boolean bl) {
        this.isDeferred = bl;
    }

    public boolean isDeferredBreakpoint() {
        return this.isDeferred;
    }

    public void setAutoLoadSymbols(boolean bl) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIGDBSetAutoSolib mIGDBSetAutoSolib = commandFactory.createMIGDBSetAutoSolib(bl);
        try {
            mISession.postCommand(mIGDBSetAutoSolib);
            mIGDBSetAutoSolib.getMIInfo();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public boolean isAutoLoadSymbols() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIGDBShow mIGDBShow = commandFactory.createMIGDBShow(new String[]{"auto-solib-add"});
        try {
            mISession.postCommand(mIGDBShow);
            MIGDBShowInfo mIGDBShowInfo = mIGDBShow.getMIGDBShowInfo();
            String string = mIGDBShowInfo.getValue();
            if (string != null) {
                return string.equalsIgnoreCase("on");
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        return false;
    }

    public void setStopOnSolibEvents(boolean bl) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIGDBSetStopOnSolibEvents mIGDBSetStopOnSolibEvents = commandFactory.createMIGDBSetStopOnSolibEvents(bl);
        try {
            mISession.postCommand(mIGDBSetStopOnSolibEvents);
            mIGDBSetStopOnSolibEvents.getMIInfo();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public boolean isStopOnSolibEvents() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIGDBShow mIGDBShow = commandFactory.createMIGDBShow(new String[]{"stop-on-solib-events"});
        try {
            mISession.postCommand(mIGDBShow);
            MIGDBShowInfo mIGDBShowInfo = mIGDBShow.getMIGDBShowInfo();
            String string = mIGDBShowInfo.getValue();
            if (string != null) {
                return string.equalsIgnoreCase("1");
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        return false;
    }

    public void setSharedLibraryPaths(String[] stringArray) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIGDBSetSolibSearchPath mIGDBSetSolibSearchPath = commandFactory.createMIGDBSetSolibSearchPath(stringArray);
        try {
            mISession.postCommand(mIGDBSetSolibSearchPath);
            mIGDBSetSolibSearchPath.getMIInfo();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public String[] getSharedLibraryPaths() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIGDBShowSolibSearchPath mIGDBShowSolibSearchPath = commandFactory.createMIGDBShowSolibSearchPath();
        try {
            mISession.postCommand(mIGDBShowSolibSearchPath);
            MIGDBShowSolibSearchPathInfo mIGDBShowSolibSearchPathInfo = mIGDBShowSolibSearchPath.getMIGDBShowSolibSearchPathInfo();
            return mIGDBShowSolibSearchPathInfo.getDirectories();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public ICDISharedLibrary[] getSharedLibraries() throws CDIException {
        return this.sharedList.toArray(new ICDISharedLibrary[0]);
    }

    public void loadSymbols() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MISharedLibrary mISharedLibrary = commandFactory.createMISharedLibrary();
        try {
            mISession.postCommand(mISharedLibrary);
            MIInfo mIInfo = mISharedLibrary.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        this.update();
    }

    public void loadSymbols(ICDISharedLibrary[] iCDISharedLibraryArray) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        int n = 0;
        while (n < iCDISharedLibraryArray.length) {
            if (!iCDISharedLibraryArray[n].areSymbolsLoaded()) {
                MISharedLibrary mISharedLibrary = commandFactory.createMISharedLibrary(iCDISharedLibraryArray[n].getFileName());
                try {
                    session.getMISession().postCommand(mISharedLibrary);
                    MIInfo mIInfo = mISharedLibrary.getMIInfo();
                    if (mIInfo == null) {
                        throw new CDIException("No answer");
                    }
                }
                catch (MIException mIException) {
                    throw new MI2CDIException(mIException);
                }
                ((SharedLibrary)iCDISharedLibraryArray[n]).getMIShared().setSymbolsRead(true);
                mISession.fireEvent(new MISharedLibChangedEvent(iCDISharedLibraryArray[n].getFileName()));
            }
            ++n;
        }
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean bl) {
        this.autoupdate = bl;
    }

    public boolean supportsAutoLoadSymbols() {
        return true;
    }

    public boolean supportsStopOnSolibEvents() {
        return true;
    }
}

