/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.StringTokenizer;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBTypeParser;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Instruction;
import org.eclipse.cdt.debug.mi.core.cdi.model.MixedInstruction;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ArrayType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.BoolType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.CharType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.DerivedType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.DoubleType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.EnumType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.FloatType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.FunctionType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IntType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.LongLongType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.LongType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.PointerType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ReferenceType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ShortType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.StructType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.Type;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.VoidType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.WCharType;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataDisassemble;
import org.eclipse.cdt.debug.mi.core.command.MIEnvironmentDirectory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowDirectories;
import org.eclipse.cdt.debug.mi.core.command.MIPType;
import org.eclipse.cdt.debug.mi.core.output.MIAsm;
import org.eclipse.cdt.debug.mi.core.output.MIDataDisassembleInfo;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowDirectoriesInfo;
import org.eclipse.cdt.debug.mi.core.output.MIPTypeInfo;
import org.eclipse.cdt.debug.mi.core.output.MISrcAsm;

public class SourceManager
extends SessionObject
implements ICDISourceManager {
    boolean autoupdate = false;
    GDBTypeParser gdbTypeParser = new GDBTypeParser();

    public SourceManager(Session session) {
        super(session);
    }

    public void addSourcePaths(String[] stringArray) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIEnvironmentDirectory mIEnvironmentDirectory = commandFactory.createMIEnvironmentDirectory(stringArray);
        try {
            mISession.postCommand(mIEnvironmentDirectory);
            mIEnvironmentDirectory.getMIInfo();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public String[] getSourcePaths() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIGDBShowDirectories mIGDBShowDirectories = commandFactory.createMIGDBShowDirectories();
        try {
            mISession.postCommand(mIGDBShowDirectories);
            MIGDBShowDirectoriesInfo mIGDBShowDirectoriesInfo = mIGDBShowDirectories.getMIGDBShowDirectoriesInfo();
            return mIGDBShowDirectoriesInfo.getDirectories();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public ICDIInstruction[] getInstructions(String string, int n, int n2) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIDataDisassemble mIDataDisassemble = commandFactory.createMIDataDisassemble(string, n, n2, false);
        try {
            mISession.postCommand(mIDataDisassemble);
            MIDataDisassembleInfo mIDataDisassembleInfo = mIDataDisassemble.getMIDataDisassembleInfo();
            MIAsm[] mIAsmArray = mIDataDisassembleInfo.getMIAsms();
            ICDIInstruction[] iCDIInstructionArray = new Instruction[mIAsmArray.length];
            int n3 = 0;
            while (n3 < iCDIInstructionArray.length) {
                iCDIInstructionArray[n3] = new Instruction(session.getCurrentTarget(), mIAsmArray[n3]);
                ++n3;
            }
            return iCDIInstructionArray;
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public ICDIInstruction[] getInstructions(String string, int n) throws CDIException {
        return this.getInstructions(string, n, -1);
    }

    public ICDIInstruction[] getInstructions(long l, long l2) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        String string = "0x";
        String string2 = String.valueOf(string) + Long.toHexString(l);
        String string3 = String.valueOf(string) + Long.toHexString(l2);
        MIDataDisassemble mIDataDisassemble = commandFactory.createMIDataDisassemble(string2, string3, false);
        try {
            mISession.postCommand(mIDataDisassemble);
            MIDataDisassembleInfo mIDataDisassembleInfo = mIDataDisassemble.getMIDataDisassembleInfo();
            MIAsm[] mIAsmArray = mIDataDisassembleInfo.getMIAsms();
            ICDIInstruction[] iCDIInstructionArray = new Instruction[mIAsmArray.length];
            int n = 0;
            while (n < iCDIInstructionArray.length) {
                iCDIInstructionArray[n] = new Instruction(session.getCurrentTarget(), mIAsmArray[n]);
                ++n;
            }
            return iCDIInstructionArray;
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public ICDIMixedInstruction[] getMixedInstructions(String string, int n, int n2) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIDataDisassemble mIDataDisassemble = commandFactory.createMIDataDisassemble(string, n, n2, true);
        try {
            mISession.postCommand(mIDataDisassemble);
            MIDataDisassembleInfo mIDataDisassembleInfo = mIDataDisassemble.getMIDataDisassembleInfo();
            MISrcAsm[] mISrcAsmArray = mIDataDisassembleInfo.getMISrcAsms();
            ICDIMixedInstruction[] iCDIMixedInstructionArray = new ICDIMixedInstruction[mISrcAsmArray.length];
            int n3 = 0;
            while (n3 < iCDIMixedInstructionArray.length) {
                iCDIMixedInstructionArray[n3] = new MixedInstruction(session.getCurrentTarget(), mISrcAsmArray[n3]);
                ++n3;
            }
            return iCDIMixedInstructionArray;
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public ICDIMixedInstruction[] getMixedInstructions(String string, int n) throws CDIException {
        return this.getMixedInstructions(string, n, -1);
    }

    public ICDIMixedInstruction[] getMixedInstructions(long l, long l2) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        String string = "0x";
        String string2 = String.valueOf(string) + Long.toHexString(l);
        String string3 = String.valueOf(string) + Long.toHexString(l2);
        MIDataDisassemble mIDataDisassemble = commandFactory.createMIDataDisassemble(string2, string3, true);
        try {
            mISession.postCommand(mIDataDisassemble);
            MIDataDisassembleInfo mIDataDisassembleInfo = mIDataDisassemble.getMIDataDisassembleInfo();
            MISrcAsm[] mISrcAsmArray = mIDataDisassembleInfo.getMISrcAsms();
            ICDIMixedInstruction[] iCDIMixedInstructionArray = new ICDIMixedInstruction[mISrcAsmArray.length];
            int n = 0;
            while (n < iCDIMixedInstructionArray.length) {
                iCDIMixedInstructionArray[n] = new MixedInstruction(session.getCurrentTarget(), mISrcAsmArray[n]);
                ++n;
            }
            return iCDIMixedInstructionArray;
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean bl) {
        this.autoupdate = bl;
    }

    public void update() throws CDIException {
    }

    public Type getType(ICDITarget iCDITarget, String string) throws CDIException {
        if (string == null) {
            string = new String();
        }
        String string2 = string.trim();
        GDBTypeParser.GDBType gDBType = this.gdbTypeParser.parse(string2);
        Type type = null;
        Type type2 = null;
        Type type3 = null;
        while (gDBType != null) {
            if (gDBType instanceof GDBTypeParser.GDBDerivedType) {
                switch (gDBType.getType()) {
                    case 3: {
                        int n = ((GDBTypeParser.GDBDerivedType)gDBType).getDimension();
                        type3 = new ArrayType(iCDITarget, gDBType.toString(), n);
                        break;
                    }
                    case 4: {
                        type3 = new FunctionType(iCDITarget, gDBType.toString());
                        break;
                    }
                    case 1: {
                        type3 = new PointerType(iCDITarget, gDBType.toString());
                        break;
                    }
                    case 2: {
                        type3 = new ReferenceType(iCDITarget, gDBType.toString());
                    }
                }
                gDBType = ((GDBTypeParser.GDBDerivedType)gDBType).getChild();
            } else {
                type3 = this.toCDIType(iCDITarget, gDBType.toString());
                gDBType = null;
            }
            if (type2 instanceof DerivedType) {
                ((DerivedType)type2).setComponentType(type3);
            }
            if (type == null) {
                type = type3;
            }
            type2 = type3;
        }
        if (type != null) {
            return type;
        }
        throw new CDIException("Unknown type");
    }

    Type toCDIType(ICDITarget iCDITarget, String string) throws CDIException {
        String string2;
        if (string == null) {
            string = new String();
        }
        if ((string2 = string.trim()).equals("char")) {
            return new CharType(iCDITarget, string2);
        }
        if (string2.equals("wchar_t")) {
            return new WCharType(iCDITarget, string2);
        }
        if (string2.equals("short")) {
            return new ShortType(iCDITarget, string2);
        }
        if (string2.equals("int")) {
            return new IntType(iCDITarget, string2);
        }
        if (string2.equals("long")) {
            return new LongType(iCDITarget, string2);
        }
        if (string2.equals("unsigned")) {
            return new IntType(iCDITarget, string2, true);
        }
        if (string2.equals("signed")) {
            return new IntType(iCDITarget, string2);
        }
        if (string2.equals("bool")) {
            return new BoolType(iCDITarget, string2);
        }
        if (string2.equals("_Bool")) {
            return new BoolType(iCDITarget, string2);
        }
        if (string2.equals("float")) {
            return new FloatType(iCDITarget, string2);
        }
        if (string2.equals("double")) {
            return new DoubleType(iCDITarget, string2);
        }
        if (string2.equals("void")) {
            return new VoidType(iCDITarget, string2);
        }
        if (string2.equals("enum")) {
            return new EnumType(iCDITarget, string2);
        }
        if (string2.equals("union")) {
            return new StructType(iCDITarget, string2);
        }
        if (string2.equals("struct")) {
            return new StructType(iCDITarget, string2);
        }
        if (string2.equals("class")) {
            return new StructType(iCDITarget, string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n = stringTokenizer.countTokens();
        if (n == 2) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            boolean bl = string3.equals("unsigned") || string4.equals("unsigned");
            boolean bl2 = string3.equals("signed") || string4.equals("signed");
            boolean bl3 = string3.equals("char") || string4.equals("char");
            boolean bl4 = string3.equals("int") || string4.equals("int");
            boolean bl5 = string3.equals("long") || string4.equals("long");
            boolean bl6 = string3.equals("short") || string4.equals("short");
            boolean bl7 = string3.equals("long") && string4.equals("long");
            boolean bl8 = string3.equals("double") || string4.equals("double");
            boolean bl9 = string3.equals("float") || string4.equals("float");
            boolean bl10 = string3.equals("complex") || string4.equals("complex") || string3.equals("_Complex") || string4.equals("_Complex");
            boolean bl11 = string3.equals("_Imaginary") || string4.equals("_Imaginary");
            boolean bl12 = string3.equals("struct");
            boolean bl13 = string3.equals("class");
            boolean bl14 = string3.equals("union");
            boolean bl15 = string3.equals("enum");
            if (bl3 && (bl2 || bl)) {
                return new CharType(iCDITarget, string2, bl);
            }
            if (bl6 && (bl2 || bl)) {
                return new ShortType(iCDITarget, string2, bl);
            }
            if (bl4 && (bl2 || bl)) {
                return new IntType(iCDITarget, string2, bl);
            }
            if (bl5 && (bl4 || bl2 || bl)) {
                return new LongType(iCDITarget, string2, bl);
            }
            if (bl7) {
                return new LongLongType(iCDITarget, string2);
            }
            if (bl8 && (bl5 || bl10 || bl11)) {
                return new DoubleType(iCDITarget, string2, bl10, bl11, bl5);
            }
            if (bl9 && (bl10 || bl11)) {
                return new FloatType(iCDITarget, string2, bl10, bl11);
            }
            if (bl12) {
                return new StructType(iCDITarget, string2);
            }
            if (bl13) {
                return new StructType(iCDITarget, string2);
            }
            if (bl14) {
                return new StructType(iCDITarget, string2);
            }
            if (bl15) {
                return new EnumType(iCDITarget, string2);
            }
        } else if (n == 3) {
            boolean bl;
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            String string7 = stringTokenizer.nextToken();
            boolean bl16 = string5.equals("signed") || string6.equals("signed") || string7.equals("signed");
            boolean bl17 = string5.equals("unsigned") || string6.equals("unsigned") || string7.equals("unsigned");
            boolean bl18 = string5.equals("int") || string6.equals("int") || string7.equals("int");
            boolean bl19 = string5.equals("long") || string6.equals("long") || string7.equals("long");
            boolean bl20 = string5.equals("short") || string6.equals("short") || string7.equals("short");
            boolean bl21 = string5.equals("long") && string6.equals("long") || string6.equals("long") && string7.equals("long");
            boolean bl22 = string5.equals("double") || string6.equals("double") || string7.equals("double");
            boolean bl23 = string5.equals("complex") || string6.equals("complex") || string7.equals("complex") || string5.equals("_Complex") || string6.equals("_Complex") || string7.equals("_Complex");
            boolean bl24 = bl = string5.equals("_Imaginary") || string6.equals("_Imaginary") || string7.equals("_Imaginary");
            if (bl20 && bl18 && (bl16 || bl17)) {
                return new ShortType(iCDITarget, string2, bl17);
            }
            if (bl19 && bl18 && (bl16 || bl17)) {
                return new LongType(iCDITarget, string2, bl17);
            }
            if (bl21 && (bl16 || bl17)) {
                return new LongLongType(iCDITarget, string2, bl17);
            }
            if (bl22 && bl19 && (bl23 || bl)) {
                return new DoubleType(iCDITarget, string2, bl23, bl, bl19);
            }
        } else if (n == 4) {
            boolean bl;
            String string8 = stringTokenizer.nextToken();
            String string9 = stringTokenizer.nextToken();
            String string10 = stringTokenizer.nextToken();
            String string11 = stringTokenizer.nextToken();
            boolean bl25 = string8.equals("unsigned") || string9.equals("unsigned") || string10.equals("unsigned") || string11.equals("unsigned");
            boolean bl26 = string8.equals("signed") || string9.equals("signed") || string10.equals("signed") || string11.equals("signed");
            boolean bl27 = string8.equals("int") || string9.equals("int") || string10.equals("int") || string11.equals("int");
            boolean bl28 = bl = string8.equals("long") && string9.equals("long") || string9.equals("long") && string10.equals("long") || string10.equals("long") && string11.equals("long");
            if (bl && bl27 && (bl26 || bl25)) {
                return new LongLongType(iCDITarget, string2, bl25);
            }
        }
        throw new CDIException("Unknown type");
    }

    public String getDetailTypeName(String string) throws CDIException {
        try {
            Session session = (Session)this.getSession();
            MISession mISession = session.getMISession();
            CommandFactory commandFactory = mISession.getCommandFactory();
            MIPType mIPType = commandFactory.createMIPType(string);
            mISession.postCommand(mIPType);
            MIPTypeInfo mIPTypeInfo = mIPType.getMIPtypeInfo();
            if (mIPTypeInfo == null) {
                throw new CDIException("No answer");
            }
            return mIPTypeInfo.getType();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }
}

