/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIDataListRegisterNamesInfo
extends MIInfo {
    String[] names;
    protected int realNameCount = 0;

    public MIDataListRegisterNamesInfo(MIOutput mIOutput) {
        super(mIOutput);
    }

    public String[] getRegisterNames() {
        if (this.names == null) {
            this.parse();
        }
        return this.names;
    }

    void parse() {
        MIOutput mIOutput;
        MIResultRecord mIResultRecord;
        ArrayList arrayList = new ArrayList();
        if (this.isDone() && (mIResultRecord = (mIOutput = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] mIResultArray = mIResultRecord.getMIResults();
            int n = 0;
            while (n < mIResultArray.length) {
                MIValue mIValue;
                String string = mIResultArray[n].getVariable();
                if (string.equals("register-names") && (mIValue = mIResultArray[n].getMIValue()) instanceof MIList) {
                    this.parseRegisters((MIList)mIValue, arrayList);
                }
                ++n;
            }
        }
        this.names = arrayList.toArray(new String[arrayList.size()]);
    }

    void parseRegisters(MIList mIList, List list) {
        MIValue[] mIValueArray = mIList.getMIValues();
        int n = 0;
        while (n < mIValueArray.length) {
            if (mIValueArray[n] instanceof MIConst) {
                String string = ((MIConst)mIValueArray[n]).getCString();
                if (string != null && string.length() > 0) {
                    ++this.realNameCount;
                    list.add(string);
                } else {
                    list.add("");
                }
            }
            ++n;
        }
    }

    public int getNumRealNames() {
        if (this.names == null) {
            this.parse();
        }
        return this.realNameCount;
    }
}

