/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.ui.actions.BreakpointLocationVerifier;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class ManageBreakpointActionDelegate
implements IWorkbenchWindowActionDelegate,
IPartListener {
    private boolean fInitialized = false;
    private IAction fAction = null;
    private int fLineNumber;
    private ITextEditor fTextEditor = null;
    private IWorkbenchWindow fWorkbenchWindow = null;
    private IFile fFile = null;

    public void dispose() {
        this.getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.setWorkbenchWindow(iWorkbenchWindow);
        iWorkbenchWindow.getPartService().addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ITextEditor) {
            this.setTextEditor((ITextEditor)iWorkbenchPart);
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.getTextEditor()) {
            this.setTextEditor(null);
            if (this.getAction() != null) {
                this.getAction().setEnabled(false);
            }
        }
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ITextEditor && this.getTextEditor() == null) {
            this.setTextEditor((ITextEditor)iWorkbenchPart);
        }
    }

    public void run(IAction iAction) {
        if (this.getTextEditor() != null) {
            this.update();
            this.manageBreakpoint(this.getTextEditor().getEditorInput());
        }
    }

    protected void update(ISelection iSelection) {
        this.setEnabledState(this.getTextEditor());
    }

    protected void update() {
        IAction iAction = this.getAction();
        if (iAction != null) {
            if (this.getTextEditor() != null) {
                this.breakpointExists(this.getTextEditor().getEditorInput());
            }
            iAction.setEnabled(this.getTextEditor() != null && this.getFile() != null);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (!this.fInitialized) {
            IEditorPart iEditorPart;
            IWorkbenchPage iWorkbenchPage;
            this.setAction(iAction);
            if (this.getWorkbenchWindow() != null && (iWorkbenchPage = this.getWorkbenchWindow().getActivePage()) != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) instanceof ITextEditor) {
                this.setTextEditor((ITextEditor)iEditorPart);
                this.update(this.getTextEditor().getSelectionProvider().getSelection());
            }
            this.fInitialized = true;
        }
        this.update(iSelection);
    }

    protected void manageBreakpoint(IEditorInput iEditorInput) {
        ISelectionProvider iSelectionProvider = this.getTextEditor().getSelectionProvider();
        if (iSelectionProvider == null || this.getFile() == null) {
            this.beep();
            return;
        }
        ISelection iSelection = iSelectionProvider.getSelection();
        if (iSelection instanceof ITextSelection) {
            if (this.getFile() == null) {
                return;
            }
            BreakpointLocationVerifier breakpointLocationVerifier = new BreakpointLocationVerifier();
            IDocument iDocument = this.getTextEditor().getDocumentProvider().getDocument((Object)iEditorInput);
            int n = breakpointLocationVerifier.getValidLineBreakpointLocation(iDocument, ((ITextSelection)iSelection).getStartLine());
            if (n > -1) {
                try {
                    ICLineBreakpoint iCLineBreakpoint = CDebugModel.lineBreakpointExists((String)this.getFile().getLocation().toOSString(), (int)n);
                    if (iCLineBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)iCLineBreakpoint, true);
                    } else {
                        CDebugModel.createLineBreakpoint((IResource)this.getFile(), (int)n, (boolean)true, (int)0, (String)"", (boolean)true);
                    }
                }
                catch (CoreException coreException) {
                    CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.ManageBreakpointActionDelegate.Cannot_add_breakpoint"), coreException);
                }
            }
        }
    }

    protected boolean breakpointExists(IEditorInput iEditorInput) {
        if (this.getFile() != null) {
            try {
                return CDebugModel.lineBreakpointExists((String)this.getFile().getLocation().toOSString(), (int)this.getLineNumber()) == null;
            }
            catch (CoreException coreException) {
                CDebugUIPlugin.log(coreException);
            }
        }
        return false;
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    protected void setWorkbenchWindow(IWorkbenchWindow iWorkbenchWindow) {
        this.fWorkbenchWindow = iWorkbenchWindow;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor iTextEditor) {
        this.fTextEditor = iTextEditor;
        if (this.fTextEditor != null) {
            IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
            this.setFile(iEditorInput != null && iEditorInput instanceof IFileEditorInput ? ((IFileEditorInput)iEditorInput).getFile() : null);
        }
        this.setEnabledState(iTextEditor);
    }

    protected void setEnabledState(ITextEditor iTextEditor) {
        if (this.getAction() != null) {
            this.getAction().setEnabled(iTextEditor != null);
        }
    }

    protected void beep() {
        if (CDebugUIPlugin.getActiveWorkbenchShell() != null) {
            CDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    protected int getLineNumber() {
        return this.fLineNumber;
    }

    protected void setLineNumber(int n) {
        this.fLineNumber = n;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    protected IFile getFile() {
        return this.fFile;
    }

    protected void setFile(IFile iFile) {
        this.fFile = iFile;
    }
}

