/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class ManageFunctionBreakpointActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICElement fElement = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        if (this.getMethod() != null) {
            this.manageBreakpoint(this.getMethod());
        } else if (this.getFunction() != null) {
            this.manageBreakpoint(this.getFunction());
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        Object object;
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof ICElement) {
            boolean bl = this.enablesFor((ICElement)object);
            iAction.setEnabled(bl);
            if (bl) {
                this.setElement((ICElement)object);
                return;
            }
        }
        iAction.setEnabled(false);
        this.setElement(null);
    }

    public ICElement getElement() {
        return this.fElement;
    }

    public void setElement(ICElement iCElement) {
        this.fElement = iCElement;
    }

    private boolean enablesFor(ICElement iCElement) {
        return true;
    }

    private void manageBreakpoint(IFunction iFunction) {
        try {
            ICFunctionBreakpoint iCFunctionBreakpoint = CDebugModel.functionBreakpointExists((IFunction)iFunction);
            if (iCFunctionBreakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)iCFunctionBreakpoint, true);
            } else {
                CDebugModel.createFunctionBreakpoint((IFunction)iFunction, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.ManageFunctionBreakpointActionDelegate.Cannot_add_breakpoint"), coreException);
        }
    }

    private IFunction getFunction() {
        IFunction iFunction;
        if (this.getElement() != null) {
            ICElement iCElement = this.getElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.IFunction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iFunction = (IFunction)iCElement.getAdapter((Class)clazz);
        } else {
            iFunction = null;
        }
        return iFunction;
    }

    private void manageBreakpoint(IMethod iMethod) {
        try {
            ICFunctionBreakpoint iCFunctionBreakpoint = CDebugModel.methodBreakpointExists((IMethod)iMethod);
            if (iCFunctionBreakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)iCFunctionBreakpoint, true);
            } else {
                CDebugModel.createMethodBreakpoint((IMethod)iMethod, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.errorDialog("Cannot add breakpoint", coreException);
        }
    }

    private IMethod getMethod() {
        IMethod iMethod;
        if (this.getElement() != null) {
            ICElement iCElement = this.getElement();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.IMethod");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iMethod = (IMethod)iCElement.getAdapter((Class)clazz);
        } else {
            iMethod = null;
        }
        return iMethod;
    }
}

