/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.editors;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.ICBreakpointManager;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.debug.internal.ui.editors.DisassemblyMarkerAnnotation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class DisassemblyMarkerAnnotationModel
extends AbstractMarkerAnnotationModel {
    private IWorkspace fWorkspace;
    private IResource fResource;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private IResourceDeltaVisitor fResourceDeltaVisitor = new ResourceDeltaVisitor();
    private IDisassemblyStorage fStorage = null;
    static /* synthetic */ Class class$0;

    public DisassemblyMarkerAnnotationModel(IDisassemblyStorage iDisassemblyStorage, IResource iResource) {
        this.fResource = iResource;
        this.fWorkspace = iResource.getWorkspace();
        this.fStorage = iDisassemblyStorage;
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        if (this.fStorage == null) {
            return null;
        }
        IDebugTarget iDebugTarget = this.fStorage.getDebugTarget();
        if (iDebugTarget != null) {
            IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints();
            ArrayList<IMarker> arrayList = new ArrayList<IMarker>(iBreakpointArray.length);
            int n = 0;
            while (n < iBreakpointArray.length) {
                if (iDebugTarget.supportsBreakpoint(iBreakpointArray[n]) && this.isAcceptable(iBreakpointArray[n].getMarker())) {
                    arrayList.add(iBreakpointArray[n].getMarker());
                }
                ++n;
            }
            return arrayList.toArray(new IMarker[arrayList.size()]);
        }
        return null;
    }

    protected void deleteMarkers(final IMarker[] iMarkerArray) throws CoreException {
        this.fWorkspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                int n = 0;
                while (n < iMarkerArray.length) {
                    iMarkerArray[n].delete();
                    ++n;
                }
            }
        }, null);
    }

    protected void listenToMarkerChanges(boolean bl) {
        if (bl) {
            this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        } else {
            this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
        }
    }

    protected boolean isAcceptable(IMarker iMarker) {
        try {
            return iMarker.getType().equals(CLineBreakpoint.getMarkerType()) || iMarker.getType().equals(CFunctionBreakpoint.getMarkerType()) || iMarker.getType().equals(CAddressBreakpoint.getMarkerType());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected IResourceDeltaVisitor getResourceDeltaVisitor() {
        return this.fResourceDeltaVisitor;
    }

    protected void update(IMarkerDelta[] iMarkerDeltaArray) {
        if (iMarkerDeltaArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < iMarkerDeltaArray.length) {
            IMarkerDelta iMarkerDelta = iMarkerDeltaArray[n];
            switch (iMarkerDelta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(iMarkerDelta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(iMarkerDelta.getMarker());
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(iMarkerDelta.getMarker());
                }
            }
            ++n;
        }
        this.fireModelChanged();
    }

    protected Position createPositionFromMarker(IMarker iMarker) {
        try {
            if (iMarker.getType().equals(CLineBreakpoint.getMarkerType())) {
                return this.createPositionFromLineBreakpoint(iMarker);
            }
            if (iMarker.getType().equals(CFunctionBreakpoint.getMarkerType())) {
                return this.createPositionFromLineBreakpoint(iMarker);
            }
            if (iMarker.getType().equals(CAddressBreakpoint.getMarkerType())) {
                return this.createPositionFromAddressBreakpoint(iMarker);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private Position createPositionFromLineBreakpoint(IMarker iMarker) {
        IDebugTarget iDebugTarget;
        IBreakpoint iBreakpoint;
        if (this.fStorage != null && (iBreakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(iMarker)) instanceof ICBreakpoint && (iDebugTarget = this.fStorage.getDebugTarget()) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICBreakpointManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iDebugTarget.getAdapter((Class)clazz) != null) {
                ICBreakpointManager iCBreakpointManager;
                long l;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICBreakpointManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((l = (iCBreakpointManager = (ICBreakpointManager)iDebugTarget.getAdapter((Class)clazz2)).getBreakpointAddress((ICBreakpoint)iBreakpoint)) != 0L) {
                    return this.createPositionFromAddress(l);
                }
            }
        }
        return null;
    }

    private Position createPositionFromAddressBreakpoint(IMarker iMarker) throws CoreException {
        try {
            return this.createPositionFromAddress(Long.parseLong(iMarker.getAttribute("org.eclipse.cdt.debug.core.address", "0")));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Position createPositionFromAddress(long l) {
        try {
            int n = -1;
            int n2 = this.fStorage.getLineNumber(l);
            if (n2 > 0 && ((AnnotationModel)this).fDocument != null && (n = ((AnnotationModel)this).fDocument.getLineOffset(n2 - 1)) > -1) {
                return new Position(n, ((AnnotationModel)this).fDocument.getLineLength(n2 - 1));
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker iMarker) {
        return new DisassemblyMarkerAnnotation(iMarker);
    }

    public Position getMarkerPosition(IMarker iMarker) {
        return this.createPositionFromMarker(iMarker);
    }

    protected void doHandleCoreException(CoreException coreException, String string) {
        this.handleCoreException(coreException, string);
    }

    protected IResource getResource() {
        return this.fResource;
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            try {
                if (iResourceDelta != null) {
                    iResourceDelta.accept(DisassemblyMarkerAnnotationModel.this.getResourceDeltaVisitor());
                }
            }
            catch (CoreException coreException) {
                DisassemblyMarkerAnnotationModel.this.doHandleCoreException(coreException, "Resource Changed");
            }
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            if (iResourceDelta != null && iResourceDelta.getResource() instanceof IFile) {
                DisassemblyMarkerAnnotationModel.this.update(iResourceDelta.getMarkerDeltas());
                return false;
            }
            return true;
        }
    }
}

