/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceListDialogField;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class SourcePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Observer {
    private SourceListDialogField fSourceListField;
    private SelectionButtonDialogField fSearchForDuplicateFiles;
    private boolean fChanged = false;

    public SourcePreferencePage() {
        this.setPreferenceStore(CDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(CDebugUIPlugin.getResourceString("internal.ui.preferences.SourcePreferencePage.Description"));
    }

    protected Control createContents(Composite composite) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)ICDebugHelpContextIds.SOURCE_PREFERENCE_PAGE);
        this.fSourceListField = this.createSourceListField();
        this.fSearchForDuplicateFiles = this.createSearchForDuplicateFilesButton();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(JFaceResources.getDialogFont());
        PixelConverter pixelConverter = new PixelConverter((Control)composite2);
        this.fSourceListField.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fSourceListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fSourceListField.getLabelControl(null), pixelConverter.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fSourceListField.getListControl(null));
        this.fSearchForDuplicateFiles.doFillIntoGrid(composite2, 3);
        this.setValues();
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void update(Observable observable, Object object) {
        this.setChanged(true);
    }

    private SourceListDialogField createSourceListField() {
        SourceListDialogField sourceListDialogField = new SourceListDialogField(CDebugUIPlugin.getResourceString("internal.ui.preferences.SourcePreferencePage.Source_locations"), new IListAdapter(){

            public void customButtonPressed(DialogField dialogField, int n) {
                SourcePreferencePage.this.sourceButtonPressed(n);
            }

            public void selectionChanged(DialogField dialogField) {
            }
        });
        sourceListDialogField.addObserver(this);
        return sourceListDialogField;
    }

    private SelectionButtonDialogField createSearchForDuplicateFilesButton() {
        SelectionButtonDialogField selectionButtonDialogField = new SelectionButtonDialogField(32);
        selectionButtonDialogField.setLabelText(CDebugUIPlugin.getResourceString("internal.ui.preferences.SourcePreferencePage.Search_for_duplicate_source_files"));
        selectionButtonDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                SourcePreferencePage.this.setChanged(true);
            }
        });
        return selectionButtonDialogField;
    }

    protected void sourceButtonPressed(int n) {
        switch (n) {
            case 0: {
                if (!this.addSourceLocation()) break;
                this.setChanged(true);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.setChanged(true);
            }
        }
    }

    protected boolean isChanged() {
        return this.fChanged;
    }

    protected void setChanged(boolean bl) {
        this.fChanged = bl;
    }

    private boolean addSourceLocation() {
        AddSourceLocationWizard addSourceLocationWizard = new AddSourceLocationWizard(this.getSourceLocations());
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)addSourceLocationWizard);
        if (wizardDialog.open() == 0) {
            this.fSourceListField.addElement(addSourceLocationWizard.getSourceLocation());
            return true;
        }
        return false;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.fSourceListField != null ? this.fSourceListField.getSourceLocations() : new ICSourceLocation[]{};
    }

    public void setSourceLocations(ICSourceLocation[] iCSourceLocationArray) {
        if (this.fSourceListField != null) {
            this.fSourceListField.setElements(Arrays.asList(iCSourceLocationArray));
        }
    }

    protected void performDefaults() {
        this.setSourceLocations(new ICSourceLocation[0]);
        this.setSearchForDuplicateFiles(false);
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        CDebugCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private boolean searchForDuplicateFiles() {
        return this.fSearchForDuplicateFiles != null ? this.fSearchForDuplicateFiles.isSelected() : false;
    }

    private void setSearchForDuplicateFiles(boolean bl) {
        if (this.fSearchForDuplicateFiles != null) {
            this.fSearchForDuplicateFiles.setSelection(bl);
        }
    }

    private void setValues() {
        this.setSourceLocations(CDebugCorePlugin.getDefault().getCommonSourceLocations());
        this.setSearchForDuplicateFiles(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SEARCH_DUPLICATE_FILES));
    }

    private void storeValues() {
        CDebugCorePlugin.getDefault().saveCommonSourceLocations(this.getSourceLocations());
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_SEARCH_DUPLICATE_FILES, this.searchForDuplicateFiles());
    }
}

