/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryPresentation;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MemoryText {
    private StyledText fText = null;
    private MemoryPresentation fPresentation = null;
    private boolean fUpdating = false;

    public MemoryText(Composite composite, int n, MemoryPresentation memoryPresentation) {
        this.fText = new StyledText(composite, n);
        this.fText.setLayoutData((Object)new GridData(1808));
        this.fPresentation = memoryPresentation;
        this.initialize();
    }

    private void initialize() {
        this.fText.invokeAction(0x1000009);
        this.fText.setKeyBinding(0x1000009, 0);
        this.fText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent extendedModifyEvent) {
                MemoryText.this.handleExtendedModify(extendedModifyEvent);
            }
        });
        this.fText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                MemoryText.this.handleVerifyKey(verifyEvent);
            }
        });
        this.refresh();
    }

    protected void handleExtendedModify(ExtendedModifyEvent extendedModifyEvent) {
        if (this.fUpdating) {
            return;
        }
        if (extendedModifyEvent.length != 1) {
            return;
        }
        int n = this.fText.getCaretOffset();
        this.fText.getCaret().setVisible(false);
        char c = this.fText.getText().charAt(extendedModifyEvent.start);
        this.restoreText(extendedModifyEvent.start, extendedModifyEvent.length, extendedModifyEvent.replacedText);
        this.fPresentation.setItemValue(extendedModifyEvent.start, c);
        this.fText.setCaretOffset(n);
        this.fText.getCaret().setVisible(true);
    }

    public void refresh() {
        int n = this.fText.getCaretOffset();
        this.fText.getCaret().setVisible(false);
        this.fText.setFont(new Font((Device)this.fText.getDisplay(), this.getFontData()));
        this.fText.setBackground(this.getBackgroundColor());
        this.fText.setForeground(this.getForegroundColor());
        this.fText.setText(this.fPresentation.getText());
        Point[] pointArray = this.fPresentation.getChangedZones();
        int n2 = 0;
        while (n2 < pointArray.length) {
            this.fText.setStyleRange(new StyleRange(pointArray[n2].x, pointArray[n2].y - pointArray[n2].x + 1, this.getChangedColor(), this.getBackgroundColor()));
            ++n2;
        }
        pointArray = this.fPresentation.getAddressZones();
        n2 = this.fPresentation.isStartAddressChanged() ? 1 : 0;
        int n3 = 0;
        while (n3 < pointArray.length) {
            this.fText.setStyleRange(new StyleRange(pointArray[n3].x, pointArray[n3].y - pointArray[n3].x + 1, n2 != 0 ? this.getChangedColor() : this.getAddressColor(), this.getBackgroundColor()));
            ++n3;
        }
        this.fText.redraw();
        this.fText.setCaretOffset(n);
        this.fText.getCaret().setVisible(true);
    }

    protected void handleVerifyKey(VerifyEvent verifyEvent) {
        if (verifyEvent.character == '\n' || verifyEvent.character == '\r' || verifyEvent.character == '\b' || verifyEvent.character == '\u007f') {
            verifyEvent.doit = false;
            return;
        }
        if (Character.isISOControl(verifyEvent.character)) {
            return;
        }
        if (this.getSelectionCount() != 0) {
            verifyEvent.doit = false;
            return;
        }
        if (!this.fPresentation.isAcceptable(verifyEvent.character, this.fText.getCaretOffset())) {
            verifyEvent.doit = false;
        }
    }

    private FontData getFontData() {
        IPreferenceStore iPreferenceStore = CDebugUIPlugin.getDefault().getPreferenceStore();
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)iPreferenceStore, (String)"Memory.font");
        return fontData;
    }

    private Color getForegroundColor() {
        return CDebugUIPlugin.getPreferenceColor("Memory.Foreground.RGB");
    }

    private Color getBackgroundColor() {
        return CDebugUIPlugin.getPreferenceColor("Memory.background.RGB");
    }

    private Color getAddressColor() {
        return CDebugUIPlugin.getPreferenceColor("Memory.Address.RGB");
    }

    private Color getChangedColor() {
        return CDebugUIPlugin.getPreferenceColor("Memory.Changed.RGB");
    }

    public void changeFont() {
        Font font = this.fText.getFont();
        this.fText.setFont(new Font((Device)this.fText.getDisplay(), this.getFontData()));
        font.dispose();
    }

    public void setForegroundColor() {
        this.fText.setForeground(CDebugUIPlugin.getPreferenceColor("Memory.Foreground.RGB"));
    }

    public void setBackgroundColor() {
        this.fText.setBackground(CDebugUIPlugin.getPreferenceColor("Memory.background.RGB"));
    }

    public void setChangedColor() {
        Point[] pointArray = this.fPresentation.getChangedZones();
        int n = 0;
        while (n < pointArray.length) {
            this.fText.setStyleRange(new StyleRange(pointArray[n].x, pointArray[n].y - pointArray[n].x + 1, this.getChangedColor(), this.getBackgroundColor()));
            ++n;
        }
    }

    public void setAddressColor() {
        Point[] pointArray = this.fPresentation.getAddressZones();
        int n = 0;
        while (n < pointArray.length) {
            this.fText.setStyleRange(new StyleRange(pointArray[n].x, pointArray[n].y - pointArray[n].x + 1, this.getAddressColor(), this.getBackgroundColor()));
            ++n;
        }
    }

    public void setDirtyColor() {
    }

    protected void setEditable(boolean bl) {
        this.fText.setEditable(bl);
    }

    protected int getSelectionCount() {
        return this.fText.getSelectionCount();
    }

    protected Control getControl() {
        return this.fText;
    }

    private void restoreText(int n, int n2, String string) {
        this.fUpdating = true;
        this.fText.replaceTextRange(n, n2, string);
        this.fUpdating = false;
    }
}

