/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;

public class ASTFunction
extends ASTScope
implements IASTFunction {
    private final boolean previouslyDeclared;
    private boolean hasFunctionBody = false;
    private final IASTTemplate ownerTemplate;
    private final IASTAbstractDeclaration returnType;
    private final IASTExceptionSpecification exception;
    private NamedOffsets offsets = new NamedOffsets();
    private final ASTQualifiedNamedElement qualifiedName;
    private final List parameters;
    protected final ASTReferenceStore references;
    private List declarations = new ArrayList();
    private boolean hasFunctionTryBlock = false;

    public ASTFunction(IParameterizedSymbol iParameterizedSymbol, int n, List list, IASTAbstractDeclaration iASTAbstractDeclaration, IASTExceptionSpecification iASTExceptionSpecification, int n2, int n3, int n4, int n5, IASTTemplate iASTTemplate, List list2, boolean bl, boolean bl2) {
        super(iParameterizedSymbol);
        this.parameters = list;
        this.returnType = iASTAbstractDeclaration;
        this.exception = iASTExceptionSpecification;
        this.setStartingOffsetAndLineNumber(n2, n3);
        this.setNameOffset(n4);
        this.setNameEndOffsetAndLineNumber(n, n5);
        this.ownerTemplate = iASTTemplate;
        this.references = new ASTReferenceStore(list2);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iParameterizedSymbol.getName());
        this.previouslyDeclared = bl;
        this.hasFunctionTryBlock = bl2;
    }

    public boolean isInline() {
        return this.symbol.getTypeInfo().checkBit(1024);
    }

    public boolean isFriend() {
        return this.symbol.getTypeInfo().checkBit(16384);
    }

    public boolean isStatic() {
        return this.symbol.getTypeInfo().checkBit(128);
    }

    public String getName() {
        return this.symbol.getName();
    }

    public IASTAbstractDeclaration getReturnType() {
        return this.returnType;
    }

    public Iterator getParameters() {
        return this.parameters.iterator();
    }

    public IASTExceptionSpecification getExceptionSpec() {
        return this.exception;
    }

    public void setHasFunctionBody(boolean bl) {
        this.hasFunctionBody = true;
    }

    public boolean hasFunctionBody() {
        return this.hasFunctionBody;
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int n) {
        this.offsets.setNameOffset(n);
    }

    public IASTTemplate getOwnerTemplateDeclaration() {
        return this.ownerTemplate;
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setStartingOffsetAndLineNumber(n, n2);
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setEndingOffsetAndLineNumber(n, n2);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor) {
        try {
            iSourceElementRequestor.acceptFunctionDeclaration(this);
        }
        catch (Exception exception) {}
        this.functionCallbacks(iSourceElementRequestor);
    }

    protected void functionCallbacks(ISourceElementRequestor iSourceElementRequestor) {
        this.references.processReferences(iSourceElementRequestor);
        this.processParameterInitializersAndArrayMods(iSourceElementRequestor);
        if (this.getReturnType() != null) {
            this.getReturnType().acceptElement(iSourceElementRequestor);
        }
        if (this.getExceptionSpec() != null) {
            this.getExceptionSpec().acceptElement(iSourceElementRequestor);
        }
    }

    protected void processParameterInitializersAndArrayMods(ISourceElementRequestor iSourceElementRequestor) {
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator.next();
            if (iASTParameterDeclaration.getDefaultValue() != null) {
                iASTParameterDeclaration.getDefaultValue().acceptElement(iSourceElementRequestor);
            }
            Iterator iterator2 = iASTParameterDeclaration.getArrayModifiers();
            while (iterator2.hasNext()) {
                ((IASTArrayModifier)iterator2.next()).acceptElement(iSourceElementRequestor);
            }
        }
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor) {
        try {
            iSourceElementRequestor.enterFunctionBody(this);
        }
        catch (Exception exception) {}
        this.functionCallbacks(iSourceElementRequestor);
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor) {
        try {
            iSourceElementRequestor.exitFunctionBody(this);
        }
        catch (Exception exception) {}
    }

    public IASTCodeScope getOwnerCodeScope() {
        return this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration() instanceof IASTCodeScope ? (IASTCodeScope)((Object)this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration()) : null;
    }

    public boolean previouslyDeclared() {
        return this.previouslyDeclared;
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.offsets.setNameEndOffsetAndLineNumber(n, n2);
    }

    public void setHasFunctionTryBlock(boolean bl) {
        this.hasFunctionTryBlock = bl;
    }

    public boolean hasFunctionTryBlock() {
        return this.hasFunctionTryBlock;
    }

    public Iterator getDeclarations() {
        return this.declarations.iterator();
    }

    public void addDeclaration(IASTDeclaration iASTDeclaration) {
        this.declarations.add(iASTDeclaration);
    }

    public boolean takesVarArgs() {
        return ((IParameterizedSymbol)this.getSymbol()).hasVariableArgs();
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }

    public IASTFunction getContainingFunction() {
        return this;
    }
}

