/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ASTSimpleTypeSpecifier
extends ASTNode
implements IASTSimpleTypeSpecifier {
    private final List refs;
    private ISymbol symbol;
    private final boolean isTypename;
    private final String name;

    public ASTSimpleTypeSpecifier(ISymbol iSymbol, boolean bl, String string, List list) {
        this.symbol = iSymbol;
        this.isTypename = bl;
        this.name = string;
        this.refs = list;
    }

    public IASTSimpleTypeSpecifier.Type getType() {
        if (this.symbol.getType() == TypeInfo.t_int) {
            return IASTSimpleTypeSpecifier.Type.INT;
        }
        if (this.symbol.getType() == TypeInfo.t_double) {
            return IASTSimpleTypeSpecifier.Type.DOUBLE;
        }
        if (this.symbol.getType() == TypeInfo.t_float) {
            return IASTSimpleTypeSpecifier.Type.FLOAT;
        }
        if (this.symbol.getType() == TypeInfo.t_bool) {
            return IASTSimpleTypeSpecifier.Type.BOOL;
        }
        if (this.symbol.getType() == TypeInfo.t_type) {
            return IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME;
        }
        if (this.symbol.getType() == TypeInfo.t_char) {
            return IASTSimpleTypeSpecifier.Type.CHAR;
        }
        if (this.symbol.getType() == TypeInfo.t_void) {
            return IASTSimpleTypeSpecifier.Type.VOID;
        }
        if (this.symbol.getType() == TypeInfo.t_wchar_t) {
            return IASTSimpleTypeSpecifier.Type.WCHAR_T;
        }
        if (this.symbol.getType() == TypeInfo.t__Bool) {
            return IASTSimpleTypeSpecifier.Type._BOOL;
        }
        return IASTSimpleTypeSpecifier.Type.UNSPECIFIED;
    }

    public String getTypename() {
        return this.name;
    }

    public boolean isLong() {
        return this.symbol.getTypeInfo().checkBit(524288);
    }

    public boolean isShort() {
        return this.symbol.getTypeInfo().checkBit(262144);
    }

    public boolean isSigned() {
        return this.symbol.getTypeInfo().checkBit(0x1000000);
    }

    public boolean isUnsigned() {
        return this.symbol.getTypeInfo().checkBit(131072);
    }

    public boolean isTypename() {
        return this.isTypename;
    }

    public ISymbol getSymbol() {
        return this.symbol;
    }

    public List getReferences() {
        return this.refs;
    }

    public IASTTypeSpecifier getTypeSpecifier() {
        return (IASTTypeSpecifier)((Object)this.getSymbol().getTypeSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public boolean isComplex() {
        return this.symbol.getTypeInfo().checkBit(0x200000);
    }

    public boolean isImaginary() {
        return this.symbol.getTypeInfo().checkBit(0x400000);
    }
}

