/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public final class TemplateEngine {
    protected static TypeInfo instantiateTypeInfo(TypeInfo typeInfo, ITemplateSymbol iTemplateSymbol, Map map) throws ParserSymbolTableException {
        if (map == null) {
            return typeInfo;
        }
        if (typeInfo.isType(TypeInfo.t_type) && typeInfo.getTypeSymbol() instanceof IDeferredTemplateInstance) {
            IDeferredTemplateInstance iDeferredTemplateInstance = (IDeferredTemplateInstance)typeInfo.getTypeSymbol();
            TypeInfo typeInfo2 = new TypeInfo(typeInfo);
            typeInfo2.setTypeSymbol(iDeferredTemplateInstance.instantiate(iTemplateSymbol, map));
            return typeInfo2;
        }
        if (typeInfo.isType(TypeInfo.t_type) && typeInfo.getTypeSymbol().isType(TypeInfo.t_templateParameter) && map.containsKey(typeInfo.getTypeSymbol())) {
            TypeInfo typeInfo3 = new TypeInfo((TypeInfo)map.get(typeInfo.getTypeSymbol()));
            if (typeInfo.hasPtrOperators()) {
                LinkedList linkedList = new LinkedList(typeInfo.getPtrOperators());
                typeInfo3.addPtrOperator(linkedList);
            }
            if (typeInfo.checkBit(32768)) {
                typeInfo3.setBit(true, 32768);
            }
            if (typeInfo.checkBit(65536)) {
                typeInfo3.setBit(true, 65536);
            }
            return typeInfo3;
        }
        if (typeInfo.isType(TypeInfo.t_type) && typeInfo.getTypeSymbol().isType(TypeInfo.t_function)) {
            TypeInfo typeInfo4 = new TypeInfo(typeInfo);
            typeInfo4.setTypeSymbol(typeInfo.getTypeSymbol().instantiate(iTemplateSymbol, map));
            return typeInfo4;
        }
        return typeInfo;
    }

    protected static ITemplateSymbol matchTemplatePartialSpecialization(ITemplateSymbol iTemplateSymbol, List list) throws ParserSymbolTableException {
        int n;
        if (iTemplateSymbol == null) {
            return null;
        }
        List list2 = iTemplateSymbol.getSpecializations();
        int n2 = n = list2 != null ? list2.size() : 0;
        if (n == 0) {
            return iTemplateSymbol;
        }
        ISpecializedSymbol iSpecializedSymbol = null;
        boolean bl = true;
        Iterator iterator = list2.iterator();
        ISpecializedSymbol iSpecializedSymbol2 = null;
        List list3 = null;
        int n3 = n;
        while (n3 > 0) {
            iSpecializedSymbol2 = (ISpecializedSymbol)iterator.next();
            list3 = iSpecializedSymbol2.getArgumentList();
            if (list3 != null && list3.size() == list.size()) {
                Iterator iterator2 = list3.iterator();
                Iterator iterator3 = list.iterator();
                HashMap hashMap = new HashMap();
                TypeInfo typeInfo = null;
                TypeInfo typeInfo2 = null;
                boolean bl2 = true;
                int n4 = list3.size();
                while (n4 > 0) {
                    typeInfo = (TypeInfo)iterator2.next();
                    typeInfo2 = (TypeInfo)iterator3.next();
                    ISymbol iSymbol = iTemplateSymbol.getSymbolTable().newSymbol("");
                    iSymbol.setTypeInfo(typeInfo);
                    if (!TemplateEngine.deduceTemplateArgument(hashMap, iSymbol, typeInfo2)) {
                        bl2 = false;
                        break;
                    }
                    --n4;
                }
                if (bl2) {
                    n4 = TemplateEngine.orderSpecializations(iSpecializedSymbol, iSpecializedSymbol2);
                    if (n4 == 0) {
                        bl = false;
                    } else if (n4 < 0) {
                        iSpecializedSymbol = iSpecializedSymbol2;
                        bl = true;
                    }
                }
            }
            --n3;
        }
        if (!bl) {
            throw new ParserSymbolTableException(0);
        }
        return iSpecializedSymbol;
    }

    protected static boolean matchTemplateParameterAndArgument(ISymbol iSymbol, TypeInfo typeInfo) {
        if (!TemplateEngine.isValidArgument(iSymbol, typeInfo)) {
            return false;
        }
        if (iSymbol.getTypeInfo().getTemplateParameterType() == TypeInfo.t_typeName) {
            return true;
        }
        if (iSymbol.getTypeInfo().getTemplateParameterType() == TypeInfo.t_template) {
            ISymbol iSymbol2 = typeInfo.getTypeSymbol();
            if (!typeInfo.isType(TypeInfo.t_type) || iSymbol2 == null || !iSymbol2.isType(TypeInfo.t_template)) {
                return false;
            }
            IParameterizedSymbol iParameterizedSymbol = (IParameterizedSymbol)iSymbol;
            IParameterizedSymbol iParameterizedSymbol2 = (IParameterizedSymbol)iSymbol2;
            List list = iParameterizedSymbol.getParameterList();
            List list2 = iParameterizedSymbol2.getParameterList();
            if (list.size() != list2.size()) {
                return false;
            }
            Iterator iterator = list.iterator();
            Iterator iterator2 = list2.iterator();
            while (iterator.hasNext()) {
                ISymbol iSymbol3 = (ISymbol)iterator.next();
                ISymbol iSymbol4 = (ISymbol)iterator2.next();
                if (iSymbol3.getType() == iSymbol4.getType() && iSymbol3.getTypeInfo().getTemplateParameterType() == iSymbol4.getTypeInfo().getTemplateParameterType()) continue;
                return false;
            }
            return true;
        }
        ParserSymbolTable.Cost cost = null;
        try {
            cost = ParserSymbolTable.checkStandardConversionSequence(typeInfo, iSymbol.getTypeInfo());
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        return cost != null && cost.rank == -1;
    }

    private static boolean isValidArgument(ISymbol iSymbol, TypeInfo typeInfo) {
        if (iSymbol.getTypeInfo().getTemplateParameterType() == TypeInfo.t_typeName) {
            if (typeInfo.isType(TypeInfo.t_type) && typeInfo.getTypeSymbol() != null) {
                ISymbol iSymbol2 = typeInfo.getTypeSymbol();
                if (iSymbol2.getName().equals("")) {
                    return false;
                }
                if (TemplateEngine.hasNoLinkage(typeInfo)) {
                    return false;
                }
            }
        } else if (iSymbol.getTypeInfo().getTemplateParameterType() != TypeInfo.t_template) {
            TypeInfo.PtrOp ptrOp;
            TypeInfo.PtrOp ptrOp2;
            List list = iSymbol.getPtrOperators();
            TypeInfo.PtrOp ptrOp3 = ptrOp2 = list.size() > 0 ? (TypeInfo.PtrOp)list.get(0) : null;
            if (ptrOp2 != null && ptrOp2.getType() == TypeInfo.PtrOp.t_reference) {
                if (typeInfo.isType(TypeInfo.t_type) && typeInfo.getTypeSymbol() != null && typeInfo.getTypeSymbol().getName().equals("")) {
                    return false;
                }
                return TemplateEngine.hasExternalLinkage(typeInfo);
            }
            List list2 = typeInfo.getPtrOperators();
            TypeInfo.PtrOp ptrOp4 = ptrOp = list2.size() > 0 ? (TypeInfo.PtrOp)list2.get(0) : null;
            if (ptrOp != null && ptrOp.getType() == TypeInfo.PtrOp.t_pointer || typeInfo.isType(TypeInfo.t_type)) {
                ISymbol iSymbol3 = typeInfo.getTypeSymbol();
                if (iSymbol3 != null && iSymbol3.getContainingSymbol().isType(TypeInfo.t_class, TypeInfo.t_union) && !iSymbol3.isType(TypeInfo.t_class, TypeInfo.t_union) && !iSymbol3.getTypeInfo().checkBit(128)) {
                    return false;
                }
                return TemplateEngine.hasExternalLinkage(typeInfo);
            }
            if (ptrOp2 == null && (typeInfo.isType(TypeInfo.t_bool, TypeInfo.t_int) || typeInfo.isType(TypeInfo.t_enumerator))) {
                return true;
            }
            return typeInfo.isType(TypeInfo.t_templateParameter) && typeInfo.getTemplateParameterType() != TypeInfo.t_typeName && typeInfo.getTemplateParameterType() != TypeInfo.t_template;
        }
        return true;
    }

    protected static boolean hasExternalLinkage(TypeInfo typeInfo) {
        if (!typeInfo.isType(TypeInfo.t_type)) {
            return false;
        }
        return !TemplateEngine.hasNoLinkage(typeInfo);
    }

    protected static boolean hasInternalLinkage(TypeInfo typeInfo) {
        return !TemplateEngine.hasNoLinkage(typeInfo);
    }

    protected static boolean hasNoLinkage(TypeInfo typeInfo) {
        if (typeInfo.isType(TypeInfo.t_type)) {
            ISymbol iSymbol = typeInfo.getTypeSymbol();
            if (iSymbol.getContainingSymbol() == null) {
                return true;
            }
            return iSymbol.getContainingSymbol().isType(TypeInfo.t_function);
        }
        return false;
    }

    private static TypeInfo getParameterTypeForDeduction(ISymbol iSymbol) {
        TypeInfo typeInfo = new TypeInfo(iSymbol.getTypeInfo());
        List list = typeInfo.getPtrOperators();
        if (list.size() > 0) {
            TypeInfo.PtrOp ptrOp = (TypeInfo.PtrOp)list.get(0);
            if (ptrOp.getType() == TypeInfo.PtrOp.t_reference || ptrOp.getType() == TypeInfo.PtrOp.t_undef) {
                list.remove(0);
            } else {
                TypeInfo.PtrOp ptrOp2 = new TypeInfo.PtrOp(ptrOp.getType(), false, false);
                list.set(0, ptrOp2);
            }
        } else {
            typeInfo.setBit(false, 32768);
            typeInfo.setBit(false, 65536);
        }
        return typeInfo;
    }

    private static TypeInfo getArgumentTypeForDeduction(TypeInfo typeInfo, boolean bl) {
        TypeInfo typeInfo2 = ParserSymbolTable.getFlatTypeInfo(typeInfo);
        if (!bl) {
            List list = typeInfo2.getPtrOperators();
            ISymbol iSymbol = typeInfo2.getTypeSymbol();
            if (typeInfo2.getType() == TypeInfo.t_type && iSymbol.isType(TypeInfo.t_function) && list.size() == 0) {
                list.add(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
            }
            if (list.size() > 0) {
                TypeInfo.PtrOp ptrOp = (TypeInfo.PtrOp)list.get(0);
                if (ptrOp.getType() == TypeInfo.PtrOp.t_array) {
                    list.set(0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, false));
                } else {
                    list.set(0, new TypeInfo.PtrOp(ptrOp.getType(), false, false));
                }
            } else {
                typeInfo2.setBit(false, 32768);
                typeInfo2.setBit(false, 65536);
            }
        }
        return typeInfo2;
    }

    private static List getSourceList(ISymbol iSymbol) {
        ITemplateSymbol iTemplateSymbol = null;
        if (iSymbol instanceof IDeferredTemplateInstance) {
            IDeferredTemplateInstance iDeferredTemplateInstance = (IDeferredTemplateInstance)iSymbol;
            return iDeferredTemplateInstance.getArguments();
        }
        ISymbol iSymbol2 = iSymbol.getInstantiatedSymbol();
        iTemplateSymbol = (ITemplateSymbol)iSymbol2.getContainingSymbol();
        if (iTemplateSymbol instanceof ISpecializedSymbol) {
            return ((ISpecializedSymbol)iTemplateSymbol).getArgumentList();
        }
        return iTemplateSymbol.getParameterList();
    }

    private static List getTargetList(ISymbol iSymbol) {
        if (iSymbol instanceof IDeferredTemplateInstance) {
            IDeferredTemplateInstance iDeferredTemplateInstance = (IDeferredTemplateInstance)iSymbol;
            return iDeferredTemplateInstance.getArguments();
        }
        ISymbol iSymbol2 = iSymbol.getInstantiatedSymbol();
        ITemplateSymbol iTemplateSymbol = (ITemplateSymbol)iSymbol2.getContainingSymbol();
        return iTemplateSymbol.findArgumentsFor((IContainerSymbol)iSymbol);
    }

    private static ISymbol findMatchingBaseClass(ISymbol iSymbol, IDerivableContainerSymbol iDerivableContainerSymbol) {
        ISymbol iSymbol2 = null;
        ITemplateSymbol iTemplateSymbol = null;
        ITemplateSymbol iTemplateSymbol2 = null;
        iTemplateSymbol = iSymbol instanceof IDeferredTemplateInstance ? ((IDeferredTemplateInstance)iSymbol).getTemplate() : (ITemplateSymbol)iSymbol.getInstantiatedSymbol().getContainingSymbol();
        if (iTemplateSymbol instanceof ISpecializedSymbol) {
            iTemplateSymbol = ((ISpecializedSymbol)iTemplateSymbol).getPrimaryTemplate();
        }
        Iterator iterator = iDerivableContainerSymbol.getParents().iterator();
        while (iterator.hasNext()) {
            IDerivableContainerSymbol.IParentSymbol iParentSymbol = (IDerivableContainerSymbol.IParentSymbol)iterator.next();
            ISymbol iSymbol3 = iParentSymbol.getParent();
            if (iSymbol3 instanceof IDeferredTemplateInstance) {
                IDeferredTemplateInstance iDeferredTemplateInstance = (IDeferredTemplateInstance)iSymbol3;
                iTemplateSymbol2 = iDeferredTemplateInstance.getTemplate();
                if (iTemplateSymbol2 instanceof ISpecializedSymbol) {
                    iTemplateSymbol2 = ((ISpecializedSymbol)iTemplateSymbol2).getPrimaryTemplate();
                }
                if (iTemplateSymbol == iTemplateSymbol2) {
                    iSymbol2 = iSymbol3;
                    break;
                }
            } else {
                iTemplateSymbol2 = (ITemplateSymbol)iSymbol3.getInstantiatedSymbol().getContainingSymbol();
                if (iTemplateSymbol2 instanceof ISpecializedSymbol) {
                    iTemplateSymbol2 = ((ISpecializedSymbol)iTemplateSymbol2).getPrimaryTemplate();
                }
                if (iTemplateSymbol == iTemplateSymbol2) {
                    iSymbol2 = iSymbol3;
                    break;
                }
                iSymbol2 = TemplateEngine.findMatchingBaseClass(iSymbol, (IDerivableContainerSymbol)iSymbol3);
            }
            if (iSymbol2 == null) continue;
            return iSymbol2;
        }
        return iSymbol2;
    }

    private static boolean deduceTemplateArgument(Map map, ISymbol iSymbol, TypeInfo typeInfo) {
        boolean bl = false;
        Iterator iterator = iSymbol.getPtrOperators().iterator();
        if (iterator.hasNext() && ((TypeInfo.PtrOp)iterator.next()).getType() == TypeInfo.PtrOp.t_reference) {
            bl = true;
        }
        TypeInfo typeInfo2 = TemplateEngine.getParameterTypeForDeduction(iSymbol);
        typeInfo = TemplateEngine.getArgumentTypeForDeduction(typeInfo, bl);
        if (typeInfo2.isType(TypeInfo.t_type)) {
            ISymbol iSymbol2 = typeInfo2.getTypeSymbol();
            ISymbol iSymbol3 = typeInfo.getTypeSymbol();
            if (iSymbol2 instanceof IDeferredTemplateInstance || iSymbol2.isTemplateInstance()) {
                return TemplateEngine.deduceFromTemplateTemplateArguments(map, iSymbol2, iSymbol3);
            }
            if (iSymbol2.isType(TypeInfo.t_templateParameter)) {
                if (iSymbol2.getTypeInfo().getTemplateParameterType() == TypeInfo.t_typeName) {
                    List list = typeInfo.getPtrOperators();
                    List list2 = typeInfo2.getPtrOperators();
                    if (list2 != null && list2.size() > 0) {
                        if (list == null) {
                            return false;
                        }
                        Iterator iterator2 = list2.iterator();
                        ListIterator listIterator = list.listIterator();
                        TypeInfo.PtrOp ptrOp = null;
                        TypeInfo.PtrOp ptrOp2 = null;
                        while (iterator2.hasNext()) {
                            ptrOp = (TypeInfo.PtrOp)iterator2.next();
                            if (!listIterator.hasNext()) {
                                return false;
                            }
                            ptrOp2 = (TypeInfo.PtrOp)listIterator.next();
                            if (ptrOp.getType() == ptrOp2.getType()) {
                                if (!ptrOp.equals(ptrOp2)) {
                                    return false;
                                }
                                listIterator.remove();
                                continue;
                            }
                            return false;
                        }
                    }
                    if (typeInfo2.checkBit(32768)) {
                        if (!typeInfo.checkBit(32768)) {
                            return false;
                        }
                        typeInfo.setBit(false, 32768);
                    }
                    if (typeInfo2.checkBit(65536)) {
                        if (!typeInfo.checkBit(65536)) {
                            return false;
                        }
                        typeInfo.setBit(false, 65536);
                    }
                    return TemplateEngine.deduceArgument(map, iSymbol2, typeInfo);
                }
                if (iSymbol2.getTypeInfo().getTemplateParameterType() != TypeInfo.t_template) {
                    if (iSymbol2.getTypeInfo().getTemplateParameterType() == typeInfo.getType()) {
                        return TemplateEngine.deduceArgument(map, iSymbol2, typeInfo);
                    }
                    return false;
                }
            } else if (iSymbol2.isType(TypeInfo.t_function)) {
                Object object;
                Object object2;
                if (!(iSymbol3 instanceof IParameterizedSymbol) || !iSymbol3.isType(TypeInfo.t_function)) {
                    return false;
                }
                IParameterizedSymbol iParameterizedSymbol = (IParameterizedSymbol)iSymbol2;
                IParameterizedSymbol iParameterizedSymbol2 = (IParameterizedSymbol)iSymbol3;
                if (!TemplateEngine.deduceTemplateArgument(map, iParameterizedSymbol.getReturnType(), iParameterizedSymbol2.getReturnType().getTypeInfo())) {
                    return false;
                }
                List list = typeInfo2.getPtrOperators();
                if (list.size() != 0 && ((TypeInfo.PtrOp)(object2 = (TypeInfo.PtrOp)list.iterator().next())).getType() == TypeInfo.PtrOp.t_memberPointer) {
                    object = new TypeInfo(TypeInfo.t_type, 0, iParameterizedSymbol2.getContainingSymbol());
                    if (!TemplateEngine.deduceTemplateArgument(map, ((TypeInfo.PtrOp)object2).getMemberOf(), (TypeInfo)object)) {
                        return false;
                    }
                }
                object2 = iParameterizedSymbol.getParameterList();
                object = iParameterizedSymbol2.getParameterList();
                if (object2.size() != object.size()) {
                    return false;
                }
                Iterator iterator3 = object2.iterator();
                Iterator iterator4 = object.iterator();
                while (iterator3.hasNext()) {
                    TypeInfo typeInfo3 = ((ISymbol)iterator4.next()).getTypeInfo();
                    if (TemplateEngine.deduceTemplateArgument(map, (ISymbol)iterator3.next(), typeInfo3)) continue;
                    return false;
                }
                return true;
            }
        } else {
            if (typeInfo2.isType(TypeInfo.t_templateParameter)) {
                return TemplateEngine.deduceArgument(map, iSymbol, typeInfo);
            }
            if (typeInfo2.getType() == typeInfo.getType()) {
                if (typeInfo2.getDefault() != null) {
                    return typeInfo2.getDefault().equals(typeInfo.getDefault());
                }
                return true;
            }
        }
        return false;
    }

    private static boolean deduceFromTemplateTemplateArguments(Map map, ISymbol iSymbol, ISymbol iSymbol2) {
        IContainerSymbol iContainerSymbol;
        ITemplateSymbol iTemplateSymbol;
        ITemplateSymbol iTemplateSymbol2 = iTemplateSymbol = iSymbol instanceof IDeferredTemplateInstance ? ((IDeferredTemplateInstance)iSymbol).getTemplate() : (ITemplateSymbol)iSymbol.getInstantiatedSymbol().getContainingSymbol();
        if (iTemplateSymbol instanceof ISpecializedSymbol) {
            iTemplateSymbol = ((ISpecializedSymbol)iTemplateSymbol).getPrimaryTemplate();
        }
        IContainerSymbol iContainerSymbol2 = iContainerSymbol = iSymbol2.isTemplateInstance() ? iSymbol2.getInstantiatedSymbol().getContainingSymbol() : iSymbol2.getContainingSymbol();
        if (iContainerSymbol instanceof ISpecializedSymbol) {
            iContainerSymbol = ((ISpecializedSymbol)iContainerSymbol).getPrimaryTemplate();
        }
        if (iTemplateSymbol != iContainerSymbol && (iSymbol2 = iSymbol2 instanceof IDerivableContainerSymbol ? TemplateEngine.findMatchingBaseClass(iSymbol, (IDerivableContainerSymbol)iSymbol2) : null) == null) {
            return false;
        }
        List list = TemplateEngine.getSourceList(iSymbol);
        List list2 = TemplateEngine.getTargetList(iSymbol2);
        if (list == null || list2 == null || list.size() != list2.size()) {
            return false;
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ISymbol iSymbol3 = null;
            if (e instanceof ISymbol) {
                iSymbol3 = (ISymbol)e;
            } else {
                iSymbol3 = iSymbol.getSymbolTable().newSymbol("");
                iSymbol3.setTypeInfo((TypeInfo)e);
            }
            TypeInfo typeInfo = TemplateEngine.transformTypeInfo(iterator2.next(), null);
            if (TemplateEngine.deduceTemplateArgument(map, iSymbol3, typeInfo)) continue;
            return false;
        }
        return true;
    }

    private static Map deduceTemplateArgumentsUsingParameterList(ITemplateSymbol iTemplateSymbol, IParameterizedSymbol iParameterizedSymbol) {
        List list = iParameterizedSymbol.getParameterList();
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ISymbol iSymbol = (ISymbol)iterator.next();
            linkedList.add(iSymbol.getTypeInfo());
        }
        return TemplateEngine.deduceTemplateArguments(iTemplateSymbol, linkedList);
    }

    private static Map deduceTemplateArguments(ITemplateSymbol iTemplateSymbol, List list) {
        if (iTemplateSymbol.getContainedSymbols() == null || iTemplateSymbol.getContainedSymbols().size() != 1) {
            return null;
        }
        Iterator iterator = iTemplateSymbol.getContainedSymbols().keySet().iterator();
        ISymbol iSymbol = (ISymbol)iTemplateSymbol.getContainedSymbols().get(iterator.next());
        if (!iSymbol.isType(TypeInfo.t_function)) {
            return null;
        }
        IParameterizedSymbol iParameterizedSymbol = (IParameterizedSymbol)iSymbol;
        List list2 = iParameterizedSymbol.getParameterList();
        if (list2 == null || list == null || list2.size() != list.size()) {
            return null;
        }
        HashMap hashMap = new HashMap();
        Iterator iterator2 = list2.iterator();
        Iterator iterator3 = list.iterator();
        while (iterator2.hasNext()) {
            if (TemplateEngine.deduceTemplateArgument(hashMap, (ISymbol)iterator2.next(), (TypeInfo)iterator3.next())) continue;
            return null;
        }
        return hashMap;
    }

    private static boolean deduceArgument(Map map, ISymbol iSymbol, TypeInfo typeInfo) {
        typeInfo = ParserSymbolTable.getFlatTypeInfo(typeInfo);
        if (map.containsKey(iSymbol)) {
            TypeInfo typeInfo2 = (TypeInfo)map.get(iSymbol);
            return typeInfo2.equals(typeInfo);
        }
        map.put(iSymbol, typeInfo);
        return true;
    }

    private static int orderSpecializations(ISpecializedSymbol iSpecializedSymbol, ISpecializedSymbol iSpecializedSymbol2) throws ParserSymbolTableException {
        if (iSpecializedSymbol == null) {
            return -1;
        }
        Iterator iterator = iSpecializedSymbol.getContainedSymbols().keySet().iterator();
        ISymbol iSymbol = (ISymbol)iSpecializedSymbol.getContainedSymbols().get(iterator.next());
        ITemplateSymbol iTemplateSymbol = iSpecializedSymbol;
        ITemplateSymbol iTemplateSymbol2 = iSpecializedSymbol2;
        if (iSymbol.isType(TypeInfo.t_class)) {
            iTemplateSymbol = TemplateEngine.classTemplateSpecializationToFunctionTemplate(iSpecializedSymbol);
            iTemplateSymbol2 = TemplateEngine.classTemplateSpecializationToFunctionTemplate(iSpecializedSymbol2);
        }
        return TemplateEngine.orderTemplateFunctions(iTemplateSymbol, iTemplateSymbol2);
    }

    protected static int orderTemplateFunctions(ITemplateSymbol iTemplateSymbol, ITemplateSymbol iTemplateSymbol2) throws ParserSymbolTableException {
        boolean bl;
        Map map = TemplateEngine.createMapForFunctionTemplateOrdering(iTemplateSymbol);
        IContainerSymbol iContainerSymbol = iTemplateSymbol.getTemplatedSymbol();
        if (!(iContainerSymbol instanceof IParameterizedSymbol)) {
            throw new ParserSymbolTableError(-1);
        }
        IParameterizedSymbol iParameterizedSymbol = (IParameterizedSymbol)iContainerSymbol;
        iParameterizedSymbol = (IParameterizedSymbol)iParameterizedSymbol.instantiate(iTemplateSymbol, map);
        Map map2 = TemplateEngine.deduceTemplateArgumentsUsingParameterList(iTemplateSymbol2, iParameterizedSymbol);
        map = TemplateEngine.createMapForFunctionTemplateOrdering(iTemplateSymbol2);
        iContainerSymbol = iTemplateSymbol2.getTemplatedSymbol();
        if (!(iContainerSymbol instanceof IParameterizedSymbol)) {
            throw new ParserSymbolTableError(-1);
        }
        iParameterizedSymbol = (IParameterizedSymbol)iContainerSymbol;
        iParameterizedSymbol = (IParameterizedSymbol)iParameterizedSymbol.instantiate(iTemplateSymbol2, map);
        Map map3 = TemplateEngine.deduceTemplateArgumentsUsingParameterList(iTemplateSymbol, iParameterizedSymbol);
        boolean bl2 = map2 != null;
        boolean bl3 = bl = map3 != null;
        if (bl2 && bl || !bl2 && !bl) {
            return 0;
        }
        if (bl2 && !bl) {
            return 1;
        }
        return -1;
    }

    private static Map createMapForFunctionTemplateOrdering(ITemplateSymbol iTemplateSymbol) {
        HashMap<ISymbol, TypeInfo> hashMap = new HashMap<ISymbol, TypeInfo>();
        TypeInfo typeInfo = null;
        List list = iTemplateSymbol.getParameterList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ISymbol iSymbol = (ISymbol)iterator.next();
            if (iSymbol.getTypeInfo().getTemplateParameterType() == TypeInfo.t_typeName) {
                typeInfo = new TypeInfo(TypeInfo.t_type, 0, iTemplateSymbol.getSymbolTable().newSymbol("", TypeInfo.t_class));
            } else if (iSymbol.getTypeInfo().getTemplateParameterType() != TypeInfo.t_template) {
                typeInfo = new TypeInfo(iSymbol.getTypeInfo().getTemplateParameterType(), 0, null);
            }
            hashMap.put(iSymbol, typeInfo);
        }
        return hashMap;
    }

    private static ITemplateSymbol classTemplateSpecializationToFunctionTemplate(ISpecializedSymbol iSpecializedSymbol) throws ParserSymbolTableException {
        ISpecializedSymbol iSpecializedSymbol2 = (ISpecializedSymbol)iSpecializedSymbol.clone();
        iSpecializedSymbol2.getArgumentList().clear();
        iSpecializedSymbol2.getContainedSymbols().clear();
        ((ContainerSymbol)((Object)iSpecializedSymbol2)).getContents().clear();
        IParameterizedSymbol iParameterizedSymbol = iSpecializedSymbol.getSymbolTable().newParameterizedSymbol(iSpecializedSymbol2.getName(), TypeInfo.t_function);
        try {
            iSpecializedSymbol2.addSymbol(iParameterizedSymbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        ISymbol iSymbol = iSpecializedSymbol.getSymbolTable().newSymbol("", TypeInfo.t_type);
        LinkedList linkedList = new LinkedList(iSpecializedSymbol.getArgumentList());
        iSymbol.setTypeSymbol(iSpecializedSymbol.instantiate(linkedList));
        iParameterizedSymbol.addParameter(iSymbol);
        return iSpecializedSymbol2;
    }

    private static TypeInfo transformTypeInfo(Object object, Map map) {
        TypeInfo typeInfo = null;
        typeInfo = object instanceof ISymbol ? new TypeInfo(TypeInfo.t_type, 0, (ISymbol)object) : (TypeInfo)object;
        if (map == null) {
            return typeInfo;
        }
        if (typeInfo.isType(TypeInfo.t_type) && typeInfo.getTypeSymbol().isType(TypeInfo.t_templateParameter) && map.containsKey(typeInfo.getTypeSymbol())) {
            TypeInfo typeInfo2 = new TypeInfo((TypeInfo)map.get(typeInfo.getTypeSymbol()));
            if (typeInfo.hasPtrOperators()) {
                typeInfo2.addPtrOperator(typeInfo.getPtrOperators());
            }
            return typeInfo2;
        }
        return typeInfo;
    }

    protected static List selectTemplateFunctions(Set set, List list) throws ParserSymbolTableException {
        if (set == null || set.size() == 0) {
            return null;
        }
        LinkedList<IContainerSymbol> linkedList = new LinkedList<IContainerSymbol>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IParameterizedSymbol iParameterizedSymbol = (IParameterizedSymbol)iterator.next();
            ITemplateSymbol iTemplateSymbol = (ITemplateSymbol)iParameterizedSymbol.getContainingSymbol();
            Map map = TemplateEngine.deduceTemplateArguments(iTemplateSymbol, list);
            if (map == null) continue;
            Iterator iterator2 = iTemplateSymbol.getParameterList().iterator();
            LinkedList linkedList2 = new LinkedList();
            while (iterator2.hasNext()) {
                linkedList2.add(map.get(iterator2.next()));
            }
            IContainerSymbol iContainerSymbol = (IContainerSymbol)iTemplateSymbol.instantiate(linkedList2);
            if (iContainerSymbol == null) continue;
            linkedList.add(iContainerSymbol);
        }
        return linkedList;
    }

    protected static ITemplateSymbol selectTemplateOrSpecialization(ITemplateSymbol iTemplateSymbol, List list, List list2) throws ParserSymbolTableException {
        if (iTemplateSymbol != null) {
            Object object;
            Object object2;
            boolean bl = true;
            if (list.size() == 0) {
                bl = false;
            } else if (list2 != null) {
                if (list2.size() != list.size()) {
                    bl = false;
                } else if (!list.isEmpty()) {
                    object2 = list.iterator();
                    object = list2.iterator();
                    while (object2.hasNext()) {
                        if (object2.next() == ((TypeInfo)object.next()).getTypeSymbol()) continue;
                        bl = false;
                        break;
                    }
                }
            }
            object2 = iTemplateSymbol;
            if (bl) {
                if (TemplateEngine.checkTemplateParameterListsAreEquivalent(object2.getParameterList(), list)) {
                    return iTemplateSymbol;
                }
                throw new ParserSymbolTableException(9);
            }
            if (list.isEmpty()) {
                return object2;
            }
            object = TemplateEngine.findPartialSpecialization(iTemplateSymbol, list, list2);
            if (object != null) {
                return object;
            }
            throw new ParserSymbolTableException(4);
        }
        return null;
    }

    private static boolean checkTemplateParameterListsAreEquivalent(List list, List list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            ISymbol iSymbol = (ISymbol)iterator.next();
            ISymbol iSymbol2 = (ISymbol)iterator2.next();
            if (iSymbol.getTypeInfo().getTemplateParameterType() == iSymbol2.getTypeInfo().getTemplateParameterType()) continue;
            return false;
        }
        return true;
    }

    private static boolean checkTemplateArgumentListsAreEquivalent(List list, List list2, List list3, List list4) {
        Iterator iterator;
        if (list3.size() != list4.size() || list.size() != list2.size()) {
            return false;
        }
        Map[] mapArray = new Map[]{new HashMap(), new HashMap()};
        Object object = list;
        while (object != null) {
            iterator = object.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                mapArray[object == list2 ? 1 : 0].put(iterator.next(), new Integer(n++));
            }
            if (object == list2) break;
            object = list2;
        }
        object = list3.iterator();
        iterator = list4.iterator();
        while (object.hasNext()) {
            TypeInfo typeInfo;
            TypeInfo typeInfo2 = (TypeInfo)object.next();
            if (typeInfo2.equals(typeInfo = (TypeInfo)iterator.next())) continue;
            if (typeInfo2.isType(TypeInfo.t_type) && typeInfo.isType(TypeInfo.t_type)) {
                ISymbol iSymbol = typeInfo2.getTypeSymbol();
                ISymbol iSymbol2 = typeInfo.getTypeSymbol();
                if (mapArray[0].containsKey(iSymbol) && mapArray[1].containsKey(iSymbol2) && mapArray[0].get(iSymbol).equals(mapArray[1].get(iSymbol2))) continue;
            }
            return false;
        }
        return true;
    }

    private static ISpecializedSymbol findPartialSpecialization(ITemplateSymbol iTemplateSymbol, List list, List list2) {
        Iterator iterator = iTemplateSymbol.getSpecializations().iterator();
        ISpecializedSymbol iSpecializedSymbol = null;
        while (iterator.hasNext()) {
            iSpecializedSymbol = (ISpecializedSymbol)iterator.next();
            if (!TemplateEngine.checkTemplateParameterListsAreEquivalent(iSpecializedSymbol.getParameterList(), list) || !TemplateEngine.checkTemplateArgumentListsAreEquivalent(iSpecializedSymbol.getParameterList(), list, iSpecializedSymbol.getArgumentList(), list2)) continue;
            return iSpecializedSymbol;
        }
        return null;
    }

    protected static ISymbol translateParameterForDefinition(ISymbol iSymbol, ISymbol iSymbol2, Map map) {
        if (map == null) {
            return iSymbol2;
        }
        ISymbol iSymbol3 = iSymbol2;
        while (iSymbol3.isTemplateInstance()) {
            iSymbol3 = iSymbol3.getInstantiatedSymbol();
        }
        if (map.containsKey(iSymbol)) {
            Map map2 = (Map)map.get(iSymbol);
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                ISymbol iSymbol4 = (ISymbol)iterator.next();
                if (map2.get(iSymbol4) != iSymbol3) continue;
                return iSymbol4;
            }
        }
        return iSymbol2;
    }

    protected static ISymbol instantiateWithinTemplateScope(IContainerSymbol iContainerSymbol, ITemplateSymbol iTemplateSymbol) {
        if (iTemplateSymbol.getTemplatedSymbol().isType(TypeInfo.t_function)) {
            return iTemplateSymbol;
        }
        ISymbol iSymbol = null;
        IContainerSymbol iContainerSymbol2 = iContainerSymbol.getContainingSymbol();
        boolean bl = false;
        while (iContainerSymbol2 != null) {
            if (iContainerSymbol2 == iTemplateSymbol) {
                bl = true;
                break;
            }
            if (((iContainerSymbol2 = iContainerSymbol2.getContainingSymbol()) == null || iContainerSymbol2.isTemplateMember()) && iContainerSymbol2.isType(TypeInfo.t_template)) continue;
            iContainerSymbol2 = null;
        }
        if (bl) {
            if (iTemplateSymbol instanceof ISpecializedSymbol) {
                ISpecializedSymbol iSpecializedSymbol = (ISpecializedSymbol)iTemplateSymbol;
                iSymbol = iSpecializedSymbol.deferredInstance(iSpecializedSymbol.getArgumentList());
            } else {
                ITemplateSymbol iTemplateSymbol2 = iTemplateSymbol;
                Iterator iterator = iTemplateSymbol2.getParameterList().iterator();
                LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
                while (iterator.hasNext()) {
                    linkedList.add(new TypeInfo(TypeInfo.t_type, 0, (ISymbol)iterator.next()));
                }
                iSymbol = iTemplateSymbol2.deferredInstance(linkedList);
            }
        }
        return iSymbol != null ? iSymbol : (ISymbol)iTemplateSymbol;
    }

    protected static boolean alreadyHasTemplateParameter(IContainerSymbol iContainerSymbol, String string) {
        while (iContainerSymbol != null) {
            ITemplateSymbol iTemplateSymbol;
            if (iContainerSymbol instanceof ITemplateSymbol && (iTemplateSymbol = (ITemplateSymbol)iContainerSymbol).getParameterMap().containsKey(string)) {
                return true;
            }
            iContainerSymbol = iContainerSymbol.getContainingSymbol();
        }
        return false;
    }

    protected static boolean canAddTemplate(IContainerSymbol iContainerSymbol, ITemplateSymbol iTemplateSymbol) {
        IContainerSymbol iContainerSymbol2;
        if (!iContainerSymbol.isType(TypeInfo.t_namespace) && !iContainerSymbol.isType(TypeInfo.t_class, TypeInfo.t_union)) {
            return false;
        }
        return !iContainerSymbol.isTemplateMember() || !iContainerSymbol.getContainingSymbol().isType(TypeInfo.t_template) || (iContainerSymbol2 = iTemplateSymbol.getTemplatedSymbol()) == null || !iContainerSymbol2.isType(TypeInfo.t_function) || !iContainerSymbol2.getTypeInfo().checkBit(2048);
    }

    protected static List verifyExplicitArguments(ITemplateSymbol iTemplateSymbol, List list, ISymbol iSymbol) throws ParserSymbolTableException {
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        Iterator iterator = iTemplateSymbol.getParameterList().iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            ISymbol iSymbol2 = (ISymbol)iterator.next();
            if (iterator2.hasNext()) {
                object = (TypeInfo)iterator2.next();
                if (TemplateEngine.matchTemplateParameterAndArgument(iSymbol2, (TypeInfo)object)) {
                    linkedList.add((TypeInfo)object);
                    continue;
                }
                throw new ParserSymbolTableException(8);
            }
            if (!(iTemplateSymbol.getTemplatedSymbol() instanceof IParameterizedSymbol) || !(iSymbol instanceof IParameterizedSymbol) || !iTemplateSymbol.getTemplatedSymbol().getName().equals(iSymbol.getName())) continue;
            object = TemplateEngine.deduceTemplateArgumentsUsingParameterList(iTemplateSymbol, (IParameterizedSymbol)iSymbol);
            if (object != null && object.containsKey(iSymbol2)) {
                linkedList.add((TypeInfo)object.get(iSymbol2));
                continue;
            }
            throw new ParserSymbolTableException(8);
        }
        return linkedList;
    }

    protected static ITemplateSymbol resolveTemplateFunctions(Set set, List list, ISymbol iSymbol) throws ParserSymbolTableException {
        ITemplateSymbol iTemplateSymbol = null;
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext()) {
            IParameterizedSymbol iParameterizedSymbol = (IParameterizedSymbol)iterator.next();
            ITemplateSymbol iTemplateSymbol2 = (ITemplateSymbol)iParameterizedSymbol.getContainingSymbol();
            Map map = TemplateEngine.deduceTemplateArgumentsUsingParameterList(iTemplateSymbol2, (IParameterizedSymbol)iSymbol);
            if (map == null) continue;
            Iterator iterator2 = iTemplateSymbol2.getParameterList().iterator();
            Iterator iterator3 = list.iterator();
            while (iterator2.hasNext() && iterator3.hasNext()) {
                ISymbol iSymbol2 = (ISymbol)iterator2.next();
                TypeInfo typeInfo = (TypeInfo)iterator3.next();
                if (!map.containsKey(iSymbol2) ? !TemplateEngine.matchTemplateParameterAndArgument(iSymbol2, typeInfo) : !map.get(iSymbol2).equals(typeInfo)) continue block0;
            }
            if (iTemplateSymbol != null) {
                throw new ParserSymbolTableException(0);
            }
            iTemplateSymbol = iTemplateSymbol2;
        }
        return iTemplateSymbol;
    }

    protected static ISymbol checkForTemplateExplicitSpecialization(ITemplateSymbol iTemplateSymbol, ISymbol iSymbol, List list) {
        if (!iTemplateSymbol.getExplicitSpecializations().isEmpty()) {
            Iterator iterator = iTemplateSymbol.getExplicitSpecializations().keySet().iterator();
            List list2 = null;
            while (iterator.hasNext()) {
                Map map;
                list2 = (List)iterator.next();
                if (!list2.equals(list) || !(map = (Map)iTemplateSymbol.getExplicitSpecializations().get(list2)).containsKey(iSymbol)) continue;
                return (ISymbol)map.get(iSymbol);
            }
        }
        return null;
    }
}

