/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BaseCElementContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers = false;
    protected boolean fProvideWorkingCopy = false;

    public BaseCElementContentProvider() {
    }

    public BaseCElementContentProvider(boolean bl, boolean bl2) {
        this.fProvideMembers = bl;
        this.fProvideWorkingCopy = bl2;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean bl) {
        this.fProvideMembers = bl;
    }

    public void setProvideWorkingCopy(boolean bl) {
        this.fProvideWorkingCopy = bl;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object object) {
        if (object instanceof ICElement) {
            ICElement iCElement = (ICElement)object;
            if (iCElement instanceof ICModel) {
                return this.getCProjects((ICModel)iCElement);
            }
            if (iCElement instanceof ICProject) {
                return this.getCProjectResources((ICProject)iCElement);
            }
            if (iCElement instanceof ICContainer) {
                return this.getCResources((ICContainer)iCElement);
            }
            if (iCElement instanceof ITranslationUnit) {
                if (this.fProvideMembers) {
                    ITranslationUnit iTranslationUnit;
                    IWorkingCopy iWorkingCopy;
                    if (this.fProvideWorkingCopy && !(iCElement instanceof IWorkingCopy) && (iWorkingCopy = (iTranslationUnit = (ITranslationUnit)iCElement).findSharedWorkingCopy(CUIPlugin.getBufferFactory())) != null) {
                        return ((IParent)iWorkingCopy).getChildren();
                    }
                    return ((IParent)iCElement).getChildren();
                }
            } else if (iCElement instanceof IParent) {
                return ((IParent)iCElement).getChildren();
            }
        }
        return this.getResources(object);
    }

    public boolean hasChildren(Object object) {
        if (this.fProvideMembers) {
            if (object instanceof IBinary || object instanceof ITranslationUnit || object instanceof IArchive) {
                return true;
            }
        } else if (object instanceof ITranslationUnit || object instanceof IBinary || object instanceof IArchive) {
            return false;
        }
        if (object instanceof ICProject) {
            ICProject iCProject = (ICProject)object;
            return iCProject.getProject().isOpen();
        }
        if (object instanceof ICContainer) {
            return true;
        }
        if (object instanceof IParent) {
            return ((IParent)object).hasChildren();
        }
        Object[] objectArray = this.getChildren(object);
        return objectArray != null && objectArray.length > 0;
    }

    public Object getParent(Object object) {
        if (!this.exists(object)) {
            return null;
        }
        return this.internalGetParent(object);
    }

    public Object internalGetParent(Object object) {
        if (object instanceof ICElement) {
            return ((ICElement)object).getParent();
        }
        if (object instanceof IResource) {
            IContainer iContainer = ((IResource)object).getParent();
            ICElement iCElement = CoreModel.getDefault().create((IResource)iContainer);
            if (iCElement != null && iCElement.exists()) {
                return iCElement;
            }
            return iContainer;
        }
        return null;
    }

    protected Object[] getCProjects(ICModel iCModel) {
        return iCModel.getCProjects();
    }

    protected Object[] getCProjectResources(ICProject iCProject) {
        IBinaryContainer iBinaryContainer;
        Object[] objectArray = this.getCResources((ICContainer)iCProject);
        IArchiveContainer iArchiveContainer = iCProject.getArchiveContainer();
        if (iArchiveContainer.hasChildren()) {
            objectArray = BaseCElementContentProvider.concatenate(objectArray, new Object[]{iArchiveContainer});
        }
        if ((iBinaryContainer = iCProject.getBinaryContainer()).hasChildren()) {
            objectArray = BaseCElementContentProvider.concatenate(objectArray, new Object[]{iBinaryContainer});
        }
        try {
            Object[] objectArray2 = iCProject.getLibraryReferences();
            objectArray = BaseCElementContentProvider.concatenate(objectArray, objectArray2);
        }
        catch (CModelException cModelException) {}
        return objectArray;
    }

    protected Object[] getCResources(ICContainer iCContainer) {
        Object[] objectArray = null;
        Object[] objectArray2 = iCContainer.getChildren();
        try {
            objectArray = iCContainer.getNonCResources();
        }
        catch (CModelException cModelException) {}
        if (objectArray == null) {
            return objectArray2;
        }
        return BaseCElementContentProvider.concatenate(objectArray2, objectArray);
    }

    private Object[] getResources(Object object) {
        try {
            if (object instanceof IContainer) {
                IResource[] iResourceArray = ((IContainer)object).members();
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                int n = 0;
                while (n < iResourceArray.length) {
                    IResource iResource = iResourceArray[n];
                    arrayList.add(iResource);
                    ++n;
                }
                return arrayList.toArray();
            }
        }
        catch (CoreException coreException) {}
        return NO_CHILDREN;
    }

    protected boolean exists(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IResource) {
            return ((IResource)object).exists();
        }
        if (object instanceof ICElement) {
            return ((ICElement)object).exists();
        }
        return true;
    }

    protected static Object[] concatenate(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray2.length;
        Object[] objectArray3 = new Object[n + n2];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        return objectArray3;
    }
}

