/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleAction;
import org.eclipse.cdt.internal.ui.buildconsole.ClearConsoleAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleEvent;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.TextEditorAction;

public class BuildConsoleView
extends ViewPart
implements ISelectionListener,
IBuildConsoleListener {
    private IProject selProject;
    private Font fFont = null;
    private IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (BuildConsoleView.this.fTextViewer != null && propertyChangeEvent.getProperty().equals("consoleFont")) {
                BuildConsoleView.this.initializeWidgetFont(BuildConsoleView.this.fTextViewer.getTextWidget());
            }
        }
    };
    protected TextViewer fTextViewer;
    IBuildConsoleManager fConsoleManager;
    ClearConsoleAction fClearOutputAction;
    TextEditorAction fCopyAction;
    TextEditorAction fSelectAllAction;
    String origTitle;
    static /* synthetic */ Class class$0;

    public BuildConsoleView() {
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fConsoleManager = CUIPlugin.getDefault().getConsoleManager();
    }

    private void initializeActions() {
        ResourceBundle resourceBundle = CUIPlugin.getResourceBundle();
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fClearOutputAction = new ClearConsoleAction(this);
        this.fCopyAction = new BuildConsoleAction(resourceBundle, "Editor.Copy.", this.fTextViewer, 4);
        this.fSelectAllAction = new BuildConsoleAction(resourceBundle, "Editor.SelectAll.", this.fTextViewer, 7);
        iActionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.fCopyAction);
        iActionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.fSelectAllAction);
        this.fTextViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                BuildConsoleView.this.fCopyAction.update();
            }
        });
    }

    public void createPartControl(Composite composite) {
        this.fTextViewer = new TextViewer(composite, 834);
        this.fTextViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent textEvent) {
                BuildConsoleView.this.revealEndOfDocument();
            }
        });
        this.fTextViewer.setEditable(false);
        this.origTitle = this.getTitle();
        this.initializeWidgetFont(this.fTextViewer.getTextWidget());
        this.initializeActions();
        this.initializeContextMenu(this.fTextViewer.getControl());
        this.initializeToolBar();
        WorkbenchHelp.setHelp((Control)this.fTextViewer.getControl(), (String)"org.eclipse.cdt.ui.clear_console_view_context");
        this.setProject(this.getSite().getPage().getSelection());
        this.setDocument();
        this.setTitle();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.fConsoleManager.addConsoleListener(this);
    }

    protected void setProject(ISelection iSelection) {
        this.selProject = this.convertSelectionToProject(iSelection);
    }

    protected void setProject(IProject iProject) {
        this.selProject = iProject;
    }

    protected IProject getProject() {
        return this.selProject;
    }

    protected IDocument setDocument() {
        IProject iProject = this.getProject();
        if (iProject != null) {
            this.fTextViewer.setDocument(this.fConsoleManager.getConsoleDocument(iProject));
        }
        return null;
    }

    protected void setTitle() {
        String string = this.origTitle;
        IProject iProject = this.getProject();
        if (iProject != null) {
            string = String.valueOf(string) + " [" + iProject.getName() + "]";
        }
        this.setTitle(string);
    }

    protected void initializeWidgetFont(StyledText styledText) {
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        String string = "consoleFont";
        FontData fontData = null;
        fontData = iPreferenceStore.contains(string) && !iPreferenceStore.isDefault(string) ? PreferenceConverter.getFontData((IPreferenceStore)iPreferenceStore, (String)string) : PreferenceConverter.getDefaultFontData((IPreferenceStore)iPreferenceStore, (String)string);
        if (fontData != null) {
            Font font = new Font((Device)styledText.getDisplay(), fontData);
            styledText.setFont(font);
            if (this.fFont != null) {
                this.fFont.dispose();
            }
            this.fFont = font;
        } else {
            styledText.setFont(JFaceResources.getTextFont());
        }
    }

    public void setFocus() {
        this.fTextViewer.getControl().setFocus();
    }

    protected void initializeContextMenu(Control control) {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                BuildConsoleView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        this.fCopyAction.update();
        iMenuManager.add((IAction)this.fCopyAction);
        iMenuManager.add((IAction)this.fSelectAllAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.fClearOutputAction);
    }

    private void initializeToolBar() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        iActionBars.getToolBarManager().add((IAction)this.fClearOutputAction);
        iActionBars.updateActionBars();
    }

    protected void revealEndOfDocument() {
        IDocument iDocument = this.fTextViewer.getDocument();
        int n = iDocument.getLength();
        if (n > 0) {
            this.fTextViewer.revealRange(n - 1, 1);
            StyledText styledText = this.fTextViewer.getTextWidget();
            styledText.setCaretOffset(n);
            styledText.showSelection();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fPropertyChangeListener != null) {
            IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
            iPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.fConsoleManager.removeConsoleListener(this);
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IProject iProject = this.convertSelectionToProject(iSelection);
        IProject iProject2 = this.getProject();
        if (iProject2 == null || iProject != null && !iProject.equals((Object)iProject2)) {
            this.setProject(iProject);
            this.setDocument();
            this.setTitle();
        }
    }

    public void consoleChange(IBuildConsoleEvent iBuildConsoleEvent) {
        if (iBuildConsoleEvent.getType() == 1 || iBuildConsoleEvent.getType() == 2) {
            Display display = this.fTextViewer.getControl().getDisplay();
            this.selProject = iBuildConsoleEvent.getProject();
            if (iBuildConsoleEvent.getType() == 2 && this.selProject != iBuildConsoleEvent.getProject()) {
                return;
            }
            display.asyncExec(new Runnable(){

                public void run() {
                    BuildConsoleView.this.setDocument();
                    BuildConsoleView.this.setTitle();
                }
            });
        }
    }

    IProject convertSelectionToProject(ISelection iSelection) {
        IAdaptable iAdaptable;
        IProject iProject = null;
        if (iSelection == null || !(iSelection instanceof IStructuredSelection)) {
            return iProject;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IAdaptable && (iAdaptable = (IAdaptable)object) != null) {
            IResource iResource = null;
            if (iAdaptable instanceof IResource) {
                iResource = (IResource)iAdaptable;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource != null) {
                iProject = iResource.getProject();
            }
        }
        return iProject;
    }

    void clear() {
        if (this.selProject != null) {
            this.fConsoleManager.getConsole(this.selProject).clear();
        }
    }
}

