/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.cview.SelectionConverter;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.actions.OpenWithMenu;

public class OpenFileGroup
extends CViewActionGroup {
    private OpenFileAction openFileAction;
    static /* synthetic */ Class class$0;

    public OpenFileGroup(CView cView) {
        super(cView);
    }

    protected void makeActions() {
        this.openFileAction = new OpenFileAction(this.getCView().getSite().getPage());
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        boolean bl;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection iStructuredSelection2 = SelectionConverter.convertSelectionToResources((ISelection)iStructuredSelection);
        boolean bl2 = !iStructuredSelection2.isEmpty() && SelectionConverter.allResourcesAreOfType(iStructuredSelection2, 7);
        boolean bl3 = bl = !iStructuredSelection2.isEmpty() && SelectionConverter.allResourcesAreOfType(iStructuredSelection2, 1);
        if (bl) {
            this.openFileAction.selectionChanged(iStructuredSelection2);
            iMenuManager.add((IAction)this.openFileAction);
            this.fillOpenWithMenu(iMenuManager, iStructuredSelection2);
        }
        if (bl2) {
            this.addNewWindowAction(iMenuManager, iStructuredSelection2);
        }
    }

    private void fillOpenWithMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IFile)) {
            return;
        }
        MenuManager menuManager = new MenuManager(CViewMessages.getString("OpenWithMenu.label"));
        menuManager.add((IContributionItem)new OpenWithMenu(this.getCView().getSite().getPage(), (IAdaptable)((IFile)object)));
        iMenuManager.add((IContributionItem)menuManager);
    }

    private void addNewWindowAction(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IContainer)) {
            return;
        }
        if (object instanceof IProject && !((IProject)object).isOpen()) {
            return;
        }
        iMenuManager.add((IAction)new OpenInNewWindowAction(this.getCView().getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)object)));
    }

    public void fillActionBars(IActionBars iActionBars) {
    }

    public void updateActionBars() {
    }

    public void runDefaultAction(IStructuredSelection iStructuredSelection) {
        block10: {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof ICElement) {
                ICElement iCElement = (ICElement)object;
                try {
                    IEditorPart iEditorPart = EditorUtility.openInEditor(iCElement);
                    if (iEditorPart == null) break block10;
                    IWorkbenchPage iWorkbenchPage = this.getCView().getSite().getPage();
                    iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
                    if (iCElement instanceof ISourceReference) {
                        EditorUtility.revealInEditor(iEditorPart, iCElement);
                    }
                }
                catch (Exception exception) {}
            } else if (object instanceof IAdaptable) {
                IResource iResource;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) instanceof IFile) {
                    this.openFileAction.selectionChanged(iStructuredSelection);
                    this.openFileAction.run();
                }
            }
        }
    }
}

