/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.ISelectionValidator;
import org.eclipse.cdt.internal.ui.dialogs.SelectionList;
import org.eclipse.cdt.internal.ui.dialogs.SelectionStatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractElementListSelectionDialog
extends SelectionStatusDialog {
    private ILabelProvider fRenderer;
    private boolean fIgnoreCase;
    private boolean fIsMultipleSelection;
    private SelectionList fSelectionList;
    private Label fMessage;
    private ISelectionValidator fValidator;
    private String fMessageText;
    private String fEmptyListMessage;
    private String fNothingSelectedMessage;
    private StatusInfo fCurrStatus;

    protected void access$superOpen() {
        super.open();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected Point computeInitialSize() {
        return new Point(this.convertWidthInCharsToPixels(60), this.convertHeightInCharsToPixels(18));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.fMessage = this.createMessage(composite2);
        int n = this.fIsMultipleSelection ? 2 : 4;
        this.fSelectionList = new SelectionList(composite2, n | 0x800 | 0x200 | 0x100, this.fRenderer, this.fIgnoreCase);
        this.fSelectionList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                AbstractElementListSelectionDialog.this.handleDoubleClick();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractElementListSelectionDialog.this.verifyCurrentSelection();
            }
        });
        GridData gridData = new GridData();
        Point point = this.computeInitialSize();
        gridData.widthHint = point.x;
        gridData.heightHint = point.y;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.fSelectionList.setLayoutData(gridData);
        return composite2;
    }

    protected Label createMessage(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(this.fMessageText);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public void create() {
        super.create();
        if (this.isEmptyList()) {
            this.fMessage.setEnabled(false);
            this.fSelectionList.setEnabled(false);
        } else {
            this.verifyCurrentSelection();
            this.fSelectionList.selectFilterText();
            this.fSelectionList.setFocus();
        }
    }

    protected String getFilter() {
        return this.fSelectionList.getFilter();
    }

    protected int[] getSelectionIndices() {
        return this.fSelectionList.getSelectionIndices();
    }

    protected List getWidgetSelection() {
        if (this.fSelectionList == null || this.fSelectionList.isDisposed()) {
            return new ArrayList(0);
        }
        return this.fSelectionList.getSelection();
    }

    protected abstract void handleDoubleClick();

    protected boolean isEmptyList() {
        if (this.fSelectionList == null) {
            return true;
        }
        return this.fSelectionList.isEmptyList();
    }

    protected AbstractElementListSelectionDialog(Shell shell, String string, Image image, ILabelProvider iLabelProvider, boolean bl, boolean bl2) {
        super(shell);
        this.setTitle(string);
        this.setImage(image);
        this.fRenderer = iLabelProvider;
        this.fIgnoreCase = bl;
        this.fIsMultipleSelection = bl2;
        this.fMessageText = "";
        this.fCurrStatus = new StatusInfo();
        this.fValidator = null;
        this.fEmptyListMessage = "";
        this.fNothingSelectedMessage = "";
    }

    protected AbstractElementListSelectionDialog(Shell shell, ILabelProvider iLabelProvider, boolean bl, boolean bl2) {
        this(shell, "", null, iLabelProvider, bl, bl2);
    }

    public int open() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                AbstractElementListSelectionDialog.this.access$superOpen();
            }
        });
        return this.getReturnCode();
    }

    protected void refilter() {
        this.fSelectionList.filter(true);
    }

    public void setEmptyListMessage(String string) {
        this.fEmptyListMessage = string;
    }

    protected void setFilter(String string, boolean bl) {
        this.fSelectionList.setFilter(string, bl);
    }

    public void setMessage(String string) {
        this.fMessageText = string;
    }

    public void setNothingSelectedMessage(String string) {
        this.fNothingSelectedMessage = string;
    }

    protected void setSelection(int[] nArray) {
        this.fSelectionList.setSelection(nArray);
    }

    protected void setSelectionListElements(List list, boolean bl) {
        this.fSelectionList.setElements(list, bl);
    }

    public void setValidator(ISelectionValidator iSelectionValidator) {
        this.fValidator = iSelectionValidator;
    }

    protected boolean verifyCurrentSelection() {
        List list = this.getWidgetSelection();
        int n = list.size();
        if (n > 0) {
            if (this.fValidator != null) {
                this.fValidator.isValid(list.toArray(), this.fCurrStatus);
            } else {
                this.fCurrStatus.setOK();
            }
        } else if (this.isEmptyList()) {
            this.fCurrStatus.setError(this.fEmptyListMessage);
        } else {
            this.fCurrStatus.setError(this.fNothingSelectedMessage);
        }
        this.updateStatus(this.fCurrStatus);
        return this.fCurrStatus.isOK();
    }
}

