/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.IWorkingCopyManagerExtension;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IEditorInput;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private CDocumentProvider fDocumentProvider;
    private Map fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(CDocumentProvider cDocumentProvider) {
        Assert.isNotNull((Object)((Object)cDocumentProvider));
        this.fDocumentProvider = cDocumentProvider;
    }

    public void connect(IEditorInput iEditorInput) throws CoreException {
        this.fDocumentProvider.connect(iEditorInput);
    }

    public void disconnect(IEditorInput iEditorInput) {
        this.fDocumentProvider.disconnect(iEditorInput);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        if (this.fIsShuttingDown) return;
        this.fIsShuttingDown = true;
        try {
            if (this.fMap != null) {
                this.fMap.clear();
                this.fMap = null;
            }
            this.fDocumentProvider.shutdown();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fIsShuttingDown = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fIsShuttingDown = false;
            return;
        }
    }

    public IWorkingCopy getWorkingCopy(IEditorInput iEditorInput) {
        IWorkingCopy iWorkingCopy = this.fMap == null ? null : (IWorkingCopy)this.fMap.get(iEditorInput);
        return iWorkingCopy != null ? iWorkingCopy : this.fDocumentProvider.getWorkingCopy(iEditorInput);
    }

    public void setWorkingCopy(IEditorInput iEditorInput, IWorkingCopy iWorkingCopy) {
        if (this.fDocumentProvider.isConnected(iEditorInput)) {
            if (this.fMap == null) {
                this.fMap = new HashMap();
            }
            this.fMap.put(iEditorInput, iWorkingCopy);
        }
    }

    public void removeWorkingCopy(IEditorInput iEditorInput) {
        this.fMap.remove(iEditorInput);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

