/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.template;

import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateBuffer;
import org.eclipse.cdt.internal.corext.template.TemplateContext;
import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.TemplatePosition;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateProposal
implements ICCompletionProposal {
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final ITextViewer fViewer;
    private final Image fImage;
    private final IRegion fRegion;
    private TemplateBuffer fTemplateBuffer;
    private String fOldText;
    private IRegion fSelectedRegion;

    public TemplateProposal(Template template, TemplateContext templateContext, IRegion iRegion, ITextViewer iTextViewer, Image image) {
        Assert.isNotNull((Object)template);
        Assert.isNotNull((Object)templateContext);
        Assert.isNotNull((Object)iRegion);
        Assert.isNotNull((Object)iTextViewer);
        this.fTemplate = template;
        this.fContext = templateContext;
        this.fViewer = iTextViewer;
        this.fImage = image;
        this.fRegion = iRegion;
    }

    public void apply(IDocument iDocument) {
        try {
            if (this.fTemplateBuffer == null) {
                this.fTemplateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            int n = this.fRegion.getOffset();
            int n2 = this.fRegion.getOffset() + this.fRegion.getLength();
            String string = this.fTemplateBuffer.getString();
            iDocument.replace(n, n2 - n, string);
            LinkedPositionManager linkedPositionManager = new LinkedPositionManager(iDocument);
            TemplatePosition[] templatePositionArray = this.fTemplateBuffer.getVariables();
            int n3 = 0;
            while (n3 != templatePositionArray.length) {
                TemplatePosition templatePosition = templatePositionArray[n3];
                if (!templatePosition.isResolved()) {
                    int[] nArray = templatePosition.getOffsets();
                    int n4 = templatePosition.getLength();
                    int n5 = 0;
                    while (n5 != nArray.length) {
                        linkedPositionManager.addPosition(nArray[n5] + n, n4);
                        ++n5;
                    }
                }
                ++n3;
            }
            LinkedPositionUI linkedPositionUI = new LinkedPositionUI(this.fViewer, linkedPositionManager);
            linkedPositionUI.setFinalCaretOffset(TemplateProposal.getCaretOffset(this.fTemplateBuffer) + n);
            linkedPositionUI.enter();
            this.fSelectedRegion = linkedPositionUI.getSelectedRegion();
        }
        catch (BadLocationException badLocationException) {
            CUIPlugin.getDefault().log(badLocationException);
            this.openErrorDialog(badLocationException);
        }
        catch (CoreException coreException) {
            CUIPlugin.getDefault().log(coreException);
            this.openErrorDialog(coreException);
        }
    }

    private static int getCaretOffset(TemplateBuffer templateBuffer) {
        TemplatePosition[] templatePositionArray = templateBuffer.getVariables();
        int n = 0;
        while (n != templatePositionArray.length) {
            TemplatePosition templatePosition = templatePositionArray[n];
            if (templatePosition.getName().equals("cursor")) {
                return templatePosition.getOffsets()[0];
            }
            ++n;
        }
        return templateBuffer.getString().length();
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        try {
            if (this.fTemplateBuffer == null) {
                this.fTemplateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            return TemplateProposal.textToHTML(this.fTemplateBuffer.getString());
        }
        catch (CoreException coreException) {
            CUIPlugin.getDefault().log(coreException);
            this.openErrorDialog(coreException);
            return null;
        }
    }

    public String getDisplayString() {
        return String.valueOf(this.fTemplate.getName()) + TemplateMessages.getString("TemplateProposal.delimiter") + this.fTemplate.getDescription();
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private static String textToHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append("<pre>");
        int n = 0;
        while (n != string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\t': {
                    stringBuffer.append("    ");
                    break;
                }
                case '\n': {
                    stringBuffer.append("<br>");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        stringBuffer.append("</pre>");
        return stringBuffer.toString();
    }

    private void openErrorDialog(BadLocationException badLocationException) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)badLocationException.getMessage());
    }

    private void openErrorDialog(CoreException coreException) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)coreException.getMessage());
    }

    public int getRelevance() {
        return 9;
    }
}

