/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    static /* synthetic */ Class class$0;

    private EditorUtility() {
    }

    public static IEditorPart isOpenInEditor(Object object) {
        IWorkbenchPage iWorkbenchPage;
        IEditorInput iEditorInput = null;
        try {
            iEditorInput = EditorUtility.getEditorInput(object);
        }
        catch (CModelException cModelException) {}
        if (iEditorInput != null && (iWorkbenchPage = CUIPlugin.getActivePage()) != null) {
            return iWorkbenchPage.findEditor(iEditorInput);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object object) throws CModelException, PartInitException {
        return EditorUtility.openInEditor(object, true);
    }

    public static IEditorPart openInEditor(Object object, boolean bl) throws CModelException, PartInitException {
        if (object instanceof IFile) {
            return EditorUtility.openInEditor((IFile)object, bl);
        }
        IEditorInput iEditorInput = EditorUtility.getEditorInput(object);
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return EditorUtility.openInEditor(iFileEditorInput.getFile(), bl);
        }
        if (iEditorInput != null) {
            return EditorUtility.openInEditor(iEditorInput, EditorUtility.getEditorID(iEditorInput, object), bl);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart iEditorPart, ICElement iCElement) {
        if (iCElement != null && iEditorPart instanceof CEditor) {
            ((CEditor)iEditorPart).setSelection(iCElement);
        }
    }

    private static IEditorPart openInEditor(IFile iFile, boolean bl) throws PartInitException {
        IWorkbenchPage iWorkbenchPage;
        if (iFile != null && (iWorkbenchPage = CUIPlugin.getActivePage()) != null) {
            IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)bl);
            EditorUtility.initializeHighlightRange(iEditorPart);
            return iEditorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput iEditorInput, String string, boolean bl) throws PartInitException {
        IWorkbenchPage iWorkbenchPage;
        if (iEditorInput != null && (iWorkbenchPage = CUIPlugin.getActivePage()) != null) {
            IEditorPart iEditorPart = iWorkbenchPage.openEditor(iEditorInput, string, bl);
            EditorUtility.initializeHighlightRange(iEditorPart);
            return iEditorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart iEditorPart) {
        boolean cfr_ignored_0 = iEditorPart instanceof ITextEditor;
    }

    private static IEditorInput getEditorInput(ICElement iCElement) throws CModelException {
        while (iCElement != null) {
            IResource iResource;
            ITranslationUnit iTranslationUnit;
            if (iCElement instanceof IWorkingCopy && ((IWorkingCopy)iCElement).isWorkingCopy()) {
                iCElement = ((IWorkingCopy)iCElement).getOriginalElement();
            }
            if (iCElement instanceof ISourceReference && (iTranslationUnit = ((ISourceReference)iCElement).getTranslationUnit()) != null) {
                iCElement = iTranslationUnit;
            }
            if (iCElement instanceof ITranslationUnit && (iResource = (iTranslationUnit = (ITranslationUnit)iCElement).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)iResource);
            }
            if (iCElement instanceof IBinary) {
                return new ExternalEditorInput(EditorUtility.getStorage((IBinary)iCElement));
            }
            iCElement = iCElement.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object object) throws CModelException {
        if (object instanceof ICElement) {
            return EditorUtility.getEditorInput((ICElement)object);
        }
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (object instanceof IStorage) {
            return new ExternalEditorInput((IStorage)object);
        }
        return null;
    }

    public static ICElement getActiveEditorCInput() {
        IEditorInput iEditorInput;
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = CUIPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null && (iEditorInput = iEditorPart.getEditorInput()) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICElement)iEditorInput.getAdapter((Class)clazz);
        }
        return null;
    }

    public static ITranslationUnit getWorkingCopy(ITranslationUnit iTranslationUnit) {
        if (iTranslationUnit == null) {
            return null;
        }
        if (iTranslationUnit.isWorkingCopy()) {
            return iTranslationUnit;
        }
        return (ITranslationUnit)iTranslationUnit.findSharedWorkingCopy(CUIPlugin.getBufferFactory());
    }

    private static ITranslationUnit getTranslationUnit(ICElement iCElement) {
        if (iCElement == null) {
            return null;
        }
        int n = iCElement.getElementType();
        if (60 == n) {
            return (ITranslationUnit)iCElement;
        }
        if (14 == n) {
            return null;
        }
        if (iCElement instanceof ISourceReference) {
            return ((ISourceReference)iCElement).getTranslationUnit();
        }
        return EditorUtility.getTranslationUnit(iCElement.getParent());
    }

    public static String getEditorID(String string) {
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (iEditorRegistry != null) {
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(string);
            if (iEditorDescriptor != null) {
                return iEditorDescriptor.getId();
            }
            return iEditorRegistry.findEditor(DEFAULT_TEXT_EDITOR_ID).getId();
        }
        return null;
    }

    public static String getEditorID(IEditorInput iEditorInput, Object object) {
        return EditorUtility.getEditorID(iEditorInput.getName());
    }

    public static IStorage getStorage(IBinary iBinary) {
        FileStorage fileStorage = null;
        try {
            fileStorage = new FileStorage((InputStream)new ByteArrayInputStream(iBinary.getBuffer().getContents().getBytes()), iBinary.getPath());
        }
        catch (CModelException cModelException) {}
        return fileStorage;
    }
}

