/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.workingsets.CElementWorkingSetPageContentProvider;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.ui.CElementSorter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CElementWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = WorkingSetMessages.getString("CElementWorkingSetPage.title");
    private static final String PAGE_ID = "CElementWorkingSetPage";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text text;
    private CheckboxTreeViewer tree;
    private IWorkingSet workingSet;
    private boolean firstCheck = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CElementWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, CPluginImages.DESC_WIZABAN_C_APP);
        this.setDescription(WorkingSetMessages.getString("CElementWorkingSetPage.description"));
    }

    private void addWorkingSetElements(List list, IContainer iContainer) {
        IAdaptable[] iAdaptableArray = this.workingSet.getElements();
        IPath iPath = iContainer.getFullPath();
        int n = 0;
        while (n < iAdaptableArray.length) {
            IPath iPath2;
            IResource iResource = null;
            if (iAdaptableArray[n] instanceof IResource) {
                iResource = (IResource)iAdaptableArray[n];
            } else {
                IAdaptable iAdaptable = iAdaptableArray[n];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource != null && iPath.isPrefixOf(iPath2 = iResource.getFullPath())) {
                list.add(iAdaptableArray[n]);
            }
            ++n;
        }
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite2);
        Label label = new Label(composite2, 64);
        label.setText(WorkingSetMessages.getString("CElementWorkingSetPage.name"));
        GridData gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        this.text = new Text(composite2, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setFont(font);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CElementWorkingSetPage.this.validateInput();
            }
        });
        this.text.setFocus();
        label = new Label(composite2, 64);
        label.setText(WorkingSetMessages.getString("CElementWorkingSetPage.content"));
        gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        this.tree = new CheckboxTreeViewer(composite2);
        this.tree.setUseHashlookup(true);
        this.tree.setContentProvider((IContentProvider)new CElementWorkingSetPageContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), CUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.tree.setInput((Object)CUIPlugin.getWorkspace().getRoot());
        this.tree.setSorter((ViewerSorter)new CElementSorter());
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 50;
        this.tree.getControl().setLayoutData((Object)gridData);
        this.tree.getControl().setFont(font);
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                CElementWorkingSetPage.this.handleCheckStateChange(checkStateChangedEvent);
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                Object object = treeExpansionEvent.getElement();
                if (!CElementWorkingSetPage.this.tree.getGrayed(object)) {
                    BusyIndicator.showWhile((Display)CElementWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, object){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            CElementWorkingSetPage.access$3(3.access$0(this.this$1), (IContainer)this.val$element, CElementWorkingSetPage.access$2(3.access$0(this.this$1)).getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ CElementWorkingSetPage access$0(3 var0) {
                return var0.CElementWorkingSetPage.this;
            }
        });
        this.initializeCheckedState();
        if (this.workingSet != null) {
            this.text.setText(this.workingSet.getName());
        }
        this.setPageComplete(false);
    }

    private void findCheckedResources(List list, IContainer iContainer) {
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, this.getShell(), WorkingSetMessages.getString("EditWorkingSetAction.nowizard.message"), "updateCheckedState");
        }
        int n = 0;
        while (n < iResourceArray.length) {
            if (this.tree.getGrayed((Object)iResourceArray[n])) {
                if (iResourceArray[n].isAccessible()) {
                    this.findCheckedResources(list, (IContainer)iResourceArray[n]);
                } else {
                    this.addWorkingSetElements(list, (IContainer)iResourceArray[n]);
                }
            } else if (this.tree.getChecked((Object)iResourceArray[n])) {
                list.add(iResourceArray[n]);
            }
            ++n;
        }
    }

    public void finish() {
        ArrayList arrayList = new ArrayList(10);
        this.findCheckedResources(arrayList, (IContainer)this.tree.getInput());
        if (this.workingSet == null) {
            IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = iWorkingSetManager.createWorkingSet(this.getWorkingSetName(), arrayList.toArray(new IAdaptable[arrayList.size()]));
        } else {
            this.workingSet.setName(this.getWorkingSetName());
            this.workingSet.setElements(arrayList.toArray(new IAdaptable[arrayList.size()]));
        }
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    private String getWorkingSetName() {
        return this.text.getText();
    }

    private void handleCheckStateChange(final CheckStateChangedEvent checkStateChangedEvent) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IResource iResource = (IResource)checkStateChangedEvent.getElement();
                boolean bl = checkStateChangedEvent.getChecked();
                CElementWorkingSetPage.this.tree.setGrayed((Object)iResource, false);
                if (iResource instanceof IContainer) {
                    CElementWorkingSetPage.this.setSubtreeChecked((IContainer)iResource, bl, true);
                }
                CElementWorkingSetPage.this.updateParentState(iResource);
                CElementWorkingSetPage.this.validateInput();
            }
        });
    }

    private void handleCoreException(CoreException coreException, Shell shell, String string, String string2) {
        IStatus iStatus = coreException.getStatus();
        if (iStatus != null) {
            ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
        } else {
            MessageDialog.openError((Shell)shell, (String)WorkingSetMessages.getString("EditWorkingSetAction.nowizard.message"), (String)coreException.getLocalizedMessage());
        }
    }

    private void initializeCheckedState() {
        if (this.workingSet == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] objectArray = CElementWorkingSetPage.this.workingSet.getElements();
                CElementWorkingSetPage.this.tree.setCheckedElements(objectArray);
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    IContainer iContainer = null;
                    IResource iResource = null;
                    if (object instanceof IContainer) {
                        iContainer = (IContainer)object;
                    } else {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IContainer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iContainer = (IContainer)object.getAdapter((Class)clazz);
                    }
                    if (iContainer != null) {
                        CElementWorkingSetPage.this.setSubtreeChecked(iContainer, true, true);
                    }
                    if (object instanceof IResource) {
                        iResource = (IResource)object;
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iResource = (IResource)object.getAdapter((Class)clazz);
                    }
                    if (iResource != null && !iResource.isAccessible()) {
                        IProject iProject = iResource.getProject();
                        if (!CElementWorkingSetPage.this.tree.getChecked((Object)iProject)) {
                            CElementWorkingSetPage.this.tree.setGrayChecked((Object)iProject, true);
                        }
                    } else {
                        CElementWorkingSetPage.this.updateParentState(iResource);
                    }
                    ++n;
                }
            }
        });
    }

    public void setSelection(IWorkingSet iWorkingSet) {
        if (iWorkingSet == null) {
            throw new IllegalArgumentException("Working set must not be null");
        }
        this.workingSet = iWorkingSet;
        if (this.getShell() != null && this.text != null) {
            this.firstCheck = true;
            this.initializeCheckedState();
            this.text.setText(iWorkingSet.getName());
        }
    }

    private void setSubtreeChecked(IContainer iContainer, boolean bl, boolean bl2) {
        if (!iContainer.isAccessible() || !this.tree.getExpandedState((Object)iContainer) && bl && bl2) {
            return;
        }
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, this.getShell(), WorkingSetMessages.getString("EditWorkingSetAction.nowizard.message"), "updateCheckedState");
        }
        int n = iResourceArray.length - 1;
        while (n >= 0) {
            boolean bl3;
            IResource iResource = iResourceArray[n];
            boolean bl4 = bl3 = this.tree.getGrayed((Object)iResource) || this.tree.getChecked((Object)iResource);
            if (bl) {
                this.tree.setChecked((Object)iResource, true);
                this.tree.setGrayed((Object)iResource, false);
            } else {
                this.tree.setGrayChecked((Object)iResource, false);
            }
            if (iResource instanceof IContainer && (bl || bl3)) {
                this.setSubtreeChecked((IContainer)iResource, bl, true);
            }
            --n;
        }
    }

    private void updateParentState(IResource iResource) {
        if (iResource == null || iResource.getParent() == null) {
            return;
        }
        IContainer iContainer = iResource.getParent();
        boolean bl = false;
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, this.getShell(), WorkingSetMessages.getString("EditWorkingSetAction.nowizard.message"), "updateCheckedState");
        }
        int n = iResourceArray.length - 1;
        while (n >= 0) {
            if (this.tree.getChecked((Object)iResourceArray[n]) || this.tree.getGrayed((Object)iResourceArray[n])) {
                bl = true;
                break;
            }
            --n;
        }
        this.tree.setGrayChecked((Object)iContainer, bl);
        this.updateParentState((IResource)iContainer);
    }

    private void validateInput() {
        String string = null;
        String string2 = this.text.getText();
        if (!string2.equals(string2.trim())) {
            string = WorkingSetMessages.getString("CElementWorkingSetPage.warning.nameMustNotBeEmpty");
        } else if (this.firstCheck) {
            this.firstCheck = false;
            return;
        }
        if (string2.equals("")) {
            string = WorkingSetMessages.getString("CElementWorkingSetPage.warning.nameMustNotBeEmpty");
        }
        if (!(string != null || this.workingSet != null && string2.equals(this.workingSet.getName()))) {
            IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (string2.equals(iWorkingSetArray[n].getName())) {
                    string = WorkingSetMessages.getString("CElementWorkingSetPage.warning.workingSetExists");
                }
                ++n;
            }
        }
        if (string == null && this.tree.getCheckedElements().length == 0) {
            string = WorkingSetMessages.getString("CElementWorkingSetPage.warning.resourceMustBeChecked");
        }
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }
}

