/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDIEndSteppingRange;
import org.eclipse.cdt.debug.core.cdi.ICDIErrorInfo;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryEvent;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointScope;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointTrigger;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIExitedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIRestartedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.IGlobalVariable;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.CBreakpointManager;
import org.eclipse.cdt.debug.internal.core.CMemoryManager;
import org.eclipse.cdt.debug.internal.core.CRegisterManager;
import org.eclipse.cdt.debug.internal.core.CSharedLibraryManager;
import org.eclipse.cdt.debug.internal.core.CSignalManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager;
import org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;

public class CDebugTarget
extends CDebugElement
implements ICDebugTarget,
ICDIEventListener,
ILaunchListener,
IExpressionListener {
    private boolean fSuspending;
    private int fTargetType;
    private ArrayList fThreads;
    private IProcess fDebuggeeProcess = null;
    private IProcess fDebuggerProcess = null;
    private ICDITarget fCDITarget;
    private String fName;
    private boolean fSuspended = true;
    private boolean fTerminated;
    private boolean fTerminating;
    private boolean fDisconnected;
    private ILaunch fLaunch;
    private ICDIConfiguration fConfig;
    private int fCurrentStateId = 0;
    private Object fCurrentStateInfo = null;
    private int fSuspendCount = 0;
    private CMemoryManager fMemoryManager;
    private DisassemblyManager fDisassemblyManager;
    private CSharedLibraryManager fSharedLibraryManager;
    private CSignalManager fSignalManager;
    private CRegisterManager fRegisterManager;
    private CBreakpointManager fBreakpointManager;
    private boolean fIsDebuggerProcessDefault = false;
    private ICDIThread fSuspensionThread;
    private IFile fExecFile;
    private Boolean fIsLittleEndian = null;
    private RunningInfo fRunningInfo = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;

    public CDebugTarget(ILaunch iLaunch, int n, ICDITarget iCDITarget, String string, IProcess iProcess, IProcess iProcess2, IFile iFile, boolean bl, boolean bl2) {
        super(null);
        this.setLaunch(iLaunch);
        this.setTargetType(n);
        this.setDebugTarget(this);
        this.setName(string);
        this.setProcesses(iProcess, iProcess2);
        this.setCDITarget(iCDITarget);
        this.setExecFile(iFile);
        this.setConfiguration(iCDITarget.getSession().getConfiguration());
        this.setThreadList(new ArrayList(5));
        this.setDisassemblyManager(new DisassemblyManager(this));
        this.setSharedLibraryManager(new CSharedLibraryManager(this));
        this.setSignalManager(new CSignalManager(this));
        this.setRegisterManager(new CRegisterManager(this));
        this.setBreakpointManager(new CBreakpointManager(this));
        this.initialize();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionListener)this);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.initializeState();
        this.initializeBreakpoints();
        this.initializeRegisters();
        this.initializeMemoryManager();
        this.initializeSourceManager();
        this.getLaunch().addDebugTarget((IDebugTarget)this);
        this.fireCreationEvent();
    }

    private void initializeBreakpoints() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.setBreakpoints();
    }

    protected void initializeState() {
        ICDIThread[] iCDIThreadArray = new ICDIThread[]{};
        try {
            iCDIThreadArray = this.getCDITarget().getThreads();
        }
        catch (CDIException cDIException) {}
        int n = 0;
        while (n < iCDIThreadArray.length) {
            this.createThread(iCDIThreadArray[n]);
            ++n;
        }
        ArrayList arrayList = this.getThreadList();
        ArrayList<DebugEvent> arrayList2 = new ArrayList<DebugEvent>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(((CThread)iterator.next()).createCreateEvent());
        }
        this.fireEventSet(arrayList2.toArray(new DebugEvent[arrayList2.size()]));
    }

    public void setBreakpoints() {
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(CDebugModel.getPluginIdentifier());
        int n = 0;
        while (n < iBreakpointArray.length) {
            if (iBreakpointArray[n] instanceof ICBreakpoint && this.getBreakpointManager().isTargetBreakpoint((ICBreakpoint)iBreakpointArray[n]) && !this.getBreakpointManager().isCDIRegistered((ICBreakpoint)iBreakpointArray[n])) {
                if (iBreakpointArray[n] instanceof ICAddressBreakpoint) {
                    try {
                        iBreakpointArray[n].setEnabled(false);
                    }
                    catch (CoreException coreException) {}
                }
                this.breakpointAdded0(iBreakpointArray[n]);
            }
            ++n;
        }
    }

    protected void initializeRegisters() {
        this.getRegisterManager().initialize();
    }

    protected void initializeMemoryManager() {
        this.fMemoryManager = new CMemoryManager(this);
    }

    protected void initializeSourceManager() {
        ISourceLocator iSourceLocator = this.getLaunch().getSourceLocator();
        if (iSourceLocator instanceof IAdaptable) {
            CSourceManager cSourceManager;
            ICSourceLocator iCSourceLocator;
            IAdaptable iAdaptable = (IAdaptable)iSourceLocator;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iCSourceLocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz)) instanceof IAdaptable) {
                IAdaptable iAdaptable2 = (IAdaptable)iCSourceLocator;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((cSourceManager = (CSourceManager)iAdaptable2.getAdapter((Class)clazz2)) != null) {
                    cSourceManager.setDebugTarget(this);
                }
            }
            IAdaptable iAdaptable3 = (IAdaptable)iSourceLocator;
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((cSourceManager = (IResourceChangeListener)iAdaptable3.getAdapter((Class)clazz3)) != null) {
                CCorePlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)cSourceManager);
            }
        }
    }

    public IProcess getProcess() {
        return this.fIsDebuggerProcessDefault ? this.fDebuggerProcess : this.fDebuggeeProcess;
    }

    protected void setProcesses(IProcess iProcess, IProcess iProcess2) {
        this.fDebuggeeProcess = iProcess;
        this.fDebuggerProcess = iProcess2;
    }

    public IThread[] getThreads() {
        ArrayList arrayList = this.getThreadList();
        return arrayList.toArray(new IThread[arrayList.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreadList().size() > 0;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    protected void setName(String string) {
        this.fName = string;
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        if (!this.getConfiguration().supportsBreakpoints()) {
            return false;
        }
        return iBreakpoint instanceof ICBreakpoint && this.getBreakpointManager().isCDIRegistered((ICBreakpoint)iBreakpoint);
    }

    public void launchRemoved(ILaunch iLaunch) {
        if (!this.isAvailable()) {
            return;
        }
        if (iLaunch.equals(this.getLaunch())) {
            this.disconnected();
        }
    }

    public void launchAdded(ILaunch iLaunch) {
    }

    public void launchChanged(ILaunch iLaunch) {
    }

    public boolean canTerminate() {
        return this.supportsTerminate() && this.isAvailable();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (this.isTerminating()) {
            return;
        }
        this.setTerminating(true);
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    CDebugTarget.this.getCDITarget().terminate();
                }
                catch (CDIException cDIException) {
                    CDebugTarget.this.setTerminating(false);
                    try {
                        CDebugTarget.this.targetRequestFailed(cDIException.getMessage(), cDIException);
                    }
                    catch (DebugException debugException) {
                        CDebugUtils.error(debugException.getStatus(), CDebugTarget.this);
                    }
                }
            }
        });
    }

    protected void setTerminated(boolean bl) {
        this.fTerminated = bl;
    }

    public boolean canResume() {
        return this.getConfiguration().supportsResume() && this.isSuspended() && this.isAvailable();
    }

    public boolean canSuspend() {
        if (!this.getConfiguration().supportsSuspend()) {
            return false;
        }
        if (!this.isSuspended() && this.isAvailable()) {
            IThread[] iThreadArray = this.getThreads();
            int n = 0;
            while (n < iThreadArray.length) {
                if (iThreadArray[n].isSuspended()) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        if (!this.isSuspended() && !this.isSuspending()) {
            return;
        }
        try {
            this.getCDITarget().resume();
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public void suspend() throws DebugException {
        if (this.isSuspended() || this.isSuspending()) {
            return;
        }
        this.setSuspending(true);
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        CDebugTarget.this.getCDITarget().suspend();
                    }
                    catch (CDIException cDIException) {
                        try {
                            CDebugTarget.this.targetRequestFailed(cDIException.getMessage(), cDIException);
                        }
                        catch (DebugException debugException) {
                            CDebugUtils.error(debugException.getStatus(), CDebugTarget.this);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    CDebugTarget.this.setSuspending(false);
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                    CDebugTarget.this.setSuspending(false);
                    return;
                }
            }
        });
    }

    protected void setSuspending(boolean bl) {
        this.fSuspending = bl;
    }

    protected boolean isSuspending() {
        return this.fSuspending;
    }

    protected void suspendThreads(ICDISuspendedEvent iCDISuspendedEvent) {
        Iterator iterator = ((AbstractList)this.getThreadList()).iterator();
        while (iterator.hasNext()) {
            ((CThread)iterator.next()).handleDebugEvent(iCDISuspendedEvent);
        }
    }

    protected synchronized List refreshThreads() {
        CThread cThread;
        ArrayList<CThread> arrayList = new ArrayList<CThread>(5);
        ArrayList<CThread> arrayList2 = new ArrayList<CThread>(5);
        ArrayList<DebugEvent> arrayList3 = new ArrayList<DebugEvent>(5);
        List list = (List)this.getThreadList().clone();
        ICDIThread[] iCDIThreadArray = new ICDIThread[]{};
        try {
            iCDIThreadArray = this.getCDITarget().getThreads();
        }
        catch (CDIException cDIException) {
            CDebugCorePlugin.log(cDIException);
        }
        int n = 0;
        while (n < iCDIThreadArray.length) {
            cThread = this.findThread(list, iCDIThreadArray[n]);
            if (cThread == null) {
                cThread = new CThread(this, iCDIThreadArray[n]);
                arrayList.add(cThread);
            } else {
                list.remove(cThread);
            }
            arrayList2.add(cThread);
            ++n;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            cThread = (CThread)iterator.next();
            cThread.terminated();
            arrayList3.add(cThread.createTerminateEvent());
        }
        this.setThreadList(arrayList2);
        iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            arrayList3.add(((CThread)iterator.next()).createCreateEvent());
        }
        if (arrayList3.size() > 0) {
            this.fireEventSet(arrayList3.toArray(new DebugEvent[arrayList3.size()]));
        }
        this.setCurrentThread();
        return arrayList;
    }

    protected synchronized void resumeThreads(List list, int n) {
        Iterator iterator = ((AbstractList)this.getThreadList()).iterator();
        while (iterator.hasNext()) {
            ((CThread)iterator.next()).resumed(n, list);
        }
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        if (!(iBreakpoint instanceof ICBreakpoint && this.getBreakpointManager().isTargetBreakpoint((ICBreakpoint)iBreakpoint) && this.isAvailable())) {
            return;
        }
        this.breakpointAdded0(iBreakpoint);
    }

    private void breakpointAdded0(IBreakpoint iBreakpoint) {
        if (!this.isAvailable()) {
            return;
        }
        if (iBreakpoint instanceof ICAddressBreakpoint && !this.getBreakpointManager().supportsAddressBreakpoint((ICAddressBreakpoint)iBreakpoint)) {
            return;
        }
        if (this.getConfiguration().supportsBreakpoints()) {
            try {
                this.getBreakpointManager().setBreakpoint((ICBreakpoint)iBreakpoint);
            }
            catch (DebugException debugException) {}
            DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged(iBreakpoint);
        }
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (!(iBreakpoint instanceof ICBreakpoint && this.getBreakpointManager().isTargetBreakpoint((ICBreakpoint)iBreakpoint) && this.isAvailable())) {
            return;
        }
        try {
            this.getBreakpointManager().removeBreakpoint((ICBreakpoint)iBreakpoint);
        }
        catch (DebugException debugException) {}
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (!(iBreakpoint instanceof ICBreakpoint && this.getBreakpointManager().isTargetBreakpoint((ICBreakpoint)iBreakpoint) && this.isAvailable() && iMarkerDelta != null)) {
            return;
        }
        try {
            this.getBreakpointManager().changeBreakpointProperties((ICBreakpoint)iBreakpoint, iMarkerDelta);
        }
        catch (DebugException debugException) {}
    }

    protected boolean supportsDisconnect() {
        return this.getConfiguration().supportsDisconnect();
    }

    protected boolean supportsTerminate() {
        return this.getConfiguration().supportsTerminate();
    }

    public boolean canDisconnect() {
        return this.supportsDisconnect() && this.isAvailable();
    }

    public void disconnect() throws DebugException {
        if (this.isDisconnected()) {
            return;
        }
        if (!this.canDisconnect()) {
            this.notSupported("Session does not support 'disconnect'");
        }
        try {
            this.getCDITarget().disconnect();
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public boolean isDisconnected() {
        return this.fDisconnected;
    }

    protected void setDisconnected(boolean bl) {
        this.fDisconnected = bl;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        return null;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    private void setLaunch(ILaunch iLaunch) {
        this.fLaunch = iLaunch;
    }

    protected ArrayList getThreadList() {
        return this.fThreads;
    }

    private void setThreadList(ArrayList arrayList) {
        this.fThreads = arrayList;
    }

    private void setCDITarget(ICDITarget iCDITarget) {
        this.fCDITarget = iCDITarget;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this;
        }
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDITarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz4)) {
            return this.fCDITarget;
        }
        Class<?> clazz5 = class$6;
        if (clazz5 == null) {
            try {
                clazz5 = class$6 = Class.forName("org.eclipse.cdt.debug.core.model.IState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz5)) {
            return this;
        }
        Class<?> clazz6 = class$7;
        if (clazz6 == null) {
            try {
                clazz6 = class$7 = Class.forName("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz6)) {
            return this;
        }
        Class<?> clazz7 = class$8;
        if (clazz7 == null) {
            try {
                clazz7 = class$8 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTargetType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz7)) {
            return this;
        }
        Class<?> clazz8 = class$9;
        if (clazz8 == null) {
            try {
                clazz8 = class$9 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ISourceMode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz8) && this.getSourceLocator() instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)this.getSourceLocator();
            Class<?> clazz9 = class$9;
            if (clazz9 == null) {
                try {
                    clazz9 = class$9 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ISourceMode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return iAdaptable.getAdapter((Class)clazz9);
        }
        Class<?> clazz10 = class$10;
        if (clazz10 == null) {
            try {
                clazz10 = class$10 = Class.forName("org.eclipse.cdt.debug.core.ICMemoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz10)) {
            return this.getMemoryManager();
        }
        Class<?> clazz11 = class$11;
        if (clazz11 == null) {
            try {
                clazz11 = class$11 = Class.forName("org.eclipse.cdt.debug.core.model.IDebuggerProcessSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz11)) {
            return this;
        }
        Class<?> clazz12 = class$12;
        if (clazz12 == null) {
            try {
                clazz12 = class$12 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz12)) {
            return this;
        }
        Class<?> clazz13 = class$13;
        if (clazz13 == null) {
            try {
                clazz13 = class$13 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz13)) {
            return this;
        }
        Class<?> clazz14 = class$14;
        if (clazz14 == null) {
            try {
                clazz14 = class$14 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToAddress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz14)) {
            return this;
        }
        Class<?> clazz15 = class$15;
        if (clazz15 == null) {
            try {
                clazz15 = class$15 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz15)) {
            return this;
        }
        Class<?> clazz16 = class$16;
        if (clazz16 == null) {
            try {
                clazz16 = class$16 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToAddress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz16)) {
            return this;
        }
        Class<?> clazz17 = class$17;
        if (clazz17 == null) {
            try {
                clazz17 = class$17 = Class.forName("org.eclipse.cdt.debug.core.ICBreakpointManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz17)) {
            return this.getBreakpointManager();
        }
        Class<?> clazz18 = class$18;
        if (clazz18 == null) {
            try {
                clazz18 = class$18 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz18)) {
            return this.getDisassemblyManager();
        }
        Class<?> clazz19 = class$19;
        if (clazz19 == null) {
            try {
                clazz19 = class$19 = Class.forName("org.eclipse.cdt.debug.core.ICSharedLibraryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz19)) {
            return this.getSharedLibraryManager();
        }
        Class<?> clazz20 = class$20;
        if (clazz20 == null) {
            try {
                clazz20 = class$20 = Class.forName("org.eclipse.cdt.debug.core.ICSignalManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz20)) {
            return this.getSignalManager();
        }
        Class<?> clazz21 = class$21;
        if (clazz21 == null) {
            try {
                clazz21 = class$21 = Class.forName("org.eclipse.cdt.debug.core.ICRegisterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz21)) {
            return this.getRegisterManager();
        }
        return super.getAdapter(clazz);
    }

    public void handleDebugEvent(ICDIEvent iCDIEvent) {
        ICDIObject iCDIObject = iCDIEvent.getSource();
        if (iCDIObject == null && iCDIEvent instanceof ICDIDestroyedEvent) {
            this.handleTerminatedEvent((ICDIDestroyedEvent)iCDIEvent);
        } else if (iCDIObject.getTarget().equals(this.getCDITarget())) {
            if (iCDIEvent instanceof ICDICreatedEvent) {
                if (iCDIObject instanceof ICDIThread) {
                    this.handleThreadCreatedEvent((ICDICreatedEvent)iCDIEvent);
                }
                if (iCDIObject instanceof ICDISharedLibrary) {
                    this.getSharedLibraryManager().sharedLibraryLoaded((ICDISharedLibrary)iCDIObject);
                }
            } else if (iCDIEvent instanceof ICDISuspendedEvent) {
                if (iCDIObject instanceof ICDITarget || iCDIObject instanceof ICDIThread) {
                    this.handleSuspendedEvent((ICDISuspendedEvent)iCDIEvent);
                }
            } else if (iCDIEvent instanceof ICDIResumedEvent) {
                if (iCDIObject instanceof ICDITarget) {
                    this.handleResumedEvent((ICDIResumedEvent)iCDIEvent);
                }
            } else if (iCDIEvent instanceof ICDIExitedEvent) {
                if (iCDIObject instanceof ICDITarget) {
                    this.handleExitedEvent((ICDIExitedEvent)iCDIEvent);
                }
            } else if (iCDIEvent instanceof ICDIDestroyedEvent) {
                if (iCDIObject instanceof ICDIThread) {
                    this.handleThreadTerminatedEvent((ICDIDestroyedEvent)iCDIEvent);
                }
                if (iCDIObject instanceof ICDISharedLibrary) {
                    this.getSharedLibraryManager().sharedLibraryUnloaded((ICDISharedLibrary)iCDIObject);
                }
            } else if (iCDIEvent instanceof ICDIDisconnectedEvent) {
                if (iCDIObject instanceof ICDITarget) {
                    this.handleDisconnectedEvent((ICDIDisconnectedEvent)iCDIEvent);
                }
            } else if (iCDIEvent instanceof ICDIChangedEvent) {
                if (iCDIObject instanceof ICDITarget) {
                    this.handleChangedEvent((ICDIChangedEvent)iCDIEvent);
                }
                if (iCDIObject instanceof ICDISharedLibrary) {
                    this.getSharedLibraryManager().symbolsLoaded((ICDISharedLibrary)iCDIObject);
                }
                if (iCDIObject instanceof ICDISignal) {
                    this.getSignalManager().signalChanged((ICDISignal)iCDIObject);
                }
            } else if (iCDIEvent instanceof ICDIRestartedEvent && iCDIObject instanceof ICDITarget) {
                this.handleRestartedEvent((ICDIRestartedEvent)iCDIEvent);
            }
        }
    }

    public boolean canRestart() {
        return this.getConfiguration().supportsRestart() && this.isSuspended() && this.isAvailable();
    }

    public void restart() throws DebugException {
        if (!this.canRestart()) {
            return;
        }
        try {
            ICDILocation iCDILocation = this.getCDISession().getBreakpointManager().createLocation("", "main", 0);
            this.setInternalTemporaryBreakpoint(iCDILocation);
            this.getCDITarget().restart();
            this.restarted();
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    protected void restarted() {
    }

    public int[] getSupportedFormats() throws DebugException {
        return null;
    }

    public boolean isAvailable() {
        return !this.isTerminated() && !this.isTerminating() && !this.isDisconnected();
    }

    private void setSuspended(boolean bl) {
        this.fSuspended = bl;
    }

    protected boolean isTerminating() {
        return this.fTerminating;
    }

    protected void setTerminating(boolean bl) {
        this.fTerminating = bl;
    }

    protected void terminated() {
        this.setTerminating(false);
        if (!this.isTerminated()) {
            if (!this.isDisconnected()) {
                this.setTerminated(true);
            }
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void disconnected() {
        if (!this.isDisconnected()) {
            this.setDisconnected(true);
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void cleanup() {
        this.resetStatus();
        this.removeAllThreads();
        this.getCDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.disposeMemoryManager();
        this.disposeSharedLibraryManager();
        this.disposeSignalManager();
        this.disposeRegisterManager();
        this.disposeDisassemblyManager();
        this.disposeSourceManager();
        this.disposeBreakpointManager();
        this.removeAllExpressions();
    }

    protected void removeAllThreads() {
        ArrayList arrayList = this.getThreadList();
        this.setThreadList(new ArrayList(0));
        ArrayList<DebugEvent> arrayList2 = new ArrayList<DebugEvent>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CThread cThread = (CThread)iterator.next();
            cThread.terminated();
            arrayList2.add(cThread.createTerminateEvent());
        }
        this.fireEventSet(arrayList2.toArray(new DebugEvent[arrayList2.size()]));
    }

    protected void removeAllExpressions() {
        IExpressionManager iExpressionManager = DebugPlugin.getDefault().getExpressionManager();
        IExpression[] iExpressionArray = iExpressionManager.getExpressions();
        int n = 0;
        while (n < iExpressionArray.length) {
            if (iExpressionArray[n] instanceof CExpression && iExpressionArray[n].getDebugTarget().equals(this)) {
                iExpressionManager.removeExpression(iExpressionArray[n]);
            }
            ++n;
        }
    }

    protected CThread createThread(ICDIThread iCDIThread) {
        CThread cThread = new CThread(this, iCDIThread);
        this.getThreadList().add(cThread);
        return cThread;
    }

    protected CThread createRunningThread(ICDIThread iCDIThread) {
        CThread cThread = new CThread(this, iCDIThread);
        cThread.setRunning(true);
        this.getThreadList().add(cThread);
        return cThread;
    }

    private void handleSuspendedEvent(ICDISuspendedEvent iCDISuspendedEvent) {
        CThread cThread;
        this.setSuspended(true);
        this.setCurrentStateId(7);
        ICDISessionObject iCDISessionObject = iCDISuspendedEvent.getReason();
        this.setCurrentStateInfo(iCDISessionObject);
        this.setRunningInfo(null);
        this.setSuspensionThread();
        List list = this.refreshThreads();
        if (iCDISuspendedEvent.getSource() instanceof ICDITarget) {
            this.suspendThreads(iCDISuspendedEvent);
        } else if (iCDISuspendedEvent.getSource() instanceof ICDIThread && (cThread = this.findThread((ICDIThread)iCDISuspendedEvent.getSource())) != null && list.contains(cThread)) {
            cThread.handleDebugEvent(iCDISuspendedEvent);
        }
        if (iCDISessionObject instanceof ICDIEndSteppingRange) {
            this.handleEndSteppingRange((ICDIEndSteppingRange)iCDISessionObject);
        } else if (iCDISessionObject instanceof ICDIBreakpointHit) {
            this.handleBreakpointHit((ICDIBreakpointHit)iCDISessionObject);
        } else if (iCDISessionObject instanceof ICDISignalReceived) {
            this.handleSuspendedBySignal((ICDISignalReceived)iCDISessionObject);
        } else if (iCDISessionObject instanceof ICDIWatchpointTrigger) {
            this.handleWatchpointTrigger((ICDIWatchpointTrigger)iCDISessionObject);
        } else if (iCDISessionObject instanceof ICDIWatchpointScope) {
            this.handleWatchpointScope((ICDIWatchpointScope)iCDISessionObject);
        } else if (iCDISessionObject instanceof ICDIErrorInfo) {
            this.handleErrorInfo((ICDIErrorInfo)iCDISessionObject);
        } else if (iCDISessionObject instanceof ICDISharedLibraryEvent) {
            this.handleSuspendedBySolibEvent((ICDISharedLibraryEvent)iCDISessionObject);
        }
    }

    private void handleResumedEvent(ICDIResumedEvent iCDIResumedEvent) {
        this.setSuspended(false);
        this.setCurrentStateId(5);
        this.setCurrentStateInfo(null);
        this.resetStatus();
        ArrayList<DebugEvent> arrayList = new ArrayList<DebugEvent>(10);
        int n = 0;
        switch (iCDIResumedEvent.getType()) {
            case 0: {
                n = 32;
                break;
            }
            case 2: 
            case 4: {
                n = 1;
                break;
            }
            case 1: 
            case 3: {
                n = 2;
                break;
            }
            case 5: {
                n = 4;
            }
        }
        this.resumeThreads(arrayList, n);
        if (this.getRunningInfo() == null) {
            this.setRunningInfo(iCDIResumedEvent.getType());
        }
        arrayList.add(this.createResumeEvent(n));
        this.fireEventSet(arrayList.toArray(new DebugEvent[arrayList.size()]));
    }

    private void handleEndSteppingRange(ICDIEndSteppingRange iCDIEndSteppingRange) {
        this.fireSuspendEvent(0);
    }

    private void handleBreakpointHit(ICDIBreakpointHit iCDIBreakpointHit) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointTrigger(ICDIWatchpointTrigger iCDIWatchpointTrigger) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointScope(ICDIWatchpointScope iCDIWatchpointScope) {
        ICBreakpoint iCBreakpoint = this.getBreakpointManager().getBreakpoint(iCDIWatchpointScope.getWatchpoint());
        if (iCBreakpoint != null) {
            try {
                this.getBreakpointManager().removeBreakpoint(iCBreakpoint);
            }
            catch (DebugException debugException) {
                CDebugCorePlugin.log(debugException);
            }
            this.fireSuspendEvent(16);
        }
    }

    private void handleSuspendedBySignal(ICDISignalReceived iCDISignalReceived) {
        this.fireSuspendEvent(0);
    }

    private void handleErrorInfo(ICDIErrorInfo iCDIErrorInfo) {
        this.setStatus(2, iCDIErrorInfo != null ? iCDIErrorInfo.getMessage() : null);
        if (iCDIErrorInfo != null) {
            MultiStatus multiStatus = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 10002, "The execution of program is suspended because of error.", null);
            StringTokenizer stringTokenizer = new StringTokenizer(iCDIErrorInfo.getDetailMessage(), "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.length() > 200) {
                    string = string.substring(0, 200);
                }
                multiStatus.add((IStatus)new Status(4, multiStatus.getPlugin(), 10002, string, null));
            }
            CDebugUtils.error((IStatus)multiStatus, this);
        }
        this.fireSuspendEvent(0);
    }

    private void handleSuspendedBySolibEvent(ICDISharedLibraryEvent iCDISharedLibraryEvent) {
        this.fireSuspendEvent(0);
    }

    private void handleExitedEvent(ICDIExitedEvent iCDIExitedEvent) {
        this.removeAllThreads();
        this.setCurrentStateId(8);
        this.setCurrentStateInfo(iCDIExitedEvent.getReason());
        this.fireChangeEvent(512);
        if (this.getConfiguration().terminateSessionOnExit()) {
            this.terminated();
        }
    }

    private void handleTerminatedEvent(ICDIDestroyedEvent iCDIDestroyedEvent) {
        this.terminated();
    }

    private void handleDisconnectedEvent(ICDIDisconnectedEvent iCDIDisconnectedEvent) {
        this.setCurrentStateId(9);
        this.setCurrentStateInfo(null);
        this.disconnected();
    }

    private void handleChangedEvent(ICDIChangedEvent iCDIChangedEvent) {
    }

    private void handleRestartedEvent(ICDIRestartedEvent iCDIRestartedEvent) {
    }

    private void handleThreadCreatedEvent(ICDICreatedEvent iCDICreatedEvent) {
        ICDIThread iCDIThread = (ICDIThread)iCDICreatedEvent.getSource();
        CThread cThread = this.findThread(iCDIThread);
        if (cThread == null) {
            cThread = this.createThread(iCDIThread);
            cThread.fireCreationEvent();
        }
    }

    private void handleThreadTerminatedEvent(ICDIDestroyedEvent iCDIDestroyedEvent) {
        ICDIThread iCDIThread = (ICDIThread)iCDIDestroyedEvent.getSource();
        CThread cThread = this.findThread(iCDIThread);
        if (cThread != null) {
            ((AbstractCollection)this.getThreadList()).remove(cThread);
            cThread.terminated();
            cThread.fireTerminateEvent();
        }
    }

    public CThread findThread(ICDIThread iCDIThread) {
        ArrayList arrayList = this.getThreadList();
        int n = 0;
        while (n < arrayList.size()) {
            CThread cThread = (CThread)arrayList.get(n);
            if (cThread.getCDIThread().equals(iCDIThread)) {
                return cThread;
            }
            ++n;
        }
        return null;
    }

    public CThread findThread(List list, ICDIThread iCDIThread) {
        int n = 0;
        while (n < list.size()) {
            CThread cThread = (CThread)list.get(n);
            if (cThread.getCDIThread().equals(iCDIThread)) {
                return cThread;
            }
            ++n;
        }
        return null;
    }

    public int getCurrentStateId() {
        return this.fCurrentStateId;
    }

    private void setCurrentStateId(int n) {
        this.fCurrentStateId = n;
    }

    public Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    private void setCurrentStateInfo(Object object) {
        this.fCurrentStateInfo = object;
    }

    protected int getSuspendCount() {
        return this.fSuspendCount;
    }

    protected void incrementSuspendCount() {
        ++this.fSuspendCount;
    }

    public void fireSuspendEvent(int n) {
        this.incrementSuspendCount();
        super.fireSuspendEvent(n);
    }

    protected void setCurrentThread() {
        ICDIThread iCDIThread = null;
        try {
            iCDIThread = this.getCDITarget().getCurrentThread();
        }
        catch (CDIException cDIException) {
            CDebugCorePlugin.log(cDIException);
        }
        Iterator iterator = ((AbstractList)this.getThreadList()).iterator();
        while (iterator.hasNext()) {
            CThread cThread = (CThread)iterator.next();
            cThread.setCurrent(iCDIThread != null && cThread.getCDIThread().equals(iCDIThread));
        }
        if (iCDIThread == null && !this.getThreadList().isEmpty()) {
            ((CThread)this.getThreadList().get(0)).setCurrent(true);
        }
    }

    protected ICDIConfiguration getConfiguration() {
        return this.fConfig;
    }

    private void setConfiguration(ICDIConfiguration iCDIConfiguration) {
        this.fConfig = iCDIConfiguration;
    }

    protected boolean supportsExpressionEvaluation() {
        return this.getConfiguration().supportsExpressionEvaluation();
    }

    public String evaluateExpressionToString(String string) throws DebugException {
        try {
            return this.getCDITarget().evaluateExpressionToString(string);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
            return null;
        }
    }

    public boolean canEvaluate() {
        return this.supportsExpressionEvaluation() && this.isAvailable() && this.isSuspended();
    }

    public void expressionAdded(IExpression iExpression) {
    }

    public void expressionChanged(IExpression iExpression) {
    }

    public void expressionRemoved(IExpression iExpression) {
        if (iExpression != null && iExpression.getDebugTarget().equals(this) && iExpression instanceof CExpression) {
            ICDIExpressionManager iCDIExpressionManager = this.getCDISession().getExpressionManager();
            try {
                iCDIExpressionManager.destroyExpression(((CExpression)iExpression).getCDIExpression());
            }
            catch (CDIException cDIException) {}
        }
    }

    public void setInternalTemporaryBreakpoint(ICDILocation iCDILocation) throws DebugException {
        try {
            this.getCDISession().getBreakpointManager().setLocationBreakpoint(1, iCDILocation, null, null);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
        }
    }

    public boolean canRunToLine(String string, int n) {
        return this.canResume();
    }

    public void runToLine(String string, int n) throws DebugException {
        if (!this.canRunToLine(string, n)) {
            return;
        }
        ICDILocation iCDILocation = this.getCDISession().getBreakpointManager().createLocation(string, null, n);
        try {
            this.getCDITarget().runUntil(iCDILocation);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public boolean canRunToLine(IFile iFile, int n) {
        return this.canResume();
    }

    public void runToLine(IFile iFile, int n) throws DebugException {
        if (!this.canRunToLine(iFile, n)) {
            return;
        }
        this.runToLine(iFile.getLocation().lastSegment(), n);
    }

    public void setCurrentThread(IThread iThread) throws DebugException {
        if (!(this.isSuspended() && this.isAvailable() && iThread instanceof CThread)) {
            return;
        }
        try {
            CThread cThread = (CThread)this.getCurrentThread();
            if (!iThread.equals(cThread)) {
                this.getCDITarget().setCurrentThread(((CThread)iThread).getCDIThread());
                if (cThread != null) {
                    cThread.setCurrent(false);
                }
                ((CThread)iThread).setCurrent(true);
            }
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
        }
    }

    public IThread getCurrentThread() throws DebugException {
        IThread[] iThreadArray = this.getThreads();
        int n = 0;
        while (n < iThreadArray.length) {
            if (((CThread)iThreadArray[n]).isCurrent()) {
                return iThreadArray[n];
            }
            ++n;
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        return this.getLaunch().getSourceLocator();
    }

    protected void resetRegisters() {
        this.getRegisterManager().reset();
    }

    public int getTargetType() {
        return this.fTargetType;
    }

    private void setTargetType(int n) {
        this.fTargetType = n;
    }

    protected boolean isCoreDumpTarget() {
        return this.getTargetType() == 3;
    }

    protected int getRealSourceMode() {
        ISourceLocator iSourceLocator = this.getSourceLocator();
        if (iSourceLocator != null && iSourceLocator instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)iSourceLocator;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iAdaptable.getAdapter((Class)clazz) != null) {
                IAdaptable iAdaptable2 = (IAdaptable)iSourceLocator;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iAdaptable2.getAdapter((Class)clazz2) instanceof CSourceManager) {
                    IAdaptable iAdaptable3 = (IAdaptable)iSourceLocator;
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return ((CSourceManager)iAdaptable3.getAdapter((Class)clazz3)).getRealMode();
                }
            }
        }
        return 0;
    }

    protected CMemoryManager getMemoryManager() {
        return this.fMemoryManager;
    }

    protected void disposeMemoryManager() {
        this.getMemoryManager().dispose();
    }

    public boolean isDebuggerProcessDefault() {
        return this.fIsDebuggerProcessDefault;
    }

    public void setDebuggerProcessDefault(boolean bl) {
        this.fIsDebuggerProcessDefault = bl;
    }

    public boolean supportsDebuggerProcess() {
        return this.fDebuggerProcess != null;
    }

    public boolean isLittleEndian() {
        if (this.fIsLittleEndian == null) {
            ICElement iCElement;
            this.fIsLittleEndian = Boolean.TRUE;
            if (this.getExecFile() != null && CoreModel.getDefault().isBinary(this.getExecFile()) && (iCElement = CCorePlugin.getDefault().getCoreModel().create(this.getExecFile())) instanceof IBinary) {
                this.fIsLittleEndian = new Boolean(((IBinary)iCElement).isLittleEndian());
            }
        }
        return this.fIsLittleEndian;
    }

    public IFile getExecFile() {
        return this.fExecFile;
    }

    private void setExecFile(IFile iFile) {
        this.fExecFile = iFile;
    }

    public IGlobalVariable[] getGlobals() {
        ICElement iCElement;
        ArrayList arrayList = new ArrayList();
        if (this.getExecFile() != null && CoreModel.getDefault().isBinary(this.getExecFile()) && (iCElement = CCorePlugin.getDefault().getCoreModel().create(this.getExecFile())) instanceof IParent) {
            arrayList.addAll(this.getCFileGlobals((IParent)iCElement));
        }
        return arrayList.toArray(new IGlobalVariable[arrayList.size()]);
    }

    private List getCFileGlobals(IParent iParent) {
        ArrayList<IGlobalVariable> arrayList = new ArrayList<IGlobalVariable>();
        ICElement[] iCElementArray = iParent.getChildren();
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n] instanceof IVariable) {
                arrayList.add(this.createGlobalVariable((IVariable)iCElementArray[n]));
            } else if (iCElementArray[n] instanceof IParent) {
                arrayList.addAll(this.getCFileGlobals((IParent)iCElementArray[n]));
            }
            ++n;
        }
        return arrayList;
    }

    private IGlobalVariable createGlobalVariable(final IVariable iVariable) {
        return new IGlobalVariable(){

            public String getName() {
                return iVariable.getElementName();
            }

            public IPath getPath() {
                Path path = new Path("");
                ICElement iCElement = iVariable.getParent();
                if (iCElement instanceof IBinaryModule) {
                    path = ((IBinaryModule)iCElement).getPath();
                }
                return path;
            }
        };
    }

    protected void setDisassemblyManager(DisassemblyManager disassemblyManager) {
        this.fDisassemblyManager = disassemblyManager;
    }

    protected DisassemblyManager getDisassemblyManager() {
        return this.fDisassemblyManager;
    }

    protected void setSharedLibraryManager(CSharedLibraryManager cSharedLibraryManager) {
        this.fSharedLibraryManager = cSharedLibraryManager;
    }

    protected CSharedLibraryManager getSharedLibraryManager() {
        return this.fSharedLibraryManager;
    }

    protected void disposeSharedLibraryManager() {
        this.fSharedLibraryManager.dispose();
    }

    protected void setSignalManager(CSignalManager cSignalManager) {
        this.fSignalManager = cSignalManager;
    }

    protected CSignalManager getSignalManager() {
        return this.fSignalManager;
    }

    protected void disposeSignalManager() {
        this.fSignalManager.dispose();
    }

    protected void disposeRegisterManager() {
        this.fRegisterManager.dispose();
    }

    protected void disposeDisassemblyManager() {
        this.fDisassemblyManager.dispose();
    }

    public boolean canRunToAddress(long l) {
        return this.canResume();
    }

    public void runToAddress(long l) throws DebugException {
        if (!this.canRunToAddress(l)) {
            return;
        }
        ICDILocation iCDILocation = this.getCDISession().getBreakpointManager().createLocation(l);
        try {
            this.getCDITarget().runUntil(iCDILocation);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public boolean canResumeWithoutSignal() {
        return this.isSuspended() && this.getCurrentStateInfo() instanceof ICDISignalReceived;
    }

    public void resumeWithoutSignal() throws DebugException {
        try {
            this.getCDITarget().signal();
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public boolean canJumpToLine(IFile iFile, int n) {
        return this.canResume();
    }

    public void jumpToLine(IFile iFile, int n) throws DebugException {
        if (!this.canJumpToLine(iFile, n)) {
            return;
        }
        this.jumpToLine(iFile.getLocation().lastSegment(), n);
    }

    public boolean canJumpToLine(String string, int n) {
        return this.canResume();
    }

    public void jumpToLine(String string, int n) throws DebugException {
        if (!this.canJumpToLine(string, n)) {
            return;
        }
        ICDILocation iCDILocation = this.getCDISession().getBreakpointManager().createLocation(string, null, n);
        try {
            this.getCDITarget().jump(iCDILocation);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public boolean canJumpToAddress(long l) {
        return this.canResume();
    }

    public void jumpToAddress(long l) throws DebugException {
        if (!this.canJumpToAddress(l)) {
            return;
        }
        ICDILocation iCDILocation = this.getCDISession().getBreakpointManager().createLocation(l);
        try {
            this.getCDITarget().jump(iCDILocation);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), cDIException);
        }
    }

    public CRegisterManager getRegisterManager() {
        return this.fRegisterManager;
    }

    protected void setRegisterManager(CRegisterManager cRegisterManager) {
        this.fRegisterManager = cRegisterManager;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return this.getRegisterManager().getRegisterGroups();
    }

    protected void disposeSourceManager() {
        ISourceLocator iSourceLocator = this.getSourceLocator();
        if (iSourceLocator instanceof IAdaptable) {
            IResourceChangeListener iResourceChangeListener;
            IAdaptable iAdaptable = (IAdaptable)iSourceLocator;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResourceChangeListener = (IResourceChangeListener)iAdaptable.getAdapter((Class)clazz)) != null) {
                CCorePlugin.getWorkspace().removeResourceChangeListener(iResourceChangeListener);
            }
        }
    }

    protected RunningInfo getRunningInfo() {
        return this.fRunningInfo;
    }

    public IFile getCurrentBreakpointFile() {
        ICDIBreakpoint iCDIBreakpoint;
        Object object = this.getCurrentStateInfo();
        if (object instanceof ICDIBreakpointHit && (iCDIBreakpoint = ((ICDIBreakpointHit)object).getBreakpoint()) != null) {
            return this.getBreakpointManager().getCDIBreakpointFile(iCDIBreakpoint);
        }
        return null;
    }

    protected void setRunningInfo(RunningInfo runningInfo) {
        this.fRunningInfo = runningInfo;
    }

    protected void setRunningInfo(int n) {
        RunningInfo runningInfo = null;
        try {
            int n2;
            CThread cThread = (CThread)this.getCurrentThread();
            if (cThread != null && (n2 = cThread.getLastStackDepth()) > 0) {
                runningInfo = new RunningInfo(n, n2);
            }
        }
        catch (DebugException debugException) {}
        this.setRunningInfo(runningInfo);
    }

    protected CBreakpointManager getBreakpointManager() {
        return this.fBreakpointManager;
    }

    protected void setBreakpointManager(CBreakpointManager cBreakpointManager) {
        this.fBreakpointManager = cBreakpointManager;
    }

    protected void disposeBreakpointManager() {
        if (this.getBreakpointManager() != null) {
            this.getBreakpointManager().dispose();
        }
    }

    protected ICDIThread getSuspensionThread() {
        return this.fSuspensionThread;
    }

    private void setSuspensionThread() {
        this.fSuspensionThread = null;
        try {
            this.fSuspensionThread = this.getCDITarget().getCurrentThread();
        }
        catch (CDIException cDIException) {}
    }

    protected IBreakpoint[] getThreadBreakpoints(CThread cThread) {
        ArrayList<ICBreakpoint> arrayList = new ArrayList<ICBreakpoint>(1);
        if (this.isSuspended() && cThread != null && this.getSuspensionThread() != null && this.getSuspensionThread().equals(cThread.getCDIThread())) {
            ICBreakpoint iCBreakpoint = null;
            if (this.getCurrentStateInfo() instanceof ICDIBreakpointHit) {
                iCBreakpoint = this.getBreakpointManager().getBreakpoint(((ICDIBreakpointHit)this.getCurrentStateInfo()).getBreakpoint());
            } else if (this.getCurrentStateInfo() instanceof ICDIWatchpointTrigger) {
                iCBreakpoint = this.getBreakpointManager().getBreakpoint(((ICDIWatchpointTrigger)this.getCurrentStateInfo()).getWatchpoint());
            }
            if (iCBreakpoint != null) {
                arrayList.add(iCBreakpoint);
            }
        }
        return arrayList.toArray(new IBreakpoint[arrayList.size()]);
    }

    public String toString() {
        String string = "";
        try {
            string = this.getName();
        }
        catch (DebugException debugException) {}
        return string;
    }

    public class RunningInfo {
        private int fType = 0;
        private int fStackDepth;

        public RunningInfo(int n, int n2) {
            this.fType = n;
            this.fStackDepth = n2;
        }

        public int getType() {
            return this.fType;
        }

        public int getStackDepth() {
            return this.fStackDepth;
        }
    }
}

