/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterObject;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegister;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;

public class CRegisterGroup
extends CDebugElement
implements IRegisterGroup {
    private String fName;
    private ICDIRegisterObject[] fRegisterObjects;
    private List fRegisters;

    public CRegisterGroup(CDebugTarget cDebugTarget, String string, ICDIRegisterObject[] iCDIRegisterObjectArray) {
        super(cDebugTarget);
        this.fName = string;
        this.fRegisterObjects = iCDIRegisterObjectArray;
        this.fRegisters = new ArrayList();
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public IRegister[] getRegisters() throws DebugException {
        List list = this.getRegisters0();
        return list.toArray(new IRegister[list.size()]);
    }

    public boolean hasRegisters() throws DebugException {
        return this.fRegisterObjects.length > 0;
    }

    private List getRegisters0() throws DebugException {
        if (this.fRegisters == null || this.fRegisters.size() == 0) {
            ICDIRegister[] iCDIRegisterArray = this.getCDIRegisters();
            this.fRegisters = new ArrayList(iCDIRegisterArray.length);
            int n = 0;
            while (n < iCDIRegisterArray.length) {
                this.fRegisters.add(new CRegister(this, iCDIRegisterArray[n]));
                ++n;
            }
        }
        return this.fRegisters;
    }

    public void dispose() {
        Iterator iterator = this.fRegisters.iterator();
        while (iterator.hasNext()) {
            ((CRegister)iterator.next()).dispose();
        }
        this.fRegisters.clear();
    }

    private ICDIRegister[] getCDIRegisters() throws DebugException {
        ICDIRegister[] iCDIRegisterArray = new ICDIRegister[this.fRegisterObjects.length];
        int n = 0;
        while (n < this.fRegisterObjects.length) {
            try {
                iCDIRegisterArray[n] = ((CDebugTarget)this.getDebugTarget()).getCDISession().getRegisterManager().createRegister(this.fRegisterObjects[n]);
            }
            catch (CDIException cDIException) {
                iCDIRegisterArray[n] = new CRegister.ErrorRegister(this.fRegisterObjects[n], cDIException);
            }
            ++n;
        }
        return iCDIRegisterArray;
    }

    public void resetChangeFlags() {
        if (this.fRegisters == null) {
            return;
        }
        try {
            Iterator iterator = this.fRegisters.iterator();
            while (iterator.hasNext()) {
                ((CVariable)iterator.next()).setChanged(false);
            }
        }
        catch (DebugException debugException) {
            CDebugCorePlugin.log(debugException);
        }
    }
}

