/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CProjectSourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CSourceLocator
implements ICSourceLocator,
IPersistableSourceLocator,
IResourceChangeListener {
    private static final String SOURCE_LOCATOR_NAME = "cSourceLocator";
    private static final String DISABLED_GENERIC_PROJECT_NAME = "disabledGenericProject";
    private static final String ADDITIONAL_SOURCE_LOCATION_NAME = "additionalSourceLocation";
    private static final String SOURCE_LOCATION_NAME = "cSourceLocation";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MEMENTO = "memento";
    private static final String ATTR_PROJECT_NAME = "projectName";
    private static final String ATTR_DUPLICATE_FILES = "duplicateFiles";
    private IProject fProject = null;
    private ICSourceLocation[] fSourceLocations;
    private List fReferencedProjects = new ArrayList(10);
    private boolean fDuplicateFiles = false;
    static /* synthetic */ Class class$0;

    public CSourceLocator(IProject iProject) {
        this.setProject(iProject);
        this.setReferencedProjects();
        this.setSourceLocations(this.getDefaultSourceLocations());
    }

    public Object getSourceElement(IStackFrame iStackFrame) {
        if (iStackFrame != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iStackFrame.getAdapter((Class)clazz) != null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return this.getInput((IStackFrameInfo)iStackFrame.getAdapter((Class)clazz2));
            }
        }
        return null;
    }

    public int getLineNumber(IStackFrame iStackFrame) {
        IStackFrameInfo iStackFrameInfo;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (iStackFrameInfo = (IStackFrameInfo)iStackFrame.getAdapter((Class)clazz)) != null ? iStackFrameInfo.getFrameLineNumber() : 0;
    }

    protected Object getInput(IStackFrameInfo iStackFrameInfo) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (iStackFrameInfo != null) {
            Object object = null;
            String string = iStackFrameInfo.getFile();
            if (string != null && string.length() > 0) {
                ICSourceLocation[] iCSourceLocationArray = this.getSourceLocations();
                int n = 0;
                while (n < iCSourceLocationArray.length) {
                    try {
                        object = iCSourceLocationArray[n].findSourceElement(string);
                    }
                    catch (CoreException coreException) {}
                    if (object != null) {
                        if (object instanceof List) {
                            linkedList.addAll((List)object);
                        } else {
                            linkedList.add(object);
                        }
                        if (!this.searchForDuplicateFiles()) break;
                    }
                    ++n;
                }
            }
        }
        return linkedList.size() > 0 ? (linkedList.size() == 1 ? linkedList.getFirst() : linkedList) : null;
    }

    public boolean contains(IResource iResource) {
        ICSourceLocation[] iCSourceLocationArray = this.getSourceLocations();
        int n = 0;
        while (n < iCSourceLocationArray.length) {
            if (iResource instanceof IProject && iCSourceLocationArray[n] instanceof CProjectSourceLocation && ((CProjectSourceLocation)iCSourceLocationArray[n]).getProject().equals((Object)iResource)) {
                return true;
            }
            if (iResource instanceof IFile) {
                try {
                    Object object = iCSourceLocationArray[n].findSourceElement(iResource.getLocation().toOSString());
                    if (object instanceof IFile && ((IFile)object).equals((Object)iResource)) {
                        return true;
                    }
                    if (object instanceof List && ((List)object).contains(iResource)) {
                        return true;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n;
        }
        return false;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.fSourceLocations;
    }

    public void setSourceLocations(ICSourceLocation[] iCSourceLocationArray) {
        this.fSourceLocations = iCSourceLocationArray;
    }

    public static ICSourceLocation[] getDefaultSourceLocations(IProject iProject) {
        ArrayList<IProjectSourceLocation> arrayList = new ArrayList<IProjectSourceLocation>();
        if (iProject != null && iProject.exists()) {
            arrayList.add(SourceLookupFactory.createProjectSourceLocation(iProject));
            CSourceLocator.addReferencedSourceLocations(arrayList, iProject);
        }
        return arrayList.toArray(new ICSourceLocation[arrayList.size()]);
    }

    private static void addReferencedSourceLocations(List list, IProject iProject) {
        if (iProject != null) {
            try {
                IProject[] iProjectArray = iProject.getReferencedProjects();
                int n = 0;
                while (n < iProjectArray.length) {
                    if (iProjectArray[n].exists() && !CSourceLocator.containsProject(list, iProjectArray[n])) {
                        list.add(SourceLookupFactory.createProjectSourceLocation(iProjectArray[n]));
                        CSourceLocator.addReferencedSourceLocations(list, iProjectArray[n]);
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private static boolean containsProject(List list, IProject iProject) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CProjectSourceLocation cProjectSourceLocation = (CProjectSourceLocation)iterator.next();
            if (!iProject.equals((Object)cProjectSourceLocation.getProject())) continue;
            return true;
        }
        return false;
    }

    public Object findSourceElement(String string) {
        Object object = null;
        if (string != null && string.length() > 0) {
            ICSourceLocation[] iCSourceLocationArray = this.getSourceLocations();
            int n = 0;
            while (n < iCSourceLocationArray.length) {
                try {
                    object = iCSourceLocationArray[n].findSourceElement(string);
                }
                catch (CoreException coreException) {}
                if (object != null) break;
                ++n;
            }
        }
        return object;
    }

    public String getMemento() throws CoreException {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement(SOURCE_LOCATOR_NAME);
        documentImpl.appendChild(element);
        ICSourceLocation[] iCSourceLocationArray = this.getSourceLocations();
        this.saveDisabledGenericSourceLocations(iCSourceLocationArray, (Document)documentImpl, element);
        this.saveAdditionalSourceLocations(iCSourceLocationArray, (Document)documentImpl, element);
        element.setAttribute(ATTR_DUPLICATE_FILES, new Boolean(this.searchForDuplicateFiles()).toString());
        try {
            return CDebugUtils.serializeDocument((Document)documentImpl, " ");
        }
        catch (IOException iOException) {
            this.abort("Unable to create memento for C/C++ source locator.", iOException);
            return null;
        }
    }

    public void initializeDefaults(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        this.setSourceLocations(this.getDefaultSourceLocations());
    }

    public void initializeFromMemento(String string) throws CoreException {
        Exception exception = null;
        try {
            Element element = null;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            element = documentBuilder.parse(inputSource).getDocumentElement();
            if (!element.getNodeName().equalsIgnoreCase(SOURCE_LOCATOR_NAME)) {
                this.abort("Unable to restore C/C++ source locator - invalid format.", null);
            }
            ArrayList<ICSourceLocation> arrayList = new ArrayList<ICSourceLocation>();
            IProject iProject = this.getProject();
            if (iProject != null && iProject.exists() && iProject.isOpen()) {
                arrayList.addAll(Arrays.asList(this.getDefaultSourceLocations()));
            }
            this.removeDisabledLocations(element, arrayList);
            this.addAdditionalLocations(element, arrayList);
            this.addOldLocations(element, arrayList);
            this.setSourceLocations(arrayList.toArray(new ICSourceLocation[arrayList.size()]));
            this.setSearchForDuplicateFiles(Boolean.valueOf(element.getAttribute(ATTR_DUPLICATE_FILES)));
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
        }
        catch (SAXException sAXException) {
            exception = sAXException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        this.abort("Exception occurred initializing source locator.", exception);
    }

    private void removeDisabledLocations(Element element, List list) throws CoreException {
        Object object;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            Element element2;
            object = nodeList.item(n2);
            short s = object.getNodeType();
            if (s == 1 && (element2 = (Element)object).getNodeName().equalsIgnoreCase(DISABLED_GENERIC_PROJECT_NAME)) {
                String string = element2.getAttribute(ATTR_PROJECT_NAME);
                if (this.isEmpty(string)) {
                    CDebugCorePlugin.log("Unable to restore C/C++ source locator - invalid format.");
                }
                hashSet.add(string.trim());
            }
            ++n2;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (ICSourceLocation)iterator.next();
            if (!(object instanceof IProjectSourceLocation) || !hashSet.contains(((IProjectSourceLocation)object).getProject().getName())) continue;
            iterator.remove();
        }
    }

    private void addAdditionalLocations(Element element, List list) throws CoreException {
        ClassLoader classLoader = CDebugCorePlugin.getDefault().getDescriptor().getPluginClassLoader();
        MultiStatus multiStatus = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 1000, "Error initializing directory source location.", null);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Element element2;
                Node node = nodeList.item(n2);
                short s = node.getNodeType();
                if (s == 1 && (element2 = (Element)node).getNodeName().equalsIgnoreCase(ADDITIONAL_SOURCE_LOCATION_NAME)) {
                    String string = element2.getAttribute(ATTR_CLASS);
                    String string2 = element2.getAttribute(ATTR_MEMENTO);
                    if (this.isEmpty(string)) {
                        CDebugCorePlugin.log("Unable to restore C/C++ source locator - invalid format.");
                    } else {
                        Class<?> clazz = null;
                        try {
                            clazz = classLoader.loadClass(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            CDebugCorePlugin.log(MessageFormat.format("Unable to restore source location - class not found {0}", string));
                            break block12;
                        }
                        ICSourceLocation iCSourceLocation = null;
                        try {
                            iCSourceLocation = (ICSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block12;
                        }
                        catch (InstantiationException instantiationException) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block12;
                        }
                        try {
                            iCSourceLocation.initializeFrom(string2);
                            list.add(iCSourceLocation);
                        }
                        catch (CoreException coreException) {
                            multiStatus.addAll(coreException.getStatus());
                        }
                    }
                }
            }
            ++n2;
        }
        if (multiStatus.getSeverity() > 0) {
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private void addOldLocations(Element element, List list) throws CoreException {
        ClassLoader classLoader = CDebugCorePlugin.getDefault().getDescriptor().getPluginClassLoader();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block11: {
                Element element2;
                Node node = nodeList.item(n2);
                short s = node.getNodeType();
                if (s == 1 && (element2 = (Element)node).getNodeName().equalsIgnoreCase(SOURCE_LOCATION_NAME)) {
                    String string = element2.getAttribute(ATTR_CLASS);
                    String string2 = element2.getAttribute(ATTR_MEMENTO);
                    if (this.isEmpty(string)) {
                        CDebugCorePlugin.log("Unable to restore C/C++ source locator - invalid format.");
                    } else {
                        Class<?> clazz = null;
                        try {
                            clazz = classLoader.loadClass(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            CDebugCorePlugin.log(MessageFormat.format("Unable to restore source location - class not found {0}", string));
                            break block11;
                        }
                        ICSourceLocation iCSourceLocation = null;
                        try {
                            iCSourceLocation = (ICSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block11;
                        }
                        catch (InstantiationException instantiationException) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block11;
                        }
                        iCSourceLocation.initializeFrom(string2);
                        if (!list.contains(iCSourceLocation)) {
                            if (iCSourceLocation instanceof CProjectSourceLocation) {
                                ((CProjectSourceLocation)iCSourceLocation).setGenerated(this.isReferencedProject(((CProjectSourceLocation)iCSourceLocation).getProject()));
                            }
                            list.add(iCSourceLocation);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void abort(String string, Throwable throwable) throws CoreException {
        Status status = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, string, throwable);
        throw new CoreException((IStatus)status);
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta[] iResourceDeltaArray;
        if (iResourceChangeEvent.getSource() instanceof IWorkspace && iResourceChangeEvent.getDelta() != null && (iResourceDeltaArray = iResourceChangeEvent.getDelta().getAffectedChildren()) != null) {
            ArrayList<IResource> arrayList = new ArrayList<IResource>(iResourceDeltaArray.length);
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                if (iResourceDeltaArray[n].getResource() instanceof IProject) {
                    arrayList.add(iResourceDeltaArray[n].getResource());
                }
                ++n;
            }
            this.resetSourceLocations(arrayList);
        }
    }

    private void saveDisabledGenericSourceLocations(ICSourceLocation[] iCSourceLocationArray, Document document, Element element) {
        IProject iProject = this.getProject();
        if (iProject != null && iProject.exists() && iProject.isOpen()) {
            List list = CDebugUtils.getReferencedProjects(iProject);
            HashSet<String> hashSet = new HashSet<String>(list.size() + 1);
            hashSet.add(iProject.getName());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                hashSet.add(((IProject)iterator.next()).getName());
            }
            int n = 0;
            while (n < iCSourceLocationArray.length) {
                if (iCSourceLocationArray[n] instanceof IProjectSourceLocation && ((IProjectSourceLocation)iCSourceLocationArray[n]).isGeneric()) {
                    hashSet.remove(((IProjectSourceLocation)iCSourceLocationArray[n]).getProject().getName());
                }
                ++n;
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Element element2 = document.createElement(DISABLED_GENERIC_PROJECT_NAME);
                element2.setAttribute(ATTR_PROJECT_NAME, (String)iterator.next());
                element.appendChild(element2);
            }
        }
    }

    private void saveAdditionalSourceLocations(ICSourceLocation[] iCSourceLocationArray, Document document, Element element) {
        int n = 0;
        while (n < iCSourceLocationArray.length) {
            block4: {
                if (!(iCSourceLocationArray[n] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)iCSourceLocationArray[n]).isGeneric()) {
                    Element element2 = document.createElement(ADDITIONAL_SOURCE_LOCATION_NAME);
                    element2.setAttribute(ATTR_CLASS, iCSourceLocationArray[n].getClass().getName());
                    try {
                        element2.setAttribute(ATTR_MEMENTO, iCSourceLocationArray[n].getMemento());
                    }
                    catch (CoreException coreException) {
                        CDebugCorePlugin.log(coreException);
                        break block4;
                    }
                    element.appendChild(element2);
                }
            }
            ++n;
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected void setProject(IProject iProject) {
        this.fProject = iProject;
    }

    private boolean isReferencedProject(IProject iProject) {
        if (this.getProject() != null) {
            try {
                return Arrays.asList(this.getProject().getReferencedProjects()).contains(iProject);
            }
            catch (CoreException coreException) {
                CDebugCorePlugin.log(coreException);
            }
        }
        return false;
    }

    private void setReferencedProjects() {
        this.fReferencedProjects.clear();
        this.fReferencedProjects = CDebugUtils.getReferencedProjects(this.getProject());
    }

    protected ICSourceLocation[] getDefaultSourceLocations() {
        Iterator iterator = this.fReferencedProjects.iterator();
        ArrayList<IProjectSourceLocation> arrayList = new ArrayList<IProjectSourceLocation>(this.fReferencedProjects.size());
        if (this.getProject() != null && this.getProject().exists() && this.getProject().isOpen()) {
            arrayList.add(SourceLookupFactory.createProjectSourceLocation(this.getProject()));
        }
        while (iterator.hasNext()) {
            IProject iProject = (IProject)iterator.next();
            if (iProject == null || !iProject.exists() || !iProject.isOpen()) continue;
            arrayList.add(SourceLookupFactory.createProjectSourceLocation(iProject));
        }
        return arrayList.toArray(new ICSourceLocation[arrayList.size()]);
    }

    private void resetSourceLocations(List list) {
        if (list.size() != 0 && this.getProject() != null) {
            if (!this.getProject().exists() || !this.getProject().isOpen()) {
                this.removeGenericSourceLocations();
            } else {
                this.updateGenericSourceLocations(list);
            }
        }
    }

    private void removeGenericSourceLocations() {
        this.fReferencedProjects.clear();
        ICSourceLocation[] iCSourceLocationArray = this.getSourceLocations();
        ArrayList<ICSourceLocation> arrayList = new ArrayList<ICSourceLocation>(iCSourceLocationArray.length);
        int n = 0;
        while (n < iCSourceLocationArray.length) {
            if (!(iCSourceLocationArray[n] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)iCSourceLocationArray[n]).isGeneric()) {
                arrayList.add(iCSourceLocationArray[n]);
            }
            ++n;
        }
        this.setSourceLocations(arrayList.toArray(new ICSourceLocation[arrayList.size()]));
    }

    private void updateGenericSourceLocations(List list) {
        IProject iProject;
        List list2 = CDebugUtils.getReferencedProjects(this.getProject());
        ICSourceLocation[] iCSourceLocationArray = this.getSourceLocations();
        ArrayList<ICSourceLocation> arrayList = new ArrayList<ICSourceLocation>(iCSourceLocationArray.length);
        int n = 0;
        while (n < iCSourceLocationArray.length) {
            if (!(iCSourceLocationArray[n] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)iCSourceLocationArray[n]).isGeneric()) {
                arrayList.add(iCSourceLocationArray[n]);
            } else {
                iProject = ((IProjectSourceLocation)iCSourceLocationArray[n]).getProject();
                if (iProject.exists() && iProject.isOpen() && (list2.contains(iProject) || iProject.equals((Object)this.getProject()))) {
                    arrayList.add(iCSourceLocationArray[n]);
                    list2.remove(iProject);
                }
            }
            ++n;
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            iProject = (IProject)iterator.next();
            if (this.fReferencedProjects.contains(iProject)) continue;
            arrayList.add(SourceLookupFactory.createProjectSourceLocation(iProject));
        }
        this.fReferencedProjects = list2;
        this.setSourceLocations(arrayList.toArray(new ICSourceLocation[arrayList.size()]));
    }

    public boolean searchForDuplicateFiles() {
        return this.fDuplicateFiles;
    }

    public void setSearchForDuplicateFiles(boolean bl) {
        this.fDuplicateFiles = bl;
        ICSourceLocation[] iCSourceLocationArray = this.getSourceLocations();
        int n = 0;
        while (n < iCSourceLocationArray.length) {
            iCSourceLocationArray[n].setSearchForDuplicateFiles(bl);
            ++n;
        }
    }
}

