/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexOutput;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntryHashedArray;
import org.eclipse.cdt.internal.core.index.impl.IndexOutput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.IndexedFileHashedArray;
import org.eclipse.cdt.internal.core.index.impl.Util;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;
import org.eclipse.cdt.internal.core.index.impl.WordEntryHashedArray;

public class InMemoryIndex {
    protected IncludeEntryHashedArray includes = new IncludeEntryHashedArray(501);
    protected WordEntryHashedArray words;
    protected IndexedFileHashedArray files;
    protected long footprint;
    private IncludeEntry[] sortedIncludeEntries;
    private WordEntry[] sortedWordEntries;
    private IndexedFile[] sortedFiles;
    private int lastId;

    public InMemoryIndex() {
        this.init();
    }

    public IndexedFile addDocument(IDocument iDocument) {
        IndexedFile indexedFile = this.files.add(iDocument);
        this.footprint += (long)(indexedFile.footprint() + 4);
        this.sortedFiles = null;
        return indexedFile;
    }

    public void addIncludeRef(IndexedFile indexedFile, char[] cArray) {
        this.addIncludeRef(cArray, indexedFile.getFileNumber());
    }

    public void addIncludeRef(IndexedFile indexedFile, String string) {
        this.addIncludeRef(string.toCharArray(), indexedFile.getFileNumber());
    }

    protected void addIncludeRef(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != 0) {
                this.addIncludeRef(cArray, nArray[n2]);
            }
            ++n2;
        }
    }

    protected void addIncludeRef(char[] cArray, int n) {
        IncludeEntry includeEntry = this.includes.get(cArray);
        if (includeEntry == null) {
            includeEntry = new IncludeEntry(cArray, ++this.lastId);
            includeEntry.addRef(n);
            this.includes.add(includeEntry);
            this.sortedIncludeEntries = null;
        } else {
            this.footprint += (long)includeEntry.addRef(n);
        }
    }

    protected void addRef(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != 0) {
                this.addRef(cArray, nArray[n2]);
            }
            ++n2;
        }
    }

    protected void addRef(char[] cArray, int n) {
        WordEntry wordEntry = this.words.get(cArray);
        if (wordEntry == null) {
            wordEntry = new WordEntry(cArray);
            wordEntry.addRef(n);
            this.words.add(wordEntry);
            this.sortedWordEntries = null;
            this.footprint += (long)wordEntry.footprint();
        } else {
            this.footprint += (long)wordEntry.addRef(n);
        }
    }

    public void addRef(IndexedFile indexedFile, char[] cArray) {
        this.addRef(cArray, indexedFile.getFileNumber());
    }

    public void addRef(IndexedFile indexedFile, String string) {
        this.addRef(string.toCharArray(), indexedFile.getFileNumber());
    }

    public void addRelatives(IndexedFile indexedFile, String string, String string2) {
        this.addRelatives(indexedFile.getFileNumber(), string.toCharArray(), string2 != null ? string2.toCharArray() : null);
    }

    protected void addRelatives(int n, char[] cArray, char[] cArray2) {
        IncludeEntry includeEntry = null;
        IncludeEntry includeEntry2 = null;
        if (cArray != null) {
            includeEntry = this.includes.get(cArray);
        }
        if (cArray2 != null) {
            includeEntry2 = this.includes.get(cArray2);
        }
        includeEntry.addParent(n, includeEntry2 != null ? includeEntry2.getID() : -1);
        if (cArray2 != null) {
            includeEntry2.addChild(n, includeEntry != null ? includeEntry.getID() : -1);
        }
    }

    public long getFootprint() {
        return this.footprint;
    }

    public IndexedFile[] getIndexedFiles() {
        return this.files.asArray();
    }

    public IndexedFile getIndexedFile(String string) {
        return this.files.get(string);
    }

    public IncludeEntry[] getIncludeEntries() {
        return this.includes.asArray();
    }

    protected IncludeEntry getIncludeEntry(char[] cArray) {
        return this.includes.get(cArray);
    }

    public int getNumFiles() {
        return this.files.size();
    }

    public int getNumWords() {
        return this.words.elementSize;
    }

    public int getNumIncludes() {
        return this.includes.elementSize;
    }

    protected IndexedFile[] getSortedFiles() {
        if (this.sortedFiles == null) {
            IndexedFile[] indexedFileArray = this.files.asArray();
            Util.sort(indexedFileArray);
            this.sortedFiles = indexedFileArray;
        }
        return this.sortedFiles;
    }

    protected WordEntry[] getSortedWordEntries() {
        if (this.sortedWordEntries == null) {
            WordEntry[] wordEntryArray = this.words.asArray();
            Util.sort(wordEntryArray);
            this.sortedWordEntries = wordEntryArray;
        }
        return this.sortedWordEntries;
    }

    protected IncludeEntry[] getSortedIncludeEntries() {
        if (this.sortedIncludeEntries == null) {
            IncludeEntry[] includeEntryArray = this.includes.asArray();
            Util.sort(includeEntryArray);
            this.sortedIncludeEntries = includeEntryArray;
        }
        return this.sortedIncludeEntries;
    }

    protected WordEntry getWordEntry(char[] cArray) {
        return this.words.get(cArray);
    }

    public void init() {
        this.includes = new IncludeEntryHashedArray(501);
        this.words = new WordEntryHashedArray(501);
        this.files = new IndexedFileHashedArray(101);
        this.footprint = 0L;
        this.lastId = 0;
        this.sortedWordEntries = null;
        this.sortedFiles = null;
        this.sortedIncludeEntries = null;
    }

    public void save(File file) throws IOException {
        BlocksIndexOutput blocksIndexOutput = new BlocksIndexOutput(file);
        this.save(blocksIndexOutput);
    }

    /*
     * Exception decompiling
     */
    protected void save(IndexOutput var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 118->122)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

