/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;

public final class WordEntryHashedArray {
    public WordEntry[] elements;
    public int elementSize;
    public int threshold;

    public WordEntryHashedArray(int n) {
        if (n < 7) {
            n = 7;
        }
        this.elements = new WordEntry[2 * n + 1];
        this.elementSize = 0;
        this.threshold = n + 1;
    }

    public WordEntry add(WordEntry wordEntry) {
        WordEntry wordEntry2;
        int n = this.elements.length;
        char[] cArray = wordEntry.getWord();
        int n2 = CharOperation.hashCode(cArray) % n;
        while ((wordEntry2 = this.elements[n2]) != null) {
            if (CharOperation.equals(wordEntry2.getWord(), cArray)) {
                this.elements[n2] = wordEntry;
                return this.elements[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.elements[n2] = wordEntry;
        if (++this.elementSize > this.threshold) {
            this.grow();
        }
        return wordEntry;
    }

    public WordEntry[] asArray() {
        WordEntry[] wordEntryArray = new WordEntry[this.elementSize];
        int n = 0;
        int n2 = 0;
        int n3 = this.elements.length;
        while (n < n3) {
            WordEntry wordEntry = this.elements[n];
            if (wordEntry != null) {
                wordEntryArray[n2++] = wordEntry;
            }
            ++n;
        }
        return wordEntryArray;
    }

    public WordEntry get(char[] cArray) {
        WordEntry wordEntry;
        int n = this.elements.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        while ((wordEntry = this.elements[n2]) != null) {
            if (CharOperation.equals(wordEntry.getWord(), cArray)) {
                return wordEntry;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    private void grow() {
        WordEntryHashedArray wordEntryHashedArray = new WordEntryHashedArray(this.elementSize * 2);
        int n = 0;
        int n2 = this.elements.length;
        while (n < n2) {
            if (this.elements[n] != null) {
                wordEntryHashedArray.add(this.elements[n]);
            }
            ++n;
        }
        this.elements = wordEntryHashedArray.elements;
        this.elementSize = wordEntryHashedArray.elementSize;
        this.threshold = wordEntryHashedArray.threshold;
    }

    public String toString() {
        String string = "";
        WordEntry[] wordEntryArray = this.asArray();
        int n = 0;
        int n2 = wordEntryArray.length;
        while (n < n2) {
            string = String.valueOf(string) + wordEntryArray[n].toString() + "\n";
            ++n;
        }
        return string;
    }
}

